/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_tcp_h
#define __nd_tcp_h

#include <netdude/nd.h>
#include <netdude/nd_gettext.h>
#include <netdude/nd_packet.h>
#include <netdude/nd_trace.h>
#include <netdude/nd_protocol.h>

#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

typedef enum {
  ND_TCP_STATE_NONE,
  ND_TCP_STATE_ONCE,
  ND_TCP_STATE_UPDATE_SINGLE,
  ND_TCP_STATE_UPDATE_ALL
} ND_TCPStateMode;

/* These are the implementations of ND_Protocol's callbacks: */
GtkWidget *nd_tcp_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf);
void       nd_tcp_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf);
void       nd_tcp_init_packet(ND_Packet *packet, guchar *data, guchar *data_end);
gboolean   nd_tcp_header_complete(const ND_Packet *packet, guint nesting);
gboolean   nd_tcp_fix_packet(ND_Packet *packet, int index);
void       nd_tcp_init_state(ND_Trace *trace);
void       nd_tcp_update_state(const ND_Packet *packet, int index);
void       nd_tcp_update_tcpdump_line(const ND_Packet *packet, char *line);
void       nd_tcp_free_state(ND_Trace *trace);

/**
 * nd_tcp_set_state_mode - sets state keeping modus
 * @mode: new state mode.
 *
 * The function sets the TCP state keeping mode,
 * returning the old one.
 *
 * Returns: old mode.
 */
ND_TCPStateMode nd_tcp_set_state_mode(ND_TCPStateMode mode);
ND_TCPStateMode nd_tcp_get_state_mode(void);

/* Generic accessor function for the protocol implementation: */
ND_Protocol *nd_tcp_get(void);
ND_Protocol *nd_tcp_get_ip(void);

gboolean     nd_tcp_get_first(const ND_Packet *packet, struct ip **iphdr, struct tcphdr **tcphdr);

guint16    nd_tcp_checksum(const ND_Packet *packet);
gboolean   nd_tcp_csum_correct(const ND_Packet *packet, guint16 *correct_sum);

/* Helper functions to set a trace's GUI table to a packet's content: */
void  nd_tcp_set_gui_sport(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_dport(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_seq(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_ack(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_off(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_unused(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_flags(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_win(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_cksum(ND_ProtoInfo *pinf, struct ip *iphdr,
			   struct tcphdr *tcphdr, const ND_Packet *packet);
void  nd_tcp_set_gui_urg(ND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_options(ND_ProtoInfo *pinf, struct tcphdr *tcphdr, const ND_Packet *packet);

#endif
