/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_trace_h
#define __nd_trace_h

#include <pcap.h>
#include <glib.h>
#include <nd_packet.h>

typedef enum
{
  ND_TAB_PPP         = 0,
  ND_TAB_FDDI        = 1,
  ND_TAB_ARP         = 2,
  ND_TAB_IP          = 3,
  ND_TAB_TCP         = 4,
  ND_TAB_UDP         = 5,
  ND_TAB_ICMP        = 6,
  ND_TAB_ICMP_ERROR  = 7
}
ND_Tabs;


typedef struct nd_trace
{
  char        *filename;
  pcap_t      *pcap;

  ND_Packet   *pl;     /* Packet list */
  ND_Packet   *pl_end; /* Last in packet list */
  ND_Packet   *sel;    /* Selected packets */

  ND_Packet   *p;      /* Most recently selected packet */
  ND_Packet   *p_frag; /* Packet selected to hilight fragments */

  int          num_packets;
  int          num_sel;

  int          dirty          : 1;
  int          apply_to_all   : 1;
  int          incomplete     : 1;
}
ND_Trace;


void        nd_trace_init(void);
void        nd_trace_clear(void);
int         nd_trace_load(char *filename);

/* Return 1 on success, 0 on failure. */
int         nd_trace_save(void);
int         nd_trace_save_as(char *filename);

void        nd_trace_update_tcpdump_packet(ND_Packet *p);
void        nd_trace_update_tcpdump_list(void);
void        nd_trace_move_packet(int from_packet, int to_packet);

int         nd_trace_packet_get_index(ND_Packet *p);
void        nd_trace_packet_insert_at_index(ND_Packet *p, int index);
ND_Packet  *nd_trace_packet_get_nth(int n);
ND_Packet  *nd_trace_sel(void);

void        nd_trace_sel_delete(void);
void        nd_trace_sel_hide(void);
void        nd_trace_sel_show(void);

/* Functions related to multiple selections */
void        nd_trace_select_packet(int index);
void        nd_trace_unselect_packet(int index);
void        nd_trace_clear_selection(void);
void        nd_trace_full_selection(void);

void        nd_trace_packet_hilight_fragments(ND_Packet *p);
void        nd_trace_packet_dehilight_fragments(void);

void        nd_trace_show_packet_tooltip(int row, int x, int y);
void        nd_trace_hide_packet_tooltip(void);

void        nd_trace_set_dirty(int dirty);

#endif
