/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_tcpdump_h
#define __nd_tcpdump_h

#include <nd_packet.h>

/* Tcpdump communication handling */

/* Initialization stuff */
int     nd_tcpdump_init(void);
void    nd_tcpdump_init_tracefile(char *tracefile);

/* Forks new tcpdump process and sends pcap_file_header
   as initialized for FILENAME given above. Returns TRUE
   when successful, FALSE otherwise.
*/
int     nd_tcpdump_open(void);

/* Kills tcpdump child process */
void    nd_tcpdump_close(void);

/* Writes tcpdump output for packet P into DEST, which
   is assumed to be of at least LINESIZE (see nd.h).
   As tcpdump keeps state for TCP connections, the
   FIND_CONTEXT flag determines whether the result should
   be without context (no relative seq nos) or not.
*/
void    nd_tcpdump_get_packet_line(ND_Packet *p, char *dest,
				   gboolean find_context);

void    nd_tcpdump_show_error_dialog(const char* err_message);

#endif
