/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_tcp_h
#define __nd_tcp_h

#ifdef LINUX
#define __FAVOR_BSD
#endif
#include <sys/types.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#include <nd_packet.h>

/* These set the various TCP fields to the given
   values, for all selected packets. */
void    tcp_sport(u_int16_t value);
void    tcp_dport(u_int16_t value);
void    tcp_seqno(tcp_seq value);
void    tcp_ackno(tcp_seq value);
void    tcp_x2(u_int8_t value);
void    tcp_fin(int onoff);
void    tcp_syn(int onoff);
void    tcp_rst(int onoff);
void    tcp_push(int onoff);
void    tcp_ack(int onoff);
void    tcp_urg(int onoff);
void    tcp_off(u_int8_t value);
void    tcp_win(u_int16_t value);
void    tcp_sum(u_int16_t value);
void    tcp_urp(u_int16_t value);

void    tcp_recalc_checksum(ND_Packet *p);

/* Whether or not certain TCP flags are set
   in a packet. */
gboolean tcp_syn_set(ND_Packet *p);
gboolean tcp_fin_set(ND_Packet *p);
gboolean tcp_ack_set(ND_Packet *p);
gboolean tcp_rst_set(ND_Packet *p);
gboolean tcp_psh_set(ND_Packet *p);
gboolean tcp_urg_set(ND_Packet *p);

#endif

