/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#ifdef LINUX
#define __FAVOR_BSD
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include <gtk/gtk.h>
#include <nd_ip.h>
#include <nd_tcp.h>
#include <nd_globals.h>
#include <nd_misc.h>
#include <interface.h>
#include <support.h>

void    
tcp_sport(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_sport = htons(value);
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_dport(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_dport = htons(value);
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_seqno(tcp_seq value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_seq = htonl(value);
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_ackno(tcp_seq value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_ack = htonl(value);
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_x2(u_int8_t value)
{
  ND_Packet        *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_flags =
	    (nd_packet_tcp(p)->th_flags & 0x3f) | (((value & 0x03) << 6) & 0xc0);
	  nd_packet_tcp(p)->th_x2 = (value >> 2);
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_fin(int onoff)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  if (onoff)
	    nd_packet_tcp(p)->th_flags |= TH_FIN;
	  else
	    nd_packet_tcp(p)->th_flags &= ~TH_FIN;
	  
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_syn(int onoff)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  if (onoff)
	    nd_packet_tcp(p)->th_flags |= TH_SYN;
	  else
	    nd_packet_tcp(p)->th_flags &= ~TH_SYN;
	  
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_rst(int onoff)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  if (onoff)
	    nd_packet_tcp(p)->th_flags |= TH_RST;
	  else
	    nd_packet_tcp(p)->th_flags &= ~TH_RST;
	  
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}

void    
tcp_push(int onoff)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  if (onoff)
	    nd_packet_tcp(p)->th_flags |= TH_PUSH;
	  else
	    nd_packet_tcp(p)->th_flags &= ~TH_PUSH;
	  
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_ack(int onoff)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  if (onoff)
	    nd_packet_tcp(p)->th_flags |= TH_ACK;
	  else
	    nd_packet_tcp(p)->th_flags &= ~TH_ACK;
	  
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_urg(int onoff)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  if (onoff)
	    nd_packet_tcp(p)->th_flags |= TH_URG;
	  else
	    nd_packet_tcp(p)->th_flags &= ~TH_URG;
	  
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_off(u_int8_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_off = (value >> 2);
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_win(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_win = htons(value);
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_sum(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_sum = htons(value);
	  nd_trace_set_dirty(TRUE);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_urp(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_TCP))
	{
	  nd_packet_tcp(p)->th_urp = htons(value);
	  tcp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_tcp(trace.p, 0);
}


void    
tcp_recalc_checksum(ND_Packet *p)
{
  if (nd_packet_has_protocol(p, ND_PROT_TCP))
    {
      nd_packet_tcp(p)->th_sum = nd_misc_tcp_checksum(p);
      nd_trace_set_dirty(TRUE);
    }
}


gboolean 
tcp_syn_set(ND_Packet *p)
{
  if (!nd_packet_has_protocol(p, ND_PROT_TCP))
    return (FALSE);

  return (nd_packet_tcp(p)->th_flags & TH_SYN);
}


gboolean 
tcp_fin_set(ND_Packet *p)
{
  if (!nd_packet_has_protocol(p, ND_PROT_TCP))
    return (FALSE);

  return (nd_packet_tcp(p)->th_flags & TH_FIN);
}


gboolean 
tcp_ack_set(ND_Packet *p)
{
  if (!nd_packet_has_protocol(p, ND_PROT_TCP))
    return (FALSE);

  return (nd_packet_tcp(p)->th_flags & TH_ACK);
}


gboolean 
tcp_rst_set(ND_Packet *p)
{
  if (!nd_packet_has_protocol(p, ND_PROT_TCP))
    return (FALSE);

  return (nd_packet_tcp(p)->th_flags & TH_RST);
}


gboolean 
tcp_psh_set(ND_Packet *p)
{
  if (!nd_packet_has_protocol(p, ND_PROT_TCP))
    return (FALSE);

  return (nd_packet_tcp(p)->th_flags & TH_PUSH);
}


gboolean 
tcp_urg_set(ND_Packet *p)
{
  if (!nd_packet_has_protocol(p, ND_PROT_TCP))
    return (FALSE);

  return (nd_packet_tcp(p)->th_flags & TH_URG);
}


