/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_plugin_h
#define __nd_plugin_h

#include <ltdl.h>
#include <nd_packet.h>

typedef struct nd_plugin
{
  char *(*name) (void);
  char *(*description) (void);
  char *(*author) (void);

  int   (*init) (void);
  int   (*cleanup) (void);

  int   (*pre_op) (void);
  int   (*op) (ND_Packet *p);
  int   (*post_op) (void);

  char        *filename;
  lt_dlhandle  lt;
}
ND_Plugin;

void    nd_plugin_init(void);
void    nd_plugin_activate(ND_Plugin *p);
char   *nd_plugin_get_description(ND_Plugin *p);
char   *nd_plugin_get_author(ND_Plugin *p);
void    nd_plugin_show_about(ND_Plugin *p);

#endif
