/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <stdlib.h>

#include <nd.h>
#include <nd_clipboard.h>
#include <nd_globals.h>
#include <nd_gui.h>
#include <nd_misc.h>
#include <nd_packet.h>
#include <nd_tcpdump.h>
#include <nd_tracefile.h>
#include <support.h>

static ND_Packet *cb = NULL;
static ND_Packet *cb_end = NULL;
static int cb_size;

static void
nd_clipboard_free(void)
{
  ND_Packet *p, *p2;

  if (cb)
    {
      p = cb;
      
      while (p)
	{
	  p2 = p;
	  p = p->next;
	  nd_packet_free(p2);
	}

      cb = cb_end = NULL;
      cb_size = 0;
    }
}


void  
nd_clipboard_cut(void)
{
  ND_Packet *p, *c = NULL;

  nd_clipboard_free();

  if (trace.sel)
    {
      for (p = trace.sel; p; p = p->sel_next)
	{
	  if (p->prev)
	    {
	      if (p->next)
		{
		  p->prev->next = p->next;
		  p->next->prev = p->prev;
		}
	      else
		{
		  p->prev->next = NULL;
		}
	    }
	  else if (p->next)
	    {
	      trace.pl = p->next;
	      p->next->prev = NULL;
	    }
	  else
	    {
	      trace.pl = NULL;
	      trace.pl_end = NULL;
	    }

	  if (c)
	    {
	      c->next = p;
	      p->prev = c;
	      c = p;
	    }
	  else
	    {
	      cb = c = p;
	    }
	}

      cb_end = c;
      cb_end->next = NULL;
      trace.num_packets -= trace.num_sel;
      cb_size = trace.num_sel;
      trace.num_sel = 0;

      nd_trace_set_dirty(TRUE);
      nd_misc_tcpdump_list_remove_selected_rows();
    }
}


void  
nd_clipboard_copy(void)
{
  ND_Packet *p, *p2, *c;

  nd_clipboard_free();

  if (trace.sel)
    {
      char message[LINESIZE];
      cb = c = nd_packet_duplicate(trace.sel);
            
      for (p = trace.sel->sel_next, cb_end = cb; p; p = p->sel_next)
	{
	  p2 = nd_packet_duplicate(p);
	  c->next = p2;
	  p2->prev = c;
	  c = p2;
	  cb_end = c;
	}
      
      cb_size = trace.num_sel;

      snprintf(message, LINESIZE, _("Copied %i packet(s) into clipboard."), cb_size);
      nd_misc_statusbar_set(message);
    }  
}


void  
nd_clipboard_paste(void)
{
  GtkWidget *w;
  ND_Packet *p, *p2, *c, *cb_copy = NULL, *cb_copy_end = NULL;
  int        index;
  char       line[LINESIZE];
  char      *s[2];

  if (!cb)
    return;

  if (trace.p)
    {
      char message[LINESIZE];

      w = gtk_object_get_data(GTK_OBJECT(toplevel), "tcpdump_list");
      D_ASSERT(w);

      index = nd_trace_packet_get_index(trace.p);

      cb_copy = c = nd_packet_duplicate(cb);
            
      for (p = cb->next, cb_copy_end = cb_copy; p; p = p->next)
	{
	  p2 = nd_packet_duplicate(p);
	  c->next = p2;
	  p2->prev = c;
	  c = p2;
	  cb_copy_end = c;
	}
            
      s[0] = line;
      s[1] = "";

      for (c = cb_copy; c; c = c->next)
	{
	  nd_tcpdump_get_packet_line(c, line, TRUE);
	  gtk_clist_insert(GTK_CLIST(w), index++, s);
	}
      
      p = trace.p->prev;
      if (p)
	{
	  p->next = cb_copy;
	  cb_copy->prev = p;
	}
      else
	{
	  trace.pl = cb_copy;
	  cb_copy->prev = NULL;
	}
      cb_copy_end->next = trace.p;
      trace.p->prev = cb_copy_end;
      
      trace.num_packets += cb_size;
      nd_misc_set_num_packets_label();
      nd_trace_set_dirty(TRUE);

      snprintf(message, LINESIZE, _("Pasted %i packet(s) from clipboard."), cb_size);
      nd_misc_statusbar_set(message);
    }
}


int   
nd_clipboard_occupied(void)
{
  return (cb != NULL);
}
