#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef LINUX
#define __FAVOR_BSD
#define __USE_BSD
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <callbacks.h>
#include <interface.h>
#include <support.h>

#include <nd.h>
#include <nd_arp.h>
#include <nd_clipboard.h>
#include <nd_globals.h>
#include <nd_gui.h>
#include <nd_filesel.h>
#include <nd_ip.h>
#include <nd_icmp.h>
#include <nd_ipfrag.h>
#include <nd_main.h>
#include <nd_misc.h>
#include <nd_tcp.h>
#include <nd_tracefile.h>
#include <nd_udp.h>
#include <nd_plugin.h>
#include <nd_prefs.h>
#include <nd_recent.h>
#include <nd_timestamp.h>

void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_filesel_trace_load();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_save();  

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_save_as1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_filesel_trace_save_as();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_main_safe_exit();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w, *w2;

  w = create_about_dialog();

  if ((w2 = gtk_object_get_data(GTK_OBJECT(w), "about_version_label")))
    {
      char label[LINESIZE];
      
#ifdef RELEASE
      snprintf(label, LINESIZE, _("Version %s"), VERSION);
#else
      snprintf(label, LINESIZE, "%s%s", _("Development Version as of "), LAST_UPDATE);
#endif
      gtk_label_set_text(GTK_LABEL(w2), label);
    }

  gtk_widget_show(w);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_filesel_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_filesel_ok();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_filesel_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_filesel_cancel();

  return;
  button = NULL;
  user_data = NULL;
}


gboolean
on_toplevel_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  nd_main_safe_exit();
  
  return TRUE;
  user_data = NULL;
  widget = NULL;
  event = NULL;
}



void
on_confirm_yes_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);
  nd_trace_save();
  nd_main_unsafe_exit();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_confirm_no_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);
  nd_main_unsafe_exit();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_confirm_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}


void
on_ip_id_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  if (user_data)
    nd_misc_show_generic_dialog(_("Enter IP ID here:"), "icmp_ip_id", 65535);
  else
    nd_misc_show_generic_dialog(_("Enter IP ID here:"), "ip_id", 65535);
  
  return;
  button = NULL;
}


void
on_ip_off_clicked                      (GtkButton       *button,
					gpointer         user_data)
{
  if (user_data)
    nd_misc_show_generic_dialog(_("Enter IP fragment offset:"), "icmp_ip_off", ((1 << 13)-1) * 8);
  else
    nd_misc_show_generic_dialog(_("Enter IP fragment offset:"), "ip_off", ((1 << 13)-1) * 8);

  return;
  button = NULL;
}


void
on_ip_ttl_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  if (user_data)
    nd_misc_show_generic_dialog(_("Enter IP TTL:"), "icmp_ip_ttl", 255);
  else
    nd_misc_show_generic_dialog(_("Enter IP TTL:"), "ip_ttl", 255);

  return;
  button = NULL;
}


void
on_ip_sum_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  if (user_data)
    nd_misc_show_generic_dialog(_("Enter IP checksum:"), "icmp_ip_sum", 65535);
  else
    nd_misc_show_generic_dialog(_("Enter IP checksum:"), "ip_sum", 65535);

  return;
  button = NULL;
}


void
on_ip_src_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  if (user_data)
    nd_misc_show_ip_dialog(_("Enter IP source address:"), "icmp_ip_src");
  else
    nd_misc_show_ip_dialog(_("Enter IP source address:"), "ip_src");

  return;
  button = NULL;
}


void
on_ip_dst_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  if (user_data)
    nd_misc_show_ip_dialog(_("Enter IP dest. address:"), "icmp_ip_dst");
  else
    nd_misc_show_ip_dialog(_("Enter IP dest. address:"), "ip_dst");

  return;
  button = NULL;
}


void
on_ip_rf_toggled                       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (user_data)
    ip_rf(gtk_toggle_button_get_active(togglebutton), ND_PROT_ICMP);
  else
    ip_rf(gtk_toggle_button_get_active(togglebutton), ND_PROT_NULL);
}


void
on_ip_df_toggled                       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (user_data)
    ip_df(gtk_toggle_button_get_active(togglebutton), ND_PROT_ICMP);
  else
    ip_df(gtk_toggle_button_get_active(togglebutton), ND_PROT_NULL);
}


void
on_ip_mf_toggled                       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (user_data)
    ip_mf(gtk_toggle_button_get_active(togglebutton), ND_PROT_ICMP);
  else
    ip_mf(gtk_toggle_button_get_active(togglebutton), ND_PROT_NULL);
}


void
on_ip_hl_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  if (user_data)
    nd_misc_show_generic_dialog(_("Enter IP header length:"), "icmp_ip_hl", 60);
  else
    nd_misc_show_generic_dialog(_("Enter IP header length:"), "ip_hl", 60);

  return;
  button = NULL;
}


void
on_ip_len_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  if (user_data)
    nd_misc_show_generic_dialog(_("Enter IP length:"), "icmp_ip_len", 65535);
  else
    nd_misc_show_generic_dialog(_("Enter IP length:"), "ip_len", 65535);

  return;
  button = NULL;
}


void
on_th_off_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter TCP data offset:"), "th_off", 60);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_th_x2_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  /* We can edit 4 bits in th_x2 and the two upper bits in th_flags,
   * therefore we can have values up to 2^6 - 1 = 63.
   */
  nd_misc_show_generic_dialog(_("Enter TCP unused data:"), "th_x2", 63);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_th_dport_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter TCP destination port:"), "th_dport", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_th_sport_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter TCP source port:"), "th_sport", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_th_seq_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_tcp_seqack_dialog(_("Enter 32-bit TCP seq. number:"), "th_seqno");

  return;
  user_data = NULL;
  button = NULL;
}


void
on_th_ack_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_tcp_seqack_dialog(_("Enter 32-bit TCP ack. number:"), "th_ackno");

  return;
  user_data = NULL;
  button = NULL;
}


void
on_th_win_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter TCP window size:"), "th_win", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_th_sum_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter TCP checksum:"), "th_sum", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_th_urg_flag_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tcp_urg(gtk_toggle_button_get_active(togglebutton));

  return;
  user_data = NULL;
}


void
on_th_ack_flag_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tcp_ack(gtk_toggle_button_get_active(togglebutton));

  return;
  user_data = NULL;
}


void
on_th_psh_flag_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tcp_push(gtk_toggle_button_get_active(togglebutton));

  return;
  user_data = NULL;
}


void
on_th_rst_flag_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tcp_rst(gtk_toggle_button_get_active(togglebutton));

  return;
  user_data = NULL;
}


void
on_th_fin_flag_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tcp_fin(gtk_toggle_button_get_active(togglebutton));

  return;
  user_data = NULL;
}


void
on_th_syn_flag_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tcp_syn(gtk_toggle_button_get_active(togglebutton));

  return;
  user_data = NULL;
}


void
on_th_urp_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter TCP urgent pointer:"), "th_urp", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_uh_ulen_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter UDP length:"), "uh_ulen", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_uh_sum_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter UDP checksum:"), "uh_sum", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_uh_dport_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter UDP dest. port:"), "uh_dport", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_uh_sport_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter UDP src. port:"), "uh_sport", 65536);

  return;
  user_data = NULL;
  button = NULL;
}



gboolean
on_ip_v_button_press_event             (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = create_menu_ip_v();

  if (user_data)
    {
      gtk_object_set_data(GTK_OBJECT(gtk_widget_get_toplevel(w)), "special",
			  GINT_TO_POINTER(ND_PROT_ICMP));
    }

  gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		 event->button, event->time);
  return FALSE;
  user_data = NULL;
  widget = NULL;
}


gboolean
on_ip_p_button_press_event             (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = create_menu_ip_proto();

  if (user_data)
    {
      gtk_object_set_data(GTK_OBJECT(gtk_widget_get_toplevel(w)), "special",
			  GINT_TO_POINTER(ND_PROT_ICMP));
    }

  gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		 event->button,event->time);
  return FALSE;
  user_data = NULL;
  widget = NULL;
}


gboolean
on_ip_tos_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = create_menu_ip_tos();

  if (user_data)
    {
      gtk_object_set_data(GTK_OBJECT(gtk_widget_get_toplevel(w)), "special",
			  GINT_TO_POINTER(ND_PROT_ICMP));
    }

  gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		 event->button,event->time);
  return FALSE;
  user_data = NULL;
  widget = NULL;
}


void
on_ip_v4_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_v(4, ND_PROT_ICMP);
  else
    ip_v(4, ND_PROT_NULL);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_ip_v6_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_v(6, ND_PROT_ICMP);
  else
    ip_v(6, ND_PROT_NULL);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_ip_v_custom_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    nd_misc_show_generic_dialog(_("Enter IP version:"), "icmp_ip_v", 15);
  else
    nd_misc_show_generic_dialog(_("Enter IP version:"), "ip_v", 15);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_ip_tos_mindelay_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_tos(IPTOS_LOWDELAY, ND_PROT_ICMP);
  else
    ip_tos(IPTOS_LOWDELAY, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_tos_maxthrough_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_tos(IPTOS_THROUGHPUT, ND_PROT_ICMP);
  else
    ip_tos(IPTOS_THROUGHPUT, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_tos_maxrel_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_tos(IPTOS_RELIABILITY, ND_PROT_ICMP);
  else
    ip_tos(IPTOS_RELIABILITY, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_tos_mincost_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_tos(IPTOS_MINCOST, ND_PROT_ICMP);
  else
    ip_tos(IPTOS_MINCOST, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_tos_custom_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    nd_misc_show_generic_dialog(_("Enter IP ToS:"), "icmp_ip_tos", 255);
  else
    nd_misc_show_generic_dialog(_("Enter IP ToS:"), "ip_tos", 255);

  return;
  user_data = NULL;
}


void
on_ip_p_icmp_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_ICMP, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_ICMP, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_igmp_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_ICMP, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_ICMP, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_ip_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_IPIP, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_IPIP, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_tcp_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_TCP, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_TCP, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_egp_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_EGP, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_EGP, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_udp_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_UDP, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_UDP, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_ipv6_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_IPV6, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_IPV6, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_ipv6routing_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_ROUTING, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_ROUTING, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_ipv6fragment_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_FRAGMENT, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_FRAGMENT, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_rsvp_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_RSVP, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_RSVP, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_icmpv6_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_ICMPV6, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_ICMPV6, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_raw_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    ip_p(IPPROTO_RAW, ND_PROT_ICMP);
  else
    ip_p(IPPROTO_RAW, ND_PROT_NULL);

  return;
  user_data = NULL;
}


void
on_ip_p_custom_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "special"))
    nd_misc_show_generic_dialog(_("Enter IP protocol number:"), "icmp_ip_p", 255);
  else
    nd_misc_show_generic_dialog(_("Enter IP protocol number:"), "ip_p", 255);

  return;
  user_data = NULL;
}


void
on_generic_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  GtkWidget *w2;

  w  = gtk_widget_get_toplevel(GTK_WIDGET(button));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "generic_spin");

  gtk_widget_hide(w);  

  /* -------------------------------------------------------------- IP */
  if (gtk_object_get_data(GTK_OBJECT(w), "ip_v"))
    ip_v(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	 ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_hl"))
    ip_hl(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	  ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_tos"))
    ip_tos(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_len"))
    ip_len(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_id"))
    ip_id(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	  ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_off"))
    ip_off(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_ttl"))
    ip_ttl(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_p"))
    ip_p(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	 ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_sum"))
    ip_sum(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_NULL);
  /* ---------------------------------------- IP in ICMP error message */
  if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_v"))
    ip_v(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	 ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_hl"))
    ip_hl(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	  ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_tos"))
    ip_tos(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_len"))
    ip_len(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_id"))
    ip_id(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	  ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_off"))
    ip_off(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_ttl"))
    ip_ttl(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_p"))
    ip_p(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	 ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_sum"))
    ip_sum(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)),
	   ND_PROT_ICMP);
  /* -------------------------------------------------------------- TCP */
  else if (gtk_object_get_data(GTK_OBJECT(w), "th_sport"))
    tcp_sport(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "th_dport"))
    tcp_dport(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  /* seqno/ackno handled in on_tcpseqack_ok_clicked() ... */
  else if (gtk_object_get_data(GTK_OBJECT(w), "th_off"))
    tcp_off(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "th_x2"))
    tcp_x2(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "th_win"))
    tcp_win(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "th_sum"))
    tcp_sum(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "th_urp"))
    tcp_urp(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  /* -------------------------------------------------------------- UDP */
  else if (gtk_object_get_data(GTK_OBJECT(w), "uh_sport"))
    udp_sport(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "uh_dport"))
    udp_dport(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "uh_ulen"))
    udp_ulen(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "uh_sum"))
    udp_sum(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  /* ------------------------------------------------------------- ICMP */
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_type"))
    icmp_type(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_code"))
    icmp_code(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_cksum"))
    icmp_cksum(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_error_sport"))
    icmp_error_sport(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_error_dport"))
    icmp_error_dport(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  /* ------------------------------------------------------------- ARP */
  else if (gtk_object_get_data(GTK_OBJECT(w), "arp_op"))
    arp_op(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)));
  else if (gtk_object_get_data(GTK_OBJECT(w), "arp_prot"))
    arp_pro(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)), ND_PROT_ARP);
  /* ------------------------------------------------------------- ARP/Ethernet */
  else if (gtk_object_get_data(GTK_OBJECT(w), "ether_prot"))
    arp_pro(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2)), ND_PROT_ETHER);
    
  gtk_widget_destroy(w);  

  return;
  user_data = NULL;
}


void
on_generic_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}


void
on_ip_entry_ok_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget        *w, *w2;
  struct in_addr    addr;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));

  w2 = gtk_object_get_data(GTK_OBJECT(w), "ip_byte1_spin");
  D_ASSERT(w2);
  ((u_char*)&addr)[0] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "ip_byte2_spin");
  D_ASSERT(w2);
  ((u_char*)&addr)[1] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "ip_byte3_spin");
  D_ASSERT(w2);
  ((u_char*)&addr)[2] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "ip_byte4_spin");
  D_ASSERT(w2);
  ((u_char*)&addr)[3] = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w2));

  if (gtk_object_get_data(GTK_OBJECT(w), "ip_src"))
    ip_src(addr, ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "ip_dst"))
    ip_dst(addr, ND_PROT_NULL);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_src"))
    ip_src(addr, ND_PROT_ICMP);
  else if (gtk_object_get_data(GTK_OBJECT(w), "icmp_ip_dst"))
    ip_dst(addr, ND_PROT_ICMP);

  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}


void
on_ip_entry_cancel_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}



void
on_tcpdump_list_row_move               (GtkCList        *clist,
                                        gint             arg1,
                                        gint             arg2,
                                        gpointer         user_data)
{
  nd_trace_move_packet(arg1, arg2);

  return;
  user_data = NULL;
  clist = NULL;
}


void
on_packet_hide_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_sel_hide();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_packet_show_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_sel_show();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_packet_cut_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_clipboard_cut();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_packet_copy_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_clipboard_copy();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_packet_paste_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_clipboard_paste();

  return;
  user_data = NULL;
  menuitem = NULL;
}



gboolean
on_tcpdump_list_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget    *w;
  int           row, col;

  nd_trace_hide_packet_tooltip();

  if ((event->button == 1)                      &&
      ((event->state & GDK_MODIFIER_MASK) == 0) &&
      trace.num_sel > 100)
    {
      nd_trace_clear_selection();
      gtk_clist_unselect_all(GTK_CLIST(widget));
    }
  else if (event->button == 3)
    {
      gtk_clist_get_selection_info(GTK_CLIST(widget), event->x, event->y, &row, &col);

      if (trace.num_sel == 0)
	{
	  gtk_clist_select_row(GTK_CLIST(widget), row, 0);
	}
      /* nd_packet_set(nd_trace_packet_get_nth(row)); */

      w = create_packet_option_menu();
      nd_misc_popupmenu_adjust(w);

      gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		     event->button, event->time);
    }

  return FALSE;
  user_data = NULL;
}


void
on_link_dest_addr_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_mac_dialog(_("Enter MAC src. addr:"), "dhost");

  return;
  user_data = NULL;
  button = NULL;
}


void
on_link_source_addr_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_mac_dialog(_("Enter MAC dest. addr:"), "shost");

  return;
  user_data = NULL;
  button = NULL;
}


void
on_mac_okay_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}


void
on_mac_cancel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}


gboolean
on_incr_button_press_event             (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget    *w, *w2;
  char          s[256];
  
  w  = gtk_widget_get_toplevel(GTK_WIDGET(widget));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "tcp_seqack_entry");
  D_ASSERT(w2);

  sprintf(s, "%u", atoi(gtk_entry_get_text(GTK_ENTRY(w2))) + 1);
  gtk_entry_set_text(GTK_ENTRY(w2), s);

  return FALSE;
  event = NULL;
  user_data = NULL;
}


gboolean
on_decr_button_press_event             (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget    *w, *w2;
  char          s[256];

  w  = gtk_widget_get_toplevel(GTK_WIDGET(widget));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "tcp_seqack_entry");
  D_ASSERT(w2);

  sprintf(s, "%u", atoi(gtk_entry_get_text(GTK_ENTRY(w2))) - 1);
  gtk_entry_set_text(GTK_ENTRY(w2), s);

  return FALSE;
  event = NULL;
  user_data = NULL;
}


void
on_tcpseqack_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  GtkWidget *w2, *w3, *w4;

  w  = gtk_widget_get_toplevel(GTK_WIDGET(button));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "arrow1");
  D_ASSERT(w2);
  w3 = gtk_object_get_data(GTK_OBJECT(w), "arrow2");
  D_ASSERT(w3);
  w4 = gtk_object_get_data(GTK_OBJECT(w), "tcp_seqack_entry");
  D_ASSERT(w4);

  gtk_widget_hide(w);  

  /* -------------------------------------------------------------- TCP */
  if (gtk_object_get_data(GTK_OBJECT(w), "th_seqno"))
    tcp_seqno(strtoul(gtk_entry_get_text(GTK_ENTRY(w4)), (char**)NULL, 10));
  else if (gtk_object_get_data(GTK_OBJECT(w), "th_ackno"))
    tcp_ackno(strtoul(gtk_entry_get_text(GTK_ENTRY(w4)), (char**)NULL, 10));
  
  gtk_widget_destroy(w);  

  return;
  user_data = NULL;
}


void
on_tcpseqack_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}


gboolean
on_generic_spin_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  GtkWidget *w2;

  w = gtk_widget_get_toplevel(GTK_WIDGET(widget));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "generic_ok_button");
  D_ASSERT(w2);

  if (event->keyval == GDK_Return)
    on_generic_ok_clicked(GTK_BUTTON(w2), user_data);
  
  return FALSE;
}


gboolean
on_tcp_seqack_entry_key_press_event    (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  GtkWidget *w2;

  w = gtk_widget_get_toplevel(GTK_WIDGET(widget));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "tcp_seqack_ok_button");
  D_ASSERT(w2);

  if (event->keyval == GDK_Return)
    on_tcpseqack_ok_clicked(GTK_BUTTON(w2), user_data);
  
  return FALSE;
}


void
on_tcpdump_list_unselect_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  nd_trace_unselect_packet(row);

  return;
  user_data = NULL;
  clist = NULL;
  event = NULL;
  column = 0;
}


void
on_tcpdump_list_select_row             (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  nd_trace_select_packet(row);
  nd_packet_set(nd_trace_packet_get_nth(row));

  return;
  user_data = NULL;
  clist = NULL;
  event = NULL;
  column = 0;
}

void
on_packet_unselect_all_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget  *w;

  w = gtk_object_get_data(GTK_OBJECT(toplevel), "tcpdump_list");
  D_ASSERT(w);
  gtk_clist_unselect_all(GTK_CLIST(w));

  /* This called OUR callback -- no signals are sent,
   * so we need to do this manually
   */
  nd_trace_clear_selection();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_packet_select_all_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget  *w;

  w = gtk_object_get_data(GTK_OBJECT(toplevel), "tcpdump_list");
  D_ASSERT(w);
  gtk_clist_select_all(GTK_CLIST(w));

  /* This called OUR callback -- no signals are sent,
   * so we need to do this manually
   */
  nd_trace_full_selection();
  nd_packet_set(nd_trace_packet_get_nth(0));

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_tcpdump_list_end_selection          (GtkCList        *clist,
                                        gpointer         user_data)
{
  return;
  clist = NULL;
  user_data = NULL;
}

void
on_packet_delete_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_sel_delete();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_ip_frag1_spinbutton_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  nd_ipfrag_adjust(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable)), FIRST);
  
  return;
  user_data = NULL;
}


void
on_ip_frag_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_ipfrag_apply();
  
  return;
  button = NULL;
  user_data = NULL;
}


void
on_ip_frag_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_ipfrag_hide_dialog();  

  return;
  button = NULL;
  user_data = NULL;
}


void
on_ip_frag2_spinbutton_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  nd_ipfrag_adjust(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable)), SECOND);
  
  return;
  user_data = NULL;
}


void
on_packet_fragment_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_ipfrag_show_dialog();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_packet_hilight_fragments_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_packet_hilight_fragments(trace.p);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_packet_dehilight_fragments_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_packet_dehilight_fragments();

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_packet_reassemble_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_ipfrag_reassemble();

  return;
  menuitem = NULL;
  user_data = NULL;
}



gboolean
on_menubar_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  nd_misc_menu_adjust();
  
  return FALSE;
  widget = NULL;
  event = NULL;
  user_data = NULL;
}


void
on_icmp_cksum_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter ICMP checksum:"), "icmp_cksum", 65535);

  return;
  button = NULL;
  user_data = NULL;
}


void
on_icmp_type_echo_reply_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_ECHOREPLY);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_destination_unreachable_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_UNREACH);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_source_quench_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_SOURCEQUENCH);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_redirect_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_REDIRECT);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_echo_request_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_ECHO);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_router_adv_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_ROUTERADVERT);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_router_solicit_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_ROUTERSOLICIT);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_time_exceeded_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_TIMXCEED);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_parameter_problem_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_PARAMPROB);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_timestamp_request_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_TSTAMP);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_timestamp_reply_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_TSTAMPREPLY);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_info_request_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_IREQ);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_info_reply_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_IREQREPLY);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_addr_mask_request_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_MASKREQ);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_addr_mask_reply_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_type(ICMP_MASKREPLY);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_type_custom_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter ICMP Type:"), "icmp_type", 255);      
  
  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_network_unreachable_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_NET);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_host_unreachable_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_HOST);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_protocol_unreachable_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_PROTOCOL);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_port_unreachable_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_PORT);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_frag_needed_w_df_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_NEEDFRAG);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_source_route_failed_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_SRCFAIL);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_dest_network_unknown_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_NET_UNKNOWN);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_dest_host_unknown_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_HOST_UNKNOWN);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_source_host_isolated_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_ISOLATED);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_dest_network_prohibited_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_NET_PROHIB);

  return;
  menuitem = NULL;
  user_data = NULL;

}


void
on_icmp_code_dest_host_prohibited_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_HOST_PROHIB);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_network_unreachable_for_tos_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_TOSNET);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_host_unreachable_for_tos_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_TOSHOST);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_communication_filtered_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_FILTER_PROHIB);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_host_precedence_violation_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_HOST_PRECEDENCE);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_precedence_cutoff_in_effect_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_UNREACH_PRECEDENCE_CUTOFF);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_redirect_for_network_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_REDIRECT_NET);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_redirect_for_host_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_REDIRECT_HOST);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_redirect_for_tos_and_network_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_REDIRECT_TOSNET);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_redirect_for_tos_and_host_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_REDIRECT_TOSHOST);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_ttl_zero_in_transit_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_TIMXCEED_INTRANS);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_ttl_zero_in_reassembly_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_TIMXCEED_REASS);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_icmp_code_ip_header_bad_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(0);

  return;
  menuitem = NULL;
  user_data = NULL;  
}


void
on_icmp_code_required_option_missing_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  icmp_code(ICMP_PARAMPROB_OPTABSENT);

  return;
  menuitem = NULL;
  user_data = NULL;
}


gboolean
on_icmp_type_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = create_menu_icmp_type();
  gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		 event->button,event->time);
  return FALSE;
  user_data = NULL;
  widget = NULL;
}


gboolean

on_icmp_code_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;

  switch (icmp_get_type())
    {
    case -1:
      /* Error case -- do nothing */
      break;
    case ICMP_UNREACH:
      w = create_menu_icmp_code_dest_unreach();
      gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		     event->button,event->time);
      break;
    case ICMP_REDIRECT:
      w = create_menu_icmp_code_redirect();
      gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		     event->button,event->time);
      break;
    case ICMP_TIMXCEED:
      w = create_menu_icmp_code_time_exceeded();
      gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		     event->button,event->time);
      break;
    case ICMP_PARAMPROB:
      w = create_menu_icmp_code_parameter_problem();
      gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		     event->button,event->time);
      break;
    default:
      nd_misc_show_generic_dialog(_("Enter ICMP Code:"), "icmp_code", 255);      
    }

  return FALSE;
  user_data = NULL;
  widget = NULL;
}


void
on_icmp_code_custom_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter ICMP Code:"), "icmp_code", 255);      
  
  return;
  menuitem = NULL;
  user_data = NULL;
}



void
on_icmp_error_src_port_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter source port:"), "icmp_error_sport", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_icmp_error_dst_port_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter destination port:"), "icmp_error_dport", 65535);

  return;
  user_data = NULL;
  button = NULL;
}


void
on_apply_to_all_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (GTK_CHECK_MENU_ITEM(menuitem)->active)
    trace.apply_to_all = TRUE;
  else
    trace.apply_to_all = FALSE;

  return;
  user_data = NULL;
}


void
on_tcpdump_list_select_all             (GtkCList        *clist,
                                        gpointer         user_data)
{
  nd_trace_full_selection();
  nd_packet_set(nd_trace_packet_get_nth(0));

  return;
  clist = NULL;
  user_data = NULL;
}


void
on_tcpdump_list_unselect_all           (GtkCList        *clist,
                                        gpointer         user_data)
{
  nd_trace_clear_selection();

  return;
  clist = NULL;
  user_data = NULL;
}


void
on_tcpdump_list_size_allocate          (GtkWidget       *widget,
                                        GtkAllocation   *allocation,
                                        gpointer         user_data)
{
  GtkWidget  *w;

  w = gtk_object_get_data(GTK_OBJECT(toplevel), "tcpdump_list");
  D_ASSERT(w);
  gtk_clist_set_column_width(GTK_CLIST(w), 0, allocation->width - 60);

  return;
  widget = NULL;
  user_data = NULL;
}


void
on_about_okay_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_prefs_dialog_show();

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_pref_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_prefs_dialog_ok();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_pref_cancel_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_prefs_dialog_cancel();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_pref_save_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_prefs_dialog_save();

  return;
  button = NULL;
  user_data = NULL;
}


gboolean
on_trace_win_bar_button_release_event  (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  return FALSE;
  widget = NULL;
  event = NULL;
  user_data = NULL;
}


void
on_about_plugins1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_aboutdummyitem_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ND_Plugin *p;

  p = (ND_Plugin*) gtk_object_get_data(GTK_OBJECT(menuitem), "plugin");
  D_ASSERT(p);

  nd_plugin_show_about(p);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_plugin_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ND_Plugin *p;

  p = (ND_Plugin*) gtk_object_get_data(GTK_OBJECT(menuitem), "plugin");
  D_ASSERT(p);

  nd_plugin_activate(p);

  return;
  user_data = NULL;
}


void
on_pref_tcpdump_loc_browse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_filesel_select_tcpdump();
  
  return;
  button = NULL;
  user_data = NULL;
}


void
on_pref_tcpdump_loc_entry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  return;
  editable = NULL;
  user_data = NULL;
}


void
on_tcpdump_error_okay_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  user_data = NULL;
}


gboolean
on_tcpdump_list_motion_notify_event    (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  GtkCList *cl = GTK_CLIST(widget);
  int row = (event->y - cl->voffset) / (cl->row_height + 1);

  /* We won't show timestamps if any buttons are pressed
     while moving around ... */
  
  if ((event->state & (GDK_BUTTON1_MASK |
		       GDK_BUTTON2_MASK |
		       GDK_BUTTON3_MASK |
		       GDK_BUTTON4_MASK |
		       GDK_BUTTON5_MASK)) != 0)
    return FALSE;

  nd_trace_show_packet_tooltip(row,
			       (int)event->x_root,
			       (int)event->y_root);

  return FALSE;
  user_data = NULL;
}


gboolean
on_tcpdump_list_leave_notify_event     (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        gpointer         user_data)
{
  nd_trace_hide_packet_tooltip();

  return FALSE;
  widget = NULL;
  event = NULL;
  user_data = NULL;
}


gboolean
on_tcpdump_list_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  nd_trace_hide_packet_tooltip();

  return FALSE;
  widget = NULL;
  event = NULL;
  user_data = NULL;
}


gboolean
on_splash_window_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gtk_widget_hide(widget);

  return FALSE;
  event = NULL;
  user_data = NULL;
}


void
on_recent_item0_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(0);

  return;
  menuitem = user_data = NULL;
}


void
on_recent_item1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(1);

  return;
  menuitem = user_data = NULL;
}


void
on_recent_item2_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(2);

  return;
  menuitem = user_data = NULL;
}


void
on_recent_item3_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(3);

  return;
  menuitem = user_data = NULL;
}


void
on_recent_item4_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(4);

  return;
  menuitem = user_data = NULL;
}


void
on_arp_hw_netrom_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_NETROM);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_ethernet_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_ETHER);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_eethernet_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_EETHER);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_ax25_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_AX25);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_pronet_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_PRONET);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_chaosnet_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_CHAOS);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_ieee802_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_IEEE802);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_arcnet_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_ARCNET);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_appletalk_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_APPLETLK);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_dlci_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_DLCI);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_atm_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_ATM);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hw_metricom_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_hrd(ARPHRD_METRICOM);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_ether_prot_pup_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "ethernet"))
    arp_pro(ETHERTYPE_PUP, ND_PROT_ETHER);
  else
    arp_pro(ETHERTYPE_PUP, ND_PROT_ARP);

  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_ether_prot_ip_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "ethernet"))
    arp_pro(ETHERTYPE_IP, ND_PROT_ETHER);
  else
    arp_pro(ETHERTYPE_IP, ND_PROT_ARP);


  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_ether_prot_arp_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "ethernet"))
    arp_pro(ETHERTYPE_ARP, ND_PROT_ETHER);
  else
    arp_pro(ETHERTYPE_ARP, ND_PROT_ARP);


  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_ether_prot_rarp_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "ethernet"))
    arp_pro(ETHERTYPE_REVARP, ND_PROT_ETHER);
  else
    arp_pro(ETHERTYPE_REVARP, ND_PROT_ARP);


  return;
  user_data = NULL;
  menuitem = NULL;
}


void
on_arp_hard_size_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter ARP hardware address size:"), "arp_hard_size", 255);
  
  return;
  button = NULL;
  user_data = NULL;
}


void
on_arp_prot_size_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter ARP protocol address size:"), "arp_prot_size", 255);
  
  return;
  button = NULL;
  user_data = NULL;
}


void
on_arp_sender_link_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  arp_sender_link();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_arp_sender_net_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  arp_sender_net();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_arp_target_link_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  arp_target_link();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_arp_target_net_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  arp_target_net();

  return;
  button = NULL;
  user_data = NULL;
}


void
on_arp_request_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_op(ARPOP_REQUEST);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_arp_reply_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_op(ARPOP_REPLY);

  return;
  menuitem = NULL;
  user_data = NULL;  
}


void
on_rarp_request_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_op(ARPOP_RREQUEST);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_rarp_reply_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_op(ARPOP_RREPLY);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_inarp_request_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_op(ARPOP_InREQUEST);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_inarp_reply_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_op(ARPOP_InREPLY);

  return;
  menuitem = NULL;
  user_data = NULL;
}


void
on_arp_nak_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  arp_op(ARPOP_NAK);

  return;
  menuitem = NULL;
  user_data = NULL;
}


gboolean
on_arp_op_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = create_menu_arp_op();

  gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		 event->button, event->time);

  return FALSE;
  widget = NULL;
  user_data = NULL;
}


gboolean
on_arp_hard_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = create_menu_arp_hardware();

  gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		 event->button, event->time);

  return FALSE;
  widget = NULL;
  user_data = NULL;
}


gboolean
on_arp_prot_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = create_menu_link_protocol_type();

  gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		 event->button, event->time);

  return FALSE;
  widget = NULL;
  user_data = NULL;
}


gboolean
on_link_type_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = create_menu_link_protocol_type();

  gtk_object_set_data(GTK_OBJECT(gtk_widget_get_toplevel(w)), "ethernet",
		      GINT_TO_POINTER(ND_PROT_ETHER));
  gtk_menu_popup(GTK_MENU(w), NULL, NULL, NULL, NULL,
		 event->button, event->time);

  return FALSE;
  widget = NULL;
  user_data = NULL;
}



void
on_ether_prot_custom_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(menuitem));

  if (gtk_object_get_data(GTK_OBJECT(w), "ethernet"))
    nd_misc_show_generic_dialog(_("Enter protocol number:"), "ether_prot", 65535);
  else
    nd_misc_show_generic_dialog(_("Enter protocol number:"), "arp_prot", 65535);

  return;
  menuitem = NULL;
  user_data = NULL;

}


void
on_arp_custom_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_misc_show_generic_dialog(_("Enter (R)ARP operation number:"), "arp_op", 65535);

  return;
  menuitem = NULL;
  user_data = NULL;
}

