#ifndef CCMHDR_H
#define CCMHDR_H


typedef struct ccm_names {
  char* std_name;
  char* std_unit;
  char* long_name;
  char* udunit;
}CCMNAMES;

CCMNAMES ccm_name_tab[] = {
  {"PHIS",     "M2/S2",    "surface geopotential",                           "m2/s2"},
  {"PS",       "PA",       "surface pressure",                               "Pa"},
  {"T",        "K",        "temperature",                                    "K"},
  {"U",        "M/S",      "zonal wind component",                           "m/s"},
  {"V",        "M/S",      "meridional wind component",                      "m/s"},
  {"ETADOT",   "1/S",      "vertical (eta) velocity",                        "s-1"},
  {"Q",        "KG/KG",    "specific humidity",                              "kg/kg"},
  {"HA01",     "KG/KGS",   "horizontal advective tendency of water vapor",   "kg/kg/s"},
  {"VA01",     "KG/KGS",   "vertical advective tendency of water vapor",     "kg/kg/s"},
  {"DF01",     "KG/KGS",   "SLT tendency of water vapor",                    "kg/kg/s"},
  {"TA01",     "KG/KGS",   "total advective tendency of water vapor",        "kg/kg/s"},
  {"VD01",     "KG/KGS",   "vertical diffusion tendency of water vapor",     "kg/kg/s"},
  {"DC01",     "KG/KGS",   "convective adjustment tendency of water vapor",  "kg/kg/s"},
  {"TE01",     "KG/KGS",   "total tendency of water vapor",                  "kg/kg/s"},
  {"SS01",     "KG/KGS",   "source/sink tendency of water vapor",            "kg/kg/s"},
  {"SF01",     "KG/M2/S",  "surface flux of water vapor",                    "kg/m2/s"},
  {"DUH",      "K/S",      "U horizontal diffusive heating",                 "K/s"},
  {"DVH",      "K/S",      "V horizontal diffusive heating",                 "K/s"},
  {"DTH",      "K/S",      "T horizontal diffusive heating",                 "K/s"},
  {"NDQH",     "KG/KGS",   "Q horizontal diffusion",                         "kg/kg/s"},
  {"ORO",      "FLAG",     "ocean (0), land (1), sea ice (2) flag",          NULL},
  {"WET",      "M",        "Soil moisture",                                  "m"},
  {"SNOWH",    "M",        "Water equivalent snow depth",                    "m"},
  {"PRECL",    "M/S",      "Large-scale (stable) precipitation rate",        "m/s"},
  {"PRECC",    "M/S",      "Convective precipitation rate",                  "m/s"},
  {"PRECSL",   "M/S",    "Large-scale (stable) snow rate (water equivalent)","m/s"},
  {"PRECSC",   "M/S",      "Convective snow rate (water equivalent)",        "m/s"},
  {"SHFLX",    "W/M2",     "Surface sensible heat flux",                     "W/m2"},
  {"LHFLX",    "W/M2",     "Surface latent heat flux",                       "W/m2"},
  {"QFLX",     "KG/M2/S",  "Surface water flux",                             "kg/m2/s"},
  {"PBLH",     "M",        "PBL height",                                     "m"},
  {"USTAR",    "M/S",      "Surface friction velocity",                      "m/s"},
  {"TREFHT",   "K",        "Reference height temperature",                   "K"},
  {"Q10",      "KG/KG",    "10-meter specific humidity",                     "kg/kg"},
  {"CGH",      "K/M",      "Counter-gradient term for heat in PBL",          "K/m"},
  {"CGQ",      "1/M",      "Counter-gradient term for moisture in PBL",      "m-1"},
  {"CGS",      "S/M2", "Counter-gradient coefficient on surface kinematic fluxes","s/m2"},
  {"TPERT",    "K",        "Perturbation temperature (eddies in PBL)",       "K"},
  {"QPERT",    "KG/KG",    "Perturbation specific humidity (eddies in PBL)", "kg/kg"},
  {"KVH",      "M2/S",     "Vertical diffusion diffusivities (heat/moisture)","m2/s"},
  {"KVM",      "M2/S",     "Vertical diffusion diffusivities (momentum)",    "m2/s"},
  {"DUV",      "M/S2",     "U vertical diffusion",                           "m/s2"},
  {"DVV",      "M/S2",     "V vertical diffusion",                           "m/s2"},
  {"DTV",      "K/S",      "T vertical diffusion",                           "K/s"},
  {"FSNS",     "W/M2",     "Net solar flux at surface",                      "W/m2"},
  {"FLNS",     "W/M2",     "Net longwave flux at surface",                   "W/m2"},
  {"FLNT",     "W/M2",     "Net longwave flux at top",                       "W/m2"},
  {"FSNT",     "W/M2",     "Net solar flux at top",                          "W/m2"},
  {"CLOUD",    "FRACTION", "Cloud fraction",                                 NULL},
  {"SETLWP",   "G/M2",     "Specified liquid water path lengths",            "gram/m2"},
  {"CLDLWP","G/M2","Actual cloud liquid water path length (account for cloud fraction)","gram/m2"},
  {"EFFCLD",   "FRACTION", "Effective cloud fraction",                       NULL},
  {"FLNTC",    "W/M2",     "Clearsky net longwave flux at top",              "W/m2"},
  {"FSNTC",    "W/M2",     "Clearsky net solar flux at top",                 "W/m2"},
  {"FLNSC",    "W/M2",     "Clearsky net longwave flux at surface",          "W/m2"},
  {"FSNSC",    "W/M2",     "Clearsky net solar flux at surface",             "W/m2"},
  {"OMEGA",    "PA/S",     "Vertical pressure velocity",                     "Pa/s"},
  {"DQP",      "KG/KGS",   "Specific humidity tendency due to precipitation","kg/kg/s"},
  {"TAUX",     "N/M2",     "X-component (east-west) of surface stress",      "N/m2"},
  {"TAUY",     "N/M2",     "Y-component (north-south) of surface stress",    "N/m2"},
  {"SRFRAD",   "W/M2",     "Net radiative flux at surface",                  "W/m2"},
  {"QRS",      "K/S",      "Solar heating rate",                             "K/s"},
  {"QRL",      "K/S",      "Longwave heating rate",                          "K/s"},
  {"CLDTOT",   "FRACTION", "Vertically-integrated, random overlap, total cloud amount",    NULL},
  {"CLDLOW",   "FRACTION", "Vertically-integrated, random overlap, low cloud amount",      NULL},
  {"CLDMED",   "FRACTION", "Vertically-integrated, random overlap, mid-level cloud amount",NULL},
  {"CLDHGH",   "FRACTION", "Vertically-integrated, random overlap, high cloud amount",     NULL},
  {"TOTLWP",   "FRACTION", "Vertically-integrated actual liquid water path length",        NULL},
  {"LWSH",     "M",        "Liquid water scale height",                      "m"},
  {"TS1",      "K",        "Surface temperature (level 1)",                  "K"},
  {"TS2",      "K",        "Subsurface temperature (level 2)",               "K"},
  {"TS3",      "K",        "Subsurface temperature (level 3)",               "K"},
  {"TS4",      "K",        "Subsurface temperature (level 4)",               "K"},
  {"TS",       "K",        "Surface temperature",                            "K"},
  {"SOLIN",    "W/M2",     "Solar insolation",                               "W/m2"},
  {"UTEND",    "M/S2",     "U tendency",                                     "m/s2"},
  {"VTEND",    "M/S2",     "V tendency",                                     "m/s2"},
  {"TTEND",    "K/S",      "T tendency",                                     "K/s"},
  {"LPSTEN",   "PA/S",     "Surface pressure tendency",                      "Pa/s"},
  {"UTGW",     "M/S2",     "U tendency - gravity wave drag",                 "m/s2"},
  {"VTGW",     "M/S2",     "V tendency - gravity wave drag",                 "m/s2"},
  {"TAUGWX",   "N/M2",     "East-west gravity wave drag surface stress",     "N/m2"},
  {"TAUGWY",   "N/M2",     "North-south gravity wave drag surface stress",   "N/m2"},
  {"DTCOND",   "K/S",      "T tendency - convective adjustment",             "K/s"},
  {"CMFDT",    "K/S",      "T tendency - moist convetion",                   "K/s"},
  {"CMFDQ",    "KG/KGS",   "Q tendency - moist convection",                  "kg/kg/s"},
  {"CMFDQF",   "KG/KGS",   "Q tendency - moist convective rainout",          "kg/kg/s"},
  {"CMFMC",    "KG/M2S",   "Moist convection mass flux",                     "kg/m2/s"},
  {"CMFSL",    "W/M2",     "Moist convection liquid water static energy flux","W/m2"},
  {"CMFLQ",    "W/M2",     "Moist convection total water flux",              "W/m2"},
  {"CNVCLD",   "FRACTION", "Random overlap total convective cloud amount",   NULL},
  {"VT",       "KM/S",     "Meridional heat transport",                      "K m/s"},
  {"VZ",       "M3/S3",    "Meridional transport",                           "m3/s3"},
  {"VQ",       "M/S",      "Meridional water transport",                     "m/s"},
  {"VVPUU",    "M2/S2",    "Kinetic Energy",                                 "m2/s2"},
  {"ALB",      "FRACTION", "Albedo",                                         NULL},
  {"ALBCLR",   "FRACTION", "Clear sky albedo",                               NULL},
  {"RELHUM",   "FRACTION", "Relative humidity",                              NULL},
  {"Z2",       "M",        "Geopotential Height (above sea level)",          "m"},
  {"MQ",       "KG/M2",    "water mass",                                     "kg/m2"},
  {"PSL",      "PASCALS",  "Sea level pressure",                             "Pa"},
  {"OMEGAUP",  "PA/S",     "Average of Omega when omega is < 0 (up)",        "Pa/s"},
  {"NUMOMGUP", "FRACTION", "Percentage of time omega is < 0 (up)",           NULL},
  {"CLOUDUP",  "FRACTION", "Average of Cloud when omega is < 0 (up)",        NULL},
  {"DPSLON",   "M/S2",     "Longitude Pressure Gradient",                    "m/s2"},
  {"DPSLAT",   "M/S2",     "Latitude Pressure Gradient",                     "m/s2"},
  {NULL,NULL,NULL,NULL}
};



#endif
