/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QApplication>
#include <QDebug>
#include <QKeyEvent>

#include "MvQTreeView.h"

//#include <iostream>

MvQTreeView::MvQTreeView(QWidget *parent) : QTreeView(parent) 
{
	activatedByKeyNavigation_=false;
	columnToDrag_=0;
}

void MvQTreeView::keyReleaseEvent(QKeyEvent *event)
{
	if(activatedByKeyNavigation_)
	{
		if(event->isAutoRepeat() == false  &&
           	  (event->key() == Qt::Key_Up || event->key() == Qt::Key_Down || 
	    	  event->key() == Qt::Key_PageUp || event->key() == Qt::Key_PageDown ||
	    	  event->key() == Qt::Key_Home || event->key() == Qt::Key_End))
		{		
			emit activated(currentIndex());
		}
	}
	else
	{
		QTreeView::keyReleaseEvent(event);
	}
}

void MvQTreeView::keyboardSearch(const QString & search)
{

}

bool MvQTreeView::dragEnabled()
{
	return (dragDropMode() != DropOnly && dragDropMode() != NoDragDrop);
}

bool MvQTreeView::dropEnabled()
{
	return (dragDropMode() != DragOnly && dragDropMode() != NoDragDrop);
}

//===========================
// Drag
//===========================
/*
void MvQTreeView::mousePressEvent(QMouseEvent *event)
{
	if(dragEnabled() &&
	   event->button() == Qt::LeftButton)
	{
		startPos_=event->pos();
	}
	
	QTreeView::mousePressEvent(event);
}

void MvQTreeView::mouseMoveEvent(QMouseEvent *event)
{
	if(dragEnabled() &&
	   event->buttons() & Qt::LeftButton)
	{
		int distance = (event->pos() - startPos_).manhattanLength();
		if(distance >= QApplication::startDragDistance())
		{
			performDrag();
		}
	}
	
	QTreeView::mouseMoveEvent(event);
}

void MvQTreeView::performDrag()
{
	if(!dragEnabled())
		return;

	
	QAbstractItemModel* model = (QAbstractItemModel*) this->model();	
	QString txt;

	if(columnToDrag_ != currentIndex().column())
	{
		QModelIndex index=model->index(currentIndex().row(),columnToDrag_,currentIndex().parent());
		txt = model->data(index).toString();
	}
	else
	{
		txt = model->data(currentIndex()).toString();
	}
 
	if(!txt.isEmpty())
	{
		QMimeData *mimeData = new QMimeData;	
		mimeData->setText(txt);
		
		QDrag *drag = new QDrag(this);
		drag->setMimeData(mimeData);
		if(drag->exec(Qt::CopyAction)  == Qt::CopyAction)
		{
		}
	}
}

//===========================
// Drop
//===========================

void MvQTreeView::dragEnterEvent(QDragEnterEvent *event)
{
	if(!dropEnabled())
		return;

	MvQTreeView *source = qobject_cast<MvQTreeView*>(event->source());
	
	if(source)
	{
		event->setDropAction(Qt::MoveAction);
		event->accept();
	}
}

void MvQTreeView::dragMoveEvent(QDragMoveEvent *event)
{
	if(!dropEnabled())
		return;

	MvQTreeView *source = qobject_cast<MvQTreeView*>(event->source());
	
	if(source)
	{
		event->setDropAction(Qt::MoveAction);
		event->accept();
	}
}

void MvQTreeView::dropEvent(QDropEvent *event)
{
	if(!dropEnabled())
		return;

	MvQTreeView *source = qobject_cast<MvQTreeView*>(event->source());
	
	if(source)
	{
		qDebug() << "Drop text: " << event->mimeData()->text();
		event->setDropAction(Qt::MoveAction);
		event->accept();
	}

	emit dropAccepted(event->mimeData()->text());
}
*/