/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Temporary.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Temporary_H
#define Temporary_H

#ifndef IconObject_H
#include "IconObject.h"
#endif

#include "Request.h"

#include <string>
using std::string;


class Temporary : public IconObject {
public:

// -- Exceptions
	// None

// -- Contructors

	Temporary(IconObject*,const Request&,const IconClass* = 0);

// -- Destructor

	virtual ~Temporary(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods


// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Temporary(const Temporary&);
	Temporary& operator=(const Temporary&);

// -- Members

	IconObjectH ref_;
	Request     request_;

// -- Methods
	// None

// -- Overridden methods

	// From IconObject

	virtual void createFiles();
	virtual Log& log();
	virtual Request request() const;
	virtual void request(const Request&);
	virtual string fullName() const;
	virtual Path   path()     const;
	// Different implementation of the path() if used by a 
	// ShellTask.
	// For Temporary Objects, it will return the PATH of the attached request, (if it exists)
	// This is done to enable the visualisation of the MAGML Objects 
	// without possible side effects! 
	virtual Path   pathForShellTask() const;
	virtual Path   dotPath()  const;
	virtual Folder* parent()  const;

	virtual bool rename(const string&);
	virtual bool renamable() const;
	virtual bool temporary() const; 
	
	virtual Folder* embeddedFolder(const string& n,bool) const;
	virtual Path    embeddedPath()  const;
	virtual Folder* embeddedFolder(bool) const;
	
	virtual string relativeName(IconObject*) const;
	virtual string makeFullName(const string&) const;



// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Temporary& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Temporary**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Temporary);
//#endif

#endif
