/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ConfigLoader.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef ConfigLoader_H
#define ConfigLoader_H

#include <string>
using std::string;

#ifndef Metview_H
#include "Metview.h"
#endif


class ConfigLoader {
public:

// -- Exceptions
	// None

// -- Contructors

	ConfigLoader(const string& name,int order);

// -- Destructor

	virtual ~ConfigLoader(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual void load(request*) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static bool process(request*,int);

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	ConfigLoader(const ConfigLoader&);
	ConfigLoader& operator=(const ConfigLoader&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const ConfigLoader& p)
	//	{ p.print(s); return s; }

};

template<class T>
class SimpleLoader : public ConfigLoader {
	void load(request* r) { T::load(r); }
public:
    SimpleLoader(const string& name,int order) : ConfigLoader(name,order) {}
};


#endif
