/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <Xm/Xm.h>
#include <Xm/ListP.h>
#include <stdio.h>
#include <errno.h>
#include <stdarg.h>
#include "xec.h"

/*---------------------------------------------------

	Remove all lines of a List.

----------------------------------------------------*/

void xec_ClearList(Widget w)
{
	ARG_DEF(4);

	SetArg(XmNselectedItemCount, 0 );
	SetArg(XmNselectedItems, NULL );
	SetArg(XmNitemCount, 0 );
	SetArg(XmNitems, NULL );
	SetValues(w);

}

/*-----------------------------------------------------

	Remove one line to a list

------------------------------------------------------*/

void xec_RemoveListItem(Widget w,const char *p)
{
	XmString item= XmStringCreateSimple((char*)p);
	XmListDeleteItem(w,item);
	XmStringFree(item);
}

/*----------------------------------------------------

	Add to a list with max number of items

-----------------------------------------------------*/

void xec_AddListMax(Widget w,int max,const char *p)
{
	int n;
	ARG_DEF(1);

	SetArg(XmNitemCount,&n);
	GetValues(w);
	if(n>=max) XmListDeletePos(w,1);
	xec_AddListItem(w,p);

	SetArg(XmNitemCount,&n);
	GetValues(w);
	XmListSetBottomPos(w,n);
}

void xec_VaAddListMax(Widget  w,int max,char *fmt,...)
{
	va_list   args;
	char      str[1000];  /* DANGER: Fixed buffer size */
				 
	va_start(args,fmt);
	vsprintf(str, fmt, args);
    xec_AddListMax(w,max,str);
	va_end(args);
}
							   

/*-----------------------------------------------------

	Add one line to a list

------------------------------------------------------*/

void xec_AddListItem(Widget w,const char *p)
{
	XmString item= XmStringCreateSimple((char*)p);
	XmListAddItemUnselected(w,item,0);
	XmStringFree(item);
}

void xec_VaAddListItem(Widget w,const char *fmt,...)
{
	va_list   args;
	char      str[1000];  /* DANGER: Fixed buffer size */
				 
	va_start(args,fmt);
	vsprintf(str, fmt, args);
    xec_AddListItem(w,str);
										
	va_end(args);
}

/*-----------------------------------------------------

	Replace all items in a list

------------------------------------------------------*/
void xec_SetListItems(Widget w,XmString *list,int count)
{
	ARG_DEF(2);

	SetArg(XmNitems, list );
	SetArg(XmNitemCount, count );
	SetValues(w);

}

/*---------------------------------------------------*/
int xec_DumpList(FILE* f,const char* fmt,Widget w)
{
	ARG_DEF(2);
	int 	count;
	XmString *list;
	int i;
	int ret = 0;

	SetArg(XmNitems,&list);
	SetArg(XmNitemCount,&count);
	GetValues(w);

	for(i=0;i<count;i++)
	{
		char *p = (char*)xec_GetString(list[i]);
		fprintf(f,fmt,p);
		if(errno) ret = errno;
		XtFree((XtPointer)p);
	}
	return errno = ret;
}
/*-----------------------------------------------------*/

/*--------------------------------------------------

	Search the regexp 'word' in the list 'w'.
	Return TRUE in the text was found.
	if 'nocase' is TRUE the search is not case sensitive.
	if 'fromstart' is TRUE the search start from the
	fisrt char, else from the current position.
	if 'wrap' is TRUE the search is done all the text.

						---------------------------------------------------*/
/* Removed by Iain Russell, 2008-12-22
   because not needed by any code which is used in Metview

Boolean xec_ListSearch(Widget w,char *word,
	Boolean nocase,Boolean fromstart,Boolean wrap)
{
	ARG_DEF(5);
	int first = 0;
	int count,sel_count,vis_count;
	XmString	*items,*sel_items;
	char        *p;
	int			from,to,i;

	SetArg(XmNitemCount,&count);
	SetArg(XmNselectedItemCount,&sel_count);
	SetArg(XmNitems,&items);
	SetArg(XmNselectedItems,&sel_items);
	SetArg(XmNvisibleItemCount,&vis_count);
	GetValues(w);


	if(!fromstart)
	    if(sel_count)
	      {
 
#if XmVERSION==1
		 first = ((XmListWidget)w)->list.selectedIndices[0];
#else
                 first = ((XmListWidget)w)->list.selectedPositions[0];
#endif
	      }


	while(TRUE)
	{
		for(i=first;i<count;i++)
		{
			p = xec_GetString(items[i]);
			if(regexp_find(word,p,nocase,&from,&to))
			{
				int n = i+1;

				XmListDeselectAllItems(w);
				XmListSelectPos(w,n,False);
				if(n<((XmListWidget)w)->list.top_position || 
				    n > ((XmListWidget)w)->list.top_position + vis_count)
					XmListSetPos(w,n);
				XtFree((XtPointer)p);
				return TRUE;


			}
			XtFree((XtPointer)p);
		}
		if(!wrap) break;
		first = 0;
		wrap = FALSE;
	}
	return FALSE;

}
*/
static char *fonts[] = {
	"normal","bold", };

void xec_AddFontListItem(Widget list,const char *buffer,Boolean bold)
{
	XmString s = XmStringCreateLtoR((char*)buffer,fonts[bold]);
	XmListAddItem(list,s,0);
	XmStringFree(s);

}

