#!/usr/bin/perl

# **************************** LICENSE START ***********************************
#
# Copyright 2012 ECMWF and INPE. This software is distributed under the terms
# of the Apache License version 2.0. In applying this license, ECMWF does not
# waive the privileges and immunities granted to it by virtue of its status as
# an Intergovernmental Organization or submit itself to any jurisdiction.
#
# ***************************** LICENSE END ************************************


use strict;
use Data::Dumper;
use IO::Socket;
use Getopt::Long;


# set default values for options

my $expver    = "0001";
my $database  = "10_days";
my $date      = 20080912;
my $time      = 0000;
my $latitude  = 0;
my $longitude = 0;
my $height    = -999;  # should be something unlikely
my $path      = "meteogram";
my $title     = "Meteogram";
my $format    = "ps";
my $size      = "a4";
my $outwidth  = "800";
 

# get value of command-line options

my $result = GetOptions ("expver=s"    => \$expver,
                         "database=s"  => \$database,
                         "date=i"      => \$date,
                         "time=i"      => \$time,
                         "latitude=f"  => \$latitude,
                         "longitude=f" => \$longitude,
                         "height=f"    => \$height,
                         "path=s"      => \$path,
                         "title=s"     => \$title,
                         "format=s"    => \$format,
                         "size=s"      => \$size,
                         "outwidth=s"  => \$outwidth,
                         );


# create a mapping that Perl will pass to the web server

my %x = (
	action     => "make_eps",
	expver     => $expver,
	database   => $database,
	date       => $date,
	time       => $time,
	latitude   => $latitude,
	longitude  => $longitude,
	path       => $path,
	title      => $title,
	type       => $format,
	format     => lc $size,
	outwidth   => $outwidth,
);


# get a reference to the hash so we can modify it

my $x = \%x;


# only add the 'height' element if we've been passed it on the command line

if ($height != -999)
{
    $x->{ 'height' } = $height;
}


# make the remote call to the metgram server

$x = remote_call($x);




sub remote_call {
	my ($args) = @_;

	local $SIG{ALRM} = sub { die "alarm"; };

	alarm(60);

	my $soc = IO::Socket::INET->new(
			PeerAddr => "epsgrams:8858",
			Proto    => "tcp",
			Type     => SOCK_STREAM,
			);

    die "Could not create socket: $!\n" unless $soc;

	print $soc Dumper($args);
	shutdown($soc,1);

	my $VAR1;
	local $/;
	$/ = "\n";

	my $line;
	while($line = get_line($soc))
	{
		if($line eq "FILE")
		{
			my $size = get_line($soc);
			my $path = get_line($soc);
            print "$path\n";
			my $buf;
			my $buflen = 64*1024;
			my $read;
			my $total = 0;


			open(OUT,">$path.tmp") or die "$path.tmp: $!";
			while($size>0)
			{
				$buflen = $size if($size < $buflen);
				$read = sysread($soc,$buf,$buflen);
				last if($read <= 0);
				syswrite(OUT,$buf,$read);
				$size -= $read;
				$total += $read;
			}
			close(OUT) or die "$path.tmp: $!";
			rename("$path.tmp",$path) unless($size);
			next;
		}

		if($line eq "REPLY")
		{
			local $/;
			$VAR1 = <$soc>;
			eval $VAR1;
			last;
		}

		die "[$line]";
	}

	close($soc);

	alarm(0);

	return $VAR1;

}
sub get_line {
	my ($soc) = @_;
	my $buf;
	my $text;

	while(sysread($soc,$buf,1) == 1)
	{
		last if($buf eq "\n");
		$text .= $buf;
	}

	return $text;


}


