/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: parser.h,v 1.14 2003/04/08 13:32:29 sasa Exp $
 *
 ***************************************************************************/
#ifndef ZORP_PARSER_H_INCLUDED
#define ZORP_PARSER_H_INCLUDED

#include <glib-object.h>

#include <zorp/zorplib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define Z_PARSER_CONFIG_TAG        "configuration"
#define Z_PARSER_SECTION_TAG             "section"

#define Z_PARSER_DEFAULT_CONFIG          "default"


typedef struct _ZParser ZParser;

#define Z_PARSER_TAG_END  {NULL, NULL, G_TYPE_NONE, FALSE}

typedef struct _ZParserTag
{
  gchar *section;
  gchar *name;
  GType type;
  gboolean required;
} ZParserTag;

typedef void (*ZParserCallback)(ZParser *self, gchar *section, gpointer user_data);

ZParser *z_parser_new(const gchar *configname, ZParserTag *taglist);
ZParser *z_parser_ref(ZParser *self);
void z_parser_unref(ZParser *self);

static inline void
z_parser_destroy(ZParser *self)
{
  z_parser_unref(self);
}

gboolean z_parser_read_file(ZParser *self, const gchar *filename, GError **error);

GValue *z_parser_lookup(ZParser *self, gchar *sectionname, gchar *tag);
void z_parser_foreach_type(ZParser *self, gchar *sectiontype, ZParserCallback callback, gpointer user_data);

gchar *z_parser_find_tag_by_value(ZParser *self, gchar *tag, GValue *value);

gchar *z_parser_check(ZParser *parser, ZParserTag *taglist);

gboolean z_parser_get_value(ZParser *s, gchar *section, gchar *tag, guint value_type, GValue **value);
gboolean z_parser_get_boolean(ZParser *s, gchar *section, gchar *tag, gboolean *value);
gboolean z_parser_get_int(ZParser *s, gchar *section, gchar *tag, gint *value);
gboolean z_parser_get_string(ZParser *s, gchar *section, gchar *tag, const gchar **value);


#ifdef __cplusplus
}
#endif

#endif
