/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  A token in an XML stream.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * The libSBML XML parser interface can read an XML file or data stream and
 * convert the contents into tokens.  The tokens represent items in the XML
 * stream, either XML elements (start or end tags) or text that appears as
 * content inside an element.  The {@link XMLToken} class is libSBML's low-level
 * representation of these entities.
 <p>
 * Each {@link XMLToken} has the following information associated with it:
 * <ol>
 * <li> <em>Qualified name</em>: every XML element or XML attribute has a
 * name (e.g., for the element <code>&lt;mytag&gt;</code>, the name is
 * <code>'mytag'</code>), but this name may be qualified with a namespace
 * (e.g., it may appear as <code>&lt;someNamespace:mytag&gt;</code> in the
 * input).  An {@link XMLToken} stores the name of a token, along with any namespace
 * qualification present, through the use of an {@link XMLTriple} object.  This
 * object stores the bare name of the element, its XML namespace prefix (if
 * any), and the XML namespace with which that prefix is associated.
 * <li> <em>Namespaces</em>: An XML token can have one or more XML namespaces
 * associated with it.  These namespaces may be specified explicitly on the
 * element or inherited from parent elements.  In libSBML, a list of
 * namespaces is stored in an {@link XMLNamespaces} object.  An {@link XMLToken} possesses a
 * field for storing an {@link XMLNamespaces} object.
 * <li> <em>Attributes</em>: XML elements can have attributes associated with
 * them, and these attributes can have values assigned to them.  The set of
 * attribute-value pairs is stored in an {@link XMLAttributes} object stored in an
 * {@link XMLToken} object.  (Note: only elements can have attributes&mdash;text
 * blocks cannot have them in XML.)
 * <li> <em>Line</em> number: the line number in the input where the token appears.
 * <li> <em>Column</em> number: the column number in the input where the token appears.
 * </ol>
 <p>
 * The {@link XMLToken} class serves as base class for {@link XMLNode}.  XML lends itself to
 * a tree-structured representation, and in libSBML, the nodes in an XML
 * document tree are {@link XMLNode} objects.  Most higher-level libSBML classes and
 * methods that offer XML-level functionality (such as the methods on {@link SBase}
 * for interacting with annotations) work with {@link XMLNode} objects rather than
 * {@link XMLToken} objects directly.
 <p>
 * @see XMLNode
 * @see XMLTriple
 * @see XMLAttributes
 * @see XMLNamespaces
 */

public class XMLToken {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected XMLToken(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(XMLToken obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (XMLToken obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_XMLToken(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for XMLToken.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((XMLToken)(sb));
  }

  /**
   * Returns a hashcode for this XMLToken object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
/**
   * Creates a new empty {@link XMLToken} object.
   */ public
 XMLToken() throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_0(), true);
  }

  
/**
   * Creates an XML start element with attributes and namespace declarations.
   <p>
   * @param triple an {@link XMLTriple} object describing the start tag.
   <p>
   * @param attributes {@link XMLAttributes}, the attributes to set on the element to
   * be created.
   <p>
   * @param namespaces {@link XMLNamespaces}, the namespaces to set on the element to
   * be created.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, long line, long column) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_1(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, XMLNamespaces.getCPtr(namespaces), namespaces, line, column), true);
  }

  
/**
   * Creates an XML start element with attributes and namespace declarations.
   <p>
   * @param triple an {@link XMLTriple} object describing the start tag.
   <p>
   * @param attributes {@link XMLAttributes}, the attributes to set on the element to
   * be created.
   <p>
   * @param namespaces {@link XMLNamespaces}, the namespaces to set on the element to
   * be created.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, long line) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_2(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, XMLNamespaces.getCPtr(namespaces), namespaces, line), true);
  }

  
/**
   * Creates an XML start element with attributes and namespace declarations.
   <p>
   * @param triple an {@link XMLTriple} object describing the start tag.
   <p>
   * @param attributes {@link XMLAttributes}, the attributes to set on the element to
   * be created.
   <p>
   * @param namespaces {@link XMLNamespaces}, the namespaces to set on the element to
   * be created.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_3(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, XMLNamespaces.getCPtr(namespaces), namespaces), true);
  }

  
/**
   * Creates an XML start element with attributes.
   <p>
   * @param triple an {@link XMLTriple} object describing the start tag.
   <p>
   * @param attributes {@link XMLAttributes}, the attributes to set on the element to
   * be created.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * The XML namespace component of this {@link XMLToken} object will be left empty.
   * See the other variants of the {@link XMLToken} constructors for versions that
   * take namespace arguments.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, long line, long column) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_4(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, line, column), true);
  }

  
/**
   * Creates an XML start element with attributes.
   <p>
   * @param triple an {@link XMLTriple} object describing the start tag.
   <p>
   * @param attributes {@link XMLAttributes}, the attributes to set on the element to
   * be created.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * The XML namespace component of this {@link XMLToken} object will be left empty.
   * See the other variants of the {@link XMLToken} constructors for versions that
   * take namespace arguments.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes, long line) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_5(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, line), true);
  }

  
/**
   * Creates an XML start element with attributes.
   <p>
   * @param triple an {@link XMLTriple} object describing the start tag.
   <p>
   * @param attributes {@link XMLAttributes}, the attributes to set on the element to
   * be created.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * The XML namespace component of this {@link XMLToken} object will be left empty.
   * See the other variants of the {@link XMLToken} constructors for versions that
   * take namespace arguments.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple, XMLAttributes attributes) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_6(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes), true);
  }

  
/**
   * Creates an XML end element.
   <p>
   * @param triple an {@link XMLTriple} object describing the end tag.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple, long line, long column) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_7(XMLTriple.getCPtr(triple), triple, line, column), true);
  }

  
/**
   * Creates an XML end element.
   <p>
   * @param triple an {@link XMLTriple} object describing the end tag.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple, long line) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_8(XMLTriple.getCPtr(triple), triple, line), true);
  }

  
/**
   * Creates an XML end element.
   <p>
   * @param triple an {@link XMLTriple} object describing the end tag.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(XMLTriple triple) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_9(XMLTriple.getCPtr(triple), triple), true);
  }

  
/**
   * Creates a text object.
   <p>
   * @param chars a string, the text to be added to the {@link XMLToken} object.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(String chars, long line, long column) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_10(chars, line, column), true);
  }

  
/**
   * Creates a text object.
   <p>
   * @param chars a string, the text to be added to the {@link XMLToken} object.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(String chars, long line) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_11(chars, line), true);
  }

  
/**
   * Creates a text object.
   <p>
   * @param chars a string, the text to be added to the {@link XMLToken} object.
   <p>
   * @param line a long integer, the line number to associate with the
   * token (default = 0).
   <p>
   * @param column a long integer, the column number to associate with the
   * token (default = 0).
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLToken(String chars) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_12(chars), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link XMLToken} object.
   <p>
   * @param orig the {@link XMLToken} object to copy.
   */ public
 XMLToken(XMLToken orig) throws org.sbml.libsbml.XMLConstructorException {
    this(libsbmlJNI.new_XMLToken__SWIG_13(XMLToken.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link XMLToken} object.
   <p>
   * @return the (deep) copy of this {@link XMLToken} object.
   */ public
 XMLToken cloneObject() {
    long cPtr = libsbmlJNI.XMLToken_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLToken(cPtr, true);
  }

  
/**
   * Returns the attributes of the XML element represented by this token.
   <p>
   * @return the attributes of this XML element, stored in an {@link XMLAttributes}
   * object.
   */ public
 XMLAttributes getAttributes() {
    return new XMLAttributes(libsbmlJNI.XMLToken_getAttributes(swigCPtr, this), false);
  }

  
/**
   * Sets the attributes on the XML element represented by this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param attributes an {@link XMLAttributes} object to be assigned to this
   * {@link XMLToken} object, thereby setting the XML attributes associated with this
   * token.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @note This function replaces any existing {@link XMLAttributes} object
   * on this {@link XMLToken} object with the one given by <code>attributes</code>.
   */ public
 int setAttributes(XMLAttributes attributes) {
    return libsbmlJNI.XMLToken_setAttributes(swigCPtr, this, XMLAttributes.getCPtr(attributes), attributes);
  }

  
/**
   * Adds an attribute to the XML element represented by this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param name a string, the so-called 'local part' of the attribute name;
   * that is, the attribute name without any namespace qualifier or prefix.
   <p>
   * @param value a string, the value assigned to the attribute.
   <p>
   * @param namespaceURI a string, the XML namespace URI of the attribute.
   <p>
   * @param prefix a string, the prefix for the XML namespace.
   <p>
   * Recall that in XML, the complete form of an attribute on an XML element
   * is the following:
   * <center>
   * <code>prefix:name='value'</code>
   * </center>
   * The <code>name</code> part is the name of the attribute, the
   * <code>'value'</code> part is the value assigned to the attribute (and
   * it is always a quoted string), and the <code>prefix</code> part is
   * an optional XML namespace prefix.  Internally in libSBML, this data
   * is stored in an {@link XMLAttributes} object associated with this {@link XMLToken}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   *
   * </ul> <p>
   * <p>
 * @note If an attribute with the same name and XML namespace URI already
 * exists on this {@link XMLToken} object, then the previous value will be replaced
 * with the new value provided to this method.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int addAttr(String name, String value, String namespaceURI, String prefix) {
    return libsbmlJNI.XMLToken_addAttr__SWIG_0(swigCPtr, this, name, value, namespaceURI, prefix);
  }

  
/**
   * Adds an attribute to the XML element represented by this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param name a string, the so-called 'local part' of the attribute name;
   * that is, the attribute name without any namespace qualifier or prefix.
   <p>
   * @param value a string, the value assigned to the attribute.
   <p>
   * @param namespaceURI a string, the XML namespace URI of the attribute.
   <p>
   * @param prefix a string, the prefix for the XML namespace.
   <p>
   * Recall that in XML, the complete form of an attribute on an XML element
   * is the following:
   * <center>
   * <code>prefix:name='value'</code>
   * </center>
   * The <code>name</code> part is the name of the attribute, the
   * <code>'value'</code> part is the value assigned to the attribute (and
   * it is always a quoted string), and the <code>prefix</code> part is
   * an optional XML namespace prefix.  Internally in libSBML, this data
   * is stored in an {@link XMLAttributes} object associated with this {@link XMLToken}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   *
   * </ul> <p>
   * <p>
 * @note If an attribute with the same name and XML namespace URI already
 * exists on this {@link XMLToken} object, then the previous value will be replaced
 * with the new value provided to this method.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int addAttr(String name, String value, String namespaceURI) {
    return libsbmlJNI.XMLToken_addAttr__SWIG_1(swigCPtr, this, name, value, namespaceURI);
  }

  
/**
   * Adds an attribute to the XML element represented by this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param name a string, the so-called 'local part' of the attribute name;
   * that is, the attribute name without any namespace qualifier or prefix.
   <p>
   * @param value a string, the value assigned to the attribute.
   <p>
   * @param namespaceURI a string, the XML namespace URI of the attribute.
   <p>
   * @param prefix a string, the prefix for the XML namespace.
   <p>
   * Recall that in XML, the complete form of an attribute on an XML element
   * is the following:
   * <center>
   * <code>prefix:name='value'</code>
   * </center>
   * The <code>name</code> part is the name of the attribute, the
   * <code>'value'</code> part is the value assigned to the attribute (and
   * it is always a quoted string), and the <code>prefix</code> part is
   * an optional XML namespace prefix.  Internally in libSBML, this data
   * is stored in an {@link XMLAttributes} object associated with this {@link XMLToken}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   *
   * </ul> <p>
   * <p>
 * @note If an attribute with the same name and XML namespace URI already
 * exists on this {@link XMLToken} object, then the previous value will be replaced
 * with the new value provided to this method.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int addAttr(String name, String value) {
    return libsbmlJNI.XMLToken_addAttr__SWIG_2(swigCPtr, this, name, value);
  }

  
/**
   * Adds an attribute to the XML element represented by this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param triple an {@link XMLTriple} object defining the attribute, its value,
   * and optionally its XML namespace (if any is provided).
   <p>
   * @param value a string, the value assigned to the attribute.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   *
   * </ul> <p>
   * <p>
 * @note If an attribute with the same name and XML namespace URI already
 * exists on this {@link XMLToken} object, then the previous value will be replaced
 * with the new value provided to this method.
   */ public
 int addAttr(XMLTriple triple, String value) {
    return libsbmlJNI.XMLToken_addAttr__SWIG_3(swigCPtr, this, XMLTriple.getCPtr(triple), triple, value);
  }

  
/**
   * Removes the <em>n</em>th attribute from the XML element represented by
   * this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param n an integer the index of the resource to be deleted
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   *
   * </ul> <p>
   * The value {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE} is returned if there is no attribute on this
   * element at the given index <code>n</code>.
   <p>
   * @see #getAttrIndex(XMLTriple triple) 
   * @see #getAttrIndex(String name, String uri) 
   * @see #getAttributesLength()
   */ public
 int removeAttr(int n) {
    return libsbmlJNI.XMLToken_removeAttr__SWIG_0(swigCPtr, this, n);
  }

  
/**
   * Removes an attribute from the XML element represented by this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param name   a string, the name of the attribute to be removed.
   * @param uri    a string, the XML namespace URI of the attribute to be removed.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   *
   * </ul> <p>
   * The value {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE} is returned if there is no attribute on this
   * element with the given <code>name</code> (and <code>uri</code> if specified).
   <p>
   * @see #hasAttr(String name, String uri) 
   */ public
 int removeAttr(String name, String uri) {
    return libsbmlJNI.XMLToken_removeAttr__SWIG_1(swigCPtr, this, name, uri);
  }

  
/**
   * Removes an attribute from the XML element represented by this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param name   a string, the name of the attribute to be removed.
   * @param uri    a string, the XML namespace URI of the attribute to be removed.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   *
   * </ul> <p>
   * The value {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE} is returned if there is no attribute on this
   * element with the given <code>name</code> (and <code>uri</code> if specified).
   <p>
   * @see #hasAttr(String name, String uri) 
   */ public
 int removeAttr(String name) {
    return libsbmlJNI.XMLToken_removeAttr__SWIG_2(swigCPtr, this, name);
  }

  
/**
   * Removes an attribute from the XML element represented by this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param triple an {@link XMLTriple} describing the attribute to be removed.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   *
   * </ul> <p>
   * The value {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE} is returned if there is no attribute on this
   * element matching the properties of the given <code>triple</code>.
   <p>
   * @see #hasAttr(XMLTriple triple) 
   */ public
 int removeAttr(XMLTriple triple) {
    return libsbmlJNI.XMLToken_removeAttr__SWIG_3(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
/**
   * Removes all attributes of this {@link XMLToken} object.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * </ul>
   */ public
 int clearAttributes() {
    return libsbmlJNI.XMLToken_clearAttributes(swigCPtr, this);
  }

  
/**
   * Returns the index of the attribute with the given name and namespace
   * URI.
   <p>
   * @param name a string, the name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   <p>
   * @return the index of an attribute with the given local name and
   * namespace URI, or <code>-1</code> if it is not present on this token.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int getAttrIndex(String name, String uri) {
    return libsbmlJNI.XMLToken_getAttrIndex__SWIG_0(swigCPtr, this, name, uri);
  }

  
/**
   * Returns the index of the attribute with the given name and namespace
   * URI.
   <p>
   * @param name a string, the name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   <p>
   * @return the index of an attribute with the given local name and
   * namespace URI, or <code>-1</code> if it is not present on this token.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int getAttrIndex(String name) {
    return libsbmlJNI.XMLToken_getAttrIndex__SWIG_1(swigCPtr, this, name);
  }

  
/**
   * Returns the index of the attribute defined by the given {@link XMLTriple}
   * object.
   <p>
   * @param triple the {@link XMLTriple} object that defines the attribute whose
   * index is being sought.
   <p>
   * @return the index of an attribute with the given {@link XMLTriple} object, or
   * <code>-1</code> if no such attribute is present on this token.
   */ public
 int getAttrIndex(XMLTriple triple) {
    return libsbmlJNI.XMLToken_getAttrIndex__SWIG_2(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
/**
   * Returns the number of attributes on this {@link XMLToken} object.
   <p>
   * @return the number of attributes possessed by this token.
   <p>
   * @see #hasAttr(int)
   */ public
 int getAttributesLength() {
    return libsbmlJNI.XMLToken_getAttributesLength(swigCPtr, this);
  }

  
/**
   * Returns the name of the <em>n</em>th attribute in this token's list of
   * attributes.
   <p>
   * @param index an integer, the position of the attribute whose name
   * is being sought.
   <p>
   * @return the name of the attribute located at position <code>n</code> in the list
   * of attributes possessed by this {@link XMLToken} object.
   <p>
   * <p>
 * @note If <code>index</code> is out of range, this method will return an empty
 * string.  {@link XMLToken#hasAttr(int)} can be used to test for an
 * attribute's existence explicitly, and {@link XMLToken#getAttributesLength()} can
 * be used to find out the number of attributes possessed by this token. 
   <p>
   * @see #hasAttr(int)
   * @see #getAttributesLength()
   */ public
 String getAttrName(int index) {
    return libsbmlJNI.XMLToken_getAttrName(swigCPtr, this, index);
  }

  
/**
   * Returns the prefix of the <em>n</em>th attribute in this token's list of
   * attributes.
   <p>
   * @param index an integer, the position of the attribute whose prefix is
   * being sought.
   <p>
   * @return the XML namespace prefix of the attribute located at position 
   * <code>n</code> in the list of attributes possessed by this {@link XMLToken} object.
   <p>
   * <p>
 * @note If <code>index</code> is out of range, this method will return an empty
 * string.  {@link XMLToken#hasAttr(int)} can be used to test for an
 * attribute's existence explicitly, and {@link XMLToken#getAttributesLength()} can
 * be used to find out the number of attributes possessed by this token.
   <p>
   * @see #hasAttr(int)
   * @see #getAttributesLength()
   */ public
 String getAttrPrefix(int index) {
    return libsbmlJNI.XMLToken_getAttrPrefix(swigCPtr, this, index);
  }

  
/**
   * Returns the prefixed name of the <em>n</em>th attribute in this token's
   * list of attributes.
   <p>
   * In this context, <em>prefixed name</em> means the name of the attribute
   * prefixed with the XML namespace prefix assigned to the attribute.  This
   * will be a string of the form <code>prefix:name</code>.
   <p>
   * @param index an integer, the position of the attribute whose prefixed
   * name is being sought.
   <p>
   * @return the prefixed name of the attribute located at position 
   * <code>n</code> in the list of attributes possessed by this {@link XMLToken} object.
   <p>
   * <p>
 * @note If <code>index</code> is out of range, this method will return an empty
 * string.  {@link XMLToken#hasAttr(int)} can be used to test for an
 * attribute's existence explicitly, and {@link XMLToken#getAttributesLength()} can
 * be used to find out the number of attributes possessed by this token.
   */ public
 String getAttrPrefixedName(int index) {
    return libsbmlJNI.XMLToken_getAttrPrefixedName(swigCPtr, this, index);
  }

  
/**
   * Returns the XML namespace URI of the <em>n</em>th attribute in this
   * token's list of attributes.
   <p>
   * @param index an integer, the position of the attribute whose namespace
   * URI is being sought.
   <p>
   * @return the XML namespace URI of the attribute located at position <code>n</code>
   * in the list of attributes possessed by this {@link XMLToken} object.
   <p>
   * <p>
 * @note If <code>index</code> is out of range, this method will return an empty
 * string.  {@link XMLToken#hasAttr(int)} can be used to test for an
 * attribute's existence explicitly, and {@link XMLToken#getAttributesLength()} can
 * be used to find out the number of attributes possessed by this token.
   */ public
 String getAttrURI(int index) {
    return libsbmlJNI.XMLToken_getAttrURI(swigCPtr, this, index);
  }

  
/**
   * Returns the value of the <em>n</em>th attribute in this token's list of
   * attributes.
   <p>
   * @param index an integer, the position of the attribute whose value is
   * required.
   <p>
   * @return the value of the attribute located at position <code>n</code> in the list
   * of attributes possessed by this {@link XMLToken} object.
   <p>
   * <p>
 * @note If <code>index</code> is out of range, this method will return an empty
 * string.  {@link XMLToken#hasAttr(int)} can be used to test for an
 * attribute's existence explicitly, and {@link XMLToken#getAttributesLength()} can
 * be used to find out the number of attributes possessed by this token.
   */ public
 String getAttrValue(int index) {
    return libsbmlJNI.XMLToken_getAttrValue__SWIG_0(swigCPtr, this, index);
  }

  
/**
   * Returns the value of the attribute with a given name and XML namespace URI.
   <p>
   * @param name a string, the name of the attribute whose value is being
   * sought.
   <p>
   * @param uri a string, the XML namespace URI of the attribute.
   <p>
   * @return The value of the attribute, as a string.
   <p>
   * @note If an attribute with the given <code>name</code> and <code>uri</code> does not exist
   * on this token object, this method will return an empty string.
   * {@link XMLToken#hasAttr(String, String)} can be used to test
   * explicitly for the presence of an attribute with a given name and
   * namespace.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 String getAttrValue(String name, String uri) {
    return libsbmlJNI.XMLToken_getAttrValue__SWIG_1(swigCPtr, this, name, uri);
  }

  
/**
   * Returns the value of the attribute with a given name and XML namespace URI.
   <p>
   * @param name a string, the name of the attribute whose value is being
   * sought.
   <p>
   * @param uri a string, the XML namespace URI of the attribute.
   <p>
   * @return The value of the attribute, as a string.
   <p>
   * @note If an attribute with the given <code>name</code> and <code>uri</code> does not exist
   * on this token object, this method will return an empty string.
   * {@link XMLToken#hasAttr(String, String)} can be used to test
   * explicitly for the presence of an attribute with a given name and
   * namespace.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 String getAttrValue(String name) {
    return libsbmlJNI.XMLToken_getAttrValue__SWIG_2(swigCPtr, this, name);
  }

  
/**
   * Returns the value of the attribute specified by a given {@link XMLTriple} object.
   <p>
   * @param triple an {@link XMLTriple} describing the attribute whose value is being
   * sought.
   <p>
   * @return The value of the attribute, as a string.
   <p>
   * @note If an attribute defined by the given <code>triple</code> does not exist on
   * this token object, this method will return an empty string.
   * {@link XMLToken#hasAttr(XMLTriple)} can be used to test
   * explicitly for the existence of an attribute with the properties of
   * a given triple.
   */ public
 String getAttrValue(XMLTriple triple) {
    return libsbmlJNI.XMLToken_getAttrValue__SWIG_3(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
/**
   * Returns <code>true</code> if an attribute with the given index exists.
   <p>
   * @param index an integer, the position of the attribute.
   <p>
   * @return <code>true</code> if this token object possesses an attribute with the
   * given index, <code>false</code> otherwise.
   */ public
 boolean hasAttr(int index) {
    return libsbmlJNI.XMLToken_hasAttr__SWIG_0(swigCPtr, this, index);
  }

  
/**
   * Returns <code>true</code> if an attribute with a given name and namespace URI
   * exists.
   <p>
   * @param name a string, the name of the attribute being sought.
   <p>
   * @param uri a string, the XML namespace URI of the attribute being
   * sought.
   <p>
   * @return <code>true</code> if an attribute with the given local name and namespace
   * URI exists in the list of attributes on this token object, <code>false</code>
   * otherwise.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 boolean hasAttr(String name, String uri) {
    return libsbmlJNI.XMLToken_hasAttr__SWIG_1(swigCPtr, this, name, uri);
  }

  
/**
   * Returns <code>true</code> if an attribute with a given name and namespace URI
   * exists.
   <p>
   * @param name a string, the name of the attribute being sought.
   <p>
   * @param uri a string, the XML namespace URI of the attribute being
   * sought.
   <p>
   * @return <code>true</code> if an attribute with the given local name and namespace
   * URI exists in the list of attributes on this token object, <code>false</code>
   * otherwise.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 boolean hasAttr(String name) {
    return libsbmlJNI.XMLToken_hasAttr__SWIG_2(swigCPtr, this, name);
  }

  
/**
   * Returns <code>true</code> if an attribute defined by a given {@link XMLTriple} object
   * exists.
   <p>
   * @param triple an {@link XMLTriple} object describing the attribute being sought.
   <p>
   * @return <code>true</code> if an attribute matching the properties of the given
   * {@link XMLTriple} object exists in the list of attributes on this token, 
   * <code>false</code> otherwise.
   */ public
 boolean hasAttr(XMLTriple triple) {
    return libsbmlJNI.XMLToken_hasAttr__SWIG_3(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
/**
   * Returns <code>true</code> if this token has no attributes.
   <p>
   * @return <code>true</code> if the list of attributes on {@link XMLToken} object is empty,
   * <code>false</code> otherwise.
   */ public
 boolean isAttributesEmpty() {
    return libsbmlJNI.XMLToken_isAttributesEmpty(swigCPtr, this);
  }

  
/**
   * Returns the XML namespaces declared for this token.
   <p>
   * @return the XML namespace declarations for this XML element.
   */ public
 XMLNamespaces getNamespaces() {
    return new XMLNamespaces(libsbmlJNI.XMLToken_getNamespaces(swigCPtr, this), false);
  }

  
/**
   * Sets the XML namespaces on this XML element.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param namespaces the {@link XMLNamespaces} object to be assigned to this {@link XMLToken} object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @note This function replaces any existing {@link XMLNamespaces} object on this
   * {@link XMLToken} object with the new one given by <code>namespaces</code>.
   */ public
 int setNamespaces(XMLNamespaces namespaces) {
    return libsbmlJNI.XMLToken_setNamespaces(swigCPtr, this, XMLNamespaces.getCPtr(namespaces), namespaces);
  }

  
/**
   * Appends an XML namespace declaration to this token.
   <p>
   * The namespace added will be defined by the given XML namespace URI and
   * an optional prefix.  If this {@link XMLToken} object already possesses an XML
   * namespace declaration with the given <code>prefix</code>, then the existing XML
   * namespace URI will be overwritten by the new one given by <code>uri</code>.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param uri a string, the XML namespace URI for the namespace.
   <p>
   * @param prefix a string, the namespace prefix to use.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   *
   * </ul> <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int addNamespace(String uri, String prefix) {
    return libsbmlJNI.XMLToken_addNamespace__SWIG_0(swigCPtr, this, uri, prefix);
  }

  
/**
   * Appends an XML namespace declaration to this token.
   <p>
   * The namespace added will be defined by the given XML namespace URI and
   * an optional prefix.  If this {@link XMLToken} object already possesses an XML
   * namespace declaration with the given <code>prefix</code>, then the existing XML
   * namespace URI will be overwritten by the new one given by <code>uri</code>.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param uri a string, the XML namespace URI for the namespace.
   <p>
   * @param prefix a string, the namespace prefix to use.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   *
   * </ul> <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 int addNamespace(String uri) {
    return libsbmlJNI.XMLToken_addNamespace__SWIG_1(swigCPtr, this, uri);
  }

  
/**
   * Removes the <em>n</em>th XML namespace declaration.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param index an integer, the position of the namespace to be removed.
   * The position in this context refers to the position of the namespace in
   * the {@link XMLNamespaces} object stored in this {@link XMLToken} object.  Callers can
   * use one of the <code>getNamespace___()</code> methods to find the index
   * number of a given namespace.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   *
   * </ul> <p>
   * @see #getNamespaceIndex(String uri)
   * @see #getNamespaceIndexByPrefix(String prefix)
   * @see #getNamespacesLength()
   */ public
 int removeNamespace(int index) {
    return libsbmlJNI.XMLToken_removeNamespace__SWIG_0(swigCPtr, this, index);
  }

  
/**
   * Removes an XML namespace declaration having a given prefix.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param prefix a string, the prefix of the namespace to be removed.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   *
   * </ul> <p>
   * The value {@link libsbmlConstants#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE}
   * is returned if there is no namespace with the given <code>prefix</code> on this
   * element.
   <p>
   * @see #getNamespaceIndexByPrefix(String prefix)
   */ public
 int removeNamespace(String prefix) {
    return libsbmlJNI.XMLToken_removeNamespace__SWIG_1(swigCPtr, this, prefix);
  }

  
/**
   * Removes all XML namespace declarations from this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element. 
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int clearNamespaces() {
    return libsbmlJNI.XMLToken_clearNamespaces(swigCPtr, this);
  }

  
/**
   * Returns the index of an XML namespace declaration based on its URI.
   <p>
   * @param uri a string, the XML namespace URI of the sought-after namespace.
   <p>
   * @return the index of the given declaration, or <code>-1</code> if
   * no such namespace URI is present on this {@link XMLToken} object.
   */ public
 int getNamespaceIndex(String uri) {
    return libsbmlJNI.XMLToken_getNamespaceIndex(swigCPtr, this, uri);
  }

  
/**
   * Returns the index of an XML namespace declaration based on its prefix.
   <p>
   * @param prefix a string, the prefix of the sought-after XML namespace.
   <p>
   * @return the index of the given declaration, or <code>-1</code> if
   * no such namespace URI is present on this {@link XMLToken} object.
   */ public
 int getNamespaceIndexByPrefix(String prefix) {
    return libsbmlJNI.XMLToken_getNamespaceIndexByPrefix(swigCPtr, this, prefix);
  }

  
/**
   * Returns the number of XML namespaces declared on this token.
   <p>
   * @return the number of XML namespaces stored in the {@link XMLNamespaces}
   * object of this {@link XMLToken} object.
   */ public
 int getNamespacesLength() {
    return libsbmlJNI.XMLToken_getNamespacesLength(swigCPtr, this);
  }

  
/**
   * Returns the prefix of the <em>n</em>th XML namespace declaration.
   <p>
   * @param index an integer, position of the required prefix.
   <p>
   * @return the prefix of an XML namespace declaration in the {@link XMLNamespaces}
   * (by position).
   <p>
   * @note If <code>index</code> is out of range, this method will return an empty
   * string.  {@link XMLToken#getNamespacesLength()} can be used to find out how
   * many namespaces are defined on this {@link XMLToken} object.
   <p>
   * @see #getNamespacesLength()
   */ public
 String getNamespacePrefix(int index) {
    return libsbmlJNI.XMLToken_getNamespacePrefix__SWIG_0(swigCPtr, this, index);
  }

  
/**
   * Returns the prefix associated with a given XML namespace URI on this
   * token.
   <p>
   * @param uri a string, the URI of the namespace whose prefix is being
   * sought.
   <p>
   * @return the prefix of an XML namespace declaration on this {@link XMLToken} object.
   <p>
   * @note If there is no XML namespace with the given <code>uri</code> declared on
   * this {@link XMLToken} object, this method will return an empty string.
   */ public
 String getNamespacePrefix(String uri) {
    return libsbmlJNI.XMLToken_getNamespacePrefix__SWIG_1(swigCPtr, this, uri);
  }

  
/**
   * Returns the URI of the <em>n</em>th XML namespace declared on this token. 
   <p>
   * @param index an integer, the position of the sought-after XML namespace URI.
   <p>
   * @return the URI of the <em>n</em>th XML namespace stored in the
   * {@link XMLNamespaces} object in this {@link XMLToken} object.
   <p>
   * @note If <code>index</code> is out of range, this method will return an empty string.
   <p>
   * @see #getNamespacesLength()
   */ public
 String getNamespaceURI(int index) {
    return libsbmlJNI.XMLToken_getNamespaceURI__SWIG_0(swigCPtr, this, index);
  }

  
/**
   * Returns the URI of an XML namespace with a given prefix.
   <p>
   * @param prefix a string, the prefix of the sought-after XML namespace URI.
   <p>
   * @return the URI of an XML namespace declaration given its prefix.
   <p>
   * @note If there is no XML namespace with the given <code>prefix</code> stored in
   * the {@link XMLNamespaces} object of this {@link XMLToken} object, this method will
   * return an empty string.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 String getNamespaceURI(String prefix) {
    return libsbmlJNI.XMLToken_getNamespaceURI__SWIG_1(swigCPtr, this, prefix);
  }

  
/**
   * Returns the URI of an XML namespace with a given prefix.
   <p>
   * @param prefix a string, the prefix of the sought-after XML namespace URI.
   <p>
   * @return the URI of an XML namespace declaration given its prefix.
   <p>
   * @note If there is no XML namespace with the given <code>prefix</code> stored in
   * the {@link XMLNamespaces} object of this {@link XMLToken} object, this method will
   * return an empty string.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 String getNamespaceURI() {
    return libsbmlJNI.XMLToken_getNamespaceURI__SWIG_2(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if there are no namespaces declared on this token.
   <p>
   * @return <code>true</code> if the {@link XMLNamespaces} object stored in this {@link XMLToken}
   * token is empty, <code>false</code> otherwise.
   */ public
 boolean isNamespacesEmpty() {
    return libsbmlJNI.XMLToken_isNamespacesEmpty(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this token has an XML namespace with a given URI.
   <p>
   * @param uri a string, the URI of the XML namespace.
   <p>
   * @return <code>true</code> if an XML namespace with the given URI is contained in
   * the {@link XMLNamespaces} object of this {@link XMLToken} object, <code>false</code> otherwise.
   */ public
 boolean hasNamespaceURI(String uri) {
    return libsbmlJNI.XMLToken_hasNamespaceURI(swigCPtr, this, uri);
  }

  
/**
   * Returns <code>true</code> if this token has an XML namespace with a given prefix.
   <p>
   * @param prefix a string, the prefix for the XML namespace.
   <p>
   * @return <code>true</code> if an XML Namespace with the given URI is contained in the
   * {@link XMLNamespaces} of this {@link XMLToken}, <code>false</code> otherwise.
   */ public
 boolean hasNamespacePrefix(String prefix) {
    return libsbmlJNI.XMLToken_hasNamespacePrefix(swigCPtr, this, prefix);
  }

  
/**
   * Returns <code>true</code> if this token has an XML namespace with a given prefix
   * and URI combination.
   <p>
   * @param uri a string, the URI for the namespace.
   * @param prefix a string, the prefix for the namespace.
   <p>
   * @return <code>true</code> if an XML namespace with the given URI/prefix pair is
   * contained in the {@link XMLNamespaces} object of this {@link XMLToken} object, <code>false</code>
   * otherwise.
   */ public
 boolean hasNamespaceNS(String uri, String prefix) {
    return libsbmlJNI.XMLToken_hasNamespaceNS(swigCPtr, this, uri, prefix);
  }

  
/**
   * Sets the name, namespace prefix and namespace URI of this token.
   <p>
   * <p>
 * This operation only makes sense for XML start elements.  This
 * method will return {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION} if this {@link XMLToken} object is not an XML start
 * element.
   <p>
   * @param triple the new {@link XMLTriple} to use for this {@link XMLToken} object.  If
   * this {@link XMLToken} already had an {@link XMLTriple} object stored within it, that
   * object will be replaced.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * </ul>
   */ public
 int setTriple(XMLTriple triple) {
    return libsbmlJNI.XMLToken_setTriple(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
/**
   * Returns the (unqualified) name of token.
   <p>
   * @return the (unqualified) name of token.
   */ public
 String getName() {
    return libsbmlJNI.XMLToken_getName(swigCPtr, this);
  }

  
/**
   * Returns the XML namespace prefix of token.
   <p>
   * @return the XML namespace prefix of token.
   <p>
   * @note If no XML namespace prefix has been assigned to this token, this
   * method will return an empty string.
   */ public
 String getPrefix() {
    return libsbmlJNI.XMLToken_getPrefix(swigCPtr, this);
  }

  
/**
   * Returns the XML namespace URI of token.
   <p>
   * @return the XML namespace URI of token.
   */ public
 String getURI() {
    return libsbmlJNI.XMLToken_getURI(swigCPtr, this);
  }

  
/**
   * Returns the character text of token.
   <p>
   * @return the characters of this XML token.  If this token is not a
   * text token (i.e., it's an XML element and not character content),
   * then this will return an empty string.
   <p>
   * @see #isText()
   * @see #isElement()
   */ public
 String getCharacters() {
    return libsbmlJNI.XMLToken_getCharacters(swigCPtr, this);
  }

  
/**
   * Appends characters to the text content of token.
   <p>
   * This method only makes sense for {@link XMLToken} objects that contains text.
   * If this method is called on a token that represents an XML start or end
   * tag, it will return the code {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}.
   <p>
   * @param chars string, characters to append to the text of this token.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #isText()
   * @see #isElement()
   */ public
 int append(String chars) {
    return libsbmlJNI.XMLToken_append(swigCPtr, this, chars);
  }

  
/**
   * Returns the column number at which this token occurs in the input.
   <p>
   * @return the column at which this {@link XMLToken} occurred.
   */ public
 long getColumn() {
    return libsbmlJNI.XMLToken_getColumn(swigCPtr, this);
  }

  
/**
   * Returns the line number at which this token occurs in the input.
   <p>
   * @return the line at which this {@link XMLToken} occurred.
   */ public
 long getLine() {
    return libsbmlJNI.XMLToken_getLine(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this token represents an XML element.
   <p>
   * This generic predicate returns <code>true</code> if the element is either a start
   * or end tag, and <code>false</code> if it's a text object.  The related methods
   * XMLToken:isStart(), {@link XMLToken#isEnd()} and {@link XMLToken#isText()} are more
   * specific predicates.
   <p>
   * @return <code>true</code> if this {@link XMLToken} object represents an XML element, 
   * <code>false</code> otherwise.
   <p>
   * @see #isStart()
   * @see #isEnd()
   * @see #isText()
   */ public
 boolean isElement() {
    return libsbmlJNI.XMLToken_isElement(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this token represents an XML end element.
   <p>
   * @return <code>true</code> if this {@link XMLToken} object represents an XML end element,
   * <code>false</code> otherwise.
   <p>
   * @see #isStart()
   * @see #isElement()
   * @see #isText()
   */ public
 boolean isEnd() {
    return libsbmlJNI.XMLToken_isEnd(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this token represents an XML end element for a
   * particular start element.
   <p>
   * @param element {@link XMLToken}, the element with which the current object
   * should be compared to determined whether the current object is a
   * start element for the given one.
   <p>
   * @return <code>true</code> if this {@link XMLToken} object represents an XML end tag for
   * the start tag given by <code>element</code>, <code>false</code> otherwise.
   <p>
   * @see #isElement()
   * @see #isStart()
   * @see #isEnd()
   * @see #isText()
   */ public
 boolean isEndFor(XMLToken element) {
    return libsbmlJNI.XMLToken_isEndFor(swigCPtr, this, XMLToken.getCPtr(element), element);
  }

  
/**
   * Returns <code>true</code> if this token is an end of file marker.
   <p>
   * @return <code>true</code> if this {@link XMLToken} object represents the end of the input,
   * <code>false</code> otherwise.
   <p>
   * @see #setEOF()
   */ public
 boolean isEOF() {
    return libsbmlJNI.XMLToken_isEOF(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this token represents an XML start element.
   <p>
   * @return <code>true</code> if this {@link XMLToken} is an XML start element, <code>false</code> otherwise.
   <p>
   * @see #isElement()
   * @see #isEnd()
   * @see #isText()
   */ public
 boolean isStart() {
    return libsbmlJNI.XMLToken_isStart(swigCPtr, this);
  }

  
/**
   * Returns <code>true</code> if this token represents an XML text element.
   <p>
   * @return <code>true</code> if this {@link XMLToken} is an XML text element, <code>false</code> otherwise.
   <p>
   * @see #isElement()
   * @see #isStart()
   * @see #isEnd()
   */ public
 boolean isText() {
    return libsbmlJNI.XMLToken_isText(swigCPtr, this);
  }

  
/**
   * Declares that this token represents an XML element end tag.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #isStart()
   * @see #isEnd()
   */ public
 int setEnd() {
    return libsbmlJNI.XMLToken_setEnd(swigCPtr, this);
  }

  
/**
   * Declares that this token is an end-of-file/input marker.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * @see #isEOF()
   */ public
 int setEOF() {
    return libsbmlJNI.XMLToken_setEOF(swigCPtr, this);
  }

  
/**
   * Declares that this token no longer represents an XML start/end element.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int unsetEnd() {
    return libsbmlJNI.XMLToken_unsetEnd(swigCPtr, this);
  }

  
/**
   * Prints a string representation of the underlying token stream.
   <p>
   * This method is intended for debugging purposes.
   <p>
   * @return a text string representing this {@link XMLToken} object.
   */ public
 String toString() {
    return libsbmlJNI.XMLToken_toString(swigCPtr, this);
  }

}
