using System;
using System.Runtime.InteropServices;
 
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

using System;
using System.Runtime.InteropServices;

class libsbmlPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [DllImport("libsbmlcs", EntryPoint="SWIGRegisterExceptionCallbacks_libsbml")]
    public static extern void SWIGRegisterExceptionCallbacks_libsbml(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [DllImport("libsbmlcs", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_libsbml")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_libsbml(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_libsbml(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_libsbml(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [ThreadStatic]
    private static Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(Exception e) {
      if (pendingException != null)
        throw new ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(libsbmlPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static Exception Retrieve() {
      Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(libsbmlPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [DllImport("libsbmlcs", EntryPoint="SWIGRegisterStringCallback_libsbml")]
    public static extern void SWIGRegisterStringCallback_libsbml(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_libsbml(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  static libsbmlPINVOKE() {
  }


  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelCreatorList")]
  public static extern IntPtr new_ModelCreatorList();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ModelCreatorList")]
  public static extern void delete_ModelCreatorList(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreatorList_add")]
  public static extern void ModelCreatorList_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreatorList_get")]
  public static extern IntPtr ModelCreatorList_get(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreatorList_prepend")]
  public static extern void ModelCreatorList_prepend(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreatorList_remove")]
  public static extern IntPtr ModelCreatorList_remove(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreatorList_getSize")]
  public static extern uint ModelCreatorList_getSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_DateList")]
  public static extern IntPtr new_DateList();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_DateList")]
  public static extern void delete_DateList(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_DateList_add")]
  public static extern void DateList_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_DateList_get")]
  public static extern IntPtr DateList_get(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_DateList_prepend")]
  public static extern void DateList_prepend(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_DateList_remove")]
  public static extern IntPtr DateList_remove(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_DateList_getSize")]
  public static extern uint DateList_getSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTermList")]
  public static extern IntPtr new_CVTermList();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_CVTermList")]
  public static extern void delete_CVTermList(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTermList_add")]
  public static extern void CVTermList_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTermList_get")]
  public static extern IntPtr CVTermList_get(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTermList_prepend")]
  public static extern void CVTermList_prepend(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTermList_remove")]
  public static extern IntPtr CVTermList_remove(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTermList_getSize")]
  public static extern uint CVTermList_getSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNodeList")]
  public static extern IntPtr new_ASTNodeList();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ASTNodeList")]
  public static extern void delete_ASTNodeList(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNodeList_add")]
  public static extern void ASTNodeList_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNodeList_get")]
  public static extern IntPtr ASTNodeList_get(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNodeList_prepend")]
  public static extern void ASTNodeList_prepend(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNodeList_remove")]
  public static extern IntPtr ASTNodeList_remove(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNodeList_getSize")]
  public static extern uint ASTNodeList_getSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLNamespacesList")]
  public static extern IntPtr new_SBMLNamespacesList();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLNamespacesList")]
  public static extern void delete_SBMLNamespacesList(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespacesList_add")]
  public static extern void SBMLNamespacesList_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespacesList_get")]
  public static extern IntPtr SBMLNamespacesList_get(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespacesList_prepend")]
  public static extern void SBMLNamespacesList_prepend(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespacesList_remove")]
  public static extern IntPtr SBMLNamespacesList_remove(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespacesList_getSize")]
  public static extern uint SBMLNamespacesList_getSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBaseList")]
  public static extern IntPtr new_SBaseList();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBaseList")]
  public static extern void delete_SBaseList(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseList_add")]
  public static extern void SBaseList_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseList_get")]
  public static extern IntPtr SBaseList_get(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseList_prepend")]
  public static extern void SBaseList_prepend(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseList_remove")]
  public static extern IntPtr SBaseList_remove(HandleRef jarg1, uint jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseList_getSize")]
  public static extern uint SBaseList_getSize(HandleRef jarg1);

  protected class SWIGWStringHelper {

    public delegate string SWIGWStringDelegate(IntPtr message);
    static SWIGWStringDelegate wstringDelegate = new SWIGWStringDelegate(CreateWString);

    [DllImport("libsbmlcs", EntryPoint="SWIGRegisterWStringCallback_libsbml")]
    public static extern void SWIGRegisterWStringCallback_libsbml(SWIGWStringDelegate wstringDelegate);

    static string CreateWString([MarshalAs(UnmanagedType.LPWStr)]IntPtr cString) {
      return System.Runtime.InteropServices.Marshal.PtrToStringUni(cString);
    }

    static SWIGWStringHelper() {
      SWIGRegisterWStringCallback_libsbml(wstringDelegate);
    }
  }

  static protected SWIGWStringHelper swigWStringHelper = new SWIGWStringHelper();


  class CustomExceptionHelper {
    // C# delegate for the C/C++ customExceptionCallback
    public delegate void CustomExceptionDelegate(string message, int type);
    static CustomExceptionDelegate customDelegate =
                                   new CustomExceptionDelegate(SetPendingCustomException);

    [DllImport("libsbmlcs", EntryPoint="CustomExceptionRegisterCallback")]
    public static extern
           void CustomExceptionRegisterCallback(CustomExceptionDelegate customCallback);

    static void SetPendingCustomException(string message, int type) {
      if (type == 0)
      SWIGPendingException.Set(new SBMLConstructorException(message));
	  else 
		SWIGPendingException.Set(new XMLConstructorException(message));
    }

    static CustomExceptionHelper() {
      CustomExceptionRegisterCallback(customDelegate);
    }
  }

  // The following pragma's disable the compiler warning that the variable is
  // never used.  Don't remove the actual code, though, or you will get 
  // compile-time errors.

  #pragma warning disable 0414
  static CustomExceptionHelper exceptionHelper = new CustomExceptionHelper();
  #pragma warning restore 0414


  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OStream__SWIG_0")]
  public static extern IntPtr new_OStream__SWIG_0(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OStream__SWIG_1")]
  public static extern IntPtr new_OStream__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_OStream")]
  public static extern void delete_OStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStream_get_ostream")]
  public static extern IntPtr OStream_get_ostream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStream_endl")]
  public static extern void OStream_endl(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OFStream__SWIG_0")]
  public static extern IntPtr new_OFStream__SWIG_0(string jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OFStream__SWIG_1")]
  public static extern IntPtr new_OFStream__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_OFStream")]
  public static extern void delete_OFStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_open__SWIG_0")]
  public static extern void OFStream_open__SWIG_0(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_open__SWIG_1")]
  public static extern void OFStream_open__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_close")]
  public static extern void OFStream_close(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_is_open")]
  public static extern bool OFStream_is_open(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OStringStream")]
  public static extern IntPtr new_OStringStream();

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStringStream_str__SWIG_0")]
  public static extern string OStringStream_str__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStringStream_str__SWIG_1")]
  public static extern void OStringStream_str__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_OStringStream")]
  public static extern void delete_OStringStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_getLibSBMLVersion")]
  public static extern int getLibSBMLVersion();

  [DllImport("libsbmlcs", EntryPoint="CSharp_getLibSBMLDottedVersion")]
  public static extern string getLibSBMLDottedVersion();

  [DllImport("libsbmlcs", EntryPoint="CSharp_getLibSBMLVersionString")]
  public static extern string getLibSBMLVersionString();

  [DllImport("libsbmlcs", EntryPoint="CSharp_isLibSBMLCompiledWith")]
  public static extern int isLibSBMLCompiledWith(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_getLibSBMLDependencyVersionOf")]
  public static extern string getLibSBMLDependencyVersionOf(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OperationReturnValue_toString")]
  public static extern string OperationReturnValue_toString(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_IdList__SWIG_0")]
  public static extern IntPtr new_IdList__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_IdList__SWIG_1")]
  public static extern IntPtr new_IdList__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdList_append")]
  public static extern void IdList_append(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdList_contains")]
  public static extern bool IdList_contains(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdList_removeIdsBefore")]
  public static extern void IdList_removeIdsBefore(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdList_size")]
  public static extern uint IdList_size(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdList_clear")]
  public static extern void IdList_clear(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdList_at")]
  public static extern string IdList_at(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_IdList")]
  public static extern void delete_IdList(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_IdentifierTransformer")]
  public static extern IntPtr new_IdentifierTransformer();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_IdentifierTransformer")]
  public static extern void delete_IdentifierTransformer(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdentifierTransformer_transform")]
  public static extern int IdentifierTransformer_transform(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdentifierTransformer_transformSwigExplicitIdentifierTransformer")]
  public static extern int IdentifierTransformer_transformSwigExplicitIdentifierTransformer(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_IdentifierTransformer_director_connect")]
  public static extern void IdentifierTransformer_director_connect(HandleRef jarg1, IdentifierTransformer.SwigDelegateIdentifierTransformer_0 delegate0);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ElementFilter")]
  public static extern IntPtr new_ElementFilter();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ElementFilter")]
  public static extern void delete_ElementFilter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ElementFilter_filter")]
  public static extern bool ElementFilter_filter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ElementFilter_filterSwigExplicitElementFilter")]
  public static extern bool ElementFilter_filterSwigExplicitElementFilter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ElementFilter_director_connect")]
  public static extern void ElementFilter_director_connect(HandleRef jarg1, ElementFilter.SwigDelegateElementFilter_0 delegate0);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLReader")]
  public static extern IntPtr new_SBMLReader();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLReader")]
  public static extern void delete_SBMLReader(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_readSBML")]
  public static extern IntPtr SBMLReader_readSBML(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_readSBMLFromFile")]
  public static extern IntPtr SBMLReader_readSBMLFromFile(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_readSBMLFromString")]
  public static extern IntPtr SBMLReader_readSBMLFromString(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_hasZlib")]
  public static extern bool SBMLReader_hasZlib();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_hasBzip2")]
  public static extern bool SBMLReader_hasBzip2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_readSBML")]
  public static extern IntPtr readSBML(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_readSBMLFromFile")]
  public static extern IntPtr readSBMLFromFile(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_readSBMLFromString")]
  public static extern IntPtr readSBMLFromString(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLWriter")]
  public static extern IntPtr new_SBMLWriter();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLWriter")]
  public static extern void delete_SBMLWriter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_setProgramName")]
  public static extern int SBMLWriter_setProgramName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_setProgramVersion")]
  public static extern int SBMLWriter_setProgramVersion(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_writeSBML__SWIG_0")]
  public static extern bool SBMLWriter_writeSBML__SWIG_0(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_writeSBML__SWIG_1")]
  public static extern bool SBMLWriter_writeSBML__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_writeToString")]
  public static extern string SBMLWriter_writeToString(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_writeSBMLToFile")]
  public static extern bool SBMLWriter_writeSBMLToFile(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_writeSBMLToString")]
  public static extern string SBMLWriter_writeSBMLToString(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_hasZlib")]
  public static extern bool SBMLWriter_hasZlib();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_hasBzip2")]
  public static extern bool SBMLWriter_hasBzip2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_writeSBML")]
  public static extern int writeSBML(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_writeSBMLToString")]
  public static extern string writeSBMLToString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_writeSBMLToFile")]
  public static extern int writeSBMLToFile(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTypeCode_toString")]
  public static extern string SBMLTypeCode_toString(int jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBase")]
  public static extern void delete_SBase(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_clone")]
  public static extern IntPtr SBase_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getElementBySId__SWIG_0")]
  public static extern IntPtr SBase_getElementBySId__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getElementByMetaId__SWIG_0")]
  public static extern IntPtr SBase_getElementByMetaId__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_renameSIdRefs")]
  public static extern void SBase_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_renameMetaIdRefs")]
  public static extern void SBase_renameMetaIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_renameUnitSIdRefs")]
  public static extern void SBase_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_replaceSIDWithFunction")]
  public static extern void SBase_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_divideAssignmentsToSIdByFunction")]
  public static extern void SBase_divideAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_multiplyAssignmentsToSIdByFunction")]
  public static extern void SBase_multiplyAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getElementFromPluginsBySId")]
  public static extern IntPtr SBase_getElementFromPluginsBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getElementFromPluginsByMetaId")]
  public static extern IntPtr SBase_getElementFromPluginsByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_hasNonstandardIdentifierBeginningWith")]
  public static extern bool SBase_hasNonstandardIdentifierBeginningWith(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_prependStringToAllIdentifiers")]
  public static extern int SBase_prependStringToAllIdentifiers(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_transformIdentifiers")]
  public static extern int SBase_transformIdentifiers(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getMetaId")]
  public static extern string SBase_getMetaId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getId")]
  public static extern string SBase_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getName")]
  public static extern string SBase_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNotes__SWIG_0")]
  public static extern IntPtr SBase_getNotes__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNotesString__SWIG_0")]
  public static extern string SBase_getNotesString__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getAnnotation__SWIG_0")]
  public static extern IntPtr SBase_getAnnotation__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getAnnotationString__SWIG_0")]
  public static extern string SBase_getAnnotationString__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNamespaces")]
  public static extern IntPtr SBase_getNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getSBMLDocument__SWIG_0")]
  public static extern IntPtr SBase_getSBMLDocument__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getParentSBMLObject__SWIG_0")]
  public static extern IntPtr SBase_getParentSBMLObject__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getAncestorOfType__SWIG_0")]
  public static extern IntPtr SBase_getAncestorOfType__SWIG_0(HandleRef jarg1, int jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getAncestorOfType__SWIG_1")]
  public static extern IntPtr SBase_getAncestorOfType__SWIG_1(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getSBOTerm")]
  public static extern int SBase_getSBOTerm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getSBOTermID")]
  public static extern string SBase_getSBOTermID(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getSBOTermAsURL")]
  public static extern string SBase_getSBOTermAsURL(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getLine")]
  public static extern uint SBase_getLine(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getColumn")]
  public static extern uint SBase_getColumn(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getModelHistory__SWIG_0")]
  public static extern IntPtr SBase_getModelHistory__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetMetaId")]
  public static extern bool SBase_isSetMetaId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetId")]
  public static extern bool SBase_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetName")]
  public static extern bool SBase_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetNotes")]
  public static extern bool SBase_isSetNotes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetAnnotation")]
  public static extern bool SBase_isSetAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetSBOTerm")]
  public static extern bool SBase_isSetSBOTerm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setMetaId")]
  public static extern int SBase_setMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetModelHistory")]
  public static extern bool SBase_isSetModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setId")]
  public static extern int SBase_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setName")]
  public static extern int SBase_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setAnnotation__SWIG_0")]
  public static extern int SBase_setAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setAnnotation__SWIG_1")]
  public static extern int SBase_setAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_appendAnnotation__SWIG_0")]
  public static extern int SBase_appendAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_appendAnnotation__SWIG_1")]
  public static extern int SBase_appendAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_removeTopLevelAnnotationElement__SWIG_0")]
  public static extern int SBase_removeTopLevelAnnotationElement__SWIG_0(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_removeTopLevelAnnotationElement__SWIG_1")]
  public static extern int SBase_removeTopLevelAnnotationElement__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_removeTopLevelAnnotationElement__SWIG_2")]
  public static extern int SBase_removeTopLevelAnnotationElement__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_replaceTopLevelAnnotationElement__SWIG_0")]
  public static extern int SBase_replaceTopLevelAnnotationElement__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_replaceTopLevelAnnotationElement__SWIG_1")]
  public static extern int SBase_replaceTopLevelAnnotationElement__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setNotes__SWIG_0")]
  public static extern int SBase_setNotes__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setNotes__SWIG_1")]
  public static extern int SBase_setNotes__SWIG_1(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setNotes__SWIG_2")]
  public static extern int SBase_setNotes__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_appendNotes__SWIG_0")]
  public static extern int SBase_appendNotes__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_appendNotes__SWIG_1")]
  public static extern int SBase_appendNotes__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setModelHistory")]
  public static extern int SBase_setModelHistory(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_connectToParent")]
  public static extern void SBase_connectToParent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_connectToChild")]
  public static extern void SBase_connectToChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setSBOTerm__SWIG_0")]
  public static extern int SBase_setSBOTerm__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setSBOTerm__SWIG_1")]
  public static extern int SBase_setSBOTerm__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setNamespaces")]
  public static extern int SBase_setNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetMetaId")]
  public static extern int SBase_unsetMetaId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetId")]
  public static extern int SBase_unsetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetName")]
  public static extern int SBase_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetNotes")]
  public static extern int SBase_unsetNotes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetAnnotation")]
  public static extern int SBase_unsetAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetSBOTerm")]
  public static extern int SBase_unsetSBOTerm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_addCVTerm__SWIG_0")]
  public static extern int SBase_addCVTerm__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_addCVTerm__SWIG_1")]
  public static extern int SBase_addCVTerm__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getCVTerms__SWIG_0")]
  public static extern IntPtr SBase_getCVTerms__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNumCVTerms")]
  public static extern uint SBase_getNumCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getCVTerm")]
  public static extern IntPtr SBase_getCVTerm(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetCVTerms")]
  public static extern int SBase_unsetCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetModelHistory")]
  public static extern int SBase_unsetModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getResourceBiologicalQualifier")]
  public static extern int SBase_getResourceBiologicalQualifier(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getResourceModelQualifier")]
  public static extern int SBase_getResourceModelQualifier(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getModel")]
  public static extern IntPtr SBase_getModel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getLevel")]
  public static extern uint SBase_getLevel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getVersion")]
  public static extern uint SBase_getVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getPackageVersion")]
  public static extern uint SBase_getPackageVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getPackageName")]
  public static extern string SBase_getPackageName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getTypeCode")]
  public static extern int SBase_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_hasValidLevelVersionNamespaceCombination")]
  public static extern bool SBase_hasValidLevelVersionNamespaceCombination(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getElementName")]
  public static extern string SBase_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_toSBML")]
  public static extern string SBase_toSBML(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_toXMLNode")]
  public static extern IntPtr SBase_toXMLNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getPlugin__SWIG_0")]
  public static extern IntPtr SBase_getPlugin__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getPlugin__SWIG_2")]
  public static extern IntPtr SBase_getPlugin__SWIG_2(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getDisabledPlugin__SWIG_0")]
  public static extern IntPtr SBase_getDisabledPlugin__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNumPlugins")]
  public static extern uint SBase_getNumPlugins(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNumDisabledPlugins")]
  public static extern uint SBase_getNumDisabledPlugins(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_deleteDisabledPlugins__SWIG_0")]
  public static extern void SBase_deleteDisabledPlugins__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_deleteDisabledPlugins__SWIG_1")]
  public static extern void SBase_deleteDisabledPlugins__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_enablePackage")]
  public static extern int SBase_enablePackage(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_disablePackage")]
  public static extern int SBase_disablePackage(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_enablePackageInternal")]
  public static extern void SBase_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isPackageURIEnabled")]
  public static extern bool SBase_isPackageURIEnabled(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isPackageEnabled")]
  public static extern bool SBase_isPackageEnabled(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isPkgURIEnabled")]
  public static extern bool SBase_isPkgURIEnabled(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isPkgEnabled")]
  public static extern bool SBase_isPkgEnabled(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_writeExtensionElements")]
  public static extern void SBase_writeExtensionElements(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_hasRequiredAttributes")]
  public static extern bool SBase_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_hasRequiredElements")]
  public static extern bool SBase_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_checkCompatibility")]
  public static extern int SBase_checkCompatibility(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setSBMLNamespacesAndOwn")]
  public static extern void SBase_setSBMLNamespacesAndOwn(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getSBMLNamespaces")]
  public static extern IntPtr SBase_getSBMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_checkMathMLNamespace")]
  public static extern string SBase_checkMathMLNamespace(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getDerivedUnitDefinition")]
  public static extern IntPtr SBase_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_containsUndeclaredUnits")]
  public static extern bool SBase_containsUndeclaredUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_removeFromParentAndDelete")]
  public static extern int SBase_removeFromParentAndDelete(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_matchesSBMLNamespaces__SWIG_0")]
  public static extern bool SBase_matchesSBMLNamespaces__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_matchesRequiredSBMLNamespacesForAddition__SWIG_0")]
  public static extern bool SBase_matchesRequiredSBMLNamespacesForAddition__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetUserData")]
  public static extern bool SBase_isSetUserData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetUserData")]
  public static extern int SBase_unsetUserData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getURI")]
  public static extern string SBase_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getPrefix")]
  public static extern string SBase_getPrefix(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getListOfAllElements__SWIG_0")]
  public static extern IntPtr SBase_getListOfAllElements__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getListOfAllElements__SWIG_1")]
  public static extern IntPtr SBase_getListOfAllElements__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getListOfAllElementsFromPlugins__SWIG_0")]
  public static extern IntPtr SBase_getListOfAllElementsFromPlugins__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getListOfAllElementsFromPlugins__SWIG_1")]
  public static extern IntPtr SBase_getListOfAllElementsFromPlugins__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOf__SWIG_0")]
  public static extern IntPtr new_ListOf__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOf__SWIG_1")]
  public static extern IntPtr new_ListOf__SWIG_1(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOf__SWIG_2")]
  public static extern IntPtr new_ListOf__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOf__SWIG_3")]
  public static extern IntPtr new_ListOf__SWIG_3(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOf")]
  public static extern void delete_ListOf(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOf__SWIG_4")]
  public static extern IntPtr new_ListOf__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_clone")]
  public static extern IntPtr ListOf_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_append")]
  public static extern int ListOf_append(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_appendAndOwn")]
  public static extern int ListOf_appendAndOwn(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_appendFrom")]
  public static extern int ListOf_appendFrom(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_insert")]
  public static extern int ListOf_insert(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_insertAndOwn")]
  public static extern int ListOf_insertAndOwn(HandleRef jarg1, int jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_get__SWIG_0")]
  public static extern IntPtr ListOf_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_getElementBySId")]
  public static extern IntPtr ListOf_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_getElementByMetaId")]
  public static extern IntPtr ListOf_getElementByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_clear__SWIG_0")]
  public static extern void ListOf_clear__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_clear__SWIG_1")]
  public static extern void ListOf_clear__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_removeFromParentAndDelete")]
  public static extern int ListOf_removeFromParentAndDelete(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_remove")]
  public static extern IntPtr ListOf_remove(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_size")]
  public static extern uint ListOf_size(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_connectToChild")]
  public static extern void ListOf_connectToChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_getTypeCode")]
  public static extern int ListOf_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_getItemTypeCode")]
  public static extern int ListOf_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_getElementName")]
  public static extern string ListOf_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_enablePackageInternal")]
  public static extern void ListOf_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_0")]
  public static extern IntPtr new_Model__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_1")]
  public static extern IntPtr new_Model__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Model")]
  public static extern void delete_Model(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_2")]
  public static extern IntPtr new_Model__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_clone")]
  public static extern IntPtr Model_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getElementBySId")]
  public static extern IntPtr Model_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getElementByMetaId")]
  public static extern IntPtr Model_getElementByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getId")]
  public static extern string Model_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getName")]
  public static extern string Model_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSubstanceUnits")]
  public static extern string Model_getSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getTimeUnits")]
  public static extern string Model_getTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getVolumeUnits")]
  public static extern string Model_getVolumeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getAreaUnits")]
  public static extern string Model_getAreaUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getLengthUnits")]
  public static extern string Model_getLengthUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getExtentUnits")]
  public static extern string Model_getExtentUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getConversionFactor")]
  public static extern string Model_getConversionFactor(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetId")]
  public static extern bool Model_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetName")]
  public static extern bool Model_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetSubstanceUnits")]
  public static extern bool Model_isSetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetTimeUnits")]
  public static extern bool Model_isSetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetVolumeUnits")]
  public static extern bool Model_isSetVolumeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetAreaUnits")]
  public static extern bool Model_isSetAreaUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetLengthUnits")]
  public static extern bool Model_isSetLengthUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetExtentUnits")]
  public static extern bool Model_isSetExtentUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetConversionFactor")]
  public static extern bool Model_isSetConversionFactor(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setId")]
  public static extern int Model_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setName")]
  public static extern int Model_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setSubstanceUnits")]
  public static extern int Model_setSubstanceUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setTimeUnits")]
  public static extern int Model_setTimeUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setVolumeUnits")]
  public static extern int Model_setVolumeUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setAreaUnits")]
  public static extern int Model_setAreaUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setLengthUnits")]
  public static extern int Model_setLengthUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setExtentUnits")]
  public static extern int Model_setExtentUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setConversionFactor")]
  public static extern int Model_setConversionFactor(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetId")]
  public static extern int Model_unsetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetName")]
  public static extern int Model_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetSubstanceUnits")]
  public static extern int Model_unsetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetTimeUnits")]
  public static extern int Model_unsetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetVolumeUnits")]
  public static extern int Model_unsetVolumeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetAreaUnits")]
  public static extern int Model_unsetAreaUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetLengthUnits")]
  public static extern int Model_unsetLengthUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetExtentUnits")]
  public static extern int Model_unsetExtentUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetConversionFactor")]
  public static extern int Model_unsetConversionFactor(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addFunctionDefinition")]
  public static extern int Model_addFunctionDefinition(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addUnitDefinition")]
  public static extern int Model_addUnitDefinition(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addCompartmentType")]
  public static extern int Model_addCompartmentType(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addSpeciesType")]
  public static extern int Model_addSpeciesType(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addCompartment")]
  public static extern int Model_addCompartment(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addSpecies")]
  public static extern int Model_addSpecies(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addParameter")]
  public static extern int Model_addParameter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addInitialAssignment")]
  public static extern int Model_addInitialAssignment(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addRule")]
  public static extern int Model_addRule(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addConstraint")]
  public static extern int Model_addConstraint(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addReaction")]
  public static extern int Model_addReaction(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addEvent")]
  public static extern int Model_addEvent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createFunctionDefinition")]
  public static extern IntPtr Model_createFunctionDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createUnitDefinition")]
  public static extern IntPtr Model_createUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createUnit")]
  public static extern IntPtr Model_createUnit(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createCompartmentType")]
  public static extern IntPtr Model_createCompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createSpeciesType")]
  public static extern IntPtr Model_createSpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createCompartment")]
  public static extern IntPtr Model_createCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createSpecies")]
  public static extern IntPtr Model_createSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createParameter")]
  public static extern IntPtr Model_createParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createInitialAssignment")]
  public static extern IntPtr Model_createInitialAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createAlgebraicRule")]
  public static extern IntPtr Model_createAlgebraicRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createAssignmentRule")]
  public static extern IntPtr Model_createAssignmentRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createRateRule")]
  public static extern IntPtr Model_createRateRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createConstraint")]
  public static extern IntPtr Model_createConstraint(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createReaction")]
  public static extern IntPtr Model_createReaction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createReactant")]
  public static extern IntPtr Model_createReactant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createProduct")]
  public static extern IntPtr Model_createProduct(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createModifier")]
  public static extern IntPtr Model_createModifier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createKineticLaw")]
  public static extern IntPtr Model_createKineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createKineticLawParameter")]
  public static extern IntPtr Model_createKineticLawParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createKineticLawLocalParameter")]
  public static extern IntPtr Model_createKineticLawLocalParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createEvent")]
  public static extern IntPtr Model_createEvent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createEventAssignment")]
  public static extern IntPtr Model_createEventAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createTrigger")]
  public static extern IntPtr Model_createTrigger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createDelay")]
  public static extern IntPtr Model_createDelay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setAnnotation__SWIG_0")]
  public static extern int Model_setAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setAnnotation__SWIG_1")]
  public static extern int Model_setAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_appendAnnotation__SWIG_0")]
  public static extern int Model_appendAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_appendAnnotation__SWIG_1")]
  public static extern int Model_appendAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfFunctionDefinitions__SWIG_0")]
  public static extern IntPtr Model_getListOfFunctionDefinitions__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfUnitDefinitions__SWIG_0")]
  public static extern IntPtr Model_getListOfUnitDefinitions__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfCompartmentTypes__SWIG_0")]
  public static extern IntPtr Model_getListOfCompartmentTypes__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfSpeciesTypes__SWIG_0")]
  public static extern IntPtr Model_getListOfSpeciesTypes__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfCompartments__SWIG_0")]
  public static extern IntPtr Model_getListOfCompartments__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfSpecies__SWIG_0")]
  public static extern IntPtr Model_getListOfSpecies__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfParameters__SWIG_0")]
  public static extern IntPtr Model_getListOfParameters__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfInitialAssignments__SWIG_0")]
  public static extern IntPtr Model_getListOfInitialAssignments__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfRules__SWIG_0")]
  public static extern IntPtr Model_getListOfRules__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfConstraints__SWIG_0")]
  public static extern IntPtr Model_getListOfConstraints__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfReactions__SWIG_0")]
  public static extern IntPtr Model_getListOfReactions__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfEvents__SWIG_0")]
  public static extern IntPtr Model_getListOfEvents__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getFunctionDefinition__SWIG_0")]
  public static extern IntPtr Model_getFunctionDefinition__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getFunctionDefinition__SWIG_2")]
  public static extern IntPtr Model_getFunctionDefinition__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getUnitDefinition__SWIG_0")]
  public static extern IntPtr Model_getUnitDefinition__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getUnitDefinition__SWIG_2")]
  public static extern IntPtr Model_getUnitDefinition__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getCompartmentType__SWIG_0")]
  public static extern IntPtr Model_getCompartmentType__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getCompartmentType__SWIG_2")]
  public static extern IntPtr Model_getCompartmentType__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpeciesType__SWIG_0")]
  public static extern IntPtr Model_getSpeciesType__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpeciesType__SWIG_2")]
  public static extern IntPtr Model_getSpeciesType__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getCompartment__SWIG_0")]
  public static extern IntPtr Model_getCompartment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getCompartment__SWIG_2")]
  public static extern IntPtr Model_getCompartment__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpecies__SWIG_0")]
  public static extern IntPtr Model_getSpecies__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpecies__SWIG_2")]
  public static extern IntPtr Model_getSpecies__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getParameter__SWIG_0")]
  public static extern IntPtr Model_getParameter__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getParameter__SWIG_2")]
  public static extern IntPtr Model_getParameter__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getInitialAssignment__SWIG_0")]
  public static extern IntPtr Model_getInitialAssignment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getInitialAssignment__SWIG_2")]
  public static extern IntPtr Model_getInitialAssignment__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getInitialAssignmentBySymbol__SWIG_0")]
  public static extern IntPtr Model_getInitialAssignmentBySymbol__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getRule__SWIG_0")]
  public static extern IntPtr Model_getRule__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getRule__SWIG_2")]
  public static extern IntPtr Model_getRule__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getRuleByVariable__SWIG_0")]
  public static extern IntPtr Model_getRuleByVariable__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getAssignmentRule__SWIG_0")]
  public static extern IntPtr Model_getAssignmentRule__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getRateRule__SWIG_0")]
  public static extern IntPtr Model_getRateRule__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getAssignmentRuleByVariable__SWIG_0")]
  public static extern IntPtr Model_getAssignmentRuleByVariable__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getRateRuleByVariable__SWIG_0")]
  public static extern IntPtr Model_getRateRuleByVariable__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getConstraint__SWIG_0")]
  public static extern IntPtr Model_getConstraint__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getReaction__SWIG_0")]
  public static extern IntPtr Model_getReaction__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getReaction__SWIG_2")]
  public static extern IntPtr Model_getReaction__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpeciesReference__SWIG_0")]
  public static extern IntPtr Model_getSpeciesReference__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getModifierSpeciesReference__SWIG_0")]
  public static extern IntPtr Model_getModifierSpeciesReference__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getEvent__SWIG_0")]
  public static extern IntPtr Model_getEvent__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getEvent__SWIG_2")]
  public static extern IntPtr Model_getEvent__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumFunctionDefinitions")]
  public static extern uint Model_getNumFunctionDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumUnitDefinitions")]
  public static extern uint Model_getNumUnitDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumCompartmentTypes")]
  public static extern uint Model_getNumCompartmentTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumSpeciesTypes")]
  public static extern uint Model_getNumSpeciesTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumCompartments")]
  public static extern uint Model_getNumCompartments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumSpecies")]
  public static extern uint Model_getNumSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumSpeciesWithBoundaryCondition")]
  public static extern uint Model_getNumSpeciesWithBoundaryCondition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumParameters")]
  public static extern uint Model_getNumParameters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumInitialAssignments")]
  public static extern uint Model_getNumInitialAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumRules")]
  public static extern uint Model_getNumRules(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumConstraints")]
  public static extern uint Model_getNumConstraints(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumReactions")]
  public static extern uint Model_getNumReactions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumEvents")]
  public static extern uint Model_getNumEvents(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeFromParentAndDelete")]
  public static extern int Model_removeFromParentAndDelete(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_renameAllIds__SWIG_0")]
  public static extern int Model_renameAllIds__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_renameAllIds__SWIG_1")]
  public static extern int Model_renameAllIds__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_renameSIdRefs")]
  public static extern void Model_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_renameUnitSIdRefs")]
  public static extern void Model_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL1ToL2")]
  public static extern void Model_convertL1ToL2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL1ToL3__SWIG_0")]
  public static extern void Model_convertL1ToL3__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL1ToL3__SWIG_1")]
  public static extern void Model_convertL1ToL3__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL2ToL3__SWIG_0")]
  public static extern void Model_convertL2ToL3__SWIG_0(HandleRef jarg1, bool jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL2ToL3__SWIG_1")]
  public static extern void Model_convertL2ToL3__SWIG_1(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL2ToL3__SWIG_2")]
  public static extern void Model_convertL2ToL3__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL2ToL1__SWIG_0")]
  public static extern void Model_convertL2ToL1__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL2ToL1__SWIG_1")]
  public static extern void Model_convertL2ToL1__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL3ToL1__SWIG_0")]
  public static extern void Model_convertL3ToL1__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL3ToL1__SWIG_1")]
  public static extern void Model_convertL3ToL1__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL3ToL2__SWIG_0")]
  public static extern void Model_convertL3ToL2__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertL3ToL2__SWIG_1")]
  public static extern void Model_convertL3ToL2__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addModifiers")]
  public static extern void Model_addModifiers(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addConstantAttribute")]
  public static extern void Model_addConstantAttribute(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setSpatialDimensions__SWIG_0")]
  public static extern void Model_setSpatialDimensions__SWIG_0(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setSpatialDimensions__SWIG_1")]
  public static extern void Model_setSpatialDimensions__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addDefinitionsForDefaultUnits")]
  public static extern void Model_addDefinitionsForDefaultUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_dealWithDefaultValues")]
  public static extern void Model_dealWithDefaultValues(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertParametersToLocals")]
  public static extern void Model_convertParametersToLocals(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setSpeciesReferenceConstantValueAndStoichiometry")]
  public static extern void Model_setSpeciesReferenceConstantValueAndStoichiometry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeParameterRuleUnits")]
  public static extern void Model_removeParameterRuleUnits(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertStoichiometryMath")]
  public static extern void Model_convertStoichiometryMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_assignRequiredValues")]
  public static extern void Model_assignRequiredValues(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_dealWithModelUnits__SWIG_0")]
  public static extern void Model_dealWithModelUnits__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_dealWithModelUnits__SWIG_1")]
  public static extern void Model_dealWithModelUnits__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_dealWithStoichiometry")]
  public static extern void Model_dealWithStoichiometry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_dealWithEvents")]
  public static extern void Model_dealWithEvents(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeSpeciesTypes")]
  public static extern void Model_removeSpeciesTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeCompartmentTypes")]
  public static extern void Model_removeCompartmentTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_connectToChild")]
  public static extern void Model_connectToChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getTypeCode")]
  public static extern int Model_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getElementName")]
  public static extern string Model_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_populateListFormulaUnitsData")]
  public static extern void Model_populateListFormulaUnitsData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isPopulatedListFormulaUnitsData")]
  public static extern bool Model_isPopulatedListFormulaUnitsData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getFormulaUnitsDataForVariable")]
  public static extern IntPtr Model_getFormulaUnitsDataForVariable(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getFormulaUnitsDataForAssignment")]
  public static extern IntPtr Model_getFormulaUnitsDataForAssignment(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_hasRequiredElements")]
  public static extern bool Model_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeFunctionDefinition__SWIG_0")]
  public static extern IntPtr Model_removeFunctionDefinition__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeFunctionDefinition__SWIG_1")]
  public static extern IntPtr Model_removeFunctionDefinition__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeUnitDefinition__SWIG_0")]
  public static extern IntPtr Model_removeUnitDefinition__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeUnitDefinition__SWIG_1")]
  public static extern IntPtr Model_removeUnitDefinition__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeCompartmentType__SWIG_0")]
  public static extern IntPtr Model_removeCompartmentType__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeCompartmentType__SWIG_1")]
  public static extern IntPtr Model_removeCompartmentType__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeSpeciesType__SWIG_0")]
  public static extern IntPtr Model_removeSpeciesType__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeSpeciesType__SWIG_1")]
  public static extern IntPtr Model_removeSpeciesType__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeCompartment__SWIG_0")]
  public static extern IntPtr Model_removeCompartment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeCompartment__SWIG_1")]
  public static extern IntPtr Model_removeCompartment__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeSpecies__SWIG_0")]
  public static extern IntPtr Model_removeSpecies__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeSpecies__SWIG_1")]
  public static extern IntPtr Model_removeSpecies__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeParameter__SWIG_0")]
  public static extern IntPtr Model_removeParameter__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeParameter__SWIG_1")]
  public static extern IntPtr Model_removeParameter__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeInitialAssignment__SWIG_0")]
  public static extern IntPtr Model_removeInitialAssignment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeInitialAssignment__SWIG_1")]
  public static extern IntPtr Model_removeInitialAssignment__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeRule__SWIG_0")]
  public static extern IntPtr Model_removeRule__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeRule__SWIG_1")]
  public static extern IntPtr Model_removeRule__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeRuleByVariable")]
  public static extern IntPtr Model_removeRuleByVariable(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeConstraint")]
  public static extern IntPtr Model_removeConstraint(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeReaction__SWIG_0")]
  public static extern IntPtr Model_removeReaction__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeReaction__SWIG_1")]
  public static extern IntPtr Model_removeReaction__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeEvent__SWIG_0")]
  public static extern IntPtr Model_removeEvent__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_removeEvent__SWIG_1")]
  public static extern IntPtr Model_removeEvent__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_appendFrom")]
  public static extern int Model_appendFrom(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_enablePackageInternal")]
  public static extern void Model_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_renameIDs")]
  public static extern void Model_renameIDs(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getDefaultLevel")]
  public static extern uint SBMLDocument_getDefaultLevel();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getDefaultVersion")]
  public static extern uint SBMLDocument_getDefaultVersion();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_0")]
  public static extern IntPtr new_SBMLDocument__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_1")]
  public static extern IntPtr new_SBMLDocument__SWIG_1(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_2")]
  public static extern IntPtr new_SBMLDocument__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_3")]
  public static extern IntPtr new_SBMLDocument__SWIG_3(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLDocument")]
  public static extern void delete_SBMLDocument(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_4")]
  public static extern IntPtr new_SBMLDocument__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_clone")]
  public static extern IntPtr SBMLDocument_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_isSetModel")]
  public static extern bool SBMLDocument_isSetModel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getModel__SWIG_0")]
  public static extern IntPtr SBMLDocument_getModel__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getElementBySId")]
  public static extern IntPtr SBMLDocument_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getElementByMetaId")]
  public static extern IntPtr SBMLDocument_getElementByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_expandFunctionDefinitions")]
  public static extern bool SBMLDocument_expandFunctionDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_expandInitialAssignments")]
  public static extern bool SBMLDocument_expandInitialAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setLevelAndVersion__SWIG_0")]
  public static extern bool SBMLDocument_setLevelAndVersion__SWIG_0(HandleRef jarg1, long jarg2, long jarg3, bool jarg4, bool jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setLevelAndVersion__SWIG_1")]
  public static extern bool SBMLDocument_setLevelAndVersion__SWIG_1(HandleRef jarg1, long jarg2, long jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setLevelAndVersion__SWIG_2")]
  public static extern bool SBMLDocument_setLevelAndVersion__SWIG_2(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_updateSBMLNamespace")]
  public static extern void SBMLDocument_updateSBMLNamespace(HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setModel")]
  public static extern int SBMLDocument_setModel(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_createModel__SWIG_0")]
  public static extern IntPtr SBMLDocument_createModel__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_createModel__SWIG_1")]
  public static extern IntPtr SBMLDocument_createModel__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setLocationURI")]
  public static extern void SBMLDocument_setLocationURI(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getLocationURI__SWIG_0")]
  public static extern string SBMLDocument_getLocationURI__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setConsistencyChecks")]
  public static extern void SBMLDocument_setConsistencyChecks(HandleRef jarg1, int jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setConsistencyChecksForConversion")]
  public static extern void SBMLDocument_setConsistencyChecksForConversion(HandleRef jarg1, int jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkConsistency")]
  public static extern uint SBMLDocument_checkConsistency(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkConsistencyWithStrictUnits")]
  public static extern uint SBMLDocument_checkConsistencyWithStrictUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_validateSBML")]
  public static extern uint SBMLDocument_validateSBML(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkInternalConsistency")]
  public static extern uint SBMLDocument_checkInternalConsistency(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL1Compatibility__SWIG_0")]
  public static extern uint SBMLDocument_checkL1Compatibility__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL1Compatibility__SWIG_1")]
  public static extern uint SBMLDocument_checkL1Compatibility__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v1Compatibility__SWIG_0")]
  public static extern uint SBMLDocument_checkL2v1Compatibility__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v1Compatibility__SWIG_1")]
  public static extern uint SBMLDocument_checkL2v1Compatibility__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v2Compatibility__SWIG_0")]
  public static extern uint SBMLDocument_checkL2v2Compatibility__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v2Compatibility__SWIG_1")]
  public static extern uint SBMLDocument_checkL2v2Compatibility__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v3Compatibility__SWIG_0")]
  public static extern uint SBMLDocument_checkL2v3Compatibility__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v3Compatibility__SWIG_1")]
  public static extern uint SBMLDocument_checkL2v3Compatibility__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v4Compatibility")]
  public static extern uint SBMLDocument_checkL2v4Compatibility(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL3v1Compatibility")]
  public static extern uint SBMLDocument_checkL3v1Compatibility(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getError")]
  public static extern IntPtr SBMLDocument_getError(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getErrorWithSeverity")]
  public static extern IntPtr SBMLDocument_getErrorWithSeverity(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getNumErrors__SWIG_0")]
  public static extern uint SBMLDocument_getNumErrors__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getNumErrors__SWIG_1")]
  public static extern uint SBMLDocument_getNumErrors__SWIG_1(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_printErrors__SWIG_0")]
  public static extern void SBMLDocument_printErrors__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_printErrors__SWIG_1")]
  public static extern void SBMLDocument_printErrors__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_printErrors__SWIG_2")]
  public static extern void SBMLDocument_printErrors__SWIG_2(HandleRef jarg1, HandleRef jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_connectToChild")]
  public static extern void SBMLDocument_connectToChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_convert")]
  public static extern int SBMLDocument_convert(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_enablePackageInternal")]
  public static extern void SBMLDocument_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getTypeCode")]
  public static extern int SBMLDocument_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getElementName")]
  public static extern string SBMLDocument_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getErrorLog__SWIG_0")]
  public static extern IntPtr SBMLDocument_getErrorLog__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getNamespaces")]
  public static extern IntPtr SBMLDocument_getNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_enableDefaultNS")]
  public static extern int SBMLDocument_enableDefaultNS(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_isEnabledDefaultNS")]
  public static extern bool SBMLDocument_isEnabledDefaultNS(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setPackageRequired")]
  public static extern int SBMLDocument_setPackageRequired(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getPackageRequired")]
  public static extern bool SBMLDocument_getPackageRequired(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_isSetPackageRequired")]
  public static extern bool SBMLDocument_isSetPackageRequired(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_isIgnoredPackage")]
  public static extern bool SBMLDocument_isIgnoredPackage(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_isDisabledIgnoredPackage")]
  public static extern bool SBMLDocument_isDisabledIgnoredPackage(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setPkgRequired")]
  public static extern int SBMLDocument_setPkgRequired(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getPkgRequired")]
  public static extern bool SBMLDocument_getPkgRequired(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_isSetPkgRequired")]
  public static extern bool SBMLDocument_isSetPkgRequired(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_isIgnoredPkg")]
  public static extern bool SBMLDocument_isIgnoredPkg(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getApplicableValidators")]
  public static extern byte SBMLDocument_getApplicableValidators(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getConversionValidators")]
  public static extern byte SBMLDocument_getConversionValidators(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setApplicableValidators")]
  public static extern void SBMLDocument_setApplicableValidators(HandleRef jarg1, byte jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setConversionValidators")]
  public static extern void SBMLDocument_setConversionValidators(HandleRef jarg1, byte jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getNumValidators")]
  public static extern uint SBMLDocument_getNumValidators(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_clearValidators")]
  public static extern int SBMLDocument_clearValidators(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_addValidator")]
  public static extern int SBMLDocument_addValidator(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getValidator")]
  public static extern IntPtr SBMLDocument_getValidator(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_addUnknownPackageRequired")]
  public static extern int SBMLDocument_addUnknownPackageRequired(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_hasUnknownPackage")]
  public static extern bool SBMLDocument_hasUnknownPackage(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getNumUnknownPackages")]
  public static extern int SBMLDocument_getNumUnknownPackages(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getUnknownPackageURI")]
  public static extern string SBMLDocument_getUnknownPackageURI(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getUnknownPackagePrefix")]
  public static extern string SBMLDocument_getUnknownPackagePrefix(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_0")]
  public static extern IntPtr new_FunctionDefinition__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_1")]
  public static extern IntPtr new_FunctionDefinition__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_FunctionDefinition")]
  public static extern void delete_FunctionDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_2")]
  public static extern IntPtr new_FunctionDefinition__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_clone")]
  public static extern IntPtr FunctionDefinition_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getId")]
  public static extern string FunctionDefinition_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getName")]
  public static extern string FunctionDefinition_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getMath")]
  public static extern IntPtr FunctionDefinition_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_isSetId")]
  public static extern bool FunctionDefinition_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_isSetName")]
  public static extern bool FunctionDefinition_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_isSetMath")]
  public static extern bool FunctionDefinition_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_setId")]
  public static extern int FunctionDefinition_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_setName")]
  public static extern int FunctionDefinition_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_setMath")]
  public static extern int FunctionDefinition_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_unsetName")]
  public static extern int FunctionDefinition_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getArgument__SWIG_0")]
  public static extern IntPtr FunctionDefinition_getArgument__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getArgument__SWIG_1")]
  public static extern IntPtr FunctionDefinition_getArgument__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getBody__SWIG_0")]
  public static extern IntPtr FunctionDefinition_getBody__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_isSetBody")]
  public static extern bool FunctionDefinition_isSetBody(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getNumArguments")]
  public static extern uint FunctionDefinition_getNumArguments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getTypeCode")]
  public static extern int FunctionDefinition_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getElementName")]
  public static extern string FunctionDefinition_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_hasRequiredAttributes")]
  public static extern bool FunctionDefinition_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_hasRequiredElements")]
  public static extern bool FunctionDefinition_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_renameUnitSIdRefs")]
  public static extern void FunctionDefinition_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfFunctionDefinitions__SWIG_0")]
  public static extern IntPtr new_ListOfFunctionDefinitions__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfFunctionDefinitions__SWIG_1")]
  public static extern IntPtr new_ListOfFunctionDefinitions__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_clone")]
  public static extern IntPtr ListOfFunctionDefinitions_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_getItemTypeCode")]
  public static extern int ListOfFunctionDefinitions_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_getElementName")]
  public static extern string ListOfFunctionDefinitions_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_get__SWIG_0")]
  public static extern IntPtr ListOfFunctionDefinitions_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_get__SWIG_2")]
  public static extern IntPtr ListOfFunctionDefinitions_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_remove__SWIG_0")]
  public static extern IntPtr ListOfFunctionDefinitions_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_remove__SWIG_1")]
  public static extern IntPtr ListOfFunctionDefinitions_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfFunctionDefinitions")]
  public static extern void delete_ListOfFunctionDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitKind_equals")]
  public static extern int UnitKind_equals(int jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitKind_forName")]
  public static extern int UnitKind_forName(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitKind_toString")]
  public static extern string UnitKind_toString(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitKind_isValidUnitKindString")]
  public static extern int UnitKind_isValidUnitKindString(string jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_0")]
  public static extern IntPtr new_Unit__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_1")]
  public static extern IntPtr new_Unit__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Unit")]
  public static extern void delete_Unit(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_2")]
  public static extern IntPtr new_Unit__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_clone")]
  public static extern IntPtr Unit_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_initDefaults")]
  public static extern void Unit_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getKind")]
  public static extern int Unit_getKind(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getExponent")]
  public static extern int Unit_getExponent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getExponentAsDouble")]
  public static extern double Unit_getExponentAsDouble(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getScale")]
  public static extern int Unit_getScale(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getMultiplier")]
  public static extern double Unit_getMultiplier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getOffset")]
  public static extern double Unit_getOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isAmpere")]
  public static extern bool Unit_isAmpere(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isAvogadro")]
  public static extern bool Unit_isAvogadro(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isBecquerel")]
  public static extern bool Unit_isBecquerel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isCandela")]
  public static extern bool Unit_isCandela(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isCelsius")]
  public static extern bool Unit_isCelsius(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isCoulomb")]
  public static extern bool Unit_isCoulomb(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isDimensionless")]
  public static extern bool Unit_isDimensionless(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isFarad")]
  public static extern bool Unit_isFarad(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isGram")]
  public static extern bool Unit_isGram(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isGray")]
  public static extern bool Unit_isGray(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isHenry")]
  public static extern bool Unit_isHenry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isHertz")]
  public static extern bool Unit_isHertz(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isItem")]
  public static extern bool Unit_isItem(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isJoule")]
  public static extern bool Unit_isJoule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isKatal")]
  public static extern bool Unit_isKatal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isKelvin")]
  public static extern bool Unit_isKelvin(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isKilogram")]
  public static extern bool Unit_isKilogram(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isLitre")]
  public static extern bool Unit_isLitre(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isLumen")]
  public static extern bool Unit_isLumen(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isLux")]
  public static extern bool Unit_isLux(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isMetre")]
  public static extern bool Unit_isMetre(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isMole")]
  public static extern bool Unit_isMole(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isNewton")]
  public static extern bool Unit_isNewton(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isOhm")]
  public static extern bool Unit_isOhm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isPascal")]
  public static extern bool Unit_isPascal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isRadian")]
  public static extern bool Unit_isRadian(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSecond")]
  public static extern bool Unit_isSecond(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSiemens")]
  public static extern bool Unit_isSiemens(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSievert")]
  public static extern bool Unit_isSievert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSteradian")]
  public static extern bool Unit_isSteradian(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isTesla")]
  public static extern bool Unit_isTesla(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isVolt")]
  public static extern bool Unit_isVolt(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isWatt")]
  public static extern bool Unit_isWatt(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isWeber")]
  public static extern bool Unit_isWeber(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSetKind")]
  public static extern bool Unit_isSetKind(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSetExponent")]
  public static extern bool Unit_isSetExponent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSetScale")]
  public static extern bool Unit_isSetScale(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSetMultiplier")]
  public static extern bool Unit_isSetMultiplier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSetOffset")]
  public static extern bool Unit_isSetOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setKind")]
  public static extern int Unit_setKind(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setExponent__SWIG_0")]
  public static extern int Unit_setExponent__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setExponent__SWIG_1")]
  public static extern int Unit_setExponent__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setScale")]
  public static extern int Unit_setScale(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setMultiplier")]
  public static extern int Unit_setMultiplier(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setOffset")]
  public static extern int Unit_setOffset(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_unsetKind")]
  public static extern int Unit_unsetKind(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_unsetExponent")]
  public static extern int Unit_unsetExponent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_unsetScale")]
  public static extern int Unit_unsetScale(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_unsetMultiplier")]
  public static extern int Unit_unsetMultiplier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_unsetOffset")]
  public static extern int Unit_unsetOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getTypeCode")]
  public static extern int Unit_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getElementName")]
  public static extern string Unit_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isBuiltIn")]
  public static extern bool Unit_isBuiltIn(string jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isUnitKind")]
  public static extern bool Unit_isUnitKind(string jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_areIdentical")]
  public static extern bool Unit_areIdentical(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_areEquivalent")]
  public static extern bool Unit_areEquivalent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_removeScale")]
  public static extern int Unit_removeScale(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_merge")]
  public static extern void Unit_merge(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_convertToSI")]
  public static extern IntPtr Unit_convertToSI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_hasRequiredAttributes")]
  public static extern bool Unit_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfUnits__SWIG_0")]
  public static extern IntPtr new_ListOfUnits__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfUnits__SWIG_1")]
  public static extern IntPtr new_ListOfUnits__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_clone")]
  public static extern IntPtr ListOfUnits_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_getItemTypeCode")]
  public static extern int ListOfUnits_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_getElementName")]
  public static extern string ListOfUnits_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_get__SWIG_0")]
  public static extern IntPtr ListOfUnits_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_remove")]
  public static extern IntPtr ListOfUnits_remove(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfUnits")]
  public static extern void delete_ListOfUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_0")]
  public static extern IntPtr new_UnitDefinition__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_1")]
  public static extern IntPtr new_UnitDefinition__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_UnitDefinition")]
  public static extern void delete_UnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_2")]
  public static extern IntPtr new_UnitDefinition__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_clone")]
  public static extern IntPtr UnitDefinition_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getElementBySId")]
  public static extern IntPtr UnitDefinition_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getElementByMetaId")]
  public static extern IntPtr UnitDefinition_getElementByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getId")]
  public static extern string UnitDefinition_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getName")]
  public static extern string UnitDefinition_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isSetId")]
  public static extern bool UnitDefinition_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isSetName")]
  public static extern bool UnitDefinition_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_setId")]
  public static extern int UnitDefinition_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_setName")]
  public static extern int UnitDefinition_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_unsetName")]
  public static extern int UnitDefinition_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfArea")]
  public static extern bool UnitDefinition_isVariantOfArea(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfLength")]
  public static extern bool UnitDefinition_isVariantOfLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfSubstance")]
  public static extern bool UnitDefinition_isVariantOfSubstance(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfTime")]
  public static extern bool UnitDefinition_isVariantOfTime(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfVolume")]
  public static extern bool UnitDefinition_isVariantOfVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfDimensionless")]
  public static extern bool UnitDefinition_isVariantOfDimensionless(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfMass")]
  public static extern bool UnitDefinition_isVariantOfMass(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfSubstancePerTime")]
  public static extern bool UnitDefinition_isVariantOfSubstancePerTime(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_addUnit")]
  public static extern int UnitDefinition_addUnit(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_createUnit")]
  public static extern IntPtr UnitDefinition_createUnit(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getListOfUnits__SWIG_0")]
  public static extern IntPtr UnitDefinition_getListOfUnits__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getUnit__SWIG_0")]
  public static extern IntPtr UnitDefinition_getUnit__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getNumUnits")]
  public static extern uint UnitDefinition_getNumUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_removeUnit")]
  public static extern IntPtr UnitDefinition_removeUnit(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_connectToChild")]
  public static extern void UnitDefinition_connectToChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_enablePackageInternal")]
  public static extern void UnitDefinition_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getTypeCode")]
  public static extern int UnitDefinition_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getElementName")]
  public static extern string UnitDefinition_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_simplify")]
  public static extern void UnitDefinition_simplify(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_reorder")]
  public static extern void UnitDefinition_reorder(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_convertToSI")]
  public static extern IntPtr UnitDefinition_convertToSI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_areIdentical")]
  public static extern bool UnitDefinition_areIdentical(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_areEquivalent")]
  public static extern bool UnitDefinition_areEquivalent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_combine")]
  public static extern IntPtr UnitDefinition_combine(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_divide")]
  public static extern IntPtr UnitDefinition_divide(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_printUnits__SWIG_0")]
  public static extern string UnitDefinition_printUnits__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_printUnits__SWIG_1")]
  public static extern string UnitDefinition_printUnits__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_hasRequiredAttributes")]
  public static extern bool UnitDefinition_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_hasRequiredElements")]
  public static extern bool UnitDefinition_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfUnitDefinitions__SWIG_0")]
  public static extern IntPtr new_ListOfUnitDefinitions__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfUnitDefinitions__SWIG_1")]
  public static extern IntPtr new_ListOfUnitDefinitions__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_clone")]
  public static extern IntPtr ListOfUnitDefinitions_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_getItemTypeCode")]
  public static extern int ListOfUnitDefinitions_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_getElementName")]
  public static extern string ListOfUnitDefinitions_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_get__SWIG_0")]
  public static extern IntPtr ListOfUnitDefinitions_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_get__SWIG_2")]
  public static extern IntPtr ListOfUnitDefinitions_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_getElementBySId")]
  public static extern IntPtr ListOfUnitDefinitions_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_remove__SWIG_0")]
  public static extern IntPtr ListOfUnitDefinitions_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_remove__SWIG_1")]
  public static extern IntPtr ListOfUnitDefinitions_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfUnitDefinitions")]
  public static extern void delete_ListOfUnitDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_0")]
  public static extern IntPtr new_CompartmentType__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_1")]
  public static extern IntPtr new_CompartmentType__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_CompartmentType")]
  public static extern void delete_CompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_2")]
  public static extern IntPtr new_CompartmentType__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_clone")]
  public static extern IntPtr CompartmentType_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_getId")]
  public static extern string CompartmentType_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_getName")]
  public static extern string CompartmentType_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_isSetId")]
  public static extern bool CompartmentType_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_isSetName")]
  public static extern bool CompartmentType_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_setId")]
  public static extern int CompartmentType_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_setName")]
  public static extern int CompartmentType_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_unsetName")]
  public static extern int CompartmentType_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_getTypeCode")]
  public static extern int CompartmentType_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_getElementName")]
  public static extern string CompartmentType_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_hasRequiredAttributes")]
  public static extern bool CompartmentType_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfCompartmentTypes__SWIG_0")]
  public static extern IntPtr new_ListOfCompartmentTypes__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfCompartmentTypes__SWIG_1")]
  public static extern IntPtr new_ListOfCompartmentTypes__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_clone")]
  public static extern IntPtr ListOfCompartmentTypes_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_getItemTypeCode")]
  public static extern int ListOfCompartmentTypes_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_getElementName")]
  public static extern string ListOfCompartmentTypes_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_get__SWIG_0")]
  public static extern IntPtr ListOfCompartmentTypes_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_get__SWIG_2")]
  public static extern IntPtr ListOfCompartmentTypes_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_remove__SWIG_0")]
  public static extern IntPtr ListOfCompartmentTypes_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_remove__SWIG_1")]
  public static extern IntPtr ListOfCompartmentTypes_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfCompartmentTypes")]
  public static extern void delete_ListOfCompartmentTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_0")]
  public static extern IntPtr new_SpeciesType__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_1")]
  public static extern IntPtr new_SpeciesType__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SpeciesType")]
  public static extern void delete_SpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_2")]
  public static extern IntPtr new_SpeciesType__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_clone")]
  public static extern IntPtr SpeciesType_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_getId")]
  public static extern string SpeciesType_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_getName")]
  public static extern string SpeciesType_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_isSetId")]
  public static extern bool SpeciesType_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_isSetName")]
  public static extern bool SpeciesType_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_setId")]
  public static extern int SpeciesType_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_setName")]
  public static extern int SpeciesType_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_unsetName")]
  public static extern int SpeciesType_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_getTypeCode")]
  public static extern int SpeciesType_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_getElementName")]
  public static extern string SpeciesType_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_hasRequiredAttributes")]
  public static extern bool SpeciesType_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpeciesTypes__SWIG_0")]
  public static extern IntPtr new_ListOfSpeciesTypes__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpeciesTypes__SWIG_1")]
  public static extern IntPtr new_ListOfSpeciesTypes__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_clone")]
  public static extern IntPtr ListOfSpeciesTypes_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_getItemTypeCode")]
  public static extern int ListOfSpeciesTypes_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_getElementName")]
  public static extern string ListOfSpeciesTypes_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_get__SWIG_0")]
  public static extern IntPtr ListOfSpeciesTypes_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_get__SWIG_2")]
  public static extern IntPtr ListOfSpeciesTypes_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_remove__SWIG_0")]
  public static extern IntPtr ListOfSpeciesTypes_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_remove__SWIG_1")]
  public static extern IntPtr ListOfSpeciesTypes_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfSpeciesTypes")]
  public static extern void delete_ListOfSpeciesTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_0")]
  public static extern IntPtr new_Compartment__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_1")]
  public static extern IntPtr new_Compartment__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Compartment")]
  public static extern void delete_Compartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_2")]
  public static extern IntPtr new_Compartment__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_clone")]
  public static extern IntPtr Compartment_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_initDefaults")]
  public static extern void Compartment_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getId")]
  public static extern string Compartment_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getName")]
  public static extern string Compartment_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getCompartmentType")]
  public static extern string Compartment_getCompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getSpatialDimensions")]
  public static extern uint Compartment_getSpatialDimensions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getSpatialDimensionsAsDouble")]
  public static extern double Compartment_getSpatialDimensionsAsDouble(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getSize")]
  public static extern double Compartment_getSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getVolume")]
  public static extern double Compartment_getVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getUnits")]
  public static extern string Compartment_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getOutside")]
  public static extern string Compartment_getOutside(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getConstant")]
  public static extern bool Compartment_getConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetId")]
  public static extern bool Compartment_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetName")]
  public static extern bool Compartment_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetCompartmentType")]
  public static extern bool Compartment_isSetCompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetSize")]
  public static extern bool Compartment_isSetSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetVolume")]
  public static extern bool Compartment_isSetVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetUnits")]
  public static extern bool Compartment_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetOutside")]
  public static extern bool Compartment_isSetOutside(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetSpatialDimensions")]
  public static extern bool Compartment_isSetSpatialDimensions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetConstant")]
  public static extern bool Compartment_isSetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setId")]
  public static extern int Compartment_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setName")]
  public static extern int Compartment_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setCompartmentType")]
  public static extern int Compartment_setCompartmentType(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setSpatialDimensions__SWIG_0")]
  public static extern int Compartment_setSpatialDimensions__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setSpatialDimensions__SWIG_1")]
  public static extern int Compartment_setSpatialDimensions__SWIG_1(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setSize")]
  public static extern int Compartment_setSize(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setVolume")]
  public static extern int Compartment_setVolume(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setUnits")]
  public static extern int Compartment_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setOutside")]
  public static extern int Compartment_setOutside(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setConstant")]
  public static extern int Compartment_setConstant(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_renameSIdRefs")]
  public static extern void Compartment_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_renameUnitSIdRefs")]
  public static extern void Compartment_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetName")]
  public static extern int Compartment_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetCompartmentType")]
  public static extern int Compartment_unsetCompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetConstant")]
  public static extern int Compartment_unsetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetSize")]
  public static extern int Compartment_unsetSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetVolume")]
  public static extern int Compartment_unsetVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetUnits")]
  public static extern int Compartment_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetOutside")]
  public static extern int Compartment_unsetOutside(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetSpatialDimensions")]
  public static extern int Compartment_unsetSpatialDimensions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr Compartment_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getTypeCode")]
  public static extern int Compartment_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getElementName")]
  public static extern string Compartment_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_hasRequiredAttributes")]
  public static extern bool Compartment_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfCompartments__SWIG_0")]
  public static extern IntPtr new_ListOfCompartments__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfCompartments__SWIG_1")]
  public static extern IntPtr new_ListOfCompartments__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_clone")]
  public static extern IntPtr ListOfCompartments_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_getItemTypeCode")]
  public static extern int ListOfCompartments_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_getElementName")]
  public static extern string ListOfCompartments_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_get__SWIG_0")]
  public static extern IntPtr ListOfCompartments_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_get__SWIG_2")]
  public static extern IntPtr ListOfCompartments_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_remove__SWIG_0")]
  public static extern IntPtr ListOfCompartments_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_remove__SWIG_1")]
  public static extern IntPtr ListOfCompartments_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfCompartments")]
  public static extern void delete_ListOfCompartments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_0")]
  public static extern IntPtr new_Species__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_1")]
  public static extern IntPtr new_Species__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Species")]
  public static extern void delete_Species(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_2")]
  public static extern IntPtr new_Species__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_clone")]
  public static extern IntPtr Species_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_initDefaults")]
  public static extern void Species_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getId")]
  public static extern string Species_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getName")]
  public static extern string Species_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getSpeciesType")]
  public static extern string Species_getSpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getCompartment")]
  public static extern string Species_getCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getInitialAmount")]
  public static extern double Species_getInitialAmount(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getInitialConcentration")]
  public static extern double Species_getInitialConcentration(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getSubstanceUnits")]
  public static extern string Species_getSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getSpatialSizeUnits")]
  public static extern string Species_getSpatialSizeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getUnits")]
  public static extern string Species_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getHasOnlySubstanceUnits")]
  public static extern bool Species_getHasOnlySubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getBoundaryCondition")]
  public static extern bool Species_getBoundaryCondition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getCharge")]
  public static extern int Species_getCharge(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getConstant")]
  public static extern bool Species_getConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getConversionFactor")]
  public static extern string Species_getConversionFactor(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetId")]
  public static extern bool Species_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetName")]
  public static extern bool Species_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetSpeciesType")]
  public static extern bool Species_isSetSpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetCompartment")]
  public static extern bool Species_isSetCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetInitialAmount")]
  public static extern bool Species_isSetInitialAmount(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetInitialConcentration")]
  public static extern bool Species_isSetInitialConcentration(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetSubstanceUnits")]
  public static extern bool Species_isSetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetSpatialSizeUnits")]
  public static extern bool Species_isSetSpatialSizeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetUnits")]
  public static extern bool Species_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetCharge")]
  public static extern bool Species_isSetCharge(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetConversionFactor")]
  public static extern bool Species_isSetConversionFactor(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetBoundaryCondition")]
  public static extern bool Species_isSetBoundaryCondition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetHasOnlySubstanceUnits")]
  public static extern bool Species_isSetHasOnlySubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetConstant")]
  public static extern bool Species_isSetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setId")]
  public static extern int Species_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setName")]
  public static extern int Species_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setSpeciesType")]
  public static extern int Species_setSpeciesType(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setCompartment")]
  public static extern int Species_setCompartment(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setInitialAmount")]
  public static extern int Species_setInitialAmount(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setInitialConcentration")]
  public static extern int Species_setInitialConcentration(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setSubstanceUnits")]
  public static extern int Species_setSubstanceUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setSpatialSizeUnits")]
  public static extern int Species_setSpatialSizeUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setUnits")]
  public static extern int Species_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setHasOnlySubstanceUnits")]
  public static extern int Species_setHasOnlySubstanceUnits(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setBoundaryCondition")]
  public static extern int Species_setBoundaryCondition(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setCharge")]
  public static extern int Species_setCharge(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setConstant")]
  public static extern int Species_setConstant(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setConversionFactor")]
  public static extern int Species_setConversionFactor(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetName")]
  public static extern int Species_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetConstant")]
  public static extern int Species_unsetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetSpeciesType")]
  public static extern int Species_unsetSpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetInitialAmount")]
  public static extern int Species_unsetInitialAmount(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetInitialConcentration")]
  public static extern int Species_unsetInitialConcentration(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetSubstanceUnits")]
  public static extern int Species_unsetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetSpatialSizeUnits")]
  public static extern int Species_unsetSpatialSizeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetUnits")]
  public static extern int Species_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetCharge")]
  public static extern int Species_unsetCharge(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetConversionFactor")]
  public static extern int Species_unsetConversionFactor(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetCompartment")]
  public static extern int Species_unsetCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetBoundaryCondition")]
  public static extern int Species_unsetBoundaryCondition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetHasOnlySubstanceUnits")]
  public static extern int Species_unsetHasOnlySubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr Species_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getTypeCode")]
  public static extern int Species_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getElementName")]
  public static extern string Species_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_hasRequiredAttributes")]
  public static extern bool Species_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_renameSIdRefs")]
  public static extern void Species_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_renameUnitSIdRefs")]
  public static extern void Species_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpecies__SWIG_0")]
  public static extern IntPtr new_ListOfSpecies__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpecies__SWIG_1")]
  public static extern IntPtr new_ListOfSpecies__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_clone")]
  public static extern IntPtr ListOfSpecies_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_getItemTypeCode")]
  public static extern int ListOfSpecies_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_getElementName")]
  public static extern string ListOfSpecies_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_get__SWIG_0")]
  public static extern IntPtr ListOfSpecies_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_get__SWIG_2")]
  public static extern IntPtr ListOfSpecies_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_remove__SWIG_0")]
  public static extern IntPtr ListOfSpecies_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_remove__SWIG_1")]
  public static extern IntPtr ListOfSpecies_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfSpecies")]
  public static extern void delete_ListOfSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_0")]
  public static extern IntPtr new_Parameter__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_1")]
  public static extern IntPtr new_Parameter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Parameter")]
  public static extern void delete_Parameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_2")]
  public static extern IntPtr new_Parameter__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_clone")]
  public static extern IntPtr Parameter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_initDefaults")]
  public static extern void Parameter_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getId")]
  public static extern string Parameter_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getName")]
  public static extern string Parameter_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getValue")]
  public static extern double Parameter_getValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getUnits")]
  public static extern string Parameter_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getConstant")]
  public static extern bool Parameter_getConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_isSetId")]
  public static extern bool Parameter_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_isSetName")]
  public static extern bool Parameter_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_isSetValue")]
  public static extern bool Parameter_isSetValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_isSetUnits")]
  public static extern bool Parameter_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_isSetConstant")]
  public static extern bool Parameter_isSetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setId")]
  public static extern int Parameter_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setName")]
  public static extern int Parameter_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setValue")]
  public static extern int Parameter_setValue(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setUnits")]
  public static extern int Parameter_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setConstant")]
  public static extern int Parameter_setConstant(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_unsetName")]
  public static extern int Parameter_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_unsetConstant")]
  public static extern int Parameter_unsetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_unsetValue")]
  public static extern int Parameter_unsetValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_unsetUnits")]
  public static extern int Parameter_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr Parameter_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getTypeCode")]
  public static extern int Parameter_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getElementName")]
  public static extern string Parameter_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_hasRequiredAttributes")]
  public static extern bool Parameter_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_renameUnitSIdRefs")]
  public static extern void Parameter_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setCalculatingUnits")]
  public static extern void Parameter_setCalculatingUnits(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfParameters__SWIG_0")]
  public static extern IntPtr new_ListOfParameters__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfParameters__SWIG_1")]
  public static extern IntPtr new_ListOfParameters__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_clone")]
  public static extern IntPtr ListOfParameters_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_getItemTypeCode")]
  public static extern int ListOfParameters_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_getElementName")]
  public static extern string ListOfParameters_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_get__SWIG_0")]
  public static extern IntPtr ListOfParameters_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_get__SWIG_2")]
  public static extern IntPtr ListOfParameters_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_remove__SWIG_0")]
  public static extern IntPtr ListOfParameters_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_remove__SWIG_1")]
  public static extern IntPtr ListOfParameters_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfParameters")]
  public static extern void delete_ListOfParameters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_LocalParameter__SWIG_0")]
  public static extern IntPtr new_LocalParameter__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_LocalParameter__SWIG_1")]
  public static extern IntPtr new_LocalParameter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_LocalParameter")]
  public static extern void delete_LocalParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_LocalParameter__SWIG_2")]
  public static extern IntPtr new_LocalParameter__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_LocalParameter__SWIG_3")]
  public static extern IntPtr new_LocalParameter__SWIG_3(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_clone")]
  public static extern IntPtr LocalParameter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr LocalParameter_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_getTypeCode")]
  public static extern int LocalParameter_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_getElementName")]
  public static extern string LocalParameter_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_hasRequiredAttributes")]
  public static extern bool LocalParameter_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_getConstant")]
  public static extern bool LocalParameter_getConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_isSetConstant")]
  public static extern bool LocalParameter_isSetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_setConstant")]
  public static extern int LocalParameter_setConstant(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_unsetConstant")]
  public static extern int LocalParameter_unsetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfLocalParameters__SWIG_0")]
  public static extern IntPtr new_ListOfLocalParameters__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfLocalParameters__SWIG_1")]
  public static extern IntPtr new_ListOfLocalParameters__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_clone")]
  public static extern IntPtr ListOfLocalParameters_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_getItemTypeCode")]
  public static extern int ListOfLocalParameters_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_getElementName")]
  public static extern string ListOfLocalParameters_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_get__SWIG_0")]
  public static extern IntPtr ListOfLocalParameters_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_get__SWIG_2")]
  public static extern IntPtr ListOfLocalParameters_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_getElementBySId")]
  public static extern IntPtr ListOfLocalParameters_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_remove__SWIG_0")]
  public static extern IntPtr ListOfLocalParameters_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_remove__SWIG_1")]
  public static extern IntPtr ListOfLocalParameters_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfLocalParameters")]
  public static extern void delete_ListOfLocalParameters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_InitialAssignment__SWIG_0")]
  public static extern IntPtr new_InitialAssignment__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_InitialAssignment__SWIG_1")]
  public static extern IntPtr new_InitialAssignment__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_InitialAssignment")]
  public static extern void delete_InitialAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_InitialAssignment__SWIG_2")]
  public static extern IntPtr new_InitialAssignment__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_clone")]
  public static extern IntPtr InitialAssignment_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getSymbol")]
  public static extern string InitialAssignment_getSymbol(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getMath")]
  public static extern IntPtr InitialAssignment_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_isSetSymbol")]
  public static extern bool InitialAssignment_isSetSymbol(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_isSetMath")]
  public static extern bool InitialAssignment_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_setSymbol")]
  public static extern int InitialAssignment_setSymbol(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_unsetSymbol")]
  public static extern int InitialAssignment_unsetSymbol(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_setMath")]
  public static extern int InitialAssignment_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr InitialAssignment_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_containsUndeclaredUnits__SWIG_0")]
  public static extern bool InitialAssignment_containsUndeclaredUnits__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getTypeCode")]
  public static extern int InitialAssignment_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getElementName")]
  public static extern string InitialAssignment_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_hasRequiredAttributes")]
  public static extern bool InitialAssignment_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_hasRequiredElements")]
  public static extern bool InitialAssignment_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getId")]
  public static extern string InitialAssignment_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_renameSIdRefs")]
  public static extern void InitialAssignment_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_renameUnitSIdRefs")]
  public static extern void InitialAssignment_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_replaceSIDWithFunction")]
  public static extern void InitialAssignment_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_divideAssignmentsToSIdByFunction")]
  public static extern void InitialAssignment_divideAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_multiplyAssignmentsToSIdByFunction")]
  public static extern void InitialAssignment_multiplyAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfInitialAssignments__SWIG_0")]
  public static extern IntPtr new_ListOfInitialAssignments__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfInitialAssignments__SWIG_1")]
  public static extern IntPtr new_ListOfInitialAssignments__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_clone")]
  public static extern IntPtr ListOfInitialAssignments_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_getItemTypeCode")]
  public static extern int ListOfInitialAssignments_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_getElementName")]
  public static extern string ListOfInitialAssignments_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_get__SWIG_0")]
  public static extern IntPtr ListOfInitialAssignments_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_get__SWIG_2")]
  public static extern IntPtr ListOfInitialAssignments_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_remove__SWIG_0")]
  public static extern IntPtr ListOfInitialAssignments_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_remove__SWIG_1")]
  public static extern IntPtr ListOfInitialAssignments_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_getElementBySId")]
  public static extern IntPtr ListOfInitialAssignments_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfInitialAssignments")]
  public static extern void delete_ListOfInitialAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Rule")]
  public static extern void delete_Rule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Rule")]
  public static extern IntPtr new_Rule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_clone")]
  public static extern IntPtr Rule_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getFormula")]
  public static extern string Rule_getFormula(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getMath")]
  public static extern IntPtr Rule_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getVariable")]
  public static extern string Rule_getVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getUnits")]
  public static extern string Rule_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSetFormula")]
  public static extern bool Rule_isSetFormula(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSetMath")]
  public static extern bool Rule_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSetVariable")]
  public static extern bool Rule_isSetVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSetUnits")]
  public static extern bool Rule_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setFormula")]
  public static extern int Rule_setFormula(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setMath")]
  public static extern int Rule_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setVariable")]
  public static extern int Rule_setVariable(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setUnits")]
  public static extern int Rule_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_unsetVariable")]
  public static extern int Rule_unsetVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_unsetUnits")]
  public static extern int Rule_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr Rule_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_containsUndeclaredUnits__SWIG_0")]
  public static extern bool Rule_containsUndeclaredUnits__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getType")]
  public static extern int Rule_getType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isAlgebraic")]
  public static extern bool Rule_isAlgebraic(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isAssignment")]
  public static extern bool Rule_isAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isCompartmentVolume")]
  public static extern bool Rule_isCompartmentVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isParameter")]
  public static extern bool Rule_isParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isRate")]
  public static extern bool Rule_isRate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isScalar")]
  public static extern bool Rule_isScalar(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSpeciesConcentration")]
  public static extern bool Rule_isSpeciesConcentration(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getTypeCode")]
  public static extern int Rule_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getL1TypeCode")]
  public static extern int Rule_getL1TypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getElementName")]
  public static extern string Rule_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setL1TypeCode")]
  public static extern int Rule_setL1TypeCode(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_hasRequiredElements")]
  public static extern bool Rule_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_hasRequiredAttributes")]
  public static extern bool Rule_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_renameSIdRefs")]
  public static extern void Rule_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_renameUnitSIdRefs")]
  public static extern void Rule_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getId")]
  public static extern string Rule_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_replaceSIDWithFunction")]
  public static extern void Rule_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_divideAssignmentsToSIdByFunction")]
  public static extern void Rule_divideAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_multiplyAssignmentsToSIdByFunction")]
  public static extern void Rule_multiplyAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfRules__SWIG_0")]
  public static extern IntPtr new_ListOfRules__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfRules__SWIG_1")]
  public static extern IntPtr new_ListOfRules__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_clone")]
  public static extern IntPtr ListOfRules_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_getItemTypeCode")]
  public static extern int ListOfRules_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_getElementName")]
  public static extern string ListOfRules_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_get__SWIG_0")]
  public static extern IntPtr ListOfRules_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_get__SWIG_2")]
  public static extern IntPtr ListOfRules_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_remove__SWIG_0")]
  public static extern IntPtr ListOfRules_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_getElementBySId")]
  public static extern IntPtr ListOfRules_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_remove__SWIG_1")]
  public static extern IntPtr ListOfRules_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfRules")]
  public static extern void delete_ListOfRules(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AlgebraicRule__SWIG_0")]
  public static extern IntPtr new_AlgebraicRule__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AlgebraicRule__SWIG_1")]
  public static extern IntPtr new_AlgebraicRule__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_AlgebraicRule")]
  public static extern void delete_AlgebraicRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AlgebraicRule_clone")]
  public static extern IntPtr AlgebraicRule_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AlgebraicRule_hasRequiredAttributes")]
  public static extern bool AlgebraicRule_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AssignmentRule__SWIG_0")]
  public static extern IntPtr new_AssignmentRule__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AssignmentRule__SWIG_1")]
  public static extern IntPtr new_AssignmentRule__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_AssignmentRule")]
  public static extern void delete_AssignmentRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AssignmentRule_clone")]
  public static extern IntPtr AssignmentRule_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AssignmentRule_hasRequiredAttributes")]
  public static extern bool AssignmentRule_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AssignmentRule_renameSIdRefs")]
  public static extern void AssignmentRule_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RateRule__SWIG_0")]
  public static extern IntPtr new_RateRule__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RateRule__SWIG_1")]
  public static extern IntPtr new_RateRule__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_RateRule")]
  public static extern void delete_RateRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RateRule_clone")]
  public static extern IntPtr RateRule_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RateRule_hasRequiredAttributes")]
  public static extern bool RateRule_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RateRule_renameSIdRefs")]
  public static extern void RateRule_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Constraint__SWIG_0")]
  public static extern IntPtr new_Constraint__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Constraint__SWIG_1")]
  public static extern IntPtr new_Constraint__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Constraint")]
  public static extern void delete_Constraint(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Constraint__SWIG_2")]
  public static extern IntPtr new_Constraint__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_clone")]
  public static extern IntPtr Constraint_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getMessage")]
  public static extern IntPtr Constraint_getMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getMessageString")]
  public static extern string Constraint_getMessageString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getMath")]
  public static extern IntPtr Constraint_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_isSetMessage")]
  public static extern bool Constraint_isSetMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_isSetMath")]
  public static extern bool Constraint_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_setMessage__SWIG_0")]
  public static extern int Constraint_setMessage__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_setMessage__SWIG_1")]
  public static extern int Constraint_setMessage__SWIG_1(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_setMessage__SWIG_2")]
  public static extern int Constraint_setMessage__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_setMath")]
  public static extern int Constraint_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_unsetMessage")]
  public static extern int Constraint_unsetMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_renameSIdRefs")]
  public static extern void Constraint_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_renameUnitSIdRefs")]
  public static extern void Constraint_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_replaceSIDWithFunction")]
  public static extern void Constraint_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getTypeCode")]
  public static extern int Constraint_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getElementName")]
  public static extern string Constraint_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_hasRequiredElements")]
  public static extern bool Constraint_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfConstraints__SWIG_0")]
  public static extern IntPtr new_ListOfConstraints__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfConstraints__SWIG_1")]
  public static extern IntPtr new_ListOfConstraints__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_clone")]
  public static extern IntPtr ListOfConstraints_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_getItemTypeCode")]
  public static extern int ListOfConstraints_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_getElementName")]
  public static extern string ListOfConstraints_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_get__SWIG_0")]
  public static extern IntPtr ListOfConstraints_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_remove")]
  public static extern IntPtr ListOfConstraints_remove(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfConstraints")]
  public static extern void delete_ListOfConstraints(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_0")]
  public static extern IntPtr new_Reaction__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_1")]
  public static extern IntPtr new_Reaction__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Reaction")]
  public static extern void delete_Reaction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_2")]
  public static extern IntPtr new_Reaction__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_clone")]
  public static extern IntPtr Reaction_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getElementBySId")]
  public static extern IntPtr Reaction_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getElementByMetaId")]
  public static extern IntPtr Reaction_getElementByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_renameSIdRefs")]
  public static extern void Reaction_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_initDefaults")]
  public static extern void Reaction_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getId")]
  public static extern string Reaction_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getName")]
  public static extern string Reaction_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getKineticLaw__SWIG_0")]
  public static extern IntPtr Reaction_getKineticLaw__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getReversible")]
  public static extern bool Reaction_getReversible(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getFast")]
  public static extern bool Reaction_getFast(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getCompartment")]
  public static extern string Reaction_getCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_isSetId")]
  public static extern bool Reaction_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_isSetName")]
  public static extern bool Reaction_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_isSetKineticLaw")]
  public static extern bool Reaction_isSetKineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_isSetFast")]
  public static extern bool Reaction_isSetFast(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_isSetCompartment")]
  public static extern bool Reaction_isSetCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_isSetReversible")]
  public static extern bool Reaction_isSetReversible(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setId")]
  public static extern int Reaction_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setName")]
  public static extern int Reaction_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setKineticLaw")]
  public static extern int Reaction_setKineticLaw(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setReversible")]
  public static extern int Reaction_setReversible(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setFast")]
  public static extern int Reaction_setFast(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setCompartment")]
  public static extern int Reaction_setCompartment(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_unsetName")]
  public static extern int Reaction_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_unsetKineticLaw")]
  public static extern int Reaction_unsetKineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_unsetFast")]
  public static extern int Reaction_unsetFast(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_unsetCompartment")]
  public static extern int Reaction_unsetCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_unsetReversible")]
  public static extern int Reaction_unsetReversible(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addReactant__SWIG_0")]
  public static extern int Reaction_addReactant__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addReactant__SWIG_1")]
  public static extern int Reaction_addReactant__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3, string jarg4, bool jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addReactant__SWIG_2")]
  public static extern int Reaction_addReactant__SWIG_2(HandleRef jarg1, HandleRef jarg2, double jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addReactant__SWIG_3")]
  public static extern int Reaction_addReactant__SWIG_3(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addReactant__SWIG_4")]
  public static extern int Reaction_addReactant__SWIG_4(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addProduct__SWIG_0")]
  public static extern int Reaction_addProduct__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addProduct__SWIG_1")]
  public static extern int Reaction_addProduct__SWIG_1(HandleRef jarg1, HandleRef jarg2, double jarg3, string jarg4, bool jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addProduct__SWIG_2")]
  public static extern int Reaction_addProduct__SWIG_2(HandleRef jarg1, HandleRef jarg2, double jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addProduct__SWIG_3")]
  public static extern int Reaction_addProduct__SWIG_3(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addProduct__SWIG_4")]
  public static extern int Reaction_addProduct__SWIG_4(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addModifier__SWIG_0")]
  public static extern int Reaction_addModifier__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addModifier__SWIG_1")]
  public static extern int Reaction_addModifier__SWIG_1(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addModifier__SWIG_2")]
  public static extern int Reaction_addModifier__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_createReactant")]
  public static extern IntPtr Reaction_createReactant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_createProduct")]
  public static extern IntPtr Reaction_createProduct(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_createModifier")]
  public static extern IntPtr Reaction_createModifier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_createKineticLaw")]
  public static extern IntPtr Reaction_createKineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getListOfReactants__SWIG_0")]
  public static extern IntPtr Reaction_getListOfReactants__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getListOfProducts__SWIG_0")]
  public static extern IntPtr Reaction_getListOfProducts__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getListOfModifiers__SWIG_0")]
  public static extern IntPtr Reaction_getListOfModifiers__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getReactant__SWIG_0")]
  public static extern IntPtr Reaction_getReactant__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getReactant__SWIG_2")]
  public static extern IntPtr Reaction_getReactant__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getProduct__SWIG_0")]
  public static extern IntPtr Reaction_getProduct__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getProduct__SWIG_2")]
  public static extern IntPtr Reaction_getProduct__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getModifier__SWIG_0")]
  public static extern IntPtr Reaction_getModifier__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getModifier__SWIG_2")]
  public static extern IntPtr Reaction_getModifier__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getNumReactants")]
  public static extern uint Reaction_getNumReactants(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getNumProducts")]
  public static extern uint Reaction_getNumProducts(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getNumModifiers")]
  public static extern uint Reaction_getNumModifiers(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_removeReactant__SWIG_0")]
  public static extern IntPtr Reaction_removeReactant__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_removeReactant__SWIG_1")]
  public static extern IntPtr Reaction_removeReactant__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_removeProduct__SWIG_0")]
  public static extern IntPtr Reaction_removeProduct__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_removeProduct__SWIG_1")]
  public static extern IntPtr Reaction_removeProduct__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_removeModifier__SWIG_0")]
  public static extern IntPtr Reaction_removeModifier__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_removeModifier__SWIG_1")]
  public static extern IntPtr Reaction_removeModifier__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_connectToChild")]
  public static extern void Reaction_connectToChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_enablePackageInternal")]
  public static extern void Reaction_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getTypeCode")]
  public static extern int Reaction_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getElementName")]
  public static extern string Reaction_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_hasRequiredAttributes")]
  public static extern bool Reaction_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfReactions__SWIG_0")]
  public static extern IntPtr new_ListOfReactions__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfReactions__SWIG_1")]
  public static extern IntPtr new_ListOfReactions__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_clone")]
  public static extern IntPtr ListOfReactions_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_getItemTypeCode")]
  public static extern int ListOfReactions_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_getElementName")]
  public static extern string ListOfReactions_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_get__SWIG_0")]
  public static extern IntPtr ListOfReactions_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_get__SWIG_2")]
  public static extern IntPtr ListOfReactions_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_remove__SWIG_0")]
  public static extern IntPtr ListOfReactions_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_remove__SWIG_1")]
  public static extern IntPtr ListOfReactions_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfReactions")]
  public static extern void delete_ListOfReactions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_0")]
  public static extern IntPtr new_KineticLaw__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_1")]
  public static extern IntPtr new_KineticLaw__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_KineticLaw")]
  public static extern void delete_KineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_2")]
  public static extern IntPtr new_KineticLaw__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_clone")]
  public static extern IntPtr KineticLaw_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getElementBySId")]
  public static extern IntPtr KineticLaw_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getElementByMetaId")]
  public static extern IntPtr KineticLaw_getElementByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getFormula")]
  public static extern string KineticLaw_getFormula(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getMath")]
  public static extern IntPtr KineticLaw_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getTimeUnits")]
  public static extern string KineticLaw_getTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getSubstanceUnits")]
  public static extern string KineticLaw_getSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_isSetFormula")]
  public static extern bool KineticLaw_isSetFormula(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_isSetMath")]
  public static extern bool KineticLaw_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_isSetTimeUnits")]
  public static extern bool KineticLaw_isSetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_isSetSubstanceUnits")]
  public static extern bool KineticLaw_isSetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setFormula")]
  public static extern int KineticLaw_setFormula(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setMath")]
  public static extern int KineticLaw_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setTimeUnits")]
  public static extern int KineticLaw_setTimeUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setSubstanceUnits")]
  public static extern int KineticLaw_setSubstanceUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_unsetTimeUnits")]
  public static extern int KineticLaw_unsetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_unsetSubstanceUnits")]
  public static extern int KineticLaw_unsetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_addParameter")]
  public static extern int KineticLaw_addParameter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_addLocalParameter")]
  public static extern int KineticLaw_addLocalParameter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_createParameter")]
  public static extern IntPtr KineticLaw_createParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_createLocalParameter")]
  public static extern IntPtr KineticLaw_createLocalParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getListOfParameters__SWIG_0")]
  public static extern IntPtr KineticLaw_getListOfParameters__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getListOfLocalParameters__SWIG_0")]
  public static extern IntPtr KineticLaw_getListOfLocalParameters__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getParameter__SWIG_0")]
  public static extern IntPtr KineticLaw_getParameter__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getLocalParameter__SWIG_0")]
  public static extern IntPtr KineticLaw_getLocalParameter__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getParameter__SWIG_2")]
  public static extern IntPtr KineticLaw_getParameter__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getLocalParameter__SWIG_2")]
  public static extern IntPtr KineticLaw_getLocalParameter__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getNumParameters")]
  public static extern uint KineticLaw_getNumParameters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getNumLocalParameters")]
  public static extern uint KineticLaw_getNumLocalParameters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr KineticLaw_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_containsUndeclaredUnits__SWIG_0")]
  public static extern bool KineticLaw_containsUndeclaredUnits__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_removeParameter__SWIG_0")]
  public static extern IntPtr KineticLaw_removeParameter__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_removeLocalParameter__SWIG_0")]
  public static extern IntPtr KineticLaw_removeLocalParameter__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_removeParameter__SWIG_1")]
  public static extern IntPtr KineticLaw_removeParameter__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_removeLocalParameter__SWIG_1")]
  public static extern IntPtr KineticLaw_removeLocalParameter__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_connectToChild")]
  public static extern void KineticLaw_connectToChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_enablePackageInternal")]
  public static extern void KineticLaw_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getTypeCode")]
  public static extern int KineticLaw_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getElementName")]
  public static extern string KineticLaw_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_hasRequiredAttributes")]
  public static extern bool KineticLaw_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_hasRequiredElements")]
  public static extern bool KineticLaw_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_removeFromParentAndDelete")]
  public static extern int KineticLaw_removeFromParentAndDelete(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_renameSIdRefs")]
  public static extern void KineticLaw_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_renameUnitSIdRefs")]
  public static extern void KineticLaw_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_replaceSIDWithFunction")]
  public static extern void KineticLaw_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_divideAssignmentsToSIdByFunction")]
  public static extern void KineticLaw_divideAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_multiplyAssignmentsToSIdByFunction")]
  public static extern void KineticLaw_multiplyAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SimpleSpeciesReference")]
  public static extern void delete_SimpleSpeciesReference(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_getId")]
  public static extern string SimpleSpeciesReference_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_getName")]
  public static extern string SimpleSpeciesReference_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_getSpecies")]
  public static extern string SimpleSpeciesReference_getSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_isSetId")]
  public static extern bool SimpleSpeciesReference_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_isSetName")]
  public static extern bool SimpleSpeciesReference_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_isSetSpecies")]
  public static extern bool SimpleSpeciesReference_isSetSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_setSpecies")]
  public static extern int SimpleSpeciesReference_setSpecies(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_setId")]
  public static extern int SimpleSpeciesReference_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_setName")]
  public static extern int SimpleSpeciesReference_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_unsetId")]
  public static extern int SimpleSpeciesReference_unsetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_unsetName")]
  public static extern int SimpleSpeciesReference_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_unsetSpecies")]
  public static extern int SimpleSpeciesReference_unsetSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_isModifier")]
  public static extern bool SimpleSpeciesReference_isModifier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_renameSIdRefs")]
  public static extern void SimpleSpeciesReference_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_0")]
  public static extern IntPtr new_SpeciesReference__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_1")]
  public static extern IntPtr new_SpeciesReference__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SpeciesReference")]
  public static extern void delete_SpeciesReference(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_2")]
  public static extern IntPtr new_SpeciesReference__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_clone")]
  public static extern IntPtr SpeciesReference_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_initDefaults")]
  public static extern void SpeciesReference_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getStoichiometry")]
  public static extern double SpeciesReference_getStoichiometry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getStoichiometryMath__SWIG_0")]
  public static extern IntPtr SpeciesReference_getStoichiometryMath__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getDenominator")]
  public static extern int SpeciesReference_getDenominator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getConstant")]
  public static extern bool SpeciesReference_getConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_isSetStoichiometryMath")]
  public static extern bool SpeciesReference_isSetStoichiometryMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_isSetConstant")]
  public static extern bool SpeciesReference_isSetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_isSetStoichiometry")]
  public static extern bool SpeciesReference_isSetStoichiometry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setStoichiometry")]
  public static extern int SpeciesReference_setStoichiometry(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setStoichiometryMath")]
  public static extern int SpeciesReference_setStoichiometryMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setDenominator")]
  public static extern int SpeciesReference_setDenominator(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setConstant")]
  public static extern int SpeciesReference_setConstant(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_unsetStoichiometryMath")]
  public static extern int SpeciesReference_unsetStoichiometryMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_unsetStoichiometry")]
  public static extern int SpeciesReference_unsetStoichiometry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_unsetConstant")]
  public static extern int SpeciesReference_unsetConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_createStoichiometryMath")]
  public static extern IntPtr SpeciesReference_createStoichiometryMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setAnnotation__SWIG_0")]
  public static extern int SpeciesReference_setAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setAnnotation__SWIG_1")]
  public static extern int SpeciesReference_setAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_appendAnnotation__SWIG_0")]
  public static extern int SpeciesReference_appendAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_appendAnnotation__SWIG_1")]
  public static extern int SpeciesReference_appendAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getTypeCode")]
  public static extern int SpeciesReference_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getElementName")]
  public static extern string SpeciesReference_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_hasRequiredAttributes")]
  public static extern bool SpeciesReference_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpeciesReferences__SWIG_0")]
  public static extern IntPtr new_ListOfSpeciesReferences__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpeciesReferences__SWIG_1")]
  public static extern IntPtr new_ListOfSpeciesReferences__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_clone")]
  public static extern IntPtr ListOfSpeciesReferences_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_getItemTypeCode")]
  public static extern int ListOfSpeciesReferences_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_getElementName")]
  public static extern string ListOfSpeciesReferences_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_get__SWIG_0")]
  public static extern IntPtr ListOfSpeciesReferences_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_get__SWIG_2")]
  public static extern IntPtr ListOfSpeciesReferences_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_remove__SWIG_0")]
  public static extern IntPtr ListOfSpeciesReferences_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_remove__SWIG_1")]
  public static extern IntPtr ListOfSpeciesReferences_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfSpeciesReferences")]
  public static extern void delete_ListOfSpeciesReferences(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModifierSpeciesReference__SWIG_0")]
  public static extern IntPtr new_ModifierSpeciesReference__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModifierSpeciesReference__SWIG_1")]
  public static extern IntPtr new_ModifierSpeciesReference__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ModifierSpeciesReference")]
  public static extern void delete_ModifierSpeciesReference(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReference_clone")]
  public static extern IntPtr ModifierSpeciesReference_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReference_getTypeCode")]
  public static extern int ModifierSpeciesReference_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReference_getElementName")]
  public static extern string ModifierSpeciesReference_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReference_hasRequiredAttributes")]
  public static extern bool ModifierSpeciesReference_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_0")]
  public static extern IntPtr new_Event__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_1")]
  public static extern IntPtr new_Event__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Event")]
  public static extern void delete_Event(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_2")]
  public static extern IntPtr new_Event__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_clone")]
  public static extern IntPtr Event_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_initDefaults")]
  public static extern void Event_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getElementBySId")]
  public static extern IntPtr Event_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getElementByMetaId")]
  public static extern IntPtr Event_getElementByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getId")]
  public static extern string Event_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getName")]
  public static extern string Event_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getTrigger__SWIG_0")]
  public static extern IntPtr Event_getTrigger__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getDelay__SWIG_0")]
  public static extern IntPtr Event_getDelay__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getPriority__SWIG_0")]
  public static extern IntPtr Event_getPriority__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getTimeUnits")]
  public static extern string Event_getTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getUseValuesFromTriggerTime")]
  public static extern bool Event_getUseValuesFromTriggerTime(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetId")]
  public static extern bool Event_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetName")]
  public static extern bool Event_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetTrigger")]
  public static extern bool Event_isSetTrigger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetDelay")]
  public static extern bool Event_isSetDelay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetPriority")]
  public static extern bool Event_isSetPriority(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetTimeUnits")]
  public static extern bool Event_isSetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetUseValuesFromTriggerTime")]
  public static extern bool Event_isSetUseValuesFromTriggerTime(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setId")]
  public static extern int Event_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setName")]
  public static extern int Event_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setTrigger")]
  public static extern int Event_setTrigger(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setDelay")]
  public static extern int Event_setDelay(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setPriority")]
  public static extern int Event_setPriority(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setTimeUnits")]
  public static extern int Event_setTimeUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setUseValuesFromTriggerTime")]
  public static extern int Event_setUseValuesFromTriggerTime(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetId")]
  public static extern int Event_unsetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetName")]
  public static extern int Event_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetUseValuesFromTriggerTime")]
  public static extern int Event_unsetUseValuesFromTriggerTime(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetDelay")]
  public static extern int Event_unsetDelay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetPriority")]
  public static extern int Event_unsetPriority(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetTrigger")]
  public static extern int Event_unsetTrigger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetTimeUnits")]
  public static extern int Event_unsetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_addEventAssignment")]
  public static extern int Event_addEventAssignment(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_createEventAssignment")]
  public static extern IntPtr Event_createEventAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_createTrigger")]
  public static extern IntPtr Event_createTrigger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_createDelay")]
  public static extern IntPtr Event_createDelay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_createPriority")]
  public static extern IntPtr Event_createPriority(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getListOfEventAssignments__SWIG_0")]
  public static extern IntPtr Event_getListOfEventAssignments__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getEventAssignment__SWIG_0")]
  public static extern IntPtr Event_getEventAssignment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getEventAssignment__SWIG_2")]
  public static extern IntPtr Event_getEventAssignment__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getNumEventAssignments")]
  public static extern uint Event_getNumEventAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_removeEventAssignment__SWIG_0")]
  public static extern IntPtr Event_removeEventAssignment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_removeEventAssignment__SWIG_1")]
  public static extern IntPtr Event_removeEventAssignment__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_connectToChild")]
  public static extern void Event_connectToChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_enablePackageInternal")]
  public static extern void Event_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getTypeCode")]
  public static extern int Event_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getElementName")]
  public static extern string Event_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_hasRequiredAttributes")]
  public static extern bool Event_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_hasRequiredElements")]
  public static extern bool Event_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfEvents__SWIG_0")]
  public static extern IntPtr new_ListOfEvents__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfEvents__SWIG_1")]
  public static extern IntPtr new_ListOfEvents__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_clone")]
  public static extern IntPtr ListOfEvents_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_getItemTypeCode")]
  public static extern int ListOfEvents_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_getElementName")]
  public static extern string ListOfEvents_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_get__SWIG_0")]
  public static extern IntPtr ListOfEvents_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_get__SWIG_2")]
  public static extern IntPtr ListOfEvents_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_remove__SWIG_0")]
  public static extern IntPtr ListOfEvents_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_remove__SWIG_1")]
  public static extern IntPtr ListOfEvents_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfEvents")]
  public static extern void delete_ListOfEvents(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_0")]
  public static extern IntPtr new_EventAssignment__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_1")]
  public static extern IntPtr new_EventAssignment__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_EventAssignment")]
  public static extern void delete_EventAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_2")]
  public static extern IntPtr new_EventAssignment__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_clone")]
  public static extern IntPtr EventAssignment_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getVariable")]
  public static extern string EventAssignment_getVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getMath")]
  public static extern IntPtr EventAssignment_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_isSetVariable")]
  public static extern bool EventAssignment_isSetVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_isSetMath")]
  public static extern bool EventAssignment_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_setVariable")]
  public static extern int EventAssignment_setVariable(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_unsetVariable")]
  public static extern int EventAssignment_unsetVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_setMath")]
  public static extern int EventAssignment_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr EventAssignment_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_containsUndeclaredUnits__SWIG_0")]
  public static extern bool EventAssignment_containsUndeclaredUnits__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getTypeCode")]
  public static extern int EventAssignment_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getElementName")]
  public static extern string EventAssignment_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_hasRequiredAttributes")]
  public static extern bool EventAssignment_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_hasRequiredElements")]
  public static extern bool EventAssignment_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getId")]
  public static extern string EventAssignment_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_renameSIdRefs")]
  public static extern void EventAssignment_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_renameUnitSIdRefs")]
  public static extern void EventAssignment_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_replaceSIDWithFunction")]
  public static extern void EventAssignment_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_divideAssignmentsToSIdByFunction")]
  public static extern void EventAssignment_divideAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_multiplyAssignmentsToSIdByFunction")]
  public static extern void EventAssignment_multiplyAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfEventAssignments__SWIG_0")]
  public static extern IntPtr new_ListOfEventAssignments__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfEventAssignments__SWIG_1")]
  public static extern IntPtr new_ListOfEventAssignments__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_clone")]
  public static extern IntPtr ListOfEventAssignments_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_getItemTypeCode")]
  public static extern int ListOfEventAssignments_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_getElementName")]
  public static extern string ListOfEventAssignments_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_get__SWIG_0")]
  public static extern IntPtr ListOfEventAssignments_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_get__SWIG_2")]
  public static extern IntPtr ListOfEventAssignments_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_remove__SWIG_0")]
  public static extern IntPtr ListOfEventAssignments_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_remove__SWIG_1")]
  public static extern IntPtr ListOfEventAssignments_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_getElementBySId")]
  public static extern IntPtr ListOfEventAssignments_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfEventAssignments")]
  public static extern void delete_ListOfEventAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Trigger__SWIG_0")]
  public static extern IntPtr new_Trigger__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Trigger__SWIG_1")]
  public static extern IntPtr new_Trigger__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Trigger")]
  public static extern void delete_Trigger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Trigger__SWIG_2")]
  public static extern IntPtr new_Trigger__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_clone")]
  public static extern IntPtr Trigger_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_getMath")]
  public static extern IntPtr Trigger_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_getInitialValue")]
  public static extern bool Trigger_getInitialValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_getPersistent")]
  public static extern bool Trigger_getPersistent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_isSetMath")]
  public static extern bool Trigger_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_isSetInitialValue")]
  public static extern bool Trigger_isSetInitialValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_isSetPersistent")]
  public static extern bool Trigger_isSetPersistent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_setMath")]
  public static extern int Trigger_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_setInitialValue")]
  public static extern int Trigger_setInitialValue(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_setPersistent")]
  public static extern int Trigger_setPersistent(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_unsetInitialValue")]
  public static extern int Trigger_unsetInitialValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_unsetPersistent")]
  public static extern int Trigger_unsetPersistent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_getTypeCode")]
  public static extern int Trigger_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_getElementName")]
  public static extern string Trigger_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_renameSIdRefs")]
  public static extern void Trigger_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_renameUnitSIdRefs")]
  public static extern void Trigger_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_replaceSIDWithFunction")]
  public static extern void Trigger_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_hasRequiredElements")]
  public static extern bool Trigger_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_hasRequiredAttributes")]
  public static extern bool Trigger_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_removeFromParentAndDelete")]
  public static extern int Trigger_removeFromParentAndDelete(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Delay__SWIG_0")]
  public static extern IntPtr new_Delay__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Delay__SWIG_1")]
  public static extern IntPtr new_Delay__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Delay")]
  public static extern void delete_Delay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Delay__SWIG_2")]
  public static extern IntPtr new_Delay__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_clone")]
  public static extern IntPtr Delay_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_getMath")]
  public static extern IntPtr Delay_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_isSetMath")]
  public static extern bool Delay_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_setMath")]
  public static extern int Delay_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr Delay_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_containsUndeclaredUnits__SWIG_0")]
  public static extern bool Delay_containsUndeclaredUnits__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_getTypeCode")]
  public static extern int Delay_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_getElementName")]
  public static extern string Delay_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_hasRequiredElements")]
  public static extern bool Delay_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_removeFromParentAndDelete")]
  public static extern int Delay_removeFromParentAndDelete(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_renameSIdRefs")]
  public static extern void Delay_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_renameUnitSIdRefs")]
  public static extern void Delay_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_replaceSIDWithFunction")]
  public static extern void Delay_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Priority__SWIG_0")]
  public static extern IntPtr new_Priority__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Priority__SWIG_1")]
  public static extern IntPtr new_Priority__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Priority")]
  public static extern void delete_Priority(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Priority__SWIG_2")]
  public static extern IntPtr new_Priority__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_clone")]
  public static extern IntPtr Priority_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_getMath")]
  public static extern IntPtr Priority_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_isSetMath")]
  public static extern bool Priority_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_setMath")]
  public static extern int Priority_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_getTypeCode")]
  public static extern int Priority_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_getElementName")]
  public static extern string Priority_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_hasRequiredElements")]
  public static extern bool Priority_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_removeFromParentAndDelete")]
  public static extern int Priority_removeFromParentAndDelete(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_renameSIdRefs")]
  public static extern void Priority_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_renameUnitSIdRefs")]
  public static extern void Priority_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_replaceSIDWithFunction")]
  public static extern void Priority_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isQuantitativeParameter")]
  public static extern bool SBO_isQuantitativeParameter(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isParticipantRole")]
  public static extern bool SBO_isParticipantRole(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isModellingFramework")]
  public static extern bool SBO_isModellingFramework(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isMathematicalExpression")]
  public static extern bool SBO_isMathematicalExpression(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isKineticConstant")]
  public static extern bool SBO_isKineticConstant(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isReactant")]
  public static extern bool SBO_isReactant(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isProduct")]
  public static extern bool SBO_isProduct(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isModifier")]
  public static extern bool SBO_isModifier(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isRateLaw")]
  public static extern bool SBO_isRateLaw(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isEvent")]
  public static extern bool SBO_isEvent(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isPhysicalParticipant")]
  public static extern bool SBO_isPhysicalParticipant(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isParticipant")]
  public static extern bool SBO_isParticipant(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isInteraction")]
  public static extern bool SBO_isInteraction(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isEntity")]
  public static extern bool SBO_isEntity(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isFunctionalEntity")]
  public static extern bool SBO_isFunctionalEntity(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isMaterialEntity")]
  public static extern bool SBO_isMaterialEntity(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isConservationLaw")]
  public static extern bool SBO_isConservationLaw(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isSteadyStateExpression")]
  public static extern bool SBO_isSteadyStateExpression(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isFunctionalCompartment")]
  public static extern bool SBO_isFunctionalCompartment(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isContinuousFramework")]
  public static extern bool SBO_isContinuousFramework(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isDiscreteFramework")]
  public static extern bool SBO_isDiscreteFramework(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isLogicalFramework")]
  public static extern bool SBO_isLogicalFramework(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isMetadataRepresentation")]
  public static extern bool SBO_isMetadataRepresentation(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isOccurringEntityRepresentation")]
  public static extern bool SBO_isOccurringEntityRepresentation(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isPhysicalEntityRepresentation")]
  public static extern bool SBO_isPhysicalEntityRepresentation(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isSystemsDescriptionParameter")]
  public static extern bool SBO_isSystemsDescriptionParameter(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isQuantitativeSystemsDescriptionParameter")]
  public static extern bool SBO_isQuantitativeSystemsDescriptionParameter(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isObselete")]
  public static extern bool SBO_isObselete(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_intToString")]
  public static extern string SBO_intToString(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_stringToInt")]
  public static extern int SBO_stringToInt(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_checkTerm__SWIG_0")]
  public static extern bool SBO_checkTerm__SWIG_0(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_checkTerm__SWIG_1")]
  public static extern bool SBO_checkTerm__SWIG_1(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_getParentBranch")]
  public static extern uint SBO_getParentBranch(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBO")]
  public static extern IntPtr new_SBO();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBO")]
  public static extern void delete_SBO(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SyntaxChecker_isValidSBMLSId")]
  public static extern bool SyntaxChecker_isValidSBMLSId(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SyntaxChecker_isValidXMLID")]
  public static extern bool SyntaxChecker_isValidXMLID(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SyntaxChecker_isValidXMLanyURI")]
  public static extern bool SyntaxChecker_isValidXMLanyURI(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SyntaxChecker_isValidUnitSId")]
  public static extern bool SyntaxChecker_isValidUnitSId(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_0")]
  public static extern bool SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_1")]
  public static extern bool SyntaxChecker_hasExpectedXHTMLSyntax__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SyntaxChecker_isValidInternalSId")]
  public static extern bool SyntaxChecker_isValidInternalSId(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SyntaxChecker_isValidInternalUnitSId")]
  public static extern bool SyntaxChecker_isValidInternalUnitSId(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SyntaxChecker")]
  public static extern IntPtr new_SyntaxChecker();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SyntaxChecker")]
  public static extern void delete_SyntaxChecker(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_StoichiometryMath__SWIG_0")]
  public static extern IntPtr new_StoichiometryMath__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_StoichiometryMath__SWIG_1")]
  public static extern IntPtr new_StoichiometryMath__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_StoichiometryMath")]
  public static extern void delete_StoichiometryMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_StoichiometryMath__SWIG_2")]
  public static extern IntPtr new_StoichiometryMath__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_clone")]
  public static extern IntPtr StoichiometryMath_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_getMath")]
  public static extern IntPtr StoichiometryMath_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_isSetMath")]
  public static extern bool StoichiometryMath_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_setMath")]
  public static extern int StoichiometryMath_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_getDerivedUnitDefinition__SWIG_0")]
  public static extern IntPtr StoichiometryMath_getDerivedUnitDefinition__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_containsUndeclaredUnits__SWIG_0")]
  public static extern bool StoichiometryMath_containsUndeclaredUnits__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_getTypeCode")]
  public static extern int StoichiometryMath_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_getElementName")]
  public static extern string StoichiometryMath_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_hasRequiredElements")]
  public static extern bool StoichiometryMath_hasRequiredElements(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_removeFromParentAndDelete")]
  public static extern int StoichiometryMath_removeFromParentAndDelete(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_renameSIdRefs")]
  public static extern void StoichiometryMath_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_renameUnitSIdRefs")]
  public static extern void StoichiometryMath_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_replaceSIDWithFunction")]
  public static extern void StoichiometryMath_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLNamespaces__SWIG_0")]
  public static extern IntPtr new_SBMLNamespaces__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLNamespaces__SWIG_1")]
  public static extern IntPtr new_SBMLNamespaces__SWIG_1(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLNamespaces__SWIG_2")]
  public static extern IntPtr new_SBMLNamespaces__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLNamespaces__SWIG_3")]
  public static extern IntPtr new_SBMLNamespaces__SWIG_3(long jarg1, long jarg2, string jarg3, long jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLNamespaces__SWIG_4")]
  public static extern IntPtr new_SBMLNamespaces__SWIG_4(long jarg1, long jarg2, string jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLNamespaces")]
  public static extern void delete_SBMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLNamespaces__SWIG_5")]
  public static extern IntPtr new_SBMLNamespaces__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_clone")]
  public static extern IntPtr SBMLNamespaces_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_getSBMLNamespaceURI")]
  public static extern string SBMLNamespaces_getSBMLNamespaceURI(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_getSupportedNamespaces")]
  public static extern IntPtr SBMLNamespaces_getSupportedNamespaces();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_freeSBMLNamespaces")]
  public static extern void SBMLNamespaces_freeSBMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_getURI")]
  public static extern string SBMLNamespaces_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_getLevel__SWIG_0")]
  public static extern uint SBMLNamespaces_getLevel__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_getVersion__SWIG_0")]
  public static extern uint SBMLNamespaces_getVersion__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_getNamespaces__SWIG_0")]
  public static extern IntPtr SBMLNamespaces_getNamespaces__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_addNamespaces")]
  public static extern int SBMLNamespaces_addNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_addNamespace")]
  public static extern int SBMLNamespaces_addNamespace(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_removeNamespace")]
  public static extern int SBMLNamespaces_removeNamespace(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_addPackageNamespace__SWIG_0")]
  public static extern int SBMLNamespaces_addPackageNamespace__SWIG_0(HandleRef jarg1, string jarg2, long jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_addPackageNamespace__SWIG_1")]
  public static extern int SBMLNamespaces_addPackageNamespace__SWIG_1(HandleRef jarg1, string jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_addPackageNamespaces")]
  public static extern int SBMLNamespaces_addPackageNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_removePackageNamespace")]
  public static extern int SBMLNamespaces_removePackageNamespace(HandleRef jarg1, long jarg2, long jarg3, string jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_addPkgNamespace__SWIG_0")]
  public static extern int SBMLNamespaces_addPkgNamespace__SWIG_0(HandleRef jarg1, string jarg2, long jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_addPkgNamespace__SWIG_1")]
  public static extern int SBMLNamespaces_addPkgNamespace__SWIG_1(HandleRef jarg1, string jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_addPkgNamespaces")]
  public static extern int SBMLNamespaces_addPkgNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_removePkgNamespace")]
  public static extern int SBMLNamespaces_removePkgNamespace(HandleRef jarg1, long jarg2, long jarg3, string jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_isSBMLNamespace")]
  public static extern bool SBMLNamespaces_isSBMLNamespace(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_isValidCombination")]
  public static extern bool SBMLNamespaces_isValidCombination(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLNamespaces_getPackageName")]
  public static extern string SBMLNamespaces_getPackageName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_replaceFD__SWIG_0")]
  public static extern void SBMLTransforms_replaceFD__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_replaceFD__SWIG_1")]
  public static extern void SBMLTransforms_replaceFD__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_replaceFD__SWIG_2")]
  public static extern void SBMLTransforms_replaceFD__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_replaceFD__SWIG_3")]
  public static extern void SBMLTransforms_replaceFD__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_expandInitialAssignments")]
  public static extern bool SBMLTransforms_expandInitialAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_evaluateASTNode__SWIG_0")]
  public static extern double SBMLTransforms_evaluateASTNode__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_evaluateASTNode__SWIG_1")]
  public static extern double SBMLTransforms_evaluateASTNode__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_mapComponentValues")]
  public static extern IntPtr SBMLTransforms_mapComponentValues(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTransforms_clearComponentValues")]
  public static extern void SBMLTransforms_clearComponentValues();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLTransforms")]
  public static extern IntPtr new_SBMLTransforms();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLTransforms")]
  public static extern void delete_SBMLTransforms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLConstructorException__SWIG_0")]
  public static extern IntPtr new_SBMLConstructorException__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLConstructorException__SWIG_1")]
  public static extern IntPtr new_SBMLConstructorException__SWIG_1(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLConstructorException__SWIG_2")]
  public static extern IntPtr new_SBMLConstructorException__SWIG_2(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLConstructorException")]
  public static extern void delete_SBMLConstructorException(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConstructorException_getSBMLErrMsg")]
  public static extern string SBMLConstructorException_getSBMLErrMsg(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_0")]
  public static extern IntPtr new_ConversionOption__SWIG_0(string jarg1, string jarg2, int jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_1")]
  public static extern IntPtr new_ConversionOption__SWIG_1(string jarg1, string jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_2")]
  public static extern IntPtr new_ConversionOption__SWIG_2(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_3")]
  public static extern IntPtr new_ConversionOption__SWIG_3(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_4")]
  public static extern IntPtr new_ConversionOption__SWIG_4(string jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_6")]
  public static extern IntPtr new_ConversionOption__SWIG_6(string jarg1, bool jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_7")]
  public static extern IntPtr new_ConversionOption__SWIG_7(string jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_8")]
  public static extern IntPtr new_ConversionOption__SWIG_8(string jarg1, double jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_9")]
  public static extern IntPtr new_ConversionOption__SWIG_9(string jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_10")]
  public static extern IntPtr new_ConversionOption__SWIG_10(string jarg1, float jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_11")]
  public static extern IntPtr new_ConversionOption__SWIG_11(string jarg1, float jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_12")]
  public static extern IntPtr new_ConversionOption__SWIG_12(string jarg1, int jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_13")]
  public static extern IntPtr new_ConversionOption__SWIG_13(string jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionOption__SWIG_14")]
  public static extern IntPtr new_ConversionOption__SWIG_14(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ConversionOption")]
  public static extern void delete_ConversionOption(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_clone")]
  public static extern IntPtr ConversionOption_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_getKey")]
  public static extern string ConversionOption_getKey(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_setKey")]
  public static extern void ConversionOption_setKey(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_getValue")]
  public static extern string ConversionOption_getValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_setValue")]
  public static extern void ConversionOption_setValue(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_getDescription")]
  public static extern string ConversionOption_getDescription(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_setDescription")]
  public static extern void ConversionOption_setDescription(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_getType")]
  public static extern int ConversionOption_getType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_setType")]
  public static extern void ConversionOption_setType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_getBoolValue")]
  public static extern bool ConversionOption_getBoolValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_setBoolValue")]
  public static extern void ConversionOption_setBoolValue(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_getDoubleValue")]
  public static extern double ConversionOption_getDoubleValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_setDoubleValue")]
  public static extern void ConversionOption_setDoubleValue(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_getFloatValue")]
  public static extern float ConversionOption_getFloatValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_setFloatValue")]
  public static extern void ConversionOption_setFloatValue(HandleRef jarg1, float jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_getIntValue")]
  public static extern int ConversionOption_getIntValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionOption_setIntValue")]
  public static extern void ConversionOption_setIntValue(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionProperties__SWIG_0")]
  public static extern IntPtr new_ConversionProperties__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionProperties__SWIG_1")]
  public static extern IntPtr new_ConversionProperties__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ConversionProperties__SWIG_2")]
  public static extern IntPtr new_ConversionProperties__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_clone")]
  public static extern IntPtr ConversionProperties_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ConversionProperties")]
  public static extern void delete_ConversionProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getTargetNamespaces")]
  public static extern IntPtr ConversionProperties_getTargetNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_hasTargetNamespaces")]
  public static extern bool ConversionProperties_hasTargetNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_setTargetNamespaces")]
  public static extern void ConversionProperties_setTargetNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getDescription")]
  public static extern string ConversionProperties_getDescription(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getType")]
  public static extern int ConversionProperties_getType(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getOption__SWIG_0")]
  public static extern IntPtr ConversionProperties_getOption__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getOption__SWIG_1")]
  public static extern IntPtr ConversionProperties_getOption__SWIG_1(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_0")]
  public static extern void ConversionProperties_addOption__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_1")]
  public static extern void ConversionProperties_addOption__SWIG_1(HandleRef jarg1, string jarg2, string jarg3, int jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_2")]
  public static extern void ConversionProperties_addOption__SWIG_2(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_3")]
  public static extern void ConversionProperties_addOption__SWIG_3(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_4")]
  public static extern void ConversionProperties_addOption__SWIG_4(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_5")]
  public static extern void ConversionProperties_addOption__SWIG_5(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_7")]
  public static extern void ConversionProperties_addOption__SWIG_7(HandleRef jarg1, string jarg2, bool jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_8")]
  public static extern void ConversionProperties_addOption__SWIG_8(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_9")]
  public static extern void ConversionProperties_addOption__SWIG_9(HandleRef jarg1, string jarg2, double jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_10")]
  public static extern void ConversionProperties_addOption__SWIG_10(HandleRef jarg1, string jarg2, double jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_11")]
  public static extern void ConversionProperties_addOption__SWIG_11(HandleRef jarg1, string jarg2, float jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_12")]
  public static extern void ConversionProperties_addOption__SWIG_12(HandleRef jarg1, string jarg2, float jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_13")]
  public static extern void ConversionProperties_addOption__SWIG_13(HandleRef jarg1, string jarg2, int jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_addOption__SWIG_14")]
  public static extern void ConversionProperties_addOption__SWIG_14(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_removeOption")]
  public static extern IntPtr ConversionProperties_removeOption(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_hasOption")]
  public static extern bool ConversionProperties_hasOption(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getValue")]
  public static extern string ConversionProperties_getValue(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_setValue")]
  public static extern void ConversionProperties_setValue(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getBoolValue")]
  public static extern bool ConversionProperties_getBoolValue(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_setBoolValue")]
  public static extern void ConversionProperties_setBoolValue(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getDoubleValue")]
  public static extern double ConversionProperties_getDoubleValue(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_setDoubleValue")]
  public static extern void ConversionProperties_setDoubleValue(HandleRef jarg1, string jarg2, double jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getFloatValue")]
  public static extern float ConversionProperties_getFloatValue(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_setFloatValue")]
  public static extern void ConversionProperties_setFloatValue(HandleRef jarg1, string jarg2, float jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getIntValue")]
  public static extern int ConversionProperties_getIntValue(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_setIntValue")]
  public static extern void ConversionProperties_setIntValue(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConversionProperties_getNumOptions")]
  public static extern int ConversionProperties_getNumOptions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLConverter__SWIG_0")]
  public static extern IntPtr new_SBMLConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLConverter__SWIG_1")]
  public static extern IntPtr new_SBMLConverter__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLConverter__SWIG_2")]
  public static extern IntPtr new_SBMLConverter__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLConverter")]
  public static extern void delete_SBMLConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_clone")]
  public static extern IntPtr SBMLConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_cloneSwigExplicitSBMLConverter")]
  public static extern IntPtr SBMLConverter_cloneSwigExplicitSBMLConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getDocument__SWIG_0")]
  public static extern IntPtr SBMLConverter_getDocument__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getDocumentSwigExplicitSBMLConverter__SWIG_0")]
  public static extern IntPtr SBMLConverter_getDocumentSwigExplicitSBMLConverter__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getDocumentSwigExplicitSBMLConverter__SWIG_1")]
  public static extern IntPtr SBMLConverter_getDocumentSwigExplicitSBMLConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getDefaultProperties")]
  public static extern IntPtr SBMLConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getDefaultPropertiesSwigExplicitSBMLConverter")]
  public static extern IntPtr SBMLConverter_getDefaultPropertiesSwigExplicitSBMLConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getTargetNamespaces")]
  public static extern IntPtr SBMLConverter_getTargetNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getTargetNamespacesSwigExplicitSBMLConverter")]
  public static extern IntPtr SBMLConverter_getTargetNamespacesSwigExplicitSBMLConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_matchesProperties")]
  public static extern bool SBMLConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_matchesPropertiesSwigExplicitSBMLConverter")]
  public static extern bool SBMLConverter_matchesPropertiesSwigExplicitSBMLConverter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_setDocument")]
  public static extern int SBMLConverter_setDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_setDocumentSwigExplicitSBMLConverter")]
  public static extern int SBMLConverter_setDocumentSwigExplicitSBMLConverter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_setProperties")]
  public static extern int SBMLConverter_setProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_setPropertiesSwigExplicitSBMLConverter")]
  public static extern int SBMLConverter_setPropertiesSwigExplicitSBMLConverter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getProperties")]
  public static extern IntPtr SBMLConverter_getProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getPropertiesSwigExplicitSBMLConverter")]
  public static extern IntPtr SBMLConverter_getPropertiesSwigExplicitSBMLConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_convert")]
  public static extern int SBMLConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_convertSwigExplicitSBMLConverter")]
  public static extern int SBMLConverter_convertSwigExplicitSBMLConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_getName")]
  public static extern string SBMLConverter_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverter_director_connect")]
  public static extern void SBMLConverter_director_connect(HandleRef jarg1, SBMLConverter.SwigDelegateSBMLConverter_0 delegate0, SBMLConverter.SwigDelegateSBMLConverter_1 delegate1, SBMLConverter.SwigDelegateSBMLConverter_2 delegate2, SBMLConverter.SwigDelegateSBMLConverter_3 delegate3, SBMLConverter.SwigDelegateSBMLConverter_4 delegate4, SBMLConverter.SwigDelegateSBMLConverter_5 delegate5, SBMLConverter.SwigDelegateSBMLConverter_6 delegate6, SBMLConverter.SwigDelegateSBMLConverter_7 delegate7, SBMLConverter.SwigDelegateSBMLConverter_8 delegate8, SBMLConverter.SwigDelegateSBMLConverter_9 delegate9);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverterRegistry_getInstance")]
  public static extern IntPtr SBMLConverterRegistry_getInstance();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverterRegistry_addConverter")]
  public static extern int SBMLConverterRegistry_addConverter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverterRegistry_getConverterByIndex")]
  public static extern IntPtr SBMLConverterRegistry_getConverterByIndex(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverterRegistry_getConverterFor")]
  public static extern IntPtr SBMLConverterRegistry_getConverterFor(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLConverterRegistry_getNumConverters")]
  public static extern int SBMLConverterRegistry_getNumConverters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLConverterRegistry")]
  public static extern void delete_SBMLConverterRegistry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLFunctionDefinitionConverter_init")]
  public static extern void SBMLFunctionDefinitionConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLFunctionDefinitionConverter__SWIG_0")]
  public static extern IntPtr new_SBMLFunctionDefinitionConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLFunctionDefinitionConverter__SWIG_1")]
  public static extern IntPtr new_SBMLFunctionDefinitionConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLFunctionDefinitionConverter_clone")]
  public static extern IntPtr SBMLFunctionDefinitionConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLFunctionDefinitionConverter")]
  public static extern void delete_SBMLFunctionDefinitionConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLFunctionDefinitionConverter_matchesProperties")]
  public static extern bool SBMLFunctionDefinitionConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLFunctionDefinitionConverter_convert")]
  public static extern int SBMLFunctionDefinitionConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLFunctionDefinitionConverter_getDefaultProperties")]
  public static extern IntPtr SBMLFunctionDefinitionConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLIdConverter_init")]
  public static extern void SBMLIdConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLIdConverter__SWIG_0")]
  public static extern IntPtr new_SBMLIdConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLIdConverter__SWIG_1")]
  public static extern IntPtr new_SBMLIdConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLIdConverter_clone")]
  public static extern IntPtr SBMLIdConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLIdConverter")]
  public static extern void delete_SBMLIdConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLIdConverter_matchesProperties")]
  public static extern bool SBMLIdConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLIdConverter_convert")]
  public static extern int SBMLIdConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLIdConverter_getDefaultProperties")]
  public static extern IntPtr SBMLIdConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInferUnitsConverter_init")]
  public static extern void SBMLInferUnitsConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLInferUnitsConverter__SWIG_0")]
  public static extern IntPtr new_SBMLInferUnitsConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLInferUnitsConverter__SWIG_1")]
  public static extern IntPtr new_SBMLInferUnitsConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLInferUnitsConverter")]
  public static extern void delete_SBMLInferUnitsConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInferUnitsConverter_clone")]
  public static extern IntPtr SBMLInferUnitsConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInferUnitsConverter_matchesProperties")]
  public static extern bool SBMLInferUnitsConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInferUnitsConverter_convert")]
  public static extern int SBMLInferUnitsConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInferUnitsConverter_getDefaultProperties")]
  public static extern IntPtr SBMLInferUnitsConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInitialAssignmentConverter_init")]
  public static extern void SBMLInitialAssignmentConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLInitialAssignmentConverter__SWIG_0")]
  public static extern IntPtr new_SBMLInitialAssignmentConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLInitialAssignmentConverter__SWIG_1")]
  public static extern IntPtr new_SBMLInitialAssignmentConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInitialAssignmentConverter_clone")]
  public static extern IntPtr SBMLInitialAssignmentConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLInitialAssignmentConverter")]
  public static extern void delete_SBMLInitialAssignmentConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInitialAssignmentConverter_matchesProperties")]
  public static extern bool SBMLInitialAssignmentConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInitialAssignmentConverter_convert")]
  public static extern int SBMLInitialAssignmentConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInitialAssignmentConverter_getDefaultProperties")]
  public static extern IntPtr SBMLInitialAssignmentConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_init")]
  public static extern void SBMLLevelVersionConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLLevelVersionConverter__SWIG_0")]
  public static extern IntPtr new_SBMLLevelVersionConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLLevelVersionConverter__SWIG_1")]
  public static extern IntPtr new_SBMLLevelVersionConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLLevelVersionConverter")]
  public static extern void delete_SBMLLevelVersionConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_clone")]
  public static extern IntPtr SBMLLevelVersionConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_matchesProperties")]
  public static extern bool SBMLLevelVersionConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_convert")]
  public static extern int SBMLLevelVersionConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_getDefaultProperties")]
  public static extern IntPtr SBMLLevelVersionConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_getTargetLevel")]
  public static extern uint SBMLLevelVersionConverter_getTargetLevel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_getTargetVersion")]
  public static extern uint SBMLLevelVersionConverter_getTargetVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_getValidityFlag")]
  public static extern bool SBMLLevelVersionConverter_getValidityFlag(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_getAddDefaultUnits")]
  public static extern bool SBMLLevelVersionConverter_getAddDefaultUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevel1Version1Converter_init")]
  public static extern void SBMLLevel1Version1Converter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLLevel1Version1Converter__SWIG_0")]
  public static extern IntPtr new_SBMLLevel1Version1Converter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLLevel1Version1Converter__SWIG_1")]
  public static extern IntPtr new_SBMLLevel1Version1Converter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLLevel1Version1Converter")]
  public static extern void delete_SBMLLevel1Version1Converter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevel1Version1Converter_clone")]
  public static extern IntPtr SBMLLevel1Version1Converter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevel1Version1Converter_matchesProperties")]
  public static extern bool SBMLLevel1Version1Converter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevel1Version1Converter_convert")]
  public static extern int SBMLLevel1Version1Converter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevel1Version1Converter_getDefaultProperties")]
  public static extern IntPtr SBMLLevel1Version1Converter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLocalParameterConverter_init")]
  public static extern void SBMLLocalParameterConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLLocalParameterConverter__SWIG_0")]
  public static extern IntPtr new_SBMLLocalParameterConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLLocalParameterConverter__SWIG_1")]
  public static extern IntPtr new_SBMLLocalParameterConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLocalParameterConverter_clone")]
  public static extern IntPtr SBMLLocalParameterConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLLocalParameterConverter")]
  public static extern void delete_SBMLLocalParameterConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLocalParameterConverter_matchesProperties")]
  public static extern bool SBMLLocalParameterConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLocalParameterConverter_convert")]
  public static extern int SBMLLocalParameterConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLocalParameterConverter_getDefaultProperties")]
  public static extern IntPtr SBMLLocalParameterConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReactionConverter_init")]
  public static extern void SBMLReactionConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLReactionConverter__SWIG_0")]
  public static extern IntPtr new_SBMLReactionConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLReactionConverter__SWIG_1")]
  public static extern IntPtr new_SBMLReactionConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReactionConverter_clone")]
  public static extern IntPtr SBMLReactionConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLReactionConverter")]
  public static extern void delete_SBMLReactionConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReactionConverter_matchesProperties")]
  public static extern bool SBMLReactionConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReactionConverter_convert")]
  public static extern int SBMLReactionConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReactionConverter_getDefaultProperties")]
  public static extern IntPtr SBMLReactionConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReactionConverter_setDocument")]
  public static extern int SBMLReactionConverter_setDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLRuleConverter_init")]
  public static extern void SBMLRuleConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLRuleConverter__SWIG_0")]
  public static extern IntPtr new_SBMLRuleConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLRuleConverter__SWIG_1")]
  public static extern IntPtr new_SBMLRuleConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLRuleConverter_clone")]
  public static extern IntPtr SBMLRuleConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLRuleConverter")]
  public static extern void delete_SBMLRuleConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLRuleConverter_matchesProperties")]
  public static extern bool SBMLRuleConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLRuleConverter_convert")]
  public static extern int SBMLRuleConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLRuleConverter_getDefaultProperties")]
  public static extern IntPtr SBMLRuleConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLStripPackageConverter_init")]
  public static extern void SBMLStripPackageConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLStripPackageConverter__SWIG_0")]
  public static extern IntPtr new_SBMLStripPackageConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLStripPackageConverter__SWIG_1")]
  public static extern IntPtr new_SBMLStripPackageConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLStripPackageConverter")]
  public static extern void delete_SBMLStripPackageConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLStripPackageConverter_clone")]
  public static extern IntPtr SBMLStripPackageConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLStripPackageConverter_matchesProperties")]
  public static extern bool SBMLStripPackageConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLStripPackageConverter_convert")]
  public static extern int SBMLStripPackageConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLStripPackageConverter_getDefaultProperties")]
  public static extern IntPtr SBMLStripPackageConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLStripPackageConverter_getPackageToStrip")]
  public static extern string SBMLStripPackageConverter_getPackageToStrip(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLStripPackageConverter_isStripAllUnrecognizedPackages")]
  public static extern bool SBMLStripPackageConverter_isStripAllUnrecognizedPackages(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLUnitsConverter_init")]
  public static extern void SBMLUnitsConverter_init();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLUnitsConverter__SWIG_0")]
  public static extern IntPtr new_SBMLUnitsConverter__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLUnitsConverter__SWIG_1")]
  public static extern IntPtr new_SBMLUnitsConverter__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLUnitsConverter")]
  public static extern void delete_SBMLUnitsConverter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLUnitsConverter_clone")]
  public static extern IntPtr SBMLUnitsConverter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLUnitsConverter_matchesProperties")]
  public static extern bool SBMLUnitsConverter_matchesProperties(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLUnitsConverter_convert")]
  public static extern int SBMLUnitsConverter_convert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLUnitsConverter_getDefaultProperties")]
  public static extern IntPtr SBMLUnitsConverter_getDefaultProperties(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLValidator__SWIG_0")]
  public static extern IntPtr new_SBMLValidator__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLValidator__SWIG_1")]
  public static extern IntPtr new_SBMLValidator__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLValidator")]
  public static extern void delete_SBMLValidator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_clone")]
  public static extern IntPtr SBMLValidator_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_cloneSwigExplicitSBMLValidator")]
  public static extern IntPtr SBMLValidator_cloneSwigExplicitSBMLValidator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_getDocument__SWIG_0")]
  public static extern IntPtr SBMLValidator_getDocument__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_0")]
  public static extern IntPtr SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_1")]
  public static extern IntPtr SBMLValidator_getDocumentSwigExplicitSBMLValidator__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_setDocument")]
  public static extern int SBMLValidator_setDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_setDocumentSwigExplicitSBMLValidator")]
  public static extern int SBMLValidator_setDocumentSwigExplicitSBMLValidator(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_validate__SWIG_0")]
  public static extern uint SBMLValidator_validate__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_validateSwigExplicitSBMLValidator__SWIG_0")]
  public static extern uint SBMLValidator_validateSwigExplicitSBMLValidator__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_clearFailures")]
  public static extern void SBMLValidator_clearFailures(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_clearFailuresSwigExplicitSBMLValidator")]
  public static extern void SBMLValidator_clearFailuresSwigExplicitSBMLValidator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_logFailure")]
  public static extern void SBMLValidator_logFailure(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_validate__SWIG_1")]
  public static extern uint SBMLValidator_validate__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_validate__SWIG_2")]
  public static extern uint SBMLValidator_validate__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_getErrorLog")]
  public static extern IntPtr SBMLValidator_getErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_getModel__SWIG_0")]
  public static extern IntPtr SBMLValidator_getModel__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_getNumFailures")]
  public static extern uint SBMLValidator_getNumFailures(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_getFailure")]
  public static extern IntPtr SBMLValidator_getFailure(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLValidator_director_connect")]
  public static extern void SBMLValidator_director_connect(HandleRef jarg1, SBMLValidator.SwigDelegateSBMLValidator_0 delegate0, SBMLValidator.SwigDelegateSBMLValidator_1 delegate1, SBMLValidator.SwigDelegateSBMLValidator_2 delegate2, SBMLValidator.SwigDelegateSBMLValidator_3 delegate3, SBMLValidator.SwigDelegateSBMLValidator_4 delegate4, SBMLValidator.SwigDelegateSBMLValidator_5 delegate5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLExternalValidator__SWIG_0")]
  public static extern IntPtr new_SBMLExternalValidator__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLExternalValidator__SWIG_1")]
  public static extern IntPtr new_SBMLExternalValidator__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_clone")]
  public static extern IntPtr SBMLExternalValidator_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLExternalValidator")]
  public static extern void delete_SBMLExternalValidator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_validate")]
  public static extern uint SBMLExternalValidator_validate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_getProgram")]
  public static extern string SBMLExternalValidator_getProgram(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_setProgram")]
  public static extern void SBMLExternalValidator_setProgram(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_getOutputFileName")]
  public static extern string SBMLExternalValidator_getOutputFileName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_setOutputFileName")]
  public static extern void SBMLExternalValidator_setOutputFileName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_getSBMLFileName")]
  public static extern string SBMLExternalValidator_getSBMLFileName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_setSBMLFileName")]
  public static extern void SBMLExternalValidator_setSBMLFileName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_clearArguments")]
  public static extern void SBMLExternalValidator_clearArguments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_addArgument")]
  public static extern void SBMLExternalValidator_addArgument(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_getNumArguments")]
  public static extern uint SBMLExternalValidator_getNumArguments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_getArgument")]
  public static extern string SBMLExternalValidator_getArgument(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLAttributes__SWIG_0")]
  public static extern IntPtr new_XMLAttributes__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLAttributes")]
  public static extern void delete_XMLAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLAttributes__SWIG_1")]
  public static extern IntPtr new_XMLAttributes__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_clone")]
  public static extern IntPtr XMLAttributes_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_add__SWIG_0")]
  public static extern int XMLAttributes_add__SWIG_0(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_add__SWIG_1")]
  public static extern int XMLAttributes_add__SWIG_1(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_add__SWIG_2")]
  public static extern int XMLAttributes_add__SWIG_2(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_add__SWIG_3")]
  public static extern int XMLAttributes_add__SWIG_3(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_removeResource")]
  public static extern int XMLAttributes_removeResource(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_remove__SWIG_0")]
  public static extern int XMLAttributes_remove__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_remove__SWIG_1")]
  public static extern int XMLAttributes_remove__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_remove__SWIG_2")]
  public static extern int XMLAttributes_remove__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_remove__SWIG_3")]
  public static extern int XMLAttributes_remove__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_clear")]
  public static extern int XMLAttributes_clear(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getIndex__SWIG_0")]
  public static extern int XMLAttributes_getIndex__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getIndex__SWIG_1")]
  public static extern int XMLAttributes_getIndex__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getIndex__SWIG_2")]
  public static extern int XMLAttributes_getIndex__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getLength")]
  public static extern int XMLAttributes_getLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getNumAttributes")]
  public static extern int XMLAttributes_getNumAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getName")]
  public static extern string XMLAttributes_getName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getPrefix")]
  public static extern string XMLAttributes_getPrefix(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getPrefixedName")]
  public static extern string XMLAttributes_getPrefixedName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getURI")]
  public static extern string XMLAttributes_getURI(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getValue__SWIG_0")]
  public static extern string XMLAttributes_getValue__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getValue__SWIG_1")]
  public static extern string XMLAttributes_getValue__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getValue__SWIG_2")]
  public static extern string XMLAttributes_getValue__SWIG_2(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getValue__SWIG_3")]
  public static extern string XMLAttributes_getValue__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_hasAttribute__SWIG_0")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_hasAttribute__SWIG_1")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_hasAttribute__SWIG_2")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_hasAttribute__SWIG_3")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_isEmpty")]
  public static extern bool XMLAttributes_isEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLConstructorException")]
  public static extern IntPtr new_XMLConstructorException();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLConstructorException")]
  public static extern void delete_XMLConstructorException(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNamespaces__SWIG_0")]
  public static extern IntPtr new_XMLNamespaces__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLNamespaces")]
  public static extern void delete_XMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNamespaces__SWIG_1")]
  public static extern IntPtr new_XMLNamespaces__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_clone")]
  public static extern IntPtr XMLNamespaces_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_add__SWIG_0")]
  public static extern int XMLNamespaces_add__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_add__SWIG_1")]
  public static extern int XMLNamespaces_add__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_remove__SWIG_0")]
  public static extern int XMLNamespaces_remove__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_remove__SWIG_1")]
  public static extern int XMLNamespaces_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_clear")]
  public static extern int XMLNamespaces_clear(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getIndex")]
  public static extern int XMLNamespaces_getIndex(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_containsUri")]
  public static extern bool XMLNamespaces_containsUri(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getIndexByPrefix")]
  public static extern int XMLNamespaces_getIndexByPrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getLength")]
  public static extern int XMLNamespaces_getLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getNumNamespaces")]
  public static extern int XMLNamespaces_getNumNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getPrefix__SWIG_0")]
  public static extern string XMLNamespaces_getPrefix__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getPrefix__SWIG_1")]
  public static extern string XMLNamespaces_getPrefix__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getURI__SWIG_0")]
  public static extern string XMLNamespaces_getURI__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getURI__SWIG_1")]
  public static extern string XMLNamespaces_getURI__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getURI__SWIG_2")]
  public static extern string XMLNamespaces_getURI__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_isEmpty")]
  public static extern bool XMLNamespaces_isEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_hasURI")]
  public static extern bool XMLNamespaces_hasURI(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_hasPrefix")]
  public static extern bool XMLNamespaces_hasPrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_hasNS")]
  public static extern bool XMLNamespaces_hasNS(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_0")]
  public static extern IntPtr new_XMLToken__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_1")]
  public static extern IntPtr new_XMLToken__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_2")]
  public static extern IntPtr new_XMLToken__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_3")]
  public static extern IntPtr new_XMLToken__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_4")]
  public static extern IntPtr new_XMLToken__SWIG_4(HandleRef jarg1, HandleRef jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_5")]
  public static extern IntPtr new_XMLToken__SWIG_5(HandleRef jarg1, HandleRef jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_6")]
  public static extern IntPtr new_XMLToken__SWIG_6(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_7")]
  public static extern IntPtr new_XMLToken__SWIG_7(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_8")]
  public static extern IntPtr new_XMLToken__SWIG_8(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_9")]
  public static extern IntPtr new_XMLToken__SWIG_9(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_10")]
  public static extern IntPtr new_XMLToken__SWIG_10(string jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_11")]
  public static extern IntPtr new_XMLToken__SWIG_11(string jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_12")]
  public static extern IntPtr new_XMLToken__SWIG_12(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLToken")]
  public static extern void delete_XMLToken(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_13")]
  public static extern IntPtr new_XMLToken__SWIG_13(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_clone")]
  public static extern IntPtr XMLToken_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttributes")]
  public static extern IntPtr XMLToken_getAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setAttributes")]
  public static extern int XMLToken_setAttributes(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addAttr__SWIG_0")]
  public static extern int XMLToken_addAttr__SWIG_0(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addAttr__SWIG_1")]
  public static extern int XMLToken_addAttr__SWIG_1(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addAttr__SWIG_2")]
  public static extern int XMLToken_addAttr__SWIG_2(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addAttr__SWIG_3")]
  public static extern int XMLToken_addAttr__SWIG_3(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeAttr__SWIG_0")]
  public static extern int XMLToken_removeAttr__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeAttr__SWIG_1")]
  public static extern int XMLToken_removeAttr__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeAttr__SWIG_2")]
  public static extern int XMLToken_removeAttr__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeAttr__SWIG_3")]
  public static extern int XMLToken_removeAttr__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_clearAttributes")]
  public static extern int XMLToken_clearAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrIndex__SWIG_0")]
  public static extern int XMLToken_getAttrIndex__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrIndex__SWIG_1")]
  public static extern int XMLToken_getAttrIndex__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrIndex__SWIG_2")]
  public static extern int XMLToken_getAttrIndex__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttributesLength")]
  public static extern int XMLToken_getAttributesLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrName")]
  public static extern string XMLToken_getAttrName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrPrefix")]
  public static extern string XMLToken_getAttrPrefix(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrPrefixedName")]
  public static extern string XMLToken_getAttrPrefixedName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrURI")]
  public static extern string XMLToken_getAttrURI(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrValue__SWIG_0")]
  public static extern string XMLToken_getAttrValue__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrValue__SWIG_1")]
  public static extern string XMLToken_getAttrValue__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrValue__SWIG_2")]
  public static extern string XMLToken_getAttrValue__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrValue__SWIG_3")]
  public static extern string XMLToken_getAttrValue__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasAttr__SWIG_0")]
  public static extern bool XMLToken_hasAttr__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasAttr__SWIG_1")]
  public static extern bool XMLToken_hasAttr__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasAttr__SWIG_2")]
  public static extern bool XMLToken_hasAttr__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasAttr__SWIG_3")]
  public static extern bool XMLToken_hasAttr__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isAttributesEmpty")]
  public static extern bool XMLToken_isAttributesEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaces")]
  public static extern IntPtr XMLToken_getNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setNamespaces")]
  public static extern int XMLToken_setNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addNamespace__SWIG_0")]
  public static extern int XMLToken_addNamespace__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addNamespace__SWIG_1")]
  public static extern int XMLToken_addNamespace__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeNamespace__SWIG_0")]
  public static extern int XMLToken_removeNamespace__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeNamespace__SWIG_1")]
  public static extern int XMLToken_removeNamespace__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_clearNamespaces")]
  public static extern int XMLToken_clearNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceIndex")]
  public static extern int XMLToken_getNamespaceIndex(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceIndexByPrefix")]
  public static extern int XMLToken_getNamespaceIndexByPrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespacesLength")]
  public static extern int XMLToken_getNamespacesLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespacePrefix__SWIG_0")]
  public static extern string XMLToken_getNamespacePrefix__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespacePrefix__SWIG_1")]
  public static extern string XMLToken_getNamespacePrefix__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceURI__SWIG_0")]
  public static extern string XMLToken_getNamespaceURI__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceURI__SWIG_1")]
  public static extern string XMLToken_getNamespaceURI__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceURI__SWIG_2")]
  public static extern string XMLToken_getNamespaceURI__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isNamespacesEmpty")]
  public static extern bool XMLToken_isNamespacesEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasNamespaceURI")]
  public static extern bool XMLToken_hasNamespaceURI(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasNamespacePrefix")]
  public static extern bool XMLToken_hasNamespacePrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasNamespaceNS")]
  public static extern bool XMLToken_hasNamespaceNS(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setTriple")]
  public static extern int XMLToken_setTriple(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getName")]
  public static extern string XMLToken_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getPrefix")]
  public static extern string XMLToken_getPrefix(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getURI")]
  public static extern string XMLToken_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getCharacters")]
  public static extern string XMLToken_getCharacters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_append")]
  public static extern int XMLToken_append(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getColumn")]
  public static extern uint XMLToken_getColumn(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getLine")]
  public static extern uint XMLToken_getLine(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isElement")]
  public static extern bool XMLToken_isElement(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isEnd")]
  public static extern bool XMLToken_isEnd(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isEndFor")]
  public static extern bool XMLToken_isEndFor(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isEOF")]
  public static extern bool XMLToken_isEOF(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isStart")]
  public static extern bool XMLToken_isStart(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isText")]
  public static extern bool XMLToken_isText(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setEnd")]
  public static extern int XMLToken_setEnd(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setEOF")]
  public static extern int XMLToken_setEOF(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_unsetEnd")]
  public static extern int XMLToken_unsetEnd(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_toString")]
  public static extern string XMLToken_toString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_0")]
  public static extern IntPtr new_XMLNode__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_1")]
  public static extern IntPtr new_XMLNode__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_2")]
  public static extern IntPtr new_XMLNode__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_3")]
  public static extern IntPtr new_XMLNode__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_4")]
  public static extern IntPtr new_XMLNode__SWIG_4(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_5")]
  public static extern IntPtr new_XMLNode__SWIG_5(HandleRef jarg1, HandleRef jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_6")]
  public static extern IntPtr new_XMLNode__SWIG_6(HandleRef jarg1, HandleRef jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_7")]
  public static extern IntPtr new_XMLNode__SWIG_7(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_8")]
  public static extern IntPtr new_XMLNode__SWIG_8(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_9")]
  public static extern IntPtr new_XMLNode__SWIG_9(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_10")]
  public static extern IntPtr new_XMLNode__SWIG_10(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_11")]
  public static extern IntPtr new_XMLNode__SWIG_11(string jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_12")]
  public static extern IntPtr new_XMLNode__SWIG_12(string jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_13")]
  public static extern IntPtr new_XMLNode__SWIG_13(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_14")]
  public static extern IntPtr new_XMLNode__SWIG_14(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLNode")]
  public static extern void delete_XMLNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_15")]
  public static extern IntPtr new_XMLNode__SWIG_15(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_clone")]
  public static extern IntPtr XMLNode_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_addChild")]
  public static extern int XMLNode_addChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_insertChild")]
  public static extern IntPtr XMLNode_insertChild(HandleRef jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_removeChild")]
  public static extern IntPtr XMLNode_removeChild(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_removeChildren")]
  public static extern int XMLNode_removeChildren(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_getChild__SWIG_0")]
  public static extern IntPtr XMLNode_getChild__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_getChild__SWIG_2")]
  public static extern IntPtr XMLNode_getChild__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_getIndex")]
  public static extern int XMLNode_getIndex(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_hasChild")]
  public static extern bool XMLNode_hasChild(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_equals__SWIG_0")]
  public static extern bool XMLNode_equals__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_equals__SWIG_1")]
  public static extern bool XMLNode_equals__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_getNumChildren")]
  public static extern uint XMLNode_getNumChildren(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_toXMLString")]
  public static extern string XMLNode_toXMLString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_convertXMLNodeToString")]
  public static extern string XMLNode_convertXMLNodeToString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_convertStringToXMLNode__SWIG_0")]
  public static extern IntPtr XMLNode_convertStringToXMLNode__SWIG_0(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_convertStringToXMLNode__SWIG_1")]
  public static extern IntPtr XMLNode_convertStringToXMLNode__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_0")]
  public static extern IntPtr new_XMLTriple__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_1")]
  public static extern IntPtr new_XMLTriple__SWIG_1(string jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_2")]
  public static extern IntPtr new_XMLTriple__SWIG_2(string jarg1, char jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_3")]
  public static extern IntPtr new_XMLTriple__SWIG_3(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_4")]
  public static extern IntPtr new_XMLTriple__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_clone")]
  public static extern IntPtr XMLTriple_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_getName")]
  public static extern string XMLTriple_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_getPrefix")]
  public static extern string XMLTriple_getPrefix(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_getURI")]
  public static extern string XMLTriple_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_getPrefixedName")]
  public static extern string XMLTriple_getPrefixedName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_isEmpty")]
  public static extern bool XMLTriple_isEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLTriple")]
  public static extern void delete_XMLTriple(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_0")]
  public static extern IntPtr new_XMLOutputStream__SWIG_0(HandleRef jarg1, string jarg2, bool jarg3, string jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_1")]
  public static extern IntPtr new_XMLOutputStream__SWIG_1(HandleRef jarg1, string jarg2, bool jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_2")]
  public static extern IntPtr new_XMLOutputStream__SWIG_2(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_3")]
  public static extern IntPtr new_XMLOutputStream__SWIG_3(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_4")]
  public static extern IntPtr new_XMLOutputStream__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLOutputStream")]
  public static extern void delete_XMLOutputStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_endElement__SWIG_0")]
  public static extern void XMLOutputStream_endElement__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_endElement__SWIG_1")]
  public static extern void XMLOutputStream_endElement__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_endElement__SWIG_2")]
  public static extern void XMLOutputStream_endElement__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_setAutoIndent")]
  public static extern void XMLOutputStream_setAutoIndent(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startElement__SWIG_0")]
  public static extern void XMLOutputStream_startElement__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startElement__SWIG_1")]
  public static extern void XMLOutputStream_startElement__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startElement__SWIG_2")]
  public static extern void XMLOutputStream_startElement__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startEndElement__SWIG_0")]
  public static extern void XMLOutputStream_startEndElement__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startEndElement__SWIG_1")]
  public static extern void XMLOutputStream_startEndElement__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startEndElement__SWIG_2")]
  public static extern void XMLOutputStream_startEndElement__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_0")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_1")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_1(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_2")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_2(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_6")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_6(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_7")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_7(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_8")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_8(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_9")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_9(HandleRef jarg1, string jarg2, double jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_10")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_10(HandleRef jarg1, string jarg2, string jarg3, double jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_11")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_11(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_12")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_12(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_13")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_13(HandleRef jarg1, string jarg2, string jarg3, int jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_14")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_14(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_18")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_18(HandleRef jarg1, string jarg2, string jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeXMLDecl")]
  public static extern void XMLOutputStream_writeXMLDecl(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeComment__SWIG_0")]
  public static extern void XMLOutputStream_writeComment__SWIG_0(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeComment__SWIG_1")]
  public static extern void XMLOutputStream_writeComment__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_downIndent")]
  public static extern void XMLOutputStream_downIndent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_upIndent")]
  public static extern void XMLOutputStream_upIndent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_getSBMLNamespaces")]
  public static extern IntPtr XMLOutputStream_getSBMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_setSBMLNamespaces")]
  public static extern void XMLOutputStream_setSBMLNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_getWriteComment")]
  public static extern bool XMLOutputStream_getWriteComment();

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_setWriteComment")]
  public static extern void XMLOutputStream_setWriteComment(bool jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_getWriteTimestamp")]
  public static extern bool XMLOutputStream_getWriteTimestamp();

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_setWriteTimestamp")]
  public static extern void XMLOutputStream_setWriteTimestamp(bool jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_getLibraryName")]
  public static extern string XMLOutputStream_getLibraryName();

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_setLibraryName")]
  public static extern void XMLOutputStream_setLibraryName(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_getLibraryVersion")]
  public static extern string XMLOutputStream_getLibraryVersion();

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_setLibraryVersion")]
  public static extern void XMLOutputStream_setLibraryVersion(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputStringStream__SWIG_0")]
  public static extern IntPtr new_XMLOwningOutputStringStream__SWIG_0(string jarg1, bool jarg2, string jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputStringStream__SWIG_1")]
  public static extern IntPtr new_XMLOwningOutputStringStream__SWIG_1(string jarg1, bool jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputStringStream__SWIG_2")]
  public static extern IntPtr new_XMLOwningOutputStringStream__SWIG_2(string jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputStringStream__SWIG_3")]
  public static extern IntPtr new_XMLOwningOutputStringStream__SWIG_3(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputStringStream__SWIG_4")]
  public static extern IntPtr new_XMLOwningOutputStringStream__SWIG_4();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLOwningOutputStringStream")]
  public static extern void delete_XMLOwningOutputStringStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputFileStream__SWIG_0")]
  public static extern IntPtr new_XMLOwningOutputFileStream__SWIG_0(string jarg1, string jarg2, bool jarg3, string jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputFileStream__SWIG_1")]
  public static extern IntPtr new_XMLOwningOutputFileStream__SWIG_1(string jarg1, string jarg2, bool jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputFileStream__SWIG_2")]
  public static extern IntPtr new_XMLOwningOutputFileStream__SWIG_2(string jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputFileStream__SWIG_3")]
  public static extern IntPtr new_XMLOwningOutputFileStream__SWIG_3(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOwningOutputFileStream__SWIG_4")]
  public static extern IntPtr new_XMLOwningOutputFileStream__SWIG_4(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLOwningOutputFileStream")]
  public static extern void delete_XMLOwningOutputFileStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLInputStream__SWIG_0")]
  public static extern IntPtr new_XMLInputStream__SWIG_0(string jarg1, bool jarg2, string jarg3, HandleRef jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLInputStream__SWIG_1")]
  public static extern IntPtr new_XMLInputStream__SWIG_1(string jarg1, bool jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLInputStream__SWIG_2")]
  public static extern IntPtr new_XMLInputStream__SWIG_2(string jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLInputStream__SWIG_3")]
  public static extern IntPtr new_XMLInputStream__SWIG_3(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLInputStream")]
  public static extern void delete_XMLInputStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_getEncoding")]
  public static extern string XMLInputStream_getEncoding(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_getVersion")]
  public static extern string XMLInputStream_getVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_getErrorLog")]
  public static extern IntPtr XMLInputStream_getErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_isEOF")]
  public static extern bool XMLInputStream_isEOF(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_isError")]
  public static extern bool XMLInputStream_isError(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_isGood")]
  public static extern bool XMLInputStream_isGood(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_next")]
  public static extern IntPtr XMLInputStream_next(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_peek")]
  public static extern IntPtr XMLInputStream_peek(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_skipPastEnd")]
  public static extern void XMLInputStream_skipPastEnd(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_skipText")]
  public static extern void XMLInputStream_skipText(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_setErrorLog")]
  public static extern int XMLInputStream_setErrorLog(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_toString")]
  public static extern string XMLInputStream_toString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_getSBMLNamespaces")]
  public static extern IntPtr XMLInputStream_getSBMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_setSBMLNamespaces")]
  public static extern void XMLInputStream_setSBMLNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_determineNumberChildren__SWIG_0")]
  public static extern uint XMLInputStream_determineNumberChildren__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_determineNumberChildren__SWIG_1")]
  public static extern uint XMLInputStream_determineNumberChildren__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_determineNumSpecificChildren")]
  public static extern uint XMLInputStream_determineNumSpecificChildren(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_containsChild")]
  public static extern bool XMLInputStream_containsChild(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_0")]
  public static extern IntPtr new_XMLError__SWIG_0(int jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_1")]
  public static extern IntPtr new_XMLError__SWIG_1(int jarg1, string jarg2, long jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_2")]
  public static extern IntPtr new_XMLError__SWIG_2(int jarg1, string jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_3")]
  public static extern IntPtr new_XMLError__SWIG_3(int jarg1, string jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_4")]
  public static extern IntPtr new_XMLError__SWIG_4(int jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_5")]
  public static extern IntPtr new_XMLError__SWIG_5(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_6")]
  public static extern IntPtr new_XMLError__SWIG_6();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_7")]
  public static extern IntPtr new_XMLError__SWIG_7(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLError")]
  public static extern void delete_XMLError(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getErrorId")]
  public static extern uint XMLError_getErrorId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getMessage")]
  public static extern string XMLError_getMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getShortMessage")]
  public static extern string XMLError_getShortMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getLine")]
  public static extern uint XMLError_getLine(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getColumn")]
  public static extern uint XMLError_getColumn(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getSeverity")]
  public static extern uint XMLError_getSeverity(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getSeverityAsString")]
  public static extern string XMLError_getSeverityAsString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getCategory")]
  public static extern uint XMLError_getCategory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getCategoryAsString")]
  public static extern string XMLError_getCategoryAsString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isInfo")]
  public static extern bool XMLError_isInfo(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isWarning")]
  public static extern bool XMLError_isWarning(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isError")]
  public static extern bool XMLError_isError(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isFatal")]
  public static extern bool XMLError_isFatal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isInternal")]
  public static extern bool XMLError_isInternal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isSystem")]
  public static extern bool XMLError_isSystem(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isXML")]
  public static extern bool XMLError_isXML(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isValid")]
  public static extern bool XMLError_isValid(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_setLine")]
  public static extern int XMLError_setLine(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_setColumn")]
  public static extern int XMLError_setColumn(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getStandardMessage")]
  public static extern string XMLError_getStandardMessage(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getPackage")]
  public static extern string XMLError_getPackage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getErrorIdOffset")]
  public static extern uint XMLError_getErrorIdOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_getNumErrors")]
  public static extern uint XMLErrorLog_getNumErrors(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_getError")]
  public static extern IntPtr XMLErrorLog_getError(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_clearLog")]
  public static extern void XMLErrorLog_clearLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLErrorLog__SWIG_0")]
  public static extern IntPtr new_XMLErrorLog__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLErrorLog__SWIG_1")]
  public static extern IntPtr new_XMLErrorLog__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLErrorLog")]
  public static extern void delete_XMLErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_add__SWIG_0")]
  public static extern void XMLErrorLog_add__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_add__SWIG_1")]
  public static extern void XMLErrorLog_add__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_toString")]
  public static extern string XMLErrorLog_toString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_printErrors__SWIG_0")]
  public static extern void XMLErrorLog_printErrors__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_printErrors__SWIG_1")]
  public static extern void XMLErrorLog_printErrors__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_printErrors__SWIG_2")]
  public static extern void XMLErrorLog_printErrors__SWIG_2(HandleRef jarg1, HandleRef jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_isSeverityOverridden")]
  public static extern bool XMLErrorLog_isSeverityOverridden(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_unsetSeverityOverride")]
  public static extern void XMLErrorLog_unsetSeverityOverride(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_getSeverityOverride")]
  public static extern int XMLErrorLog_getSeverityOverride(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_setSeverityOverride")]
  public static extern void XMLErrorLog_setSeverityOverride(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_changeErrorSeverity__SWIG_0")]
  public static extern void XMLErrorLog_changeErrorSeverity__SWIG_0(HandleRef jarg1, int jarg2, int jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_changeErrorSeverity__SWIG_1")]
  public static extern void XMLErrorLog_changeErrorSeverity__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_getError")]
  public static extern IntPtr SBMLErrorLog_getError(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_getErrorWithSeverity")]
  public static extern IntPtr SBMLErrorLog_getErrorWithSeverity(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_getNumFailsWithSeverity__SWIG_0")]
  public static extern uint SBMLErrorLog_getNumFailsWithSeverity__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLErrorLog__SWIG_0")]
  public static extern IntPtr new_SBMLErrorLog__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLErrorLog__SWIG_1")]
  public static extern IntPtr new_SBMLErrorLog__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLErrorLog")]
  public static extern void delete_SBMLErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_0")]
  public static extern void SBMLErrorLog_logError__SWIG_0(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7, long jarg8, long jarg9);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_1")]
  public static extern void SBMLErrorLog_logError__SWIG_1(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7, long jarg8);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_2")]
  public static extern void SBMLErrorLog_logError__SWIG_2(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_3")]
  public static extern void SBMLErrorLog_logError__SWIG_3(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_4")]
  public static extern void SBMLErrorLog_logError__SWIG_4(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_5")]
  public static extern void SBMLErrorLog_logError__SWIG_5(HandleRef jarg1, long jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_6")]
  public static extern void SBMLErrorLog_logError__SWIG_6(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_7")]
  public static extern void SBMLErrorLog_logError__SWIG_7(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_8")]
  public static extern void SBMLErrorLog_logError__SWIG_8(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_0")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_0(HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7, long jarg8, long jarg9, long jarg10, long jarg11);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_1")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_1(HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7, long jarg8, long jarg9, long jarg10);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_2")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_2(HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7, long jarg8, long jarg9);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_3")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_3(HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7, long jarg8);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_4")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_4(HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6, string jarg7);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_5")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_5(HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_6")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_6(HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_7")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_7(HandleRef jarg1, string jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_8")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_8(HandleRef jarg1, string jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_9")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_9(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logPackageError__SWIG_10")]
  public static extern void SBMLErrorLog_logPackageError__SWIG_10(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_add")]
  public static extern void SBMLErrorLog_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_remove")]
  public static extern void SBMLErrorLog_remove(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_removeAll")]
  public static extern void SBMLErrorLog_removeAll(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_contains")]
  public static extern bool SBMLErrorLog_contains(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_0")]
  public static extern IntPtr new_SBMLError__SWIG_0(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7, long jarg8, string jarg9, long jarg10);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_1")]
  public static extern IntPtr new_SBMLError__SWIG_1(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7, long jarg8, string jarg9);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_2")]
  public static extern IntPtr new_SBMLError__SWIG_2(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7, long jarg8);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_3")]
  public static extern IntPtr new_SBMLError__SWIG_3(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_4")]
  public static extern IntPtr new_SBMLError__SWIG_4(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_5")]
  public static extern IntPtr new_SBMLError__SWIG_5(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_6")]
  public static extern IntPtr new_SBMLError__SWIG_6(long jarg1, long jarg2, long jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_7")]
  public static extern IntPtr new_SBMLError__SWIG_7(long jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_8")]
  public static extern IntPtr new_SBMLError__SWIG_8(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_9")]
  public static extern IntPtr new_SBMLError__SWIG_9(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_10")]
  public static extern IntPtr new_SBMLError__SWIG_10();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_11")]
  public static extern IntPtr new_SBMLError__SWIG_11(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLError")]
  public static extern void delete_SBMLError(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTerm__SWIG_0")]
  public static extern IntPtr new_CVTerm__SWIG_0(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTerm__SWIG_1")]
  public static extern IntPtr new_CVTerm__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTerm__SWIG_2")]
  public static extern IntPtr new_CVTerm__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_CVTerm")]
  public static extern void delete_CVTerm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTerm__SWIG_3")]
  public static extern IntPtr new_CVTerm__SWIG_3(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_clone")]
  public static extern IntPtr CVTerm_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getQualifierType__SWIG_0")]
  public static extern int CVTerm_getQualifierType__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getModelQualifierType__SWIG_0")]
  public static extern int CVTerm_getModelQualifierType__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getBiologicalQualifierType__SWIG_0")]
  public static extern int CVTerm_getBiologicalQualifierType__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getResources__SWIG_0")]
  public static extern IntPtr CVTerm_getResources__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getNumResources__SWIG_0")]
  public static extern uint CVTerm_getNumResources__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getResourceURI__SWIG_0")]
  public static extern string CVTerm_getResourceURI__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_setQualifierType")]
  public static extern int CVTerm_setQualifierType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_setModelQualifierType__SWIG_0")]
  public static extern int CVTerm_setModelQualifierType__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_setBiologicalQualifierType__SWIG_0")]
  public static extern int CVTerm_setBiologicalQualifierType__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_setModelQualifierType__SWIG_1")]
  public static extern int CVTerm_setModelQualifierType__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_setBiologicalQualifierType__SWIG_1")]
  public static extern int CVTerm_setBiologicalQualifierType__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_addResource")]
  public static extern int CVTerm_addResource(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_removeResource")]
  public static extern int CVTerm_removeResource(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_hasRequiredAttributes__SWIG_0")]
  public static extern bool CVTerm_hasRequiredAttributes__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_hasBeenModified")]
  public static extern bool CVTerm_hasBeenModified(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_resetModifiedFlags")]
  public static extern void CVTerm_resetModifiedFlags(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getNumNestedCVTerms")]
  public static extern uint CVTerm_getNumNestedCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getNestedCVTerm__SWIG_0")]
  public static extern IntPtr CVTerm_getNestedCVTerm__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getListNestedCVTerms__SWIG_0")]
  public static extern IntPtr CVTerm_getListNestedCVTerms__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_addNestedCVTerm")]
  public static extern int CVTerm_addNestedCVTerm(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_removeNestedCVTerm")]
  public static extern IntPtr CVTerm_removeNestedCVTerm(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelQualifierType_toString")]
  public static extern string ModelQualifierType_toString(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_BiolQualifierType_toString")]
  public static extern string BiolQualifierType_toString(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelQualifierType_fromString")]
  public static extern int ModelQualifierType_fromString(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_BiolQualifierType_fromString")]
  public static extern int BiolQualifierType_fromString(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_0")]
  public static extern IntPtr new_Date__SWIG_0(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7, long jarg8, long jarg9);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_1")]
  public static extern IntPtr new_Date__SWIG_1(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7, long jarg8);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_2")]
  public static extern IntPtr new_Date__SWIG_2(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_3")]
  public static extern IntPtr new_Date__SWIG_3(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_4")]
  public static extern IntPtr new_Date__SWIG_4(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_5")]
  public static extern IntPtr new_Date__SWIG_5(long jarg1, long jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_6")]
  public static extern IntPtr new_Date__SWIG_6(long jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_7")]
  public static extern IntPtr new_Date__SWIG_7(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_8")]
  public static extern IntPtr new_Date__SWIG_8(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_9")]
  public static extern IntPtr new_Date__SWIG_9();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_10")]
  public static extern IntPtr new_Date__SWIG_10(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Date")]
  public static extern void delete_Date(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_11")]
  public static extern IntPtr new_Date__SWIG_11(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_clone")]
  public static extern IntPtr Date_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getYear")]
  public static extern uint Date_getYear(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getMonth")]
  public static extern uint Date_getMonth(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getDay")]
  public static extern uint Date_getDay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getHour")]
  public static extern uint Date_getHour(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getMinute")]
  public static extern uint Date_getMinute(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getSecond")]
  public static extern uint Date_getSecond(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getSignOffset")]
  public static extern uint Date_getSignOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getHoursOffset")]
  public static extern uint Date_getHoursOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getMinutesOffset")]
  public static extern uint Date_getMinutesOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getDateAsString")]
  public static extern string Date_getDateAsString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setYear")]
  public static extern int Date_setYear(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setMonth")]
  public static extern int Date_setMonth(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setDay")]
  public static extern int Date_setDay(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setHour")]
  public static extern int Date_setHour(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setMinute")]
  public static extern int Date_setMinute(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setSecond")]
  public static extern int Date_setSecond(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setSignOffset")]
  public static extern int Date_setSignOffset(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setHoursOffset")]
  public static extern int Date_setHoursOffset(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setMinutesOffset")]
  public static extern int Date_setMinutesOffset(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setDateAsString")]
  public static extern int Date_setDateAsString(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_representsValidDate")]
  public static extern bool Date_representsValidDate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_hasBeenModified")]
  public static extern bool Date_hasBeenModified(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_resetModifiedFlags")]
  public static extern void Date_resetModifiedFlags(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelCreator__SWIG_0")]
  public static extern IntPtr new_ModelCreator__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelCreator__SWIG_1")]
  public static extern IntPtr new_ModelCreator__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ModelCreator")]
  public static extern void delete_ModelCreator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelCreator__SWIG_2")]
  public static extern IntPtr new_ModelCreator__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_clone")]
  public static extern IntPtr ModelCreator_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getFamilyName")]
  public static extern string ModelCreator_getFamilyName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getGivenName")]
  public static extern string ModelCreator_getGivenName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getEmail")]
  public static extern string ModelCreator_getEmail(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getOrganization")]
  public static extern string ModelCreator_getOrganization(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getOrganisation")]
  public static extern string ModelCreator_getOrganisation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetFamilyName")]
  public static extern bool ModelCreator_isSetFamilyName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetGivenName")]
  public static extern bool ModelCreator_isSetGivenName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetEmail")]
  public static extern bool ModelCreator_isSetEmail(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetOrganization")]
  public static extern bool ModelCreator_isSetOrganization(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetOrganisation")]
  public static extern bool ModelCreator_isSetOrganisation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setFamilyName")]
  public static extern int ModelCreator_setFamilyName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setGivenName")]
  public static extern int ModelCreator_setGivenName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setEmail")]
  public static extern int ModelCreator_setEmail(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setOrganization")]
  public static extern int ModelCreator_setOrganization(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setOrganisation")]
  public static extern int ModelCreator_setOrganisation(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetFamilyName")]
  public static extern int ModelCreator_unsetFamilyName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetGivenName")]
  public static extern int ModelCreator_unsetGivenName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetEmail")]
  public static extern int ModelCreator_unsetEmail(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetOrganization")]
  public static extern int ModelCreator_unsetOrganization(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetOrganisation")]
  public static extern int ModelCreator_unsetOrganisation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_hasRequiredAttributes")]
  public static extern bool ModelCreator_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_hasBeenModified")]
  public static extern bool ModelCreator_hasBeenModified(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_resetModifiedFlags")]
  public static extern void ModelCreator_resetModifiedFlags(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelHistory__SWIG_0")]
  public static extern IntPtr new_ModelHistory__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ModelHistory")]
  public static extern void delete_ModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelHistory__SWIG_1")]
  public static extern IntPtr new_ModelHistory__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_clone")]
  public static extern IntPtr ModelHistory_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getCreatedDate")]
  public static extern IntPtr ModelHistory_getCreatedDate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getModifiedDate__SWIG_0")]
  public static extern IntPtr ModelHistory_getModifiedDate__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_isSetCreatedDate")]
  public static extern bool ModelHistory_isSetCreatedDate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_isSetModifiedDate")]
  public static extern bool ModelHistory_isSetModifiedDate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_setCreatedDate")]
  public static extern int ModelHistory_setCreatedDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_setModifiedDate")]
  public static extern int ModelHistory_setModifiedDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_addModifiedDate")]
  public static extern int ModelHistory_addModifiedDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getListModifiedDates")]
  public static extern IntPtr ModelHistory_getListModifiedDates(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getModifiedDate__SWIG_1")]
  public static extern IntPtr ModelHistory_getModifiedDate__SWIG_1(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getNumModifiedDates")]
  public static extern uint ModelHistory_getNumModifiedDates(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_addCreator")]
  public static extern int ModelHistory_addCreator(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getListCreators")]
  public static extern IntPtr ModelHistory_getListCreators(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getCreator")]
  public static extern IntPtr ModelHistory_getCreator(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getNumCreators")]
  public static extern uint ModelHistory_getNumCreators(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_hasRequiredAttributes")]
  public static extern bool ModelHistory_hasRequiredAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_hasBeenModified")]
  public static extern bool ModelHistory_hasBeenModified(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_resetModifiedFlags")]
  public static extern void ModelHistory_resetModifiedFlags(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseRDFAnnotation__SWIG_0")]
  public static extern IntPtr RDFAnnotationParser_parseRDFAnnotation__SWIG_0(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseRDFAnnotation__SWIG_1")]
  public static extern IntPtr RDFAnnotationParser_parseRDFAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseRDFAnnotation__SWIG_2")]
  public static extern IntPtr RDFAnnotationParser_parseRDFAnnotation__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createAnnotation")]
  public static extern IntPtr RDFAnnotationParser_createAnnotation();

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createRDFAnnotation__SWIG_0")]
  public static extern IntPtr RDFAnnotationParser_createRDFAnnotation__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createRDFAnnotation__SWIG_1")]
  public static extern IntPtr RDFAnnotationParser_createRDFAnnotation__SWIG_1(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createRDFAnnotation__SWIG_2")]
  public static extern IntPtr RDFAnnotationParser_createRDFAnnotation__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createCVTerms")]
  public static extern IntPtr RDFAnnotationParser_createCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseCVTerms")]
  public static extern IntPtr RDFAnnotationParser_parseCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseModelHistory")]
  public static extern IntPtr RDFAnnotationParser_parseModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseOnlyModelHistory")]
  public static extern IntPtr RDFAnnotationParser_parseOnlyModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_deleteRDFAnnotation")]
  public static extern IntPtr RDFAnnotationParser_deleteRDFAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_deleteRDFHistoryAnnotation")]
  public static extern IntPtr RDFAnnotationParser_deleteRDFHistoryAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_deleteRDFCVTermAnnotation")]
  public static extern IntPtr RDFAnnotationParser_deleteRDFCVTermAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseRDFAnnotation__SWIG_3")]
  public static extern void RDFAnnotationParser_parseRDFAnnotation__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseRDFAnnotation__SWIG_4")]
  public static extern void RDFAnnotationParser_parseRDFAnnotation__SWIG_4(HandleRef jarg1, HandleRef jarg2, string jarg3, HandleRef jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseRDFAnnotation__SWIG_5")]
  public static extern void RDFAnnotationParser_parseRDFAnnotation__SWIG_5(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RDFAnnotationParser")]
  public static extern IntPtr new_RDFAnnotationParser();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_RDFAnnotationParser")]
  public static extern void delete_RDFAnnotationParser(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ISBMLExtensionNamespaces")]
  public static extern void delete_ISBMLExtensionNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ISBMLExtensionNamespaces_getURI")]
  public static extern string ISBMLExtensionNamespaces_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ISBMLExtensionNamespaces_getPackageVersion")]
  public static extern uint ISBMLExtensionNamespaces_getPackageVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ISBMLExtensionNamespaces_getPackageName")]
  public static extern string ISBMLExtensionNamespaces_getPackageName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ISBMLExtensionNamespaces_setPackageVersion")]
  public static extern void ISBMLExtensionNamespaces_setPackageVersion(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBaseExtensionPoint__SWIG_0")]
  public static extern IntPtr new_SBaseExtensionPoint__SWIG_0(string jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBaseExtensionPoint__SWIG_1")]
  public static extern IntPtr new_SBaseExtensionPoint__SWIG_1(string jarg1, int jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBaseExtensionPoint__SWIG_2")]
  public static extern IntPtr new_SBaseExtensionPoint__SWIG_2(string jarg1, int jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBaseExtensionPoint")]
  public static extern void delete_SBaseExtensionPoint(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBaseExtensionPoint__SWIG_3")]
  public static extern IntPtr new_SBaseExtensionPoint__SWIG_3(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseExtensionPoint_clone")]
  public static extern IntPtr SBaseExtensionPoint_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseExtensionPoint_getPackageName")]
  public static extern string SBaseExtensionPoint_getPackageName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseExtensionPoint_getTypeCode")]
  public static extern int SBaseExtensionPoint_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseExtensionPoint_getElementName")]
  public static extern string SBaseExtensionPoint_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBaseExtensionPoint_isElementOnly")]
  public static extern bool SBaseExtensionPoint_isElementOnly(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBasePlugin")]
  public static extern void delete_SBasePlugin(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getElementNamespace")]
  public static extern string SBasePlugin_getElementNamespace(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getPrefix")]
  public static extern string SBasePlugin_getPrefix(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getPackageName")]
  public static extern string SBasePlugin_getPackageName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_clone")]
  public static extern IntPtr SBasePlugin_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getElementBySId")]
  public static extern IntPtr SBasePlugin_getElementBySId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getElementByMetaId")]
  public static extern IntPtr SBasePlugin_getElementByMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_connectToParent")]
  public static extern void SBasePlugin_connectToParent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_enablePackageInternal")]
  public static extern void SBasePlugin_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_stripPackage")]
  public static extern bool SBasePlugin_stripPackage(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getSBMLDocument__SWIG_0")]
  public static extern IntPtr SBasePlugin_getSBMLDocument__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getURI")]
  public static extern string SBasePlugin_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getParentSBMLObject__SWIG_0")]
  public static extern IntPtr SBasePlugin_getParentSBMLObject__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_setElementNamespace")]
  public static extern int SBasePlugin_setElementNamespace(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getLevel")]
  public static extern uint SBasePlugin_getLevel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getVersion")]
  public static extern uint SBasePlugin_getVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getPackageVersion")]
  public static extern uint SBasePlugin_getPackageVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_replaceSIDWithFunction")]
  public static extern void SBasePlugin_replaceSIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_divideAssignmentsToSIdByFunction")]
  public static extern void SBasePlugin_divideAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_multiplyAssignmentsToSIdByFunction")]
  public static extern void SBasePlugin_multiplyAssignmentsToSIdByFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_hasIdentifierBeginningWith")]
  public static extern bool SBasePlugin_hasIdentifierBeginningWith(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_prependStringToAllIdentifiers")]
  public static extern int SBasePlugin_prependStringToAllIdentifiers(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_renameSIdRefs")]
  public static extern void SBasePlugin_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_renameMetaIdRefs")]
  public static extern void SBasePlugin_renameMetaIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_renameUnitSIdRefs")]
  public static extern void SBasePlugin_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_transformIdentifiers")]
  public static extern int SBasePlugin_transformIdentifiers(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getLine")]
  public static extern uint SBasePlugin_getLine(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getColumn")]
  public static extern uint SBasePlugin_getColumn(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getSBMLNamespaces")]
  public static extern IntPtr SBasePlugin_getSBMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_logUnknownElement")]
  public static extern void SBasePlugin_logUnknownElement(HandleRef jarg1, string jarg2, long jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_isValidTypeForList")]
  public static extern bool SBasePlugin_isValidTypeForList(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getSBMLExtension")]
  public static extern IntPtr SBasePlugin_getSBMLExtension(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getListOfAllElements__SWIG_0")]
  public static extern IntPtr SBasePlugin_getListOfAllElements__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBasePlugin_getListOfAllElements__SWIG_1")]
  public static extern IntPtr SBasePlugin_getListOfAllElements__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocumentPlugin__SWIG_0")]
  public static extern IntPtr new_SBMLDocumentPlugin__SWIG_0(string jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocumentPlugin__SWIG_1")]
  public static extern IntPtr new_SBMLDocumentPlugin__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLDocumentPlugin")]
  public static extern void delete_SBMLDocumentPlugin(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentPlugin_clone")]
  public static extern IntPtr SBMLDocumentPlugin_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentPlugin_setRequired")]
  public static extern int SBMLDocumentPlugin_setRequired(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentPlugin_getRequired")]
  public static extern bool SBMLDocumentPlugin_getRequired(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentPlugin_isSetRequired")]
  public static extern bool SBMLDocumentPlugin_isSetRequired(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentPlugin_unsetRequired")]
  public static extern int SBMLDocumentPlugin_unsetRequired(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentPlugin_isCompFlatteningImplemented")]
  public static extern bool SBMLDocumentPlugin_isCompFlatteningImplemented(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentPlugin_checkConsistency")]
  public static extern uint SBMLDocumentPlugin_checkConsistency(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLExtension")]
  public static extern void delete_SBMLExtension(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getNumOfSBasePlugins")]
  public static extern int SBMLExtension_getNumOfSBasePlugins(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getNumOfSupportedPackageURI")]
  public static extern uint SBMLExtension_getNumOfSupportedPackageURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_isSupported")]
  public static extern bool SBMLExtension_isSupported(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getSupportedPackageURI")]
  public static extern string SBMLExtension_getSupportedPackageURI(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_clone")]
  public static extern IntPtr SBMLExtension_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getName")]
  public static extern string SBMLExtension_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getURI")]
  public static extern string SBMLExtension_getURI(HandleRef jarg1, long jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getLevel")]
  public static extern uint SBMLExtension_getLevel(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getVersion")]
  public static extern uint SBMLExtension_getVersion(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getPackageVersion")]
  public static extern uint SBMLExtension_getPackageVersion(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getStringFromTypeCode")]
  public static extern string SBMLExtension_getStringFromTypeCode(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getSBMLExtensionNamespaces")]
  public static extern IntPtr SBMLExtension_getSBMLExtensionNamespaces(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_setEnabled")]
  public static extern bool SBMLExtension_setEnabled(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_isEnabled")]
  public static extern bool SBMLExtension_isEnabled(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_removeL2Namespaces")]
  public static extern void SBMLExtension_removeL2Namespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_addL2Namespaces")]
  public static extern void SBMLExtension_addL2Namespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_enableL2NamespaceForDocument")]
  public static extern void SBMLExtension_enableL2NamespaceForDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_isInUse")]
  public static extern bool SBMLExtension_isInUse(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_hasMultipleVersions")]
  public static extern bool SBMLExtension_hasMultipleVersions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getErrorTableIndex")]
  public static extern uint SBMLExtension_getErrorTableIndex(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getErrorIdOffset")]
  public static extern uint SBMLExtension_getErrorIdOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getSeverity")]
  public static extern uint SBMLExtension_getSeverity(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getCategory")]
  public static extern uint SBMLExtension_getCategory(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getMessage")]
  public static extern string SBMLExtension_getMessage(HandleRef jarg1, long jarg2, long jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtension_getShortMessage")]
  public static extern string SBMLExtension_getShortMessage(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLExtensionException")]
  public static extern IntPtr new_SBMLExtensionException(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLExtensionException")]
  public static extern void delete_SBMLExtensionException(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_getInstance")]
  public static extern IntPtr SBMLExtensionRegistry_getInstance();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_addExtension")]
  public static extern int SBMLExtensionRegistry_addExtension(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_getExtension")]
  public static extern IntPtr SBMLExtensionRegistry_getExtension(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_removeL2Namespaces")]
  public static extern void SBMLExtensionRegistry_removeL2Namespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_addL2Namespaces")]
  public static extern void SBMLExtensionRegistry_addL2Namespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_enableL2NamespaceForDocument")]
  public static extern void SBMLExtensionRegistry_enableL2NamespaceForDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_disableUnusedPackages")]
  public static extern void SBMLExtensionRegistry_disableUnusedPackages(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_disablePackage")]
  public static extern void SBMLExtensionRegistry_disablePackage(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_isPackageEnabled")]
  public static extern bool SBMLExtensionRegistry_isPackageEnabled(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_enablePackage")]
  public static extern void SBMLExtensionRegistry_enablePackage(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_getNumExtension")]
  public static extern uint SBMLExtensionRegistry_getNumExtension(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_setEnabled")]
  public static extern bool SBMLExtensionRegistry_setEnabled(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_isEnabled")]
  public static extern bool SBMLExtensionRegistry_isEnabled(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_isRegistered")]
  public static extern bool SBMLExtensionRegistry_isRegistered(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_getAllRegisteredPackageNames")]
  public static extern IntPtr SBMLExtensionRegistry_getAllRegisteredPackageNames();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_getNumRegisteredPackages")]
  public static extern uint SBMLExtensionRegistry_getNumRegisteredPackages();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExtensionRegistry_getRegisteredPackageName")]
  public static extern string SBMLExtensionRegistry_getRegisteredPackageName(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsNumber")]
  public static extern bool representsNumber(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsFunction__SWIG_0")]
  public static extern bool representsFunction__SWIG_0(int jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsFunction__SWIG_1")]
  public static extern bool representsFunction__SWIG_1(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsUnaryFunction__SWIG_0")]
  public static extern bool representsUnaryFunction__SWIG_0(int jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsUnaryFunction__SWIG_1")]
  public static extern bool representsUnaryFunction__SWIG_1(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsBinaryFunction__SWIG_0")]
  public static extern bool representsBinaryFunction__SWIG_0(int jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsBinaryFunction__SWIG_1")]
  public static extern bool representsBinaryFunction__SWIG_1(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsNaryFunction__SWIG_0")]
  public static extern bool representsNaryFunction__SWIG_0(int jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsNaryFunction__SWIG_1")]
  public static extern bool representsNaryFunction__SWIG_1(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsQualifier__SWIG_0")]
  public static extern bool representsQualifier__SWIG_0(int jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsQualifier__SWIG_1")]
  public static extern bool representsQualifier__SWIG_1(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_representsFunctionRequiringAtLeastTwoArguments")]
  public static extern bool representsFunctionRequiringAtLeastTwoArguments(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_getCoreTypeFromName")]
  public static extern int getCoreTypeFromName(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_getNameFromCoreType")]
  public static extern string getNameFromCoreType(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_isCoreTopLevelMathMLFunctionNodeTag")]
  public static extern bool isCoreTopLevelMathMLFunctionNodeTag(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_isCoreTopLevelMathMLNumberNodeTag")]
  public static extern bool isCoreTopLevelMathMLNumberNodeTag(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ASTBase")]
  public static extern void delete_ASTBase(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_deepCopy")]
  public static extern IntPtr ASTBase_deepCopy(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_loadASTPlugins")]
  public static extern void ASTBase_loadASTPlugins(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getType")]
  public static extern int ASTBase_getType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getExtendedType")]
  public static extern int ASTBase_getExtendedType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isSetType")]
  public static extern bool ASTBase_isSetType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_setType__SWIG_0")]
  public static extern int ASTBase_setType__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isAvogadro")]
  public static extern bool ASTBase_isAvogadro(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isBoolean")]
  public static extern bool ASTBase_isBoolean(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isBinaryFunction")]
  public static extern bool ASTBase_isBinaryFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isConstant")]
  public static extern bool ASTBase_isConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isExponential")]
  public static extern bool ASTBase_isExponential(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isCiNumber")]
  public static extern bool ASTBase_isCiNumber(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isConstantNumber")]
  public static extern bool ASTBase_isConstantNumber(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isCSymbolFunction")]
  public static extern bool ASTBase_isCSymbolFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isCSymbolNumber")]
  public static extern bool ASTBase_isCSymbolNumber(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isFunction")]
  public static extern bool ASTBase_isFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isInteger")]
  public static extern bool ASTBase_isInteger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isLambda")]
  public static extern bool ASTBase_isLambda(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isLogical")]
  public static extern bool ASTBase_isLogical(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isName")]
  public static extern bool ASTBase_isName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isNaryFunction")]
  public static extern bool ASTBase_isNaryFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isNumber")]
  public static extern bool ASTBase_isNumber(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isOperator")]
  public static extern bool ASTBase_isOperator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isPiecewise")]
  public static extern bool ASTBase_isPiecewise(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isQualifier")]
  public static extern bool ASTBase_isQualifier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isRational")]
  public static extern bool ASTBase_isRational(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isReal")]
  public static extern bool ASTBase_isReal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isRelational")]
  public static extern bool ASTBase_isRelational(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isSemantics")]
  public static extern bool ASTBase_isSemantics(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isUnaryFunction")]
  public static extern bool ASTBase_isUnaryFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isUnknown")]
  public static extern bool ASTBase_isUnknown(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isUserFunction")]
  public static extern bool ASTBase_isUserFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_representsBvar")]
  public static extern bool ASTBase_representsBvar(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_setIsBvar")]
  public static extern int ASTBase_setIsBvar(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isNumberNode")]
  public static extern bool ASTBase_isNumberNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isFunctionNode")]
  public static extern bool ASTBase_isFunctionNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isTopLevelMathMLFunctionNodeTag")]
  public static extern bool ASTBase_isTopLevelMathMLFunctionNodeTag(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isTopLevelMathMLNumberNodeTag")]
  public static extern bool ASTBase_isTopLevelMathMLNumberNodeTag(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_write")]
  public static extern void ASTBase_write(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_read__SWIG_0")]
  public static extern bool ASTBase_read__SWIG_0(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_read__SWIG_1")]
  public static extern bool ASTBase_read__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_addExpectedAttributes")]
  public static extern void ASTBase_addExpectedAttributes(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_readAttributes")]
  public static extern bool ASTBase_readAttributes(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_logError__SWIG_0")]
  public static extern void ASTBase_logError__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_logError__SWIG_1")]
  public static extern void ASTBase_logError__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_setIsChildFlag")]
  public static extern void ASTBase_setIsChildFlag(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getClass")]
  public static extern string ASTBase_getClass(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getId")]
  public static extern string ASTBase_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getStyle")]
  public static extern string ASTBase_getStyle(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getParentSBMLObject")]
  public static extern IntPtr ASTBase_getParentSBMLObject(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isSetClass")]
  public static extern bool ASTBase_isSetClass(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isSetId")]
  public static extern bool ASTBase_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isSetStyle")]
  public static extern bool ASTBase_isSetStyle(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isSetParentSBMLObject")]
  public static extern bool ASTBase_isSetParentSBMLObject(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_setClass")]
  public static extern int ASTBase_setClass(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_setId")]
  public static extern int ASTBase_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_setStyle")]
  public static extern int ASTBase_setStyle(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_unsetClass")]
  public static extern int ASTBase_unsetClass(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_unsetId")]
  public static extern int ASTBase_unsetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_unsetStyle")]
  public static extern int ASTBase_unsetStyle(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_unsetParentSBMLObject")]
  public static extern int ASTBase_unsetParentSBMLObject(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getFunction")]
  public static extern IntPtr ASTBase_getFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_addPlugin")]
  public static extern void ASTBase_addPlugin(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getPlugin__SWIG_0")]
  public static extern IntPtr ASTBase_getPlugin__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getPlugin__SWIG_2")]
  public static extern IntPtr ASTBase_getPlugin__SWIG_2(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getNumPlugins")]
  public static extern uint ASTBase_getNumPlugins(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getTypeFromName")]
  public static extern int ASTBase_getTypeFromName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getNameFromType")]
  public static extern string ASTBase_getNameFromType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isSetUserData")]
  public static extern bool ASTBase_isSetUserData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_unsetUserData")]
  public static extern int ASTBase_unsetUserData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_writeNodeOfType__SWIG_0")]
  public static extern void ASTBase_writeNodeOfType__SWIG_0(HandleRef jarg1, HandleRef jarg2, int jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_writeNodeOfType__SWIG_1")]
  public static extern void ASTBase_writeNodeOfType__SWIG_1(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isWellFormedNode")]
  public static extern bool ASTBase_isWellFormedNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_hasCorrectNumberArguments")]
  public static extern bool ASTBase_hasCorrectNumberArguments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getTypeCode")]
  public static extern int ASTBase_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getPackageName")]
  public static extern string ASTBase_getPackageName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_setPackageName")]
  public static extern int ASTBase_setPackageName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_hasCnUnits")]
  public static extern bool ASTBase_hasCnUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getUnitsPrefix")]
  public static extern string ASTBase_getUnitsPrefix(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_isPackageInfixFunction")]
  public static extern bool ASTBase_isPackageInfixFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_hasPackageOnlyInfixSyntax")]
  public static extern bool ASTBase_hasPackageOnlyInfixSyntax(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getL3PackageInfixPrecedence")]
  public static extern int ASTBase_getL3PackageInfixPrecedence(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_hasUnambiguousPackageInfixGrammar")]
  public static extern bool ASTBase_hasUnambiguousPackageInfixGrammar(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBase_getValue")]
  public static extern double ASTBase_getValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNode__SWIG_0")]
  public static extern IntPtr new_ASTNode__SWIG_0(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNode__SWIG_1")]
  public static extern IntPtr new_ASTNode__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNode__SWIG_2")]
  public static extern IntPtr new_ASTNode__SWIG_2(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNode__SWIG_3")]
  public static extern IntPtr new_ASTNode__SWIG_3(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNode__SWIG_4")]
  public static extern IntPtr new_ASTNode__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ASTNode")]
  public static extern void delete_ASTNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_freeName")]
  public static extern int ASTNode_freeName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_canonicalize")]
  public static extern bool ASTNode_canonicalize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_addChild")]
  public static extern int ASTNode_addChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_prependChild")]
  public static extern int ASTNode_prependChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_removeChild")]
  public static extern int ASTNode_removeChild(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_replaceChild__SWIG_0")]
  public static extern int ASTNode_replaceChild__SWIG_0(HandleRef jarg1, long jarg2, HandleRef jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_replaceChild__SWIG_1")]
  public static extern int ASTNode_replaceChild__SWIG_1(HandleRef jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_insertChild")]
  public static extern int ASTNode_insertChild(HandleRef jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_deepCopy")]
  public static extern IntPtr ASTNode_deepCopy(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getChild")]
  public static extern IntPtr ASTNode_getChild(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getLeftChild")]
  public static extern IntPtr ASTNode_getLeftChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getRightChild")]
  public static extern IntPtr ASTNode_getRightChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getNumChildren")]
  public static extern uint ASTNode_getNumChildren(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_addSemanticsAnnotation")]
  public static extern int ASTNode_addSemanticsAnnotation(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getNumSemanticsAnnotations")]
  public static extern uint ASTNode_getNumSemanticsAnnotations(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getSemanticsAnnotation")]
  public static extern IntPtr ASTNode_getSemanticsAnnotation(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getCharacter")]
  public static extern char ASTNode_getCharacter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getId")]
  public static extern string ASTNode_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getClass")]
  public static extern string ASTNode_getClass(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getStyle")]
  public static extern string ASTNode_getStyle(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getInteger")]
  public static extern int ASTNode_getInteger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getName")]
  public static extern string ASTNode_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getOperatorName")]
  public static extern string ASTNode_getOperatorName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getNumerator")]
  public static extern int ASTNode_getNumerator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getDenominator")]
  public static extern int ASTNode_getDenominator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getReal")]
  public static extern double ASTNode_getReal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getMantissa")]
  public static extern double ASTNode_getMantissa(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getExponent")]
  public static extern int ASTNode_getExponent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getValue")]
  public static extern double ASTNode_getValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getPrecedence")]
  public static extern int ASTNode_getPrecedence(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getType")]
  public static extern int ASTNode_getType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getExtendedType")]
  public static extern int ASTNode_getExtendedType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getUnits")]
  public static extern string ASTNode_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isAvogadro")]
  public static extern bool ASTNode_isAvogadro(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isBoolean")]
  public static extern bool ASTNode_isBoolean(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_returnsBoolean__SWIG_0")]
  public static extern bool ASTNode_returnsBoolean__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_returnsBoolean__SWIG_1")]
  public static extern bool ASTNode_returnsBoolean__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isConstant")]
  public static extern bool ASTNode_isConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isFunction")]
  public static extern bool ASTNode_isFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isInfinity")]
  public static extern bool ASTNode_isInfinity(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isInteger")]
  public static extern bool ASTNode_isInteger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isLambda")]
  public static extern bool ASTNode_isLambda(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isLog10")]
  public static extern bool ASTNode_isLog10(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isLogical")]
  public static extern bool ASTNode_isLogical(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isName")]
  public static extern bool ASTNode_isName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isNaN")]
  public static extern bool ASTNode_isNaN(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isNegInfinity")]
  public static extern bool ASTNode_isNegInfinity(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isNumber")]
  public static extern bool ASTNode_isNumber(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isOperator")]
  public static extern bool ASTNode_isOperator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isPiecewise")]
  public static extern bool ASTNode_isPiecewise(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isQualifier")]
  public static extern bool ASTNode_isQualifier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isRational")]
  public static extern bool ASTNode_isRational(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isReal")]
  public static extern bool ASTNode_isReal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isRelational")]
  public static extern bool ASTNode_isRelational(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSemantics")]
  public static extern bool ASTNode_isSemantics(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSqrt")]
  public static extern bool ASTNode_isSqrt(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isUMinus")]
  public static extern bool ASTNode_isUMinus(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isUPlus")]
  public static extern bool ASTNode_isUPlus(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_hasTypeAndNumChildren")]
  public static extern int ASTNode_hasTypeAndNumChildren(HandleRef jarg1, int jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isUnknown")]
  public static extern bool ASTNode_isUnknown(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSetId")]
  public static extern bool ASTNode_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSetClass")]
  public static extern bool ASTNode_isSetClass(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSetStyle")]
  public static extern bool ASTNode_isSetStyle(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSetUnits")]
  public static extern bool ASTNode_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_hasUnits")]
  public static extern bool ASTNode_hasUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setCharacter")]
  public static extern int ASTNode_setCharacter(HandleRef jarg1, char jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setId")]
  public static extern int ASTNode_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setClass")]
  public static extern int ASTNode_setClass(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setStyle")]
  public static extern int ASTNode_setStyle(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setName")]
  public static extern int ASTNode_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setValue__SWIG_0")]
  public static extern int ASTNode_setValue__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setValue__SWIG_1")]
  public static extern int ASTNode_setValue__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setValue__SWIG_2")]
  public static extern int ASTNode_setValue__SWIG_2(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setValue__SWIG_3")]
  public static extern int ASTNode_setValue__SWIG_3(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setType")]
  public static extern int ASTNode_setType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setUnits")]
  public static extern int ASTNode_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_swapChildren")]
  public static extern int ASTNode_swapChildren(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_renameSIdRefs")]
  public static extern void ASTNode_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_renameUnitSIdRefs")]
  public static extern void ASTNode_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_replaceIDWithFunction")]
  public static extern void ASTNode_replaceIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setIsChildFlag")]
  public static extern void ASTNode_setIsChildFlag(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_unsetUnits")]
  public static extern int ASTNode_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_unsetId")]
  public static extern int ASTNode_unsetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_unsetClass")]
  public static extern int ASTNode_unsetClass(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_unsetStyle")]
  public static extern int ASTNode_unsetStyle(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setDefinitionURL__SWIG_0")]
  public static extern int ASTNode_setDefinitionURL__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setDefinitionURL__SWIG_1")]
  public static extern int ASTNode_setDefinitionURL__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getDefinitionURL")]
  public static extern IntPtr ASTNode_getDefinitionURL(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_replaceArgument")]
  public static extern void ASTNode_replaceArgument(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getParentSBMLObject")]
  public static extern IntPtr ASTNode_getParentSBMLObject(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_unsetParentSBMLObject")]
  public static extern int ASTNode_unsetParentSBMLObject(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSetParentSBMLObject")]
  public static extern bool ASTNode_isSetParentSBMLObject(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_reduceToBinary")]
  public static extern void ASTNode_reduceToBinary(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_unsetUserData")]
  public static extern int ASTNode_unsetUserData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSetUserData")]
  public static extern bool ASTNode_isSetUserData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isWellFormedASTNode")]
  public static extern bool ASTNode_isWellFormedASTNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_hasCorrectNumberArguments")]
  public static extern bool ASTNode_hasCorrectNumberArguments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getDefinitionURLString")]
  public static extern string ASTNode_getDefinitionURLString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_representsBvar")]
  public static extern bool ASTNode_representsBvar(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_write")]
  public static extern void ASTNode_write(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_read__SWIG_0")]
  public static extern bool ASTNode_read__SWIG_0(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_read__SWIG_1")]
  public static extern bool ASTNode_read__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_writeNodeOfType__SWIG_0")]
  public static extern void ASTNode_writeNodeOfType__SWIG_0(HandleRef jarg1, HandleRef jarg2, int jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_writeNodeOfType__SWIG_1")]
  public static extern void ASTNode_writeNodeOfType__SWIG_1(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getNumBvars")]
  public static extern uint ASTNode_getNumBvars(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getTypeCode")]
  public static extern int ASTNode_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getPackageName")]
  public static extern string ASTNode_getPackageName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getPlugin__SWIG_0")]
  public static extern IntPtr ASTNode_getPlugin__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getPlugin__SWIG_2")]
  public static extern IntPtr ASTNode_getPlugin__SWIG_2(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getNumPiece")]
  public static extern uint ASTNode_getNumPiece(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getListOfNodes")]
  public static extern IntPtr ASTNode_getListOfNodes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_MathML__SWIG_0")]
  public static extern IntPtr new_MathML__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_MathML__SWIG_1")]
  public static extern IntPtr new_MathML__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_MathML")]
  public static extern void delete_MathML(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_MathML_setPrefix")]
  public static extern void MathML_setPrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_readMathMLFromString")]
  public static extern IntPtr readMathMLFromString(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_readMathMLFromStringWithNamespaces")]
  public static extern IntPtr readMathMLFromStringWithNamespaces(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_writeMathMLToString")]
  public static extern string writeMathMLToString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_parseFormula")]
  public static extern IntPtr parseFormula(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_formulaToL3String")]
  public static extern string formulaToL3String(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_formulaToL3StringWithSettings")]
  public static extern string formulaToL3StringWithSettings(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_formulaToString")]
  public static extern string formulaToString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_parseL3Formula")]
  public static extern IntPtr parseL3Formula(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_parseL3FormulaWithModel")]
  public static extern IntPtr parseL3FormulaWithModel(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_parseL3FormulaWithSettings")]
  public static extern IntPtr parseL3FormulaWithSettings(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_getDefaultL3ParserSettings")]
  public static extern IntPtr getDefaultL3ParserSettings();

  [DllImport("libsbmlcs", EntryPoint="CSharp_getLastParseL3Error")]
  public static extern string getLastParseL3Error();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBML_deleteL3Parser")]
  public static extern void SBML_deleteL3Parser();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_L3ParserSettings__SWIG_0")]
  public static extern IntPtr new_L3ParserSettings__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_L3ParserSettings__SWIG_1")]
  public static extern IntPtr new_L3ParserSettings__SWIG_1(HandleRef jarg1, int jarg2, bool jarg3, bool jarg4, bool jarg5, bool jarg6, HandleRef jarg7);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_L3ParserSettings__SWIG_2")]
  public static extern IntPtr new_L3ParserSettings__SWIG_2(HandleRef jarg1, int jarg2, bool jarg3, bool jarg4, bool jarg5, bool jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_L3ParserSettings__SWIG_3")]
  public static extern IntPtr new_L3ParserSettings__SWIG_3(HandleRef jarg1, int jarg2, bool jarg3, bool jarg4, bool jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_L3ParserSettings__SWIG_4")]
  public static extern IntPtr new_L3ParserSettings__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_L3ParserSettings")]
  public static extern void delete_L3ParserSettings(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_setModel")]
  public static extern void L3ParserSettings_setModel(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_getModel")]
  public static extern IntPtr L3ParserSettings_getModel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_unsetModel")]
  public static extern void L3ParserSettings_unsetModel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_setParseLog")]
  public static extern void L3ParserSettings_setParseLog(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_getParseLog")]
  public static extern int L3ParserSettings_getParseLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_setParseCollapseMinus")]
  public static extern void L3ParserSettings_setParseCollapseMinus(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_getParseCollapseMinus")]
  public static extern bool L3ParserSettings_getParseCollapseMinus(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_setParseUnits")]
  public static extern void L3ParserSettings_setParseUnits(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_getParseUnits")]
  public static extern bool L3ParserSettings_getParseUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_setParseAvogadroCsymbol")]
  public static extern void L3ParserSettings_setParseAvogadroCsymbol(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_getParseAvogadroCsymbol")]
  public static extern bool L3ParserSettings_getParseAvogadroCsymbol(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_setComparisonCaseSensitivity")]
  public static extern void L3ParserSettings_setComparisonCaseSensitivity(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_getComparisonCaseSensitivity")]
  public static extern bool L3ParserSettings_getComparisonCaseSensitivity(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_setPlugins")]
  public static extern void L3ParserSettings_setPlugins(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_L3ParserSettings_visitPackageInfixSyntax")]
  public static extern void L3ParserSettings_visitPackageInfixSyntax(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ASTBasePlugin")]
  public static extern void delete_ASTBasePlugin(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_clone")]
  public static extern IntPtr ASTBasePlugin_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getElementNamespace")]
  public static extern string ASTBasePlugin_getElementNamespace(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getPrefix")]
  public static extern string ASTBasePlugin_getPrefix(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getPackageName")]
  public static extern string ASTBasePlugin_getPackageName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_setSBMLExtension")]
  public static extern int ASTBasePlugin_setSBMLExtension(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_setPrefix")]
  public static extern int ASTBasePlugin_setPrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_connectToParent")]
  public static extern void ASTBasePlugin_connectToParent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_enablePackageInternal")]
  public static extern void ASTBasePlugin_enablePackageInternal(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_stripPackage")]
  public static extern bool ASTBasePlugin_stripPackage(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getURI")]
  public static extern string ASTBasePlugin_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getParentASTObject__SWIG_0")]
  public static extern IntPtr ASTBasePlugin_getParentASTObject__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_setElementNamespace")]
  public static extern int ASTBasePlugin_setElementNamespace(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getLevel")]
  public static extern uint ASTBasePlugin_getLevel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getVersion")]
  public static extern uint ASTBasePlugin_getVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getPackageVersion")]
  public static extern uint ASTBasePlugin_getPackageVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getSBMLNamespaces")]
  public static extern IntPtr ASTBasePlugin_getSBMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isSetMath")]
  public static extern bool ASTBasePlugin_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getMath")]
  public static extern IntPtr ASTBasePlugin_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_createMath")]
  public static extern void ASTBasePlugin_createMath(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_addChild")]
  public static extern int ASTBasePlugin_addChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getChild")]
  public static extern IntPtr ASTBasePlugin_getChild(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getNumChildren")]
  public static extern uint ASTBasePlugin_getNumChildren(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_insertChild")]
  public static extern int ASTBasePlugin_insertChild(HandleRef jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_prependChild")]
  public static extern int ASTBasePlugin_prependChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_removeChild")]
  public static extern int ASTBasePlugin_removeChild(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_replaceChild")]
  public static extern int ASTBasePlugin_replaceChild(HandleRef jarg1, long jarg2, HandleRef jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_swapChildren")]
  public static extern int ASTBasePlugin_swapChildren(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_read")]
  public static extern bool ASTBasePlugin_read(HandleRef jarg1, HandleRef jarg2, string jarg3, HandleRef jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_addExpectedAttributes")]
  public static extern void ASTBasePlugin_addExpectedAttributes(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, int jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_readAttributes")]
  public static extern bool ASTBasePlugin_readAttributes(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, HandleRef jarg4, HandleRef jarg5, int jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_writeAttributes")]
  public static extern void ASTBasePlugin_writeAttributes(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_writeXMLNS")]
  public static extern void ASTBasePlugin_writeXMLNS(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isNumberNode")]
  public static extern bool ASTBasePlugin_isNumberNode(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isFunctionNode")]
  public static extern bool ASTBasePlugin_isFunctionNode(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isLogical")]
  public static extern bool ASTBasePlugin_isLogical(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isConstantNumber")]
  public static extern bool ASTBasePlugin_isConstantNumber(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isCSymbolFunction")]
  public static extern bool ASTBasePlugin_isCSymbolFunction(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isCSymbolNumber")]
  public static extern bool ASTBasePlugin_isCSymbolNumber(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isName")]
  public static extern bool ASTBasePlugin_isName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isNumber")]
  public static extern bool ASTBasePlugin_isNumber(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isOperator")]
  public static extern bool ASTBasePlugin_isOperator(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isRelational")]
  public static extern bool ASTBasePlugin_isRelational(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_representsQualifier")]
  public static extern bool ASTBasePlugin_representsQualifier(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isFunction")]
  public static extern bool ASTBasePlugin_isFunction(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_representsUnaryFunction")]
  public static extern bool ASTBasePlugin_representsUnaryFunction(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_representsBinaryFunction")]
  public static extern bool ASTBasePlugin_representsBinaryFunction(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_representsNaryFunction")]
  public static extern bool ASTBasePlugin_representsNaryFunction(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_hasCorrectNumberArguments")]
  public static extern bool ASTBasePlugin_hasCorrectNumberArguments(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isWellFormedNode")]
  public static extern bool ASTBasePlugin_isWellFormedNode(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isTopLevelMathMLFunctionNodeTag")]
  public static extern bool ASTBasePlugin_isTopLevelMathMLFunctionNodeTag(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_isTopLevelMathMLNumberNodeTag")]
  public static extern bool ASTBasePlugin_isTopLevelMathMLNumberNodeTag(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getTypeFromName")]
  public static extern int ASTBasePlugin_getTypeFromName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_getNameFromType")]
  public static extern string ASTBasePlugin_getNameFromType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_renameSIdRefs")]
  public static extern void ASTBasePlugin_renameSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_renameUnitSIdRefs")]
  public static extern void ASTBasePlugin_renameUnitSIdRefs(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTBasePlugin_replaceIDWithFunction")]
  public static extern void ASTBasePlugin_replaceIDWithFunction(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_SWIGUpcast")]
  public static extern IntPtr OFStream_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStringStream_SWIGUpcast")]
  public static extern IntPtr OStringStream_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_SWIGUpcast")]
  public static extern IntPtr ListOf_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_SWIGUpcast")]
  public static extern IntPtr Model_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_SWIGUpcast")]
  public static extern IntPtr SBMLDocument_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_SWIGUpcast")]
  public static extern IntPtr FunctionDefinition_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_SWIGUpcast")]
  public static extern IntPtr ListOfFunctionDefinitions_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_SWIGUpcast")]
  public static extern IntPtr Unit_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_SWIGUpcast")]
  public static extern IntPtr ListOfUnits_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_SWIGUpcast")]
  public static extern IntPtr UnitDefinition_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_SWIGUpcast")]
  public static extern IntPtr ListOfUnitDefinitions_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_SWIGUpcast")]
  public static extern IntPtr CompartmentType_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_SWIGUpcast")]
  public static extern IntPtr ListOfCompartmentTypes_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_SWIGUpcast")]
  public static extern IntPtr SpeciesType_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_SWIGUpcast")]
  public static extern IntPtr ListOfSpeciesTypes_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_SWIGUpcast")]
  public static extern IntPtr Compartment_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_SWIGUpcast")]
  public static extern IntPtr ListOfCompartments_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_SWIGUpcast")]
  public static extern IntPtr Species_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_SWIGUpcast")]
  public static extern IntPtr ListOfSpecies_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_SWIGUpcast")]
  public static extern IntPtr Parameter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_SWIGUpcast")]
  public static extern IntPtr ListOfParameters_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_LocalParameter_SWIGUpcast")]
  public static extern IntPtr LocalParameter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfLocalParameters_SWIGUpcast")]
  public static extern IntPtr ListOfLocalParameters_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_SWIGUpcast")]
  public static extern IntPtr InitialAssignment_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_SWIGUpcast")]
  public static extern IntPtr ListOfInitialAssignments_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_SWIGUpcast")]
  public static extern IntPtr Rule_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_SWIGUpcast")]
  public static extern IntPtr ListOfRules_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AlgebraicRule_SWIGUpcast")]
  public static extern IntPtr AlgebraicRule_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AssignmentRule_SWIGUpcast")]
  public static extern IntPtr AssignmentRule_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RateRule_SWIGUpcast")]
  public static extern IntPtr RateRule_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_SWIGUpcast")]
  public static extern IntPtr Constraint_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_SWIGUpcast")]
  public static extern IntPtr ListOfConstraints_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_SWIGUpcast")]
  public static extern IntPtr Reaction_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_SWIGUpcast")]
  public static extern IntPtr ListOfReactions_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_SWIGUpcast")]
  public static extern IntPtr KineticLaw_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_SWIGUpcast")]
  public static extern IntPtr SimpleSpeciesReference_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_SWIGUpcast")]
  public static extern IntPtr SpeciesReference_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_SWIGUpcast")]
  public static extern IntPtr ListOfSpeciesReferences_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReference_SWIGUpcast")]
  public static extern IntPtr ModifierSpeciesReference_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_SWIGUpcast")]
  public static extern IntPtr Event_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_SWIGUpcast")]
  public static extern IntPtr ListOfEvents_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_SWIGUpcast")]
  public static extern IntPtr EventAssignment_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_SWIGUpcast")]
  public static extern IntPtr ListOfEventAssignments_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_SWIGUpcast")]
  public static extern IntPtr Trigger_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_SWIGUpcast")]
  public static extern IntPtr Delay_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Priority_SWIGUpcast")]
  public static extern IntPtr Priority_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_SWIGUpcast")]
  public static extern IntPtr StoichiometryMath_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLFunctionDefinitionConverter_SWIGUpcast")]
  public static extern IntPtr SBMLFunctionDefinitionConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLIdConverter_SWIGUpcast")]
  public static extern IntPtr SBMLIdConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInferUnitsConverter_SWIGUpcast")]
  public static extern IntPtr SBMLInferUnitsConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLInitialAssignmentConverter_SWIGUpcast")]
  public static extern IntPtr SBMLInitialAssignmentConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevelVersionConverter_SWIGUpcast")]
  public static extern IntPtr SBMLLevelVersionConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLevel1Version1Converter_SWIGUpcast")]
  public static extern IntPtr SBMLLevel1Version1Converter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLLocalParameterConverter_SWIGUpcast")]
  public static extern IntPtr SBMLLocalParameterConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReactionConverter_SWIGUpcast")]
  public static extern IntPtr SBMLReactionConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLRuleConverter_SWIGUpcast")]
  public static extern IntPtr SBMLRuleConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLStripPackageConverter_SWIGUpcast")]
  public static extern IntPtr SBMLStripPackageConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLUnitsConverter_SWIGUpcast")]
  public static extern IntPtr SBMLUnitsConverter_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLExternalValidator_SWIGUpcast")]
  public static extern IntPtr SBMLExternalValidator_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_SWIGUpcast")]
  public static extern IntPtr XMLNode_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_SWIGUpcast")]
  public static extern IntPtr SBMLErrorLog_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLError_SWIGUpcast")]
  public static extern IntPtr SBMLError_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ISBMLExtensionNamespaces_SWIGUpcast")]
  public static extern IntPtr ISBMLExtensionNamespaces_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentPlugin_SWIGUpcast")]
  public static extern IntPtr SBMLDocumentPlugin_SWIGUpcast(IntPtr jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_SWIGUpcast")]
  public static extern IntPtr ASTNode_SWIGUpcast(IntPtr jarg1);
}

}
