using System;
using System.Runtime.InteropServices;
 
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html Controls the behavior of the Level 3 formula parser.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * The function
 * @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings},
 * along with its variants @sbmlfunction{parseL3Formula, String} and
 * @sbmlfunction{parseL3FormulaWithModel, String\, Model},
 * are the interfaces to a parser for mathematical formulas written as
 * text strings.  The inverse function is @sbmlfunction{formulaToL3String,
 * ASTNode} and its variants such as
 * @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}.
 * The parsers and the formula writers convert between a text-string
 * representation of mathematical formulas and Abstract Syntax Trees (ASTs),
 * represented in libSBML using ASTNode objects.
 * Compared to the parser and writer implemented by the functions
 * @sbmlfunction{parseFormula, String} and
 * @sbmlfunction{formulaToString, ASTNode},
 * which were designed primarily for converting the mathematical formula
 * strings in SBML Level&nbsp;1, the SBML Level&nbsp;3 or 'L3' variants of
 * the parser and writer use an extended formula syntax.  They also have a
 * number of configurable behaviors.  This class (L3ParserSettings) is an
 * object used to communicate the configuration settings with callers.
 *
 * The following aspects of the parser are configurable using
 * L3ParserSettings objects.  (For the formula writer, only a subset of these
 * settings is relevant; please see the documentation for
 * @sbmlfunction{formulaToL3StringWithSettings, ASTNode\,
 * L3ParserSettings} for more information about which ones).
 * @li A Model object may optionally be provided to use identifiers (values
 * of type @c SId) from the model in preference to pre-defined MathML symbols
 * More precisely, the Model entities whose identifiers will shadow identical
 * symbols in the mathematical formula are: Species, Compartment, Parameter,
 * Reaction, and SpeciesReference.  For instance, if the parser is given a
 * Model containing a Species with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced by the parser will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.  Another example, if the passed-in
 * Model contains a FunctionDefinition with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * @li The function @c log with a single argument
 * (&quot;<code>log(x)</code>&quot;) can be parsed as <code>log10(x)</code>,
 * <code>ln(x)</code>, or treated as an error, as desired.
 * @li Unary minus signs can be either collapsed or preserved; that is, the
 * parser can either (1) remove sequential pairs of unary minuses (e.g.,
 * &quot;<code>- -3</code>&quot;) from the input and incorporate single unary
 * minuses into the number node, or (2) preserve all minuses in the AST node
 * structure, turning them into ASTNode objects of type
 * @link libsbml#AST_MINUS AST_MINUS@endlink.
 * @li The character sequence &quot;<code>number id</code>&quot; can be
 * interpreted as a numerical value @c number followed by units of measurement
 * indicated by @c id, or it can be treated as a syntax error.  (In
 * Level&nbsp;3, MathML <code>&lt;cn&gt;</code> elements can have an
 * attribute named @c units placed in the SBML namespace, which can be used
 * to indicate the units to be associated with the number.  The text-string
 * infix formula parser allows units to be placed after raw numbers; they are
 * interpreted as unit identifiers for units defined by the SBML
 * specification or in the containing Model object.)
 * @li The symbol @c avogadro can be parsed either as a MathML @em csymbol or
 * as a identifier.  More specifically, &quot;<code>avogadro</code>&quot; can
 * be treated as an ASTNode of type
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink or of type
 * @link libsbml#AST_NAME AST_NAME@endlink.
 * @li Strings that match built-in functions and constants can either be parsed
 * as a match regardless of capitalization, or may be required to be
 * all-lower-case to be considered a match.
 * @li LibSBML plug-ins implementing support for SBML Level&nbsp;3 packages
 * may introduce extensions to the syntax understood by the parser.  The
 * precise nature of the extensions will be documented by the individual
 * package plug-ins.  An example of a possible extension is a notation for
 * vectors and arrays, introduced by the SBML Level&nbsp;3 @em Arrays
 * package.
 *
 *
 *
 * To obtain the default configuration values, callers can use the function
 * @sbmlfunction{getDefaultL3ParserSettings,}.  To change the configuration,
 * callers can create an L3ParserSettings object, set the desired
 * characteristics using the methods provided, and pass that object to
 * @sbmlfunction{parseL3FormulaWithSettings, String formula\, L3ParserSettings settings}.
 *
 * @see @sbmlfunction{parseL3Formula, String}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{parseFormula, String}
 * @see @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * @see @sbmlfunction{formulaToL3String, ASTNode}
 * @see @sbmlfunction{formulaToString, ASTNode}
 * @see @sbmlfunction{getDefaultL3ParserSettings,}
 */

public class L3ParserSettings : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal L3ParserSettings(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(L3ParserSettings obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (L3ParserSettings obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~L3ParserSettings() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_L3ParserSettings(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  
/**
   * Creates a new L3ParserSettings object with default values.
   *
   * This is the default constructor for the L3ParserSettings object.  It
   * sets the stored Model object to @c null and sets the following
   * field values in the L3ParserSettings object:
   *
   * @li <em>parseunits</em> ('parse units') is set to
   * @link libsbml#L3P_PARSE_UNITS L3P_PARSE_UNITS@endlink.
   *
   * @li <em>collapseminus</em> ('collapse minus') is set to
   * @link libsbml#L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS@endlink.
   *
   * @li <em>parselog</em> ('parse log') is set to
   * @link libsbml#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink.
   *
   * @li <em>avocsymbol</em> ('Avogadro csymbol') is set to
   * @link libsbml#L3P_AVOGADRO_IS_CSYMBOL L3P_AVOGADRO_IS_CSYMBOL@endlink.
   *
   * @li <em>caseSensitive</em> ('case sensitive') is set to
   * @link libsbml#L3P_COMPARE_BUILTINS_CASE_INSENSITIVE L3P_COMPARE_BUILTINS_CASE_INSENSITIVE@endlink.
   *
   * @li <em>sbmlns</em> ('SBML namespaces') is set to @c null (which
   * indicates that no syntax extensions due to SBML Level&nbsp;3 packages
   * will be assumed---the formula parser will only understand the
   * core syntax described in the documentation for
   * @sbmlfunction{parseL3Formula, String}).
   */ public
 L3ParserSettings() : this(libsbmlPINVOKE.new_L3ParserSettings__SWIG_0(), true) {
  }

  
/**
   * Creates a new L3ParserSettings object with specific values for all
   * possible settings.
   *
   * @param model a Model object to be used for disambiguating identifiers
   * encountered by @sbmlfunction{parseL3FormulaWithSettings, String\,
   * L3ParserSettings} in mathematical formulas.
   *
   * @param parselog ('parse log') a flag that controls how the parser will
   * handle the symbol @c log in mathematical formulas. The function @c log
   * with a single argument (&quot;<code>log(x)</code>&quot;) can be parsed
   * as <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
   * desired, by using the parameter values
   * @link libsbml#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink,
   * @link libsbml#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink, or
   * @link libsbml#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink, respectively.
   *
   * @param collapseminus ('collapse minus') a flag that controls how the
   * parser will handle minus signs in formulas.  Unary minus signs can be
   * collapsed or preserved; that is, sequential pairs of unary minuses
   * (e.g., &quot;<code>- -3</code>&quot;) can be removed from the input
   * entirely and single unary minuses can be incorporated into the number
   * node, or all minuses can be preserved in the AST node structure.
   * The possible values of this field are
   * @link libsbml#L3P_COLLAPSE_UNARY_MINUS L3P_COLLAPSE_UNARY_MINUS@endlink (to collapse unary minuses) and
   * @link libsbml#L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS@endlink (to expand unary minuses).
   *
   * @param parseunits ('parse units') a flag that controls how the parser
   * will handle apparent references to units of measurement associated with
   * raw numbers in a formula.  If set to the value
   * @link libsbml#L3P_PARSE_UNITS L3P_PARSE_UNITS@endlink, units are parsed; if set to the value
   * @link libsbml#L3P_NO_UNITS L3P_NO_UNITS@endlink, units are not parsed.
   *
   * @param avocsymbol ('Avogadro csymbol') a flag that controls how the
   * parser will handle the appearance of the symbol @c avogadro in a
   * formula.  If set to the value @link libsbml#L3P_AVOGADRO_IS_CSYMBOL L3P_AVOGADRO_IS_CSYMBOL@endlink,
   * the symbol is interpreted as the SBML/MathML @em csymbol @c avogadro; if
   * set to the value @link libsbml#L3P_AVOGADRO_IS_NAME L3P_AVOGADRO_IS_NAME@endlink, the symbol is
   * interpreted as a plain symbol name.
   *
   * @param caseSensitive ('case sensitive') a flag that controls how the
   * cases of alphabetical characters are treated when symbols are compared.
   * If the flag is set to the value
   * @link libsbml#L3P_COMPARE_BUILTINS_CASE_INSENSITIVE L3P_COMPARE_BUILTINS_CASE_INSENSITIVE@endlink, symbols are
   * compared in a case-insensitive manner, which means that mathematical
   * functions such as @c 'sin' will be matched no matter what their case is:
   * @c 'Sin', @c 'SIN', etc.  If the flag is set to the value
   * @link libsbml#L3P_COMPARE_BUILTINS_CASE_SENSITIVE L3P_COMPARE_BUILTINS_CASE_SENSITIVE@endlink, symbols are
   * interpreted in a case-sensitive manner.
   *
   * @param sbmlns ('SBML namespaces') an SBML namespaces object.  The
   * namespaces identify the SBML Level&nbsp;3 packages that can extend the
   * syntax understood by the formula parser.  When non-@c null, the parser
   * will interpret additional syntax defined by the packages; for example,
   * it may understand vector/array extensions introduced by the SBML
   * Level&nbsp;3 @em Arrays package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   *
   * @see getModel()
   * @see setModel(@if java Model@endif)
   * @see unsetModel()
   * @see getParseLog()
   * @see setParseLog(@if java int@endif)
   * @see getParseUnits()
   * @see setParseUnits(@if java boolean@endif)
   * @see getParseCollapseMinus()
   * @see setParseCollapseMinus(@if java boolean@endif)
   * @see getParseAvogadroCsymbol()
   * @see setParseAvogadroCsymbol(@if java boolean@endif)
   */ public
 L3ParserSettings(Model model, int parselog, bool collapseminus, bool parseunits, bool avocsymbol, bool caseSensitive, SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_L3ParserSettings__SWIG_1(Model.getCPtr(model), parselog, collapseminus, parseunits, avocsymbol, caseSensitive, SBMLNamespaces.getCPtr(sbmlns)), true) {
  }

  
/**
   * Creates a new L3ParserSettings object with specific values for all
   * possible settings.
   *
   * @param model a Model object to be used for disambiguating identifiers
   * encountered by @sbmlfunction{parseL3FormulaWithSettings, String\,
   * L3ParserSettings} in mathematical formulas.
   *
   * @param parselog ('parse log') a flag that controls how the parser will
   * handle the symbol @c log in mathematical formulas. The function @c log
   * with a single argument (&quot;<code>log(x)</code>&quot;) can be parsed
   * as <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
   * desired, by using the parameter values
   * @link libsbml#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink,
   * @link libsbml#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink, or
   * @link libsbml#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink, respectively.
   *
   * @param collapseminus ('collapse minus') a flag that controls how the
   * parser will handle minus signs in formulas.  Unary minus signs can be
   * collapsed or preserved; that is, sequential pairs of unary minuses
   * (e.g., &quot;<code>- -3</code>&quot;) can be removed from the input
   * entirely and single unary minuses can be incorporated into the number
   * node, or all minuses can be preserved in the AST node structure.
   * The possible values of this field are
   * @link libsbml#L3P_COLLAPSE_UNARY_MINUS L3P_COLLAPSE_UNARY_MINUS@endlink (to collapse unary minuses) and
   * @link libsbml#L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS@endlink (to expand unary minuses).
   *
   * @param parseunits ('parse units') a flag that controls how the parser
   * will handle apparent references to units of measurement associated with
   * raw numbers in a formula.  If set to the value
   * @link libsbml#L3P_PARSE_UNITS L3P_PARSE_UNITS@endlink, units are parsed; if set to the value
   * @link libsbml#L3P_NO_UNITS L3P_NO_UNITS@endlink, units are not parsed.
   *
   * @param avocsymbol ('Avogadro csymbol') a flag that controls how the
   * parser will handle the appearance of the symbol @c avogadro in a
   * formula.  If set to the value @link libsbml#L3P_AVOGADRO_IS_CSYMBOL L3P_AVOGADRO_IS_CSYMBOL@endlink,
   * the symbol is interpreted as the SBML/MathML @em csymbol @c avogadro; if
   * set to the value @link libsbml#L3P_AVOGADRO_IS_NAME L3P_AVOGADRO_IS_NAME@endlink, the symbol is
   * interpreted as a plain symbol name.
   *
   * @param caseSensitive ('case sensitive') a flag that controls how the
   * cases of alphabetical characters are treated when symbols are compared.
   * If the flag is set to the value
   * @link libsbml#L3P_COMPARE_BUILTINS_CASE_INSENSITIVE L3P_COMPARE_BUILTINS_CASE_INSENSITIVE@endlink, symbols are
   * compared in a case-insensitive manner, which means that mathematical
   * functions such as @c 'sin' will be matched no matter what their case is:
   * @c 'Sin', @c 'SIN', etc.  If the flag is set to the value
   * @link libsbml#L3P_COMPARE_BUILTINS_CASE_SENSITIVE L3P_COMPARE_BUILTINS_CASE_SENSITIVE@endlink, symbols are
   * interpreted in a case-sensitive manner.
   *
   * @param sbmlns ('SBML namespaces') an SBML namespaces object.  The
   * namespaces identify the SBML Level&nbsp;3 packages that can extend the
   * syntax understood by the formula parser.  When non-@c null, the parser
   * will interpret additional syntax defined by the packages; for example,
   * it may understand vector/array extensions introduced by the SBML
   * Level&nbsp;3 @em Arrays package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   *
   * @see getModel()
   * @see setModel(@if java Model@endif)
   * @see unsetModel()
   * @see getParseLog()
   * @see setParseLog(@if java int@endif)
   * @see getParseUnits()
   * @see setParseUnits(@if java boolean@endif)
   * @see getParseCollapseMinus()
   * @see setParseCollapseMinus(@if java boolean@endif)
   * @see getParseAvogadroCsymbol()
   * @see setParseAvogadroCsymbol(@if java boolean@endif)
   */ public
 L3ParserSettings(Model model, int parselog, bool collapseminus, bool parseunits, bool avocsymbol, bool caseSensitive) : this(libsbmlPINVOKE.new_L3ParserSettings__SWIG_2(Model.getCPtr(model), parselog, collapseminus, parseunits, avocsymbol, caseSensitive), true) {
  }

  
/**
   * Creates a new L3ParserSettings object with specific values for all
   * possible settings.
   *
   * @param model a Model object to be used for disambiguating identifiers
   * encountered by @sbmlfunction{parseL3FormulaWithSettings, String\,
   * L3ParserSettings} in mathematical formulas.
   *
   * @param parselog ('parse log') a flag that controls how the parser will
   * handle the symbol @c log in mathematical formulas. The function @c log
   * with a single argument (&quot;<code>log(x)</code>&quot;) can be parsed
   * as <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
   * desired, by using the parameter values
   * @link libsbml#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink,
   * @link libsbml#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink, or
   * @link libsbml#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink, respectively.
   *
   * @param collapseminus ('collapse minus') a flag that controls how the
   * parser will handle minus signs in formulas.  Unary minus signs can be
   * collapsed or preserved; that is, sequential pairs of unary minuses
   * (e.g., &quot;<code>- -3</code>&quot;) can be removed from the input
   * entirely and single unary minuses can be incorporated into the number
   * node, or all minuses can be preserved in the AST node structure.
   * The possible values of this field are
   * @link libsbml#L3P_COLLAPSE_UNARY_MINUS L3P_COLLAPSE_UNARY_MINUS@endlink (to collapse unary minuses) and
   * @link libsbml#L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS@endlink (to expand unary minuses).
   *
   * @param parseunits ('parse units') a flag that controls how the parser
   * will handle apparent references to units of measurement associated with
   * raw numbers in a formula.  If set to the value
   * @link libsbml#L3P_PARSE_UNITS L3P_PARSE_UNITS@endlink, units are parsed; if set to the value
   * @link libsbml#L3P_NO_UNITS L3P_NO_UNITS@endlink, units are not parsed.
   *
   * @param avocsymbol ('Avogadro csymbol') a flag that controls how the
   * parser will handle the appearance of the symbol @c avogadro in a
   * formula.  If set to the value @link libsbml#L3P_AVOGADRO_IS_CSYMBOL L3P_AVOGADRO_IS_CSYMBOL@endlink,
   * the symbol is interpreted as the SBML/MathML @em csymbol @c avogadro; if
   * set to the value @link libsbml#L3P_AVOGADRO_IS_NAME L3P_AVOGADRO_IS_NAME@endlink, the symbol is
   * interpreted as a plain symbol name.
   *
   * @param caseSensitive ('case sensitive') a flag that controls how the
   * cases of alphabetical characters are treated when symbols are compared.
   * If the flag is set to the value
   * @link libsbml#L3P_COMPARE_BUILTINS_CASE_INSENSITIVE L3P_COMPARE_BUILTINS_CASE_INSENSITIVE@endlink, symbols are
   * compared in a case-insensitive manner, which means that mathematical
   * functions such as @c 'sin' will be matched no matter what their case is:
   * @c 'Sin', @c 'SIN', etc.  If the flag is set to the value
   * @link libsbml#L3P_COMPARE_BUILTINS_CASE_SENSITIVE L3P_COMPARE_BUILTINS_CASE_SENSITIVE@endlink, symbols are
   * interpreted in a case-sensitive manner.
   *
   * @param sbmlns ('SBML namespaces') an SBML namespaces object.  The
   * namespaces identify the SBML Level&nbsp;3 packages that can extend the
   * syntax understood by the formula parser.  When non-@c null, the parser
   * will interpret additional syntax defined by the packages; for example,
   * it may understand vector/array extensions introduced by the SBML
   * Level&nbsp;3 @em Arrays package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   *
   * @see getModel()
   * @see setModel(@if java Model@endif)
   * @see unsetModel()
   * @see getParseLog()
   * @see setParseLog(@if java int@endif)
   * @see getParseUnits()
   * @see setParseUnits(@if java boolean@endif)
   * @see getParseCollapseMinus()
   * @see setParseCollapseMinus(@if java boolean@endif)
   * @see getParseAvogadroCsymbol()
   * @see setParseAvogadroCsymbol(@if java boolean@endif)
   */ public
 L3ParserSettings(Model model, int parselog, bool collapseminus, bool parseunits, bool avocsymbol) : this(libsbmlPINVOKE.new_L3ParserSettings__SWIG_3(Model.getCPtr(model), parselog, collapseminus, parseunits, avocsymbol), true) {
  }

  
/**
   * Copy constructor.
   */ public
 L3ParserSettings(L3ParserSettings source) : this(libsbmlPINVOKE.new_L3ParserSettings__SWIG_4(L3ParserSettings.getCPtr(source)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Sets the model reference in this L3ParserSettings object.
   *
   *
 * 
 * When a Model object is provided, identifiers (values of type @c SId)
 * from that model are used in preference to pre-defined MathML symbol
 * definitions.  More precisely, the Model entities whose identifiers will
 * shadow identical symbols in the mathematical formula are: Species,
 * Compartment, Parameter, Reaction, and SpeciesReference.  For instance, if
 * the parser is given a Model containing a Species with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
 * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the construct
 * <code>&lt;pi/&gt;</code>.  Similarly, when a Model object is provided, @c
 * SId values of user-defined functions present in the Model will be used
 * preferentially over pre-defined MathML functions.  For example, if the
 * passed-in Model contains a FunctionDefinition with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 *
   *
   * @param model a Model object to be used for disambiguating identifiers.
   *
   * @warning <span class='warning'>This does @em not copy the Model object.
   * This means that modifications made to the Model after invoking this
   * method may affect parsing behavior, because the parser will query the
   * @em current contents of the model.</span>
   *
   * @see getModel()
   * @see unsetModel()
   */ public
 void setModel(Model model) {
    libsbmlPINVOKE.L3ParserSettings_setModel(swigCPtr, Model.getCPtr(model));
  }

  
/**
   * Returns the Model object referenced by this L3ParserSettings object.
   *
   *
 * 
 * When a Model object is provided, identifiers (values of type @c SId)
 * from that model are used in preference to pre-defined MathML symbol
 * definitions.  More precisely, the Model entities whose identifiers will
 * shadow identical symbols in the mathematical formula are: Species,
 * Compartment, Parameter, Reaction, and SpeciesReference.  For instance, if
 * the parser is given a Model containing a Species with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
 * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the construct
 * <code>&lt;pi/&gt;</code>.  Similarly, when a Model object is provided, @c
 * SId values of user-defined functions present in the Model will be used
 * preferentially over pre-defined MathML functions.  For example, if the
 * passed-in Model contains a FunctionDefinition with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 *
   *
   * @see setModel(@if java Model@endif)
   * @see unsetModel()
   */ public
 Model getModel() {
    IntPtr cPtr = libsbmlPINVOKE.L3ParserSettings_getModel(swigCPtr);
    Model ret = (cPtr == IntPtr.Zero) ? null : new Model(cPtr, false);
    return ret;
  }

  
/**
   * Unsets the Model reference in this L3ParserSettings object.
   *
   * The effect of calling this method is to set the stored model value
   * to @c null.
   *
   * @see setModel(@if java Model@endif)
   * @see getModel()
   */ public
 void unsetModel() {
    libsbmlPINVOKE.L3ParserSettings_unsetModel(swigCPtr);
  }

  
/**
   * Sets the behavior for handling @c log in mathematical formulas.
   *
   * The function @c log with a single argument
   * (&quot;<code>log(x)</code>&quot;) can be parsed as
   * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error.
   * These three behaviors are set, respectively, by using the value
   * @link libsbml#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink,
   * @link libsbml#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink, or
   * @link libsbml#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink
   * for the @p type parameter.
   *
   * @param type a constant, one of following three possibilities:
   * @li @link libsbml#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink
   * @li @link libsbml#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink
   * @li @link libsbml#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink
   *
   * @see getParseLog()
   */ public
 void setParseLog(int type) {
    libsbmlPINVOKE.L3ParserSettings_setParseLog(swigCPtr, type);
  }

  
/**
   * Indicates the current behavior set for handling the function @c log with
   * one argument.
   *
   * The function @c log with a single argument
   * (&quot;<code>log(x)</code>&quot;) can be parsed as
   * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
   * desired.  These three possible behaviors are indicated, respectively, by
   * the values
   * @link libsbml#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink,
   * @link libsbml#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink, and
   * @link libsbml#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink.
   *
   * @return One of following three constants:
   * @li @link libsbml#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink
   * @li @link libsbml#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink
   * @li @link libsbml#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink
   *
   * @see setParseLog(@if java int@endif)
   */ public
 int getParseLog() {
    int ret = libsbmlPINVOKE.L3ParserSettings_getParseLog(swigCPtr);
    return ret;
  }

  
/**
   * Sets the behavior for handling unary minuses appearing in mathematical
   * formulas.
   *
   *
 * 
 * This setting affects two behaviors.  First, pairs of multiple unary
 * minuses in a row (e.g., &quot;<code>- -3</code>&quot;) can be collapsed
 * and ignored in the input, or the multiple minuses can be preserved in the
 * AST node tree that is generated by the parser.  Second, minus signs in
 * front of numbers can be collapsed into the number node itself; for
 * example, a &quot;<code>- 4.1</code>&quot; can be turned into a single
 * ASTNode of type @link libsbml#AST_REAL AST_REAL@endlink with a value of
 * <code>-4.1</code>, or it can be turned into a node of type
 * @link libsbml#AST_MINUS AST_MINUS@endlink having a child node of type
 * @link libsbml#AST_REAL AST_REAL@endlink.
 *
   *
   * This method lets you tell the parser which behavior to use---either
   * collapse minuses or always preserve them.  The two possibilities are
   * represented using the following constants:
   *
   *
 * <ul>
 * <li> @link libsbml#L3P_COLLAPSE_UNARY_MINUS L3P_COLLAPSE_UNARY_MINUS@endlink (value = @c true): collapse
 * unary minuses where possible.
 * <li> @link libsbml#L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS@endlink (value = @c false): do not
 * collapse unary minuses, and instead translate each one into an AST node of
 * type @link libsbml#AST_MINUS AST_MINUS@endlink.
 * </ul>
 *
   *
   * @param collapseminus a boolean value (one of the constants
   * @link libsbml#L3P_COLLAPSE_UNARY_MINUS L3P_COLLAPSE_UNARY_MINUS@endlink or
   * @link libsbml#L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS@endlink)
   * indicating how unary minus signs in the input should be handled.
   *
   * @see getParseCollapseMinus()
   */ public
 void setParseCollapseMinus(bool collapseminus) {
    libsbmlPINVOKE.L3ParserSettings_setParseCollapseMinus(swigCPtr, collapseminus);
  }

  
/**
   * Indicates the current behavior set for handling multiple unary minuses
   * in formulas.
   *
   *
 * 
 * This setting affects two behaviors.  First, pairs of multiple unary
 * minuses in a row (e.g., &quot;<code>- -3</code>&quot;) can be collapsed
 * and ignored in the input, or the multiple minuses can be preserved in the
 * AST node tree that is generated by the parser.  Second, minus signs in
 * front of numbers can be collapsed into the number node itself; for
 * example, a &quot;<code>- 4.1</code>&quot; can be turned into a single
 * ASTNode of type @link libsbml#AST_REAL AST_REAL@endlink with a value of
 * <code>-4.1</code>, or it can be turned into a node of type
 * @link libsbml#AST_MINUS AST_MINUS@endlink having a child node of type
 * @link libsbml#AST_REAL AST_REAL@endlink.
 *
   *
   * @return A boolean indicating the behavior currently set.  The possible
   * values are as follows:
   *
 * <ul>
 * <li> @link libsbml#L3P_COLLAPSE_UNARY_MINUS L3P_COLLAPSE_UNARY_MINUS@endlink (value = @c true): collapse
 * unary minuses where possible.
 * <li> @link libsbml#L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS@endlink (value = @c false): do not
 * collapse unary minuses, and instead translate each one into an AST node of
 * type @link libsbml#AST_MINUS AST_MINUS@endlink.
 * </ul>
 *
   *
   * @see setParseCollapseMinus(@if java boolean@endif)
   */ public
 bool getParseCollapseMinus() {
    bool ret = libsbmlPINVOKE.L3ParserSettings_getParseCollapseMinus(swigCPtr);
    return ret;
  }

  
/**
   * Sets the parser's behavior in handling units associated with numbers
   * in a mathematical formula.
   *
   *
 * 
 * In SBML Level&nbsp;2, there is no means of associating a unit of
 * measurement with a pure number in a formula, while SBML Level&nbsp;3 does
 * define a syntax for this.  In Level&nbsp;3, MathML <code>&lt;cn&gt;</code>
 * elements can have an attribute named @c units placed in the SBML
 * namespace, which can be used to indicate the units to be associated with
 * the number.  The text-string infix formula parser allows units to be
 * placed after raw numbers; they are interpreted as unit identifiers for
 * units defined by the SBML specification or in the containing Model object.
 * Some examples include: &quot;<code>4 mL</code>&quot;, &quot;<code>2.01
 * Hz</code>&quot;, &quot;<code>3.1e-6 M</code>&quot;, and &quot;<code>(5/8)
 * inches</code>&quot;.  To produce a valid SBML model, there must either
 * exist a UnitDefinition corresponding to the identifier of the unit, or the
 * unit must be defined in Table&nbsp;2 of the SBML Level&nbsp;3 specification.
 *
   *
   * This method sets the formula parser's behavior with respect to units.
   *
   * @param units A boolean indicating whether to parse units.  The
   * possible values are as follows:
   *
 * <ul>
 * <li> @link libsbml#L3P_PARSE_UNITS L3P_PARSE_UNITS@endlink (value = @c true): parse units in the
 * text-string formula.
 * <li> @link libsbml#L3P_NO_UNITS L3P_NO_UNITS@endlink (value = @c false): treat units in the
 * text-string formula as errors.
 * </ul>
 *
   *
   * @see getParseUnits()
   */ public
 void setParseUnits(bool units) {
    libsbmlPINVOKE.L3ParserSettings_setParseUnits(swigCPtr, units);
  }

  
/**
   * Indicates the current behavior set for handling units in text-string
   * mathematical formulas.
   *
   *
 * 
 * In SBML Level&nbsp;2, there is no means of associating a unit of
 * measurement with a pure number in a formula, while SBML Level&nbsp;3 does
 * define a syntax for this.  In Level&nbsp;3, MathML <code>&lt;cn&gt;</code>
 * elements can have an attribute named @c units placed in the SBML
 * namespace, which can be used to indicate the units to be associated with
 * the number.  The text-string infix formula parser allows units to be
 * placed after raw numbers; they are interpreted as unit identifiers for
 * units defined by the SBML specification or in the containing Model object.
 * Some examples include: &quot;<code>4 mL</code>&quot;, &quot;<code>2.01
 * Hz</code>&quot;, &quot;<code>3.1e-6 M</code>&quot;, and &quot;<code>(5/8)
 * inches</code>&quot;.  To produce a valid SBML model, there must either
 * exist a UnitDefinition corresponding to the identifier of the unit, or the
 * unit must be defined in Table&nbsp;2 of the SBML Level&nbsp;3 specification.
 *
   *
   * Since SBML Level&nbsp;2 does not have the ability to associate units
   * with pure numbers, the value should be expected to be @c false
   * (@link libsbml#L3P_NO_UNITS L3P_NO_UNITS@endlink) when parsing text-string
   * formulas intended for use in SBML Level&nbsp;2 documents.
   *
   * @return A boolean indicating whether to parse units.  The
   * possible values are as follows:
   *
 * <ul>
 * <li> @link libsbml#L3P_PARSE_UNITS L3P_PARSE_UNITS@endlink (value = @c true): parse units in the
 * text-string formula.
 * <li> @link libsbml#L3P_NO_UNITS L3P_NO_UNITS@endlink (value = @c false): treat units in the
 * text-string formula as errors.
 * </ul>
 *
   *
   * @see setParseUnits(@if java boolean@endif)
   */ public
 bool getParseUnits() {
    bool ret = libsbmlPINVOKE.L3ParserSettings_getParseUnits(swigCPtr);
    return ret;
  }

  
/**
   * Sets the parser's behavior in handling the symbol @c avogadro in
   * mathematical formulas.
   *
   *
 * 
 * SBML Level&nbsp;3 defines a symbol for representing the value of
 * Avogadro's constant, but it is not defined in SBML Level&nbsp;2.  As a
 * result, the text-string formula parser must behave differently
 * depending on which SBML Level is being targeted.  For Level&nbsp;3
 * documents, it can interpret instances of @c avogadro in the input
 * as a reference to the MathML @em csymbol for Avogadro's constant
 * defined in the SBML Level&nbsp;3 specification.  For Level&nbsp;2,
 * it must treat @c avogadro as just another plain symbol.
 *
   *
   * This method allows callers to set the <code>avogadro</code>-handling
   * behavior in this L3ParserSettings object.  The possible values of @p
   * l2only are as follows:
   *
   *
 * <ul>
 * <li> @link libsbml#L3P_AVOGADRO_IS_CSYMBOL L3P_AVOGADRO_IS_CSYMBOL@endlink (value = @c true): tells the
 * parser to translate the string @c avogadro (in any capitalization) into an
 * AST node of type @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink.
 * <li> @link libsbml#L3P_AVOGADRO_IS_NAME L3P_AVOGADRO_IS_NAME@endlink (value = @c false): tells the
 * parser to translate the string @c avogadro into an AST of type
 * @link libsbml#AST_NAME AST_NAME@endlink.
 * </ul>
 *
   *
   * Since SBML Level&nbsp;2 does not define a symbol for Avogadro's
   * constant, the value should be set to
   * @link libsbml#L3P_AVOGADRO_IS_NAME L3P_AVOGADRO_IS_NAME@endlink when parsing text-string formulas
   * intended for use in SBML Level&nbsp;2 documents.
   *
   * @param l2only a boolean value indicating how the string @c avogadro
   * should be treated when encountered in a formula.  This will be one of
   * the values @link libsbml#L3P_AVOGADRO_IS_CSYMBOL L3P_AVOGADRO_IS_CSYMBOL@endlink or
   * @link libsbml#L3P_AVOGADRO_IS_NAME L3P_AVOGADRO_IS_NAME@endlink.
   *
   * @see getParseAvogadroCsymbol()
   */ public
 void setParseAvogadroCsymbol(bool l2only) {
    libsbmlPINVOKE.L3ParserSettings_setParseAvogadroCsymbol(swigCPtr, l2only);
  }

  
/**
   * Indicates the current behavior set for handling @c avogadro for SBML
   * Level&nbsp;3.
   *
   *
 * 
 * SBML Level&nbsp;3 defines a symbol for representing the value of
 * Avogadro's constant, but it is not defined in SBML Level&nbsp;2.  As a
 * result, the text-string formula parser must behave differently
 * depending on which SBML Level is being targeted.  For Level&nbsp;3
 * documents, it can interpret instances of @c avogadro in the input
 * as a reference to the MathML @em csymbol for Avogadro's constant
 * defined in the SBML Level&nbsp;3 specification.  For Level&nbsp;2,
 * it must treat @c avogadro as just another plain symbol.
 *
   *
   * This method returns the current setting of the
   * <code>avogadro</code>-handling behavior in this L3ParserSettings object.
   * The possible values are as follows:
   *
   *
 * <ul>
 * <li> @link libsbml#L3P_AVOGADRO_IS_CSYMBOL L3P_AVOGADRO_IS_CSYMBOL@endlink (value = @c true): tells the
 * parser to translate the string @c avogadro (in any capitalization) into an
 * AST node of type @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink.
 * <li> @link libsbml#L3P_AVOGADRO_IS_NAME L3P_AVOGADRO_IS_NAME@endlink (value = @c false): tells the
 * parser to translate the string @c avogadro into an AST of type
 * @link libsbml#AST_NAME AST_NAME@endlink.
 * </ul>
 *
   *
   * @return A boolean indicating which mode is currently set; one of
   * @link libsbml#L3P_AVOGADRO_IS_CSYMBOL L3P_AVOGADRO_IS_CSYMBOL@endlink
   * or
   * @link libsbml#L3P_AVOGADRO_IS_NAME L3P_AVOGADRO_IS_NAME@endlink.
   *
   * @see setParseAvogadroCsymbol(@if java boolean@endif)
   */ public
 bool getParseAvogadroCsymbol() {
    bool ret = libsbmlPINVOKE.L3ParserSettings_getParseAvogadroCsymbol(swigCPtr);
    return ret;
  }

  
/**
   * Sets the parser's behavior with respect to case sensitivity for
   * recognizing predefined symbols.
   *
   *
 * 
 * By default (which is the value
 * @link libsbml#L3P_COMPARE_BUILTINS_CASE_INSENSITIVE L3P_COMPARE_BUILTINS_CASE_INSENSITIVE@endlink), the parser
 * compares symbols in a case @em insensitive manner for built-in functions
 * such as @c 'sin' and @c 'piecewise', and for constants such as @c 'true'
 * and @c 'avogadro'.  Setting this option to
 * @link libsbml#L3P_COMPARE_BUILTINS_CASE_SENSITIVE L3P_COMPARE_BUILTINS_CASE_SENSITIVE@endlink causes the parser to
 * become case sensitive.  In that mode, for example, the symbols @c 'sin'
 * and @c 'true' will match the built-in values, but the symbols @c 'SIN',
 * @c 'Sin', @c 'True', @c 'TRUE', and so on, will not.
   *
   * @param strcmp a boolean indicating whether to be case sensitive (if @c
   * true) or be case insensitive (if @c false).
   *
   * @see getComparisonCaseSensitivity()
   */ public
 void setComparisonCaseSensitivity(bool strcmp) {
    libsbmlPINVOKE.L3ParserSettings_setComparisonCaseSensitivity(swigCPtr, strcmp);
  }

  
/**
   * Returns @c true if the parser is configured to match built-in symbols
   * in a case-insensitive way.
   *
   *
 * 
 * By default (which is the value
 * @link libsbml#L3P_COMPARE_BUILTINS_CASE_INSENSITIVE L3P_COMPARE_BUILTINS_CASE_INSENSITIVE@endlink), the parser
 * compares symbols in a case @em insensitive manner for built-in functions
 * such as @c 'sin' and @c 'piecewise', and for constants such as @c 'true'
 * and @c 'avogadro'.  Setting this option to
 * @link libsbml#L3P_COMPARE_BUILTINS_CASE_SENSITIVE L3P_COMPARE_BUILTINS_CASE_SENSITIVE@endlink causes the parser to
 * become case sensitive.  In that mode, for example, the symbols @c 'sin'
 * and @c 'true' will match the built-in values, but the symbols @c 'SIN',
 * @c 'Sin', @c 'True', @c 'TRUE', and so on, will not.
   *
   * @return @c true if matches are done in a case-sensitive manner, and 
   * @c false if the parser will recognize built-in functions and
   * constants regardless of case,.
   *
   * @see setComparisonCaseSensitivity(@if java boolean@endif)
   */ public
 bool getComparisonCaseSensitivity() {
    bool ret = libsbmlPINVOKE.L3ParserSettings_getComparisonCaseSensitivity(swigCPtr);
    return ret;
  }

  
/**
   * Set up the plugins for this L3ParserSettings, based on the
   * SBMLNamespaces object.
   *
   * When a SBMLNamespaces object is provided, the parser will only interpret
   * infix syntax understood by the core libSBML @em plus the packages
   * indicated by the SBMLNamespaces objects provided.  ASTNode objects
   * returned by the L3Parser will contain those SBMLNamespaces objects, and
   * will be used to parse certain constructs that may only be understood by
   * packages (e.g., vectors for the SBML Level&nbsp;3 'arrays' package).
   * Note that by default, all packages that were compiled with this version
   * of libSBML are included, so this function is most useful as a way to
   * turn @em off certain namespaces, such as might be desired if your tool
   * does not support vectors, for example.
   *
   * @param sbmlns a SBMLNamespaces object to be used.  If @c null is given
   * as the value, all plugins will be loaded.
   */ public
 void setPlugins(SBMLNamespaces sbmlns) {
    libsbmlPINVOKE.L3ParserSettings_setPlugins(swigCPtr, SBMLNamespaces.getCPtr(sbmlns));
  }

  
/** */ /* libsbml-internal */ public
 void visitPackageInfixSyntax(ASTNode parent, ASTNode node, SWIGTYPE_p_StringBuffer_t sb) {
    libsbmlPINVOKE.L3ParserSettings_visitPackageInfixSyntax(swigCPtr, ASTNode.getCPtr(parent), ASTNode.getCPtr(node), SWIGTYPE_p_StringBuffer_t.getCPtr(sb));
  }

}

}
