/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html A list of attributes on an XML element.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * In libSBML's XML interface layer, attributes on an element are stored as a
 * list of values kept in an XMLAttributes object.  XMLAttributes has methods
 * for adding and removing individual attributes as well as performing other
 * actions on the list of attributes.  Classes in libSBML that represent nodes
 * in an XML document (i.e., XMLNode and its parent class, XMLToken) use
 * XMLAttributes objects to manage attributes on XML elements.
 *
 * Attributes on an XML element can be written in one of two forms:
 * @li <code>name='value'</code>
 * @li <code>prefix:name='value'</code>
 *
 * An attribute in XML must always have a value, and the value must always be
 * a quoted string; i.e., it is always <code>name='value'</code> and not
 * <code>name=value</code>.  An empty value is represented simply as an
 * empty string; i.e., <code>name=''</code>.
 *
 * In cases when a <code>prefix</code> is provided with an attribute name,
 * general XML validity rules require that the prefix is an XML namespace
 * prefix that has been declared somewhere else (possibly as an another
 * attribute on the same element).  However, the XMLAttributes class does
 * @em not test for the proper existence or declaration of XML
 * namespaces&mdash;callers must arrange to do this themselves in some other
 * way.  This class only provides facilities for tracking and manipulating
 * attributes and their prefix/URI/name/value components.
 *
 *
 * @note Note that although XMLAttributes provides operations that can
 * manipulate attributes based on a numerical index, XML attributes are in
 * fact unordered when they appear in files and data streams.  The
 * XMLAttributes class provides some list-like facilities, but it is only for
 * the convenience of callers.  (For example, it permits callers to loop
 * across all attributes more easily.)  Users should keep in mind that the
 * order in which attributes are stored in XMLAttributes objects has no real
 * impact on the order in which the attributes are read or written from an
 * XML file or data stream.
 *
 *
 *
 * @see XMLTriple
 * @see XMLNode
 * @see XMLToken
 */

public class XMLAttributes : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal XMLAttributes(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(XMLAttributes obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (XMLAttributes obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~XMLAttributes() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_XMLAttributes(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(XMLAttributes lhs, XMLAttributes rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(XMLAttributes lhs, XMLAttributes rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is XMLAttributes) )
    {
      return false;
    }

    return this == (XMLAttributes)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
/**
   * Creates a new, empty XMLAttributes object.
   */ public
 XMLAttributes() : this(libsbmlPINVOKE.new_XMLAttributes__SWIG_0(), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this XMLAttributes object.
   *
   * @p orig the XMLAttributes object to copy.
   */ public
 XMLAttributes(XMLAttributes orig) : this(libsbmlPINVOKE.new_XMLAttributes__SWIG_1(XMLAttributes.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this XMLAttributes object.
   *
   * @return the (deep) copy of this XMLAttributes object.
   */ public
 XMLAttributes clone() {
    IntPtr cPtr = libsbmlPINVOKE.XMLAttributes_clone(swigCPtr);
    XMLAttributes ret = (cPtr == IntPtr.Zero) ? null : new XMLAttributes(cPtr, true);
    return ret;
  }

  
/**
   * Adds an attribute to this list of attributes.
   *
   *
 * 
 * Some explanations are in order about the behavior of XMLAttributes with
 * respect to namespace prefixes and namespace URIs.  XMLAttributes does @em
 * not verify the consistency of different uses of an XML namespace and the
 * prefix used to refer to it in a given context.  It cannot, because the
 * prefix used for a given XML namespace in an XML document may intentionally
 * be different on different elements in the document.  Consequently, callers
 * need to manage their own prefix-to-namespace mappings, and need to ensure
 * that the desired prefix is used in any given context.
 *
 * When called with attribute names, prefixes and namespace URIs,
 * XMLAttributes pays attention to the namespace URIs and not the prefixes: a
 * match is established by a combination of attribute name and namespace URI,
 * and if on different occasions a different prefix is used for the same
 * name/namespace combination, the prefix associated with the namespace on
 * that attribute is overwritten.
 *
 * Some examples will hopefully clarify this.  Here are the results of a
 * sequence of calls to the XMLAttributes <code>add</code> methods with
 * different argument combinations.  First, we create the object and add
 * one attribute:
 *
 * @code{.cpp}
XMLAttributes  att = new XMLAttributes();
att->add('myattribute', '1', 'myuri');
@endcode
 * The above adds an attribute named <code>myattribute</code> in the namespace
 * <code>myuri</code>, and with the attribute value <code>1</code>.  No
 * namespace prefix is associated with the attribute (but the attribute is
 * recorded to exist in the namespace <code>myuri</code>).  If
 * this attribute object were written out in XML, it would look like the
 * following (and note that, since no namespace prefix was assigned, none
 * is written out):
 * <center><pre>
myattribute='1'
 * </pre></center>
 *
 * Continuing with this series of examples, suppose we invoke the
 * <code>add</code> method again as follows:
 *
 * @code{.cpp}
att->add('myattribute', '2');
@endcode
 * The above adds a @em new attribute @em also named <code>myattribute</code>,
 * but in a different XML namespace: it is placed in the namespace with no
 * URI, which is to say, the default XML namespace.  Both attributes coexist
 * on this XMLAttributes object; both can be independently retrieved.
 *
 * @code{.cpp}
att->add('myattribute', '3');
@endcode
 * The code above now replaces the value of the attribute
 * <code>myattribute</code> that resides in the default namespace.  The
 * attribute in the namespace <code>myuri</code> remains untouched.
 *
 * @code{.cpp}
att->add('myattribute', '4', 'myuri');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * The attribute in the default namespace remains untouched.
 *
 * @code{.cpp}
att->add('myattribute', '5', 'myuri', 'foo');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * It also now assigns a namespace prefix, <code>foo</code>, to the attribute.
 * The attribute <code>myattribute</code> in the default namespace remains
 * untouched. If this XMLAttributes object were written out in XML, it would
 * look like the following:
 * <center><pre>
myattribute='3'
foo:myattribute='5'
 * </pre></center>
 * Pressing on, now suppose we call the <code>add</code> method as follows:
 *
 * @code{.cpp}
att->add('myattribute', '6', 'myuri', 'bar');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * It also assigns a different prefix to the attribute.  The namespace of
 * the attribute remains <code>myuri</code>.
 *
 * @code{.cpp}
att->add('myattribute', '7', '', 'foo');
@endcode

 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the default namespace.  It also
 * now assigns a namespace prefix, <code>foo</code>, to that attribute.  If
 * this XMLAttributes object were written out in XML, it would look like the
 * following:
 * <center><pre>
bar:myattribute='6'
foo:myattribute='7'
 * </pre></center>
   *
   * @param name a string, the unprefixed name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, a prefix for the XML namespace.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * &ndash; this value is returned if any of the arguments are @c null.  To
   * set an empty @p prefix and/or @p name value, use an empty string rather
   * than @c null.
   *
   *
 * @note If an attribute with the same name and XML namespace URI already
 * exists in the list of attributes held by this XMLAttributes object, then
 * the previous value of that attribute will be replaced with the new value
 * provided to this method.
 *
 *
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   *
   * @see add(XMLTriple triple, string value)
   * @see getIndex(string name, string uri) 
   * @see getIndex(XMLTriple triple) 
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 int add(string name, string value, string namespaceURI, string prefix) {
    int ret = libsbmlPINVOKE.XMLAttributes_add__SWIG_0(swigCPtr, name, value, namespaceURI, prefix);
    return ret;
  }

  
/**
   * Adds an attribute to this list of attributes.
   *
   *
 * 
 * Some explanations are in order about the behavior of XMLAttributes with
 * respect to namespace prefixes and namespace URIs.  XMLAttributes does @em
 * not verify the consistency of different uses of an XML namespace and the
 * prefix used to refer to it in a given context.  It cannot, because the
 * prefix used for a given XML namespace in an XML document may intentionally
 * be different on different elements in the document.  Consequently, callers
 * need to manage their own prefix-to-namespace mappings, and need to ensure
 * that the desired prefix is used in any given context.
 *
 * When called with attribute names, prefixes and namespace URIs,
 * XMLAttributes pays attention to the namespace URIs and not the prefixes: a
 * match is established by a combination of attribute name and namespace URI,
 * and if on different occasions a different prefix is used for the same
 * name/namespace combination, the prefix associated with the namespace on
 * that attribute is overwritten.
 *
 * Some examples will hopefully clarify this.  Here are the results of a
 * sequence of calls to the XMLAttributes <code>add</code> methods with
 * different argument combinations.  First, we create the object and add
 * one attribute:
 *
 * @code{.cpp}
XMLAttributes  att = new XMLAttributes();
att->add('myattribute', '1', 'myuri');
@endcode
 * The above adds an attribute named <code>myattribute</code> in the namespace
 * <code>myuri</code>, and with the attribute value <code>1</code>.  No
 * namespace prefix is associated with the attribute (but the attribute is
 * recorded to exist in the namespace <code>myuri</code>).  If
 * this attribute object were written out in XML, it would look like the
 * following (and note that, since no namespace prefix was assigned, none
 * is written out):
 * <center><pre>
myattribute='1'
 * </pre></center>
 *
 * Continuing with this series of examples, suppose we invoke the
 * <code>add</code> method again as follows:
 *
 * @code{.cpp}
att->add('myattribute', '2');
@endcode
 * The above adds a @em new attribute @em also named <code>myattribute</code>,
 * but in a different XML namespace: it is placed in the namespace with no
 * URI, which is to say, the default XML namespace.  Both attributes coexist
 * on this XMLAttributes object; both can be independently retrieved.
 *
 * @code{.cpp}
att->add('myattribute', '3');
@endcode
 * The code above now replaces the value of the attribute
 * <code>myattribute</code> that resides in the default namespace.  The
 * attribute in the namespace <code>myuri</code> remains untouched.
 *
 * @code{.cpp}
att->add('myattribute', '4', 'myuri');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * The attribute in the default namespace remains untouched.
 *
 * @code{.cpp}
att->add('myattribute', '5', 'myuri', 'foo');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * It also now assigns a namespace prefix, <code>foo</code>, to the attribute.
 * The attribute <code>myattribute</code> in the default namespace remains
 * untouched. If this XMLAttributes object were written out in XML, it would
 * look like the following:
 * <center><pre>
myattribute='3'
foo:myattribute='5'
 * </pre></center>
 * Pressing on, now suppose we call the <code>add</code> method as follows:
 *
 * @code{.cpp}
att->add('myattribute', '6', 'myuri', 'bar');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * It also assigns a different prefix to the attribute.  The namespace of
 * the attribute remains <code>myuri</code>.
 *
 * @code{.cpp}
att->add('myattribute', '7', '', 'foo');
@endcode

 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the default namespace.  It also
 * now assigns a namespace prefix, <code>foo</code>, to that attribute.  If
 * this XMLAttributes object were written out in XML, it would look like the
 * following:
 * <center><pre>
bar:myattribute='6'
foo:myattribute='7'
 * </pre></center>
   *
   * @param name a string, the unprefixed name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, a prefix for the XML namespace.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * &ndash; this value is returned if any of the arguments are @c null.  To
   * set an empty @p prefix and/or @p name value, use an empty string rather
   * than @c null.
   *
   *
 * @note If an attribute with the same name and XML namespace URI already
 * exists in the list of attributes held by this XMLAttributes object, then
 * the previous value of that attribute will be replaced with the new value
 * provided to this method.
 *
 *
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   *
   * @see add(XMLTriple triple, string value)
   * @see getIndex(string name, string uri) 
   * @see getIndex(XMLTriple triple) 
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 int add(string name, string value, string namespaceURI) {
    int ret = libsbmlPINVOKE.XMLAttributes_add__SWIG_1(swigCPtr, name, value, namespaceURI);
    return ret;
  }

  
/**
   * Adds an attribute to this list of attributes.
   *
   *
 * 
 * Some explanations are in order about the behavior of XMLAttributes with
 * respect to namespace prefixes and namespace URIs.  XMLAttributes does @em
 * not verify the consistency of different uses of an XML namespace and the
 * prefix used to refer to it in a given context.  It cannot, because the
 * prefix used for a given XML namespace in an XML document may intentionally
 * be different on different elements in the document.  Consequently, callers
 * need to manage their own prefix-to-namespace mappings, and need to ensure
 * that the desired prefix is used in any given context.
 *
 * When called with attribute names, prefixes and namespace URIs,
 * XMLAttributes pays attention to the namespace URIs and not the prefixes: a
 * match is established by a combination of attribute name and namespace URI,
 * and if on different occasions a different prefix is used for the same
 * name/namespace combination, the prefix associated with the namespace on
 * that attribute is overwritten.
 *
 * Some examples will hopefully clarify this.  Here are the results of a
 * sequence of calls to the XMLAttributes <code>add</code> methods with
 * different argument combinations.  First, we create the object and add
 * one attribute:
 *
 * @code{.cpp}
XMLAttributes  att = new XMLAttributes();
att->add('myattribute', '1', 'myuri');
@endcode
 * The above adds an attribute named <code>myattribute</code> in the namespace
 * <code>myuri</code>, and with the attribute value <code>1</code>.  No
 * namespace prefix is associated with the attribute (but the attribute is
 * recorded to exist in the namespace <code>myuri</code>).  If
 * this attribute object were written out in XML, it would look like the
 * following (and note that, since no namespace prefix was assigned, none
 * is written out):
 * <center><pre>
myattribute='1'
 * </pre></center>
 *
 * Continuing with this series of examples, suppose we invoke the
 * <code>add</code> method again as follows:
 *
 * @code{.cpp}
att->add('myattribute', '2');
@endcode
 * The above adds a @em new attribute @em also named <code>myattribute</code>,
 * but in a different XML namespace: it is placed in the namespace with no
 * URI, which is to say, the default XML namespace.  Both attributes coexist
 * on this XMLAttributes object; both can be independently retrieved.
 *
 * @code{.cpp}
att->add('myattribute', '3');
@endcode
 * The code above now replaces the value of the attribute
 * <code>myattribute</code> that resides in the default namespace.  The
 * attribute in the namespace <code>myuri</code> remains untouched.
 *
 * @code{.cpp}
att->add('myattribute', '4', 'myuri');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * The attribute in the default namespace remains untouched.
 *
 * @code{.cpp}
att->add('myattribute', '5', 'myuri', 'foo');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * It also now assigns a namespace prefix, <code>foo</code>, to the attribute.
 * The attribute <code>myattribute</code> in the default namespace remains
 * untouched. If this XMLAttributes object were written out in XML, it would
 * look like the following:
 * <center><pre>
myattribute='3'
foo:myattribute='5'
 * </pre></center>
 * Pressing on, now suppose we call the <code>add</code> method as follows:
 *
 * @code{.cpp}
att->add('myattribute', '6', 'myuri', 'bar');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * It also assigns a different prefix to the attribute.  The namespace of
 * the attribute remains <code>myuri</code>.
 *
 * @code{.cpp}
att->add('myattribute', '7', '', 'foo');
@endcode

 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the default namespace.  It also
 * now assigns a namespace prefix, <code>foo</code>, to that attribute.  If
 * this XMLAttributes object were written out in XML, it would look like the
 * following:
 * <center><pre>
bar:myattribute='6'
foo:myattribute='7'
 * </pre></center>
   *
   * @param name a string, the unprefixed name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, a prefix for the XML namespace.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * &ndash; this value is returned if any of the arguments are @c null.  To
   * set an empty @p prefix and/or @p name value, use an empty string rather
   * than @c null.
   *
   *
 * @note If an attribute with the same name and XML namespace URI already
 * exists in the list of attributes held by this XMLAttributes object, then
 * the previous value of that attribute will be replaced with the new value
 * provided to this method.
 *
 *
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   *
   * @see add(XMLTriple triple, string value)
   * @see getIndex(string name, string uri) 
   * @see getIndex(XMLTriple triple) 
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 int add(string name, string value) {
    int ret = libsbmlPINVOKE.XMLAttributes_add__SWIG_2(swigCPtr, name, value);
    return ret;
  }

  
/**
   * Adds an attribute to this list of attributes.
   *
   *
 * 
 * Some explanations are in order about the behavior of XMLAttributes with
 * respect to namespace prefixes and namespace URIs.  XMLAttributes does @em
 * not verify the consistency of different uses of an XML namespace and the
 * prefix used to refer to it in a given context.  It cannot, because the
 * prefix used for a given XML namespace in an XML document may intentionally
 * be different on different elements in the document.  Consequently, callers
 * need to manage their own prefix-to-namespace mappings, and need to ensure
 * that the desired prefix is used in any given context.
 *
 * When called with attribute names, prefixes and namespace URIs,
 * XMLAttributes pays attention to the namespace URIs and not the prefixes: a
 * match is established by a combination of attribute name and namespace URI,
 * and if on different occasions a different prefix is used for the same
 * name/namespace combination, the prefix associated with the namespace on
 * that attribute is overwritten.
 *
 * Some examples will hopefully clarify this.  Here are the results of a
 * sequence of calls to the XMLAttributes <code>add</code> methods with
 * different argument combinations.  First, we create the object and add
 * one attribute:
 *
 * @code{.cpp}
XMLAttributes  att = new XMLAttributes();
att->add('myattribute', '1', 'myuri');
@endcode
 * The above adds an attribute named <code>myattribute</code> in the namespace
 * <code>myuri</code>, and with the attribute value <code>1</code>.  No
 * namespace prefix is associated with the attribute (but the attribute is
 * recorded to exist in the namespace <code>myuri</code>).  If
 * this attribute object were written out in XML, it would look like the
 * following (and note that, since no namespace prefix was assigned, none
 * is written out):
 * <center><pre>
myattribute='1'
 * </pre></center>
 *
 * Continuing with this series of examples, suppose we invoke the
 * <code>add</code> method again as follows:
 *
 * @code{.cpp}
att->add('myattribute', '2');
@endcode
 * The above adds a @em new attribute @em also named <code>myattribute</code>,
 * but in a different XML namespace: it is placed in the namespace with no
 * URI, which is to say, the default XML namespace.  Both attributes coexist
 * on this XMLAttributes object; both can be independently retrieved.
 *
 * @code{.cpp}
att->add('myattribute', '3');
@endcode
 * The code above now replaces the value of the attribute
 * <code>myattribute</code> that resides in the default namespace.  The
 * attribute in the namespace <code>myuri</code> remains untouched.
 *
 * @code{.cpp}
att->add('myattribute', '4', 'myuri');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * The attribute in the default namespace remains untouched.
 *
 * @code{.cpp}
att->add('myattribute', '5', 'myuri', 'foo');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * It also now assigns a namespace prefix, <code>foo</code>, to the attribute.
 * The attribute <code>myattribute</code> in the default namespace remains
 * untouched. If this XMLAttributes object were written out in XML, it would
 * look like the following:
 * <center><pre>
myattribute='3'
foo:myattribute='5'
 * </pre></center>
 * Pressing on, now suppose we call the <code>add</code> method as follows:
 *
 * @code{.cpp}
att->add('myattribute', '6', 'myuri', 'bar');
@endcode
 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the <code>myuri</code> namespace.
 * It also assigns a different prefix to the attribute.  The namespace of
 * the attribute remains <code>myuri</code>.
 *
 * @code{.cpp}
att->add('myattribute', '7', '', 'foo');
@endcode

 * The code above replaces the value of the attribute
 * <code>myattribute</code> that resides in the default namespace.  It also
 * now assigns a namespace prefix, <code>foo</code>, to that attribute.  If
 * this XMLAttributes object were written out in XML, it would look like the
 * following:
 * <center><pre>
bar:myattribute='6'
foo:myattribute='7'
 * </pre></center>
   *
   * @param triple an XMLTriple object describing the attribute to be added.
   * @param value a string, the value of the attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * &ndash; this value is returned if any of the arguments are @c null.  To
   * set an empty value for the attribute, use an empty string rather than @c
   * null.
   *
   *
 * @note If an attribute with the same name and XML namespace URI already
 * exists in the list of attributes held by this XMLAttributes object, then
 * the previous value of that attribute will be replaced with the new value
 * provided to this method.
 *
 *
   *
   * @see add(string name, string value, string namespaceURI, string prefix)
   * @see getIndex(string name, string uri) 
   * @see getIndex(XMLTriple triple) 
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 int add(XMLTriple triple, string value) {
    int ret = libsbmlPINVOKE.XMLAttributes_add__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple), value);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int removeResource(int n) {
    int ret = libsbmlPINVOKE.XMLAttributes_removeResource(swigCPtr, n);
    return ret;
  }

  
/**
   * Removes the <em>n</em>th attribute from this list of attributes.
   *
   * @param n an integer the index of the resource to be deleted
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute at the
   * given index @p n.
   *
   *
 * @note Note that although XMLAttributes provides operations that can
 * manipulate attributes based on a numerical index, XML attributes are in
 * fact unordered when they appear in files and data streams.  The
 * XMLAttributes class provides some list-like facilities, but it is only for
 * the convenience of callers.  (For example, it permits callers to loop
 * across all attributes more easily.)  Users should keep in mind that the
 * order in which attributes are stored in XMLAttributes objects has no real
 * impact on the order in which the attributes are read or written from an
 * XML file or data stream.
 *
 *
   *
   * @see getLength()
   * @see remove(XMLTriple triple)
   * @see remove(string name, string uri)
   */ public
 int remove(int n) {
    int ret = libsbmlPINVOKE.XMLAttributes_remove__SWIG_0(swigCPtr, n);
    return ret;
  }

  
/**
   * Removes a named attribute from this list of attributes.
   *
   * @param name a string, the unprefixed name of the attribute to be
   * removed.
   *
   * @param uri a string, the namespace URI of the attribute to be removed.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute with the
   * given @p name (and @p uri if specified).
   *
   * @see remove(int n)
   * @see remove(XMLTriple triple)
   */ public
 int remove(string name, string uri) {
    int ret = libsbmlPINVOKE.XMLAttributes_remove__SWIG_1(swigCPtr, name, uri);
    return ret;
  }

  
/**
   * Removes a named attribute from this list of attributes.
   *
   * @param name a string, the unprefixed name of the attribute to be
   * removed.
   *
   * @param uri a string, the namespace URI of the attribute to be removed.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute with the
   * given @p name (and @p uri if specified).
   *
   * @see remove(int n)
   * @see remove(XMLTriple triple)
   */ public
 int remove(string name) {
    int ret = libsbmlPINVOKE.XMLAttributes_remove__SWIG_2(swigCPtr, name);
    return ret;
  }

  
/**
   * Removes a specific attribute from this list of attributes.
   *
   * @param triple an XMLTriple describing the attribute to be removed.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink
   *
   * The value @link libsbml#LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE@endlink is returned if there is no attribute matching
   * the properties of the given @p triple.
   *
   * @see remove(int n)
   * @see remove(string name, string uri)
   */ public
 int remove(XMLTriple triple) {
    int ret = libsbmlPINVOKE.XMLAttributes_remove__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Removes all attributes in this XMLAttributes object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see remove(int n)
   * @see remove(XMLTriple triple)
   * @see remove(string name, string uri)
   */ public
 int clear() {
    int ret = libsbmlPINVOKE.XMLAttributes_clear(swigCPtr);
    return ret;
  }

  
/**
   * Returns the index of an attribute having a given name.
   *
   * @note This method does not check XML namespaces.  Thus, if there are
   * multiple attributes with the same local @p name but different
   * namespaces, this method will return the first one found.  Callers should
   * use the more specific methods
   * XMLAttributes::getIndex(string name, string uri) 
   * or XMLAttributes::getIndex(XMLTriple triple) 
   * to find attributes in particular namespaces.
   *
   * @param name a string, the name of the attribute whose index is begin
   * sought.
   *
   * @return the index of an attribute with the given local name, or
   * <code>-1</code> if no such attribute is present.
   *
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 int getIndex(string name) {
    int ret = libsbmlPINVOKE.XMLAttributes_getIndex__SWIG_0(swigCPtr, name);
    return ret;
  }

  
/**
   * Returns the index of the attribute having a given name and XML namespace
   * URI.
   *
   * @param name a string, the name of the attribute being sought.
   * @param uri  a string, the namespace URI of the attribute being sought.
   *
   * @return the index of an attribute with the given local name and
   * namespace URI, or <code>-1</code> if no such attribute is present.
   *
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 int getIndex(string name, string uri) {
    int ret = libsbmlPINVOKE.XMLAttributes_getIndex__SWIG_1(swigCPtr, name, uri);
    return ret;
  }

  
/**
   * Returns the index of the attribute defined by the given XMLTriple object.
   *
   * @param triple an XMLTriple describing the attribute being sought.
   *
   * @return the index of an attribute described by the given XMLTriple
   * object, or <code>-1</code> if no such attribute is present.
   *
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 int getIndex(XMLTriple triple) {
    int ret = libsbmlPINVOKE.XMLAttributes_getIndex__SWIG_2(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the number of attributes in this list of attributes.
   *
   * @return the number of attributes contained in this XMLAttributes object.
   */ public
 int getLength() {
    int ret = libsbmlPINVOKE.XMLAttributes_getLength(swigCPtr);
    return ret;
  }

  
/**
   * Returns the number of attributes in this list of attributes.
   *
   * This function is merely an alias of XMLAttributes::getLength()
   * introduced for consistency with other libXML classes.
   *
   * @return the number of attributes contained in this XMLAttributes object.
   */ public
 int getNumAttributes() {
    int ret = libsbmlPINVOKE.XMLAttributes_getNumAttributes(swigCPtr);
    return ret;
  }

  
/**
   * Returns the name of the <em>n</em>th attribute in this list of
   * attributes.
   *
   * @param index an integer, the position of the attribute whose name
   * is being sought.
   *
   * @return the local name of the <em>n</em>th attribute.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  Callers should use XMLAttributes::getLength() to check the number
 * of attributes contained in this object or XMLAttributes::hasAttribute(int
 * index) to test for the existence of an attribute at a given
 * position.
 *
 *
   *
   *
 * @note Note that although XMLAttributes provides operations that can
 * manipulate attributes based on a numerical index, XML attributes are in
 * fact unordered when they appear in files and data streams.  The
 * XMLAttributes class provides some list-like facilities, but it is only for
 * the convenience of callers.  (For example, it permits callers to loop
 * across all attributes more easily.)  Users should keep in mind that the
 * order in which attributes are stored in XMLAttributes objects has no real
 * impact on the order in which the attributes are read or written from an
 * XML file or data stream.
 *
 *
   *
   * @see getLength()
   * @see hasAttribute(int index) 
   */ public
 string getName(int index) {
    string ret = libsbmlPINVOKE.XMLAttributes_getName(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the namespace prefix of the <em>n</em>th attribute in this
   * attribute set.
   *
   * @param index an integer, the position of the attribute whose namespace
   * prefix is being sought.
   *
   * @return the XML namespace prefix of the <em>n</em>th attribute.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  Callers should use XMLAttributes::getLength() to check the number
 * of attributes contained in this object or XMLAttributes::hasAttribute(int
 * index) to test for the existence of an attribute at a given
 * position.
 *
 *
   *
   *
 * @note Note that although XMLAttributes provides operations that can
 * manipulate attributes based on a numerical index, XML attributes are in
 * fact unordered when they appear in files and data streams.  The
 * XMLAttributes class provides some list-like facilities, but it is only for
 * the convenience of callers.  (For example, it permits callers to loop
 * across all attributes more easily.)  Users should keep in mind that the
 * order in which attributes are stored in XMLAttributes objects has no real
 * impact on the order in which the attributes are read or written from an
 * XML file or data stream.
 *
 *
   *
   * @see getLength()
   * @see hasAttribute(int index) 
   */ public
 string getPrefix(int index) {
    string ret = libsbmlPINVOKE.XMLAttributes_getPrefix(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the prefix name of the <em>n</em>th attribute in this attribute
   * set.
   *
   * @param index an integer, the position of the attribute whose prefixed
   * name is being sought.
   *
   * @return the prefixed name of the <em>n</em>th attribute.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  Callers should use XMLAttributes::getLength() to check the number
 * of attributes contained in this object or XMLAttributes::hasAttribute(int
 * index) to test for the existence of an attribute at a given
 * position.
 *
 *
   *
   *
 * @note Note that although XMLAttributes provides operations that can
 * manipulate attributes based on a numerical index, XML attributes are in
 * fact unordered when they appear in files and data streams.  The
 * XMLAttributes class provides some list-like facilities, but it is only for
 * the convenience of callers.  (For example, it permits callers to loop
 * across all attributes more easily.)  Users should keep in mind that the
 * order in which attributes are stored in XMLAttributes objects has no real
 * impact on the order in which the attributes are read or written from an
 * XML file or data stream.
 *
 *
   *
   * @see getLength()
   * @see hasAttribute(int index) 
   */ public
 string getPrefixedName(int index) {
    string ret = libsbmlPINVOKE.XMLAttributes_getPrefixedName(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the XML namespace URI of the <em>n</em>th attribute in this
   * attribute set.
   *
   * @param index an integer, the position of the attribute whose namespace
   * URI is being sought.
   *
   * @return the XML namespace URI of the <em>n</em>th attribute.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  Callers should use XMLAttributes::getLength() to check the number
 * of attributes contained in this object or XMLAttributes::hasAttribute(int
 * index) to test for the existence of an attribute at a given
 * position.
 *
 *
   *
   *
 * @note Note that although XMLAttributes provides operations that can
 * manipulate attributes based on a numerical index, XML attributes are in
 * fact unordered when they appear in files and data streams.  The
 * XMLAttributes class provides some list-like facilities, but it is only for
 * the convenience of callers.  (For example, it permits callers to loop
 * across all attributes more easily.)  Users should keep in mind that the
 * order in which attributes are stored in XMLAttributes objects has no real
 * impact on the order in which the attributes are read or written from an
 * XML file or data stream.
 *
 *
   *
   * @see getLength()
   * @see hasAttribute(int index) 
   */ public
 string getURI(int index) {
    string ret = libsbmlPINVOKE.XMLAttributes_getURI(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns the value of the <em>n</em>th attribute in this list of attributes.
   *
   * @param index an integer, the position of the attribute whose value is
   * being sought.
   *
   * @return the XML value of the <em>n</em>th attribute.
   *
   *
 * @note If @p index is out of range, this method will return an empty
 * string.  Callers should use XMLAttributes::getLength() to check the number
 * of attributes contained in this object or XMLAttributes::hasAttribute(int
 * index) to test for the existence of an attribute at a given
 * position.
 *
 *
   *
   *
 * @note Note that although XMLAttributes provides operations that can
 * manipulate attributes based on a numerical index, XML attributes are in
 * fact unordered when they appear in files and data streams.  The
 * XMLAttributes class provides some list-like facilities, but it is only for
 * the convenience of callers.  (For example, it permits callers to loop
 * across all attributes more easily.)  Users should keep in mind that the
 * order in which attributes are stored in XMLAttributes objects has no real
 * impact on the order in which the attributes are read or written from an
 * XML file or data stream.
 *
 *
   *
   * @see getLength()
   * @see hasAttribute(int index) 
   */ public
 string getValue(int index) {
    string ret = libsbmlPINVOKE.XMLAttributes_getValue__SWIG_0(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns a named attribute's value.
   *
   * @param name a string, the unprefixed name of the attribute whose value
   * is being sought.
   *
   * @return The attribute value as a string.
   *
   * @note If an attribute with the given local @p name does not exist in
   * this XMLAttributes object, this method will return an empty string.
   * Callers can use
   * XMLAttributes::hasAttribute(string name, string uri) 
   * to test for an attribute's existence.  This method also does not check
   * the XML namespace of the named attribute.  Thus, if there are multiple
   * attributes with the same local @p name but different namespaces, this
   * method will return the value of the first such attribute found.  Callers
   * should use the more specific methods
   * XMLAttributes::getIndex(string name, string uri) 
   * or XMLAttributes::getIndex(XMLTriple triple) to find
   * attributes in particular namespaces.
   *
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 string getValue(string name) {
    string ret = libsbmlPINVOKE.XMLAttributes_getValue__SWIG_1(swigCPtr, name);
    return ret;
  }

  
/**
   * Returns a named attribute's value.
   *
   * @param name a string, the name of the attribute whose value is being sought.
   * @param uri  a string, the XML namespace URI of the attribute.
   *
   * @return The attribute value as a string.
   *
   * @note If an attribute with the given @p name and namespace @p uri does
   * not exist in this XMLAttributes object, this method will return an empty
   * string.  Callers can use
   * XMLAttributes::hasAttribute(string name, string uri) 
   * to test for an attribute's existence.
   *
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 string getValue(string name, string uri) {
    string ret = libsbmlPINVOKE.XMLAttributes_getValue__SWIG_2(swigCPtr, name, uri);
    return ret;
  }

  
/**
   * Return the value of an attribute described by a given XMLTriple object.
   *
   * @param triple an XMLTriple describing the attribute whose value is being
   * sought.
   *
   * @return The attribute value as a string.
   *
   * @note If an attribute with the properties given by @p triple does not
   * exist in this XMLAttributes object, this method will return an empty
   * string.  Callers can use
   * XMLAttributes::hasAttribute(string name, string uri) 
   * to test for an attribute's existence.
   *
   * @see hasAttribute(string name, string uri) 
   * @see hasAttribute(XMLTriple triple) 
   */ public
 string getValue(XMLTriple triple) {
    string ret = libsbmlPINVOKE.XMLAttributes_getValue__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns @c true if an attribute exists at a given index.
   *
   * @param index an integer, the position of the attribute to be tested.
   *
   * @return @c true if an attribute with the given index exists in this
   * XMLAttributes object, @c false otherwise.
   *
   *
 * @note Note that although XMLAttributes provides operations that can
 * manipulate attributes based on a numerical index, XML attributes are in
 * fact unordered when they appear in files and data streams.  The
 * XMLAttributes class provides some list-like facilities, but it is only for
 * the convenience of callers.  (For example, it permits callers to loop
 * across all attributes more easily.)  Users should keep in mind that the
 * order in which attributes are stored in XMLAttributes objects has no real
 * impact on the order in which the attributes are read or written from an
 * XML file or data stream.
 *
 *
   */ public
 bool hasAttribute(int index) {
    bool ret = libsbmlPINVOKE.XMLAttributes_hasAttribute__SWIG_0(swigCPtr, index);
    return ret;
  }

  
/**
   * Returns @c true if an attribute with a given name and namespace URI
   * exists.
   *
   * @param name a string, the unprefixed name of the attribute.
   * @param uri  a string, the XML namespace URI of the attribute.
   *
   * @return @c true if an attribute with the given local name and XML
   * namespace URI exists in this XMLAttributes object, @c false otherwise.
   *
   * @see add(string name, string value, string namespaceURI, string prefix)
   * @see add(XMLTriple triple, string value)
   */ public
 bool hasAttribute(string name, string uri) {
    bool ret = libsbmlPINVOKE.XMLAttributes_hasAttribute__SWIG_1(swigCPtr, name, uri);
    return ret;
  }

  
/**
   * Returns @c true if an attribute with a given name and namespace URI
   * exists.
   *
   * @param name a string, the unprefixed name of the attribute.
   * @param uri  a string, the XML namespace URI of the attribute.
   *
   * @return @c true if an attribute with the given local name and XML
   * namespace URI exists in this XMLAttributes object, @c false otherwise.
   *
   * @see add(string name, string value, string namespaceURI, string prefix)
   * @see add(XMLTriple triple, string value)
   */ public
 bool hasAttribute(string name) {
    bool ret = libsbmlPINVOKE.XMLAttributes_hasAttribute__SWIG_2(swigCPtr, name);
    return ret;
  }

  
/**
   * Returns @c true if an attribute with the given properties exists.
   *
   * @param triple an XMLTriple describing the attribute to be tested.
   *
   * @return @c true if an attribute with the given XML triple exists in this
   * XMLAttributes object, @c false otherwise.
   *
   * @see add(string name, string value, string namespaceURI, string prefix)
   * @see add(XMLTriple triple, string value)
   */ public
 bool hasAttribute(XMLTriple triple) {
    bool ret = libsbmlPINVOKE.XMLAttributes_hasAttribute__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns @c true if this list of attributes is empty.
   *
   * @return @c true if this XMLAttributes object is empty, @c false
   * otherwise.
   */ public
 bool isEmpty() {
    bool ret = libsbmlPINVOKE.XMLAttributes_isEmpty(swigCPtr);
    return ret;
  }

}

}
