/* this is a roxen module */
/* c burgess 20/8/98           */

//	int thread_safe=1;
//	#include <array.h>
//	#include <stdio.h>

#include <module.h>
#include <simulate.h>
inherit "module";
inherit "roxenlib";

string myfilename = "";
string realdir = "";
string absdir = "";
string reldir = "";
string dir = "";

void create() {  
  defvar("gfx_exts", 
         ({ "png", "jpg", "gif" }),
         "Extensions of graphics files",
         TYPE_STRING_LIST,
         "Extensions which denote graphics files.");
  defvar("src_exts", 
         ({ "txt", "html", "rxml", "incl" }),
         "Extensions of include-able files",
         TYPE_STRING_LIST,
         "Extensions which denote files to be included as part of the HTML page.");
  defvar("media_exts", 
         ({ "mov", "class", "ram" }),
         "Extensions of assorted other media files",
         TYPE_STRING_LIST,
         "Extensions which denote other media files.");
}

// This function is needed in _all_ modules. The first index in the
// resulting array is the type of the module, the second is the 'short name',
// the third is a documentation string, the next is reserved, and the last one
// indiceates wheter or not there can be more than one of this module
// active in any virtual server at any time. If it is 0, there can be more
// than one, othervise not.    This is a 'one of a kind' module, only one
// copy of this module can be included in any virtual server at any time.

array register_module()
{
  return ({ MODULE_PARSER, 
            "Finder Module",
            "This module allows you to include a <tt>&lt;finder&gt;</tt> "
            "tag and automatically generate a select box containing the "
            "images or texts available in a subdirectory. "
            "<p>The tag has syntax like:<br><tt>"
            "&nbsp;&nbsp;&lt;finder type=\"image\" name=\"image_selector\"&gt;</tt><br> "
            "where the field <tt>name</tt> denotes the select box name, and the type "
            "denotes the file type to offer a selection of (currently either \"image\", "
            "\"media\" or \"src\")."
            "<p>Optional arguments include <tt>dir=\"path/to/images\"</tt>. The tag "
            "requires both name and type arguments to work.",
            ({ }),
            1
  });
}

string find_items_tag(string tag_name, mapping args, object request_id, mapping defines) {

  string dbg = "";

  myfilename = request_id->realfile;
  realdir = reverse(reverse(explode(request_id->realfile, "/")) [1..])*"/"+"/";
  absdir = reverse(reverse(explode(request_id->not_query, "/")) [1..])*"/"+"/";

  if (args->debug) {
    dbg += sprintf("<b>finder.pike: -</b><tt>realdir = %O\nabsdir = %O\nmyfilename = %O", 
                   realdir, absdir, myfilename);
  }

  string img_select_tag = "";

  if(args->help) // This is a standard argument.
    return register_module()[2];

  // arg to specify directory                                    (??)
  // - must end in trailing slash, doesn't hurt to have two?
  // - attempts to block ".." attempts; can this be improved?
  //   (yes it can, there's a clean_path in file somewhere)

  /* strangely, under roxen 1.3.x this goes nuts if used after an ximg
   * tag as request_id->realfile is set to the value that the ximg
   * used. don't know if this is a bug in ximg or this module, but
   * stick an ximg above a finder and uncomment this line to see. */
  //  report_debug("The finder tag was found in " + request_id->realfile);

  if(args->dir) {
    realdir = simplify_path(realdir + ((args->dir) - ".." + "/"));
    absdir = simplify_path(absdir + ((args->dir) - ".." + "/"));
    reldir = simplify_path(args->dir - ".." + "/");
  } else {
    realdir = simplify_path(realdir);
    absdir = simplify_path(absdir);
    reldir = simplify_path(reldir);
  }

  //	"bad argument to sort()" probably means you forgot to symlink
  //	the images directory into place from the directory you're calling
  //	the finder tag from. shouldn't happen now anyway?
  if(args->debug)
	dbg += (sprintf("<pre>%O</pre>\n", get_dir(realdir)));
  
  array filenames;
  
  if (get_dir(realdir))
    filenames = sort(get_dir(realdir));
  else
    filenames = ({ "NO SUITABLE FILES FOUND" });

  if (!args->name) {
    return "<p><b>select name not defined</b>";
  }

  if (args->debug) {
    dbg += ("Select box named " + args->name + "\n  from dir " + realdir + "\n  called from " + myfilename + "</tt>");
  }

  if(args->preview) {
    /* should also check for provided->thumbnail to use this, and
     * get the thumbnail mountpoint - not sure how inter-module
     * communication works tho */
    /* should also check for js support */
    img_select_tag += "<p><img border=1 src=\"images/space.gif\" width=120 heigh=100 " + 
      "name=\"prv_" + args->name + "\"><br>\n" +
      "<select name=\"" + args->name + "\" " +
      "onChange=\"document.images['prv_" + args->name + "'].src = " + 
      "'/thumbnail/0/0/ffffff/100/120/$/' + '" + 
      reverse(reverse(explode(request_id->not_query, "/")) [1..])*"/"+"/" +
      "' + this[this.selectedIndex].value;\"> ";
  } else {
    img_select_tag += "<select name=\"" + args->name + "\"> ";
  }

  if (args->addblank)
    img_select_tag += ("<option value=\"" + args->addblank + "\">[ none ]\n");

  if (args->abs)
    dir = absdir;
  else
    dir = reldir;

  foreach (filenames, string filename) {
    switch (args->type) {
    case "image": 
      if ((search(QUERY(gfx_exts),extension(filename))!=-1) && (backup_extension(filename)!=1))
        img_select_tag += ("<option value=\"" + dir + filename +  "\">" 
                           + filename + " (" + file_size(realdir+filename) + " bytes) \n");
      break;
    case "media":
      if ((search(QUERY(media_exts),extension(filename))!=-1) && (backup_extension(filename)!=1))
        img_select_tag += ("<option value=\"" + filename + "\">" + filename + "\n");
      break;
    case "src":
      if ((search(QUERY(src_exts),extension(filename))!=-1) && (backup_extension(filename)!=1))
        img_select_tag += ("<option value=\"" + filename + "\">" + filename + "\n");
      break;
    default:
      string error = "<p><b>finder type not defined</b>";
      return error;
    }
  }

  img_select_tag += "\n</select>";

  if (args->debug)
    report_debug(dbg);

  return img_select_tag;

}

string user_id_tag(string tag_name, mapping args, object request_id, mapping defines) {
  string result = "unknown";
  if (!(request_id->auth && request_id->auth[0])) {
    return result;
  } else {
    return request_id->auth[0];
  }
}

// This is nessesary functions for all MODULE_PARSER modules.
mapping query_tag_callers() { 
  return( ([ "finder": find_items_tag, "uid": user_id_tag ]) );
}

