
- Indentation in tabs, 8 characters wide, spaces after the tabs where
  vertical alignment is required (see below)

**Note: this file uses spaces due to markdown rendering issues for tabs.
  Code must be implemented using tabs.**

- Max line width 80ch, do not break up printed strings though

- Break up long lines at logical groupings, one line for each logical group

```c
int a = somelongname() +
        someotherlongname();

if (a < 0 &&
    (b > 20 & d < 10) &&
    d != 0.0)


somelongfunctioncall(arg1,
                     arg2,
                     arg3);
```

- Function declarations: return type on separate line, {} on separate line,
  arguments broken up as above.

```c
static inline int
foobar(int a, int b)
{

}

void
somenamethatiswaytoolong(int a,
                         int b,
                         int c)
{
}
```

- `/* comments only */`, no `// comments`

- `variable_name`, not `VariableName` or `variableName`. same for functions.

- no typedefs of structs, enums, unions

- if it generates a compiler warning, it needs to be fixed
- if it generates a static checker warning, it needs to be fixed or
  commented

- declare variables at the top, try to keep them as local as possible.
  Exception: if the same variable is re-used in multiple blocks, declare it
  at the top.
  Exception: basic loop variables, e.g. for (int i = 0; ...)

```c
int a;
int c;

if (foo) {
        int b;

        c = get_value();
        usevalue(c);
}

if (bar) {
        c = get_value();
        useit(c);
}
```

- do not mix function invocations and variable definitions.

  wrong:

```c
{
        int a = foo();
        int b = 7;
}
```

  right:
```c
{
        int a;
        int b = 7;

        a = foo();
}
```

  There are exceptions here, e.g. `tp_libinput_context()`,
  `litest_current_device()`

- if/else: { on the same line, no curly braces if both blocks are a single
  statement. If either if or else block are multiple statements, both must
  have curly braces.

```c
if (foo) {
        blah();
        bar();
} else {
        a = 10;
}
```

- public functions MUST be doxygen-commented, use doxygen's `@foo` rather than
  `\foo` notation

- `#include "config.h"` comes first, followed by system headers, followed by
  external library headers, followed by internal headers.
  sort alphabetically where it makes sense (specifically system headers)

```c
#include "config.h"

#include <stdio.h>
#include <string.h>

#include <libevdev/libevdev.h>

#include "libinput-private.h"
```

- goto jumps only to the end of the function, and only for good reasons
  (usually cleanup). goto never jumps backwards

- Use stdbool.h's bool for booleans within the library (instead of `int`).
  Exception: the public API uses int, not bool.
