/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * An element where nodes can be "added," but data is not
 * actually appended.  Returns no data as well.
 * Implemented as a singleton.
 */
public final class NullElement 
	extends Element
{
	private static final NullElement ne = new NullElement();

	public static NullElement getInstance() 
	{
		return ne;
	}

	protected NullElement()
	{
		super(null);
	}

	/**
	 * Does nothing.
	 */
	@Override
	public void appendAttribute(Attribute a) 
	{
	}

	/**
	 * Does nothing.
	 */
	@Override
	public void setAttributes(java.util.List<Attribute> attributes) 
	{
	}

	/**
	 * Does nothing.
	 */
	@Override
	public void setName(String name)
	{
	}

	/**
	 * Does nothing.
	 */
	@Override
	public void appendChild(Node n) 
	{
	}

	/**
	 * Returns the comment <pre>&lt;!-- null element --&gt;</pre>.
	 */
	@Override
	public String toString() 
	{
		return "<!-- null element -->";
	}

}
