package net.noderunner.amazon.s3;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;

/**
 * HTTP Methods.
 * 
 * @author Elias Ross
 */
public enum Method {
	GET, PUT, DELETE, HEAD;
	
	/**
	 * Returns a new HTTP method for processing.
	 */
	HttpMethod createHttpMethod() {
		switch (this) {
        case PUT: return new PutMethod();
        case GET: return new GetMethod(); 
        case DELETE: return new DeleteMethod();
        case HEAD: return new HeadMethod();
		}
		throw new Error();
	}
}