// -*- C++ -*-
#include <ept/core/apt/action.h>
#include <ept/test.h>

using namespace ept::core;

struct TestAptAction : AptTestEnvironment
{
    package::Source pkgs;
    TestAptAction() : pkgs( db ) {}

    Test basic() {
        ept::Token t( "sp" );
        package::Action a( t, package::Action::Install );
        a.apply( pkgs );
        assert( pkgs.get< package::State >( t ).install() );
        a = package::Action( t, package::Action::Keep );
        a.apply( pkgs );
        assert( pkgs.get< package::State >( t ).keep() );
    }

    Test revert() {
        ept::Token t( "sp" );
        package::Action a( t, package::Action::Install );
        a.apply( pkgs );
        assert( pkgs.get< package::State >( t ).install() );
        pkgs.revertStates();
        assert( pkgs.get< package::State >( t ).keep() );
    }

    Test keep() {
        package::ActionList al;
        ept::Token t( "sp" );
        al.add( package::Action( t, package::Action::Install ) );
        assert( !al.empty() );
        al.add( package::Action( t, package::Action::Remove ) );
        al.add( package::Action( t, package::Action::Keep ) );
        al.replay( pkgs );
        assert( pkgs.get< package::State >( t ).keep() );
    }
};
