/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.iterator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.codehaus.janino.util.iterator.EnumerationIterator;
import org.codehaus.janino.util.iterator.UniterableElementException;

public class MultiDimensionalIterator
implements Iterator {
    private final Iterator[] nest;
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    };

    public MultiDimensionalIterator(Iterator iterator, int n) {
        this.nest = new Iterator[n];
        this.nest[0] = iterator;
        int n2 = 1;
        while (n2 < n) {
            this.nest[n2] = EMPTY_ITERATOR;
            ++n2;
        }
    }

    public boolean hasNext() {
        if (this.nest[this.nest.length - 1].hasNext()) {
            return true;
        }
        int n = this.nest.length - 2;
        if (n < 0) {
            return false;
        }
        while (true) {
            if (!this.nest[n].hasNext()) {
                if (n == 0) {
                    return false;
                }
                --n;
                continue;
            }
            if (n == this.nest.length - 1) {
                return true;
            }
            Object e = this.nest[n].next();
            if (e instanceof Iterator) {
                this.nest[++n] = (Iterator)e;
                continue;
            }
            if (e instanceof Object[]) {
                this.nest[++n] = Arrays.asList((Object[])e).iterator();
                continue;
            }
            if (e instanceof Collection) {
                this.nest[++n] = ((Collection)e).iterator();
                continue;
            }
            if (!(e instanceof Enumeration)) break;
            this.nest[++n] = new EnumerationIterator((Enumeration)e);
        }
        throw new UniterableElementException();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nest[this.nest.length - 1].next();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

