; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs
; RUN: opt -S -passes=iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; Check alloca with non-0 address spaces works correctly.

target datalayout = "A5"

define i32 @outlineable() {
bb:
  %i = tail call i32 @func(i32 0, i32 1)
  %i1 = or i32 0, %i
  %i2 = tail call i32 @func(i32 %i1, i32 0)
  %i3 = or i32 %i1, %i2
  ret i32 0
}

declare i32 @func(i32, i32)
; CHECK-LABEL: define {{[^@]+}}@outlineable() {
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I1_LOC:%.*]] = alloca i32, align 4, addrspace(5)
; CHECK-NEXT:    [[LT_CAST:%.*]] = addrspacecast ptr addrspace(5) [[I1_LOC]] to ptr
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[LT_CAST]])
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 0, i32 1, ptr addrspace(5) [[I1_LOC]], i32 0)
; CHECK-NEXT:    [[I1_RELOAD:%.*]] = load i32, ptr addrspace(5) [[I1_LOC]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[LT_CAST]])
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 [[I1_RELOAD]], i32 0, ptr addrspace(5) null, i32 -1)
; CHECK-NEXT:    ret i32 0
;
;
; CHECK-LABEL: define {{[^@]+}}@outlined_ir_func_0
; CHECK-SAME: (i32 [[TMP0:%.*]], i32 [[TMP1:%.*]], ptr addrspace(5) [[TMP2:%.*]], i32 [[TMP3:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:  newFuncRoot:
; CHECK-NEXT:    br label [[BB_TO_OUTLINE:%.*]]
; CHECK:       bb_to_outline:
; CHECK-NEXT:    [[I:%.*]] = tail call i32 @func(i32 [[TMP0]], i32 [[TMP1]])
; CHECK-NEXT:    [[I1:%.*]] = or i32 [[TMP0]], [[I]]
; CHECK-NEXT:    br label [[BB_AFTER_OUTLINE_EXITSTUB:%.*]]
; CHECK:       bb_after_outline.exitStub:
; CHECK-NEXT:    switch i32 [[TMP3]], label [[FINAL_BLOCK_0:%.*]] [
; CHECK-NEXT:    i32 0, label [[OUTPUT_BLOCK_0_0:%.*]]
; CHECK-NEXT:    ]
; CHECK:       output_block_0_0:
; CHECK-NEXT:    store i32 [[I1]], ptr addrspace(5) [[TMP2]], align 4
; CHECK-NEXT:    br label [[FINAL_BLOCK_0]]
; CHECK:       final_block_0:
; CHECK-NEXT:    ret void
;
