/* -------------------------- gnuCurveFit class --------------------------
   
   This is a class to create an object to handle curve fitting. 

   This file is part of Xgfe: X Windows GUI front end to Gnuplot
   Copyright (C) 1998 David Ishee

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ------------------------------------------------------------------------*/

#include "gnuCurveFit.h"

gnuCurveFit::gnuCurveFit()
{
  functionName = "";
  functionValue = "";
  dataFile = "";
  varXRangeName = "";
  varXRangeMin = "";
  varXRangeMax = "";
  varYRangeName = "";
  varYRangeMin = "";
  varYRangeMax = "";
  paramFile = "";
  paramFileFlag = 0;
  paramCSLFlag = 1;
  paramCSL = "";
  fitLimit = "";
  fitMaxIter = "";
  dataSetStart = "";
  dataSetEnd = "";
  dataSetInc = "";
  pointInc = "";
  lineInc = "";
  startPoint = "";
  startLine = "";
  endPoint = "";
  endLine = "";
  xColumn = "";
  yColumn = "";
  zColumn = "";
  format = "";
  rawFormat = "";
}

string gnuCurveFit::getFitCmd()
{
  string fitcmd;

  // define function
  fitcmd += functionName;
  fitcmd += " = ";
  fitcmd += functionValue;
  fitcmd += "\n";
  
  // define fitting variables

  // ---- fit limit
  fitcmd += "FIT_LIMIT = ";
  
  if (fitLimit != "")
    fitcmd += fitLimit;
  else
    fitcmd += "1e-5";

  
  fitcmd += "\n";
  
  // ---- fit maxiter
  fitcmd += "FIT_MAXITER = ";
  
  if (fitMaxIter != "")
    fitcmd += fitMaxIter;
  else
    fitcmd += "0";
  
  fitcmd += "\n";
  
  // define start of command
  fitcmd += "fit ";
  
  // insert x range

  if ((varXRangeName != "") || (varXRangeMin != "") || (varXRangeMax != ""))
  {
    fitcmd += " [";

    if (varXRangeName != "")
    {
      fitcmd += varXRangeName;
      fitcmd += "=";
    }
    
    if ((varXRangeMin != "") || (varXRangeMax != ""))
    {
      fitcmd += varXRangeMin;
      fitcmd += ":";
      fitcmd += varXRangeMax;
    }

    fitcmd += "]";
  }

  // insert Y range
  if ((varYRangeName != "") || (varYRangeMin != "") || (varYRangeMax != ""))
  {
    fitcmd += " [";
    
    if (varYRangeName != "")
    {
      fitcmd += varYRangeName;
      fitcmd += "=";
    }
    
    if ((varYRangeMin != "") || (varYRangeMax != ""))
    {
      fitcmd += varYRangeMin;
      fitcmd += ":";
      fitcmd += varYRangeMax;
    }

    fitcmd += "]";
  }

  // insert function 
  fitcmd += " ";
  fitcmd += functionName;

  // define datafile
  fitcmd += " '";
  fitcmd += dataFile;
  fitcmd += "' ";
  
  // define datafile modifiers
  // ---- insert "index" command
  if ((dataSetStart != "") && (dataSetEnd != "") && (dataSetInc != ""))
  {
    fitcmd += " index ";
    fitcmd += dataSetStart;
    fitcmd += ":";
    fitcmd += dataSetEnd;
    fitcmd += ":";
    fitcmd += dataSetInc;
  }
  
  if ((dataSetStart != "") && (dataSetEnd != "") && (dataSetInc == ""))
  {
    fitcmd += " index ";
    fitcmd += dataSetStart;
    fitcmd += ":";
    fitcmd += dataSetEnd;
  }
  
  if ((dataSetStart != "") && (dataSetEnd == "") && (dataSetInc == ""))
  {
    fitcmd += " index ";
    fitcmd += dataSetStart;
  }
  
  // insert "every" command
  if ((pointInc != "") || (lineInc != "") || 
      (startPoint != "") || (startLine != "") || 
      (endPoint != "") || (endLine != ""))
  {
    if (endLine != "")
    {
      fitcmd += " every ";
      fitcmd += pointInc;
      fitcmd += ":";
      fitcmd += lineInc;
      fitcmd += ":";
      fitcmd += startPoint;
      fitcmd += ":";
      fitcmd += startLine;
      fitcmd += ":";
      fitcmd += endPoint;
      fitcmd += ":";
      fitcmd += endLine;
    }
    else if (endPoint != "")
    {
      fitcmd += " every ";
      fitcmd += pointInc;
      fitcmd += ":";
      fitcmd += lineInc;
      fitcmd += ":";
      fitcmd += startPoint;
      fitcmd += ":";
      fitcmd += startLine;
      fitcmd += ":";
      fitcmd += endPoint;
    }
    else if (startLine != "")
    {
      fitcmd += " every ";
      fitcmd += pointInc;
      fitcmd += ":";
      fitcmd += lineInc;
      fitcmd += ":";
      fitcmd += startPoint;
      fitcmd += ":";
      fitcmd += startLine;
    }
    else if (startPoint != "")
    {
      fitcmd += " every ";
      fitcmd += pointInc;
      fitcmd += ":";
      fitcmd += lineInc;
      fitcmd += ":";
      fitcmd += startPoint;
    }
    else if (lineInc != "")
    {
      fitcmd += " every ";
      fitcmd += pointInc;
      fitcmd += ":";
      fitcmd += lineInc;
    }
    else if (pointInc != "")
    {
      fitcmd += " every ";
      fitcmd += pointInc;
    }
  }
  
  // ---- insert using command if columns or format string is specified 
  // ---- and a raw format string is not specified
  if (rawFormat == "")
  {      
    if ((xColumn != "") || (yColumn != "") || (zColumn != "") || 
        (format != ""))
    {
      fitcmd += " using ";
      fitcmd += xColumn;
      fitcmd += ":";
      fitcmd += yColumn;
      
      if (zColumn != "")
      {
        fitcmd += ":";
        fitcmd += zColumn;
      }
      
      fitcmd += " ";
      fitcmd += format;
    }      
  }
  else 
  {
    fitcmd += " using ";
    fitcmd += rawFormat;
  }

  // insert via parameters
  fitcmd += " via ";

  if (paramFileFlag == 1)
  {
    fitcmd += "'";
    fitcmd += paramFile;
    fitcmd += "'";
  }
  else if (paramCSLFlag == 1)
  {
    fitcmd += paramCSL;
  }

  return fitcmd;
}

void gnuCurveFit::setFunctionName(string name)
{
  functionName = name;
}

string gnuCurveFit::getFunctionName()
{
  return functionName;
}

void gnuCurveFit::setFunctionValue(string function)
{
  functionValue = function;
}

string gnuCurveFit::getFunctionValue()
{
  return functionValue;
}

void gnuCurveFit::setDataFile(string file)
{
  dataFile = file;
}

string gnuCurveFit::getDataFile()
{
  return dataFile;
}

void gnuCurveFit::setVarXRangeName(string range)
{
  varXRangeName = range;
}

string gnuCurveFit::getVarXRangeName()
{
  return varXRangeName;
}

void gnuCurveFit::setVarXRangeMin(string min)
{
  varXRangeMin = min;
}

string gnuCurveFit::getVarXRangeMin()
{
  return varXRangeMin;
}

void gnuCurveFit::setVarXRangeMax(string max)
{
  varXRangeMax = max;
}

string gnuCurveFit::getVarXRangeMax()
{
  return varXRangeMax;
}

void gnuCurveFit::setVarYRangeName(string range)
{
  varYRangeName = range;
}

string gnuCurveFit::getVarYRangeName()
{
  return varYRangeName;
}

void gnuCurveFit::setVarYRangeMin(string min)
{
  varYRangeMin = min;
}

string gnuCurveFit::getVarYRangeMin()
{
  return varYRangeMin;
}

void gnuCurveFit::setVarYRangeMax(string max)
{
  varYRangeMax = max;
}

string gnuCurveFit::getVarYRangeMax()
{
  return varYRangeMax;
}

void gnuCurveFit::setParamFile(string file)
{
  paramFile = file;
}

string gnuCurveFit::getParamFile()
{
  return paramFile;
}

void gnuCurveFit::setParamFileFlag(int flag)
{
  paramFileFlag = flag;
}

int gnuCurveFit::getParamFileFlag()
{
  return paramFileFlag;
}

void gnuCurveFit::setParamCSLFlag(int flag)
{
  paramCSLFlag = flag;
}

int gnuCurveFit::getParamCSLFlag()
{
  return paramCSLFlag;
}

void gnuCurveFit::setParamCSL(string list)
{
  paramCSL = list;
}

string gnuCurveFit::getParamCSL()
{
  return paramCSL;
}

void gnuCurveFit::setFitLimit(string limit)
{
  fitLimit = limit;
}

string gnuCurveFit::getFitLimit()
{
  return fitLimit;
}

void gnuCurveFit::setFitMaxIter(string iter)
{
  fitMaxIter = iter;
}

string gnuCurveFit::getFitMaxIter()
{
  return fitMaxIter;
}

void gnuCurveFit::setDataSetStart(string start)
{
  dataSetStart = start;
}

string gnuCurveFit::getDataSetStart()
{
  return dataSetStart;
}

void gnuCurveFit::setDataSetEnd(string end)
{
  dataSetEnd = end;
}

string gnuCurveFit::getDataSetEnd()
{
  return dataSetEnd;
}

void gnuCurveFit::setDataSetInc(string inc)
{
  dataSetInc = inc;
}

string gnuCurveFit::getDataSetInc()
{
  return dataSetInc;
}

void gnuCurveFit::setPointInc(string inc)
{
  pointInc = inc;
}

string gnuCurveFit::getPointInc()
{
  return pointInc;
}

void gnuCurveFit::setLineInc(string inc)
{
  lineInc = inc;
}

string gnuCurveFit::getLineInc()
{
  return lineInc;
}

void gnuCurveFit::setStartPoint(string start)
{
  startPoint = start;
}

string gnuCurveFit::getStartPoint()
{
  return startPoint;
}

void gnuCurveFit::setStartLine(string start)
{
  startLine = start;
}

string gnuCurveFit::getStartLine()
{
  return startLine;
}

void gnuCurveFit::setEndPoint(string end)
{
  endPoint = end;
}

string gnuCurveFit::getEndPoint()
{
  return endPoint;
}

void gnuCurveFit::setEndLine(string end)
{
  endLine = end;
}

string gnuCurveFit::getEndLine()
{
  return endLine;
}

void gnuCurveFit::setXColumn(string col)
{
  xColumn = col;
}

string gnuCurveFit::getXColumn()
{
  return xColumn;
}

void gnuCurveFit::setYColumn(string col)
{
  yColumn = col;
}

string gnuCurveFit::getYColumn()
{
  return yColumn;
}

void gnuCurveFit::setZColumn(string col)
{
  zColumn = col;
}

string gnuCurveFit::getZColumn()
{
  return zColumn;
}

void gnuCurveFit::setFormat(string informat)
{
  format = informat;
}

string gnuCurveFit::getFormat()
{
  return format;
}

void gnuCurveFit::setRawFormat(string format)
{
  rawFormat = format;
}

string gnuCurveFit::getRawFormat()
{
  return rawFormat;
}
