/* -*- c++ -*-
 *
 * webbrowser.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 * Copyright (C) 2003,2007 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kmldonkey_webbrowser_h__
#define __kmldonkey_webbrowser_h__

#include <qwidget.h>
#include <QList>
#include <kurl.h>
#include <khtml_part.h>
#include <ed2kurl.h>

class KSqueezedTextLabel;
class QProgressBar;
class FileInfo;
class KPushButton;

class WebBrowser : public QWidget
{
    Q_OBJECT
public:
    explicit WebBrowser(QWidget* parent);
    virtual ~WebBrowser();

    virtual void handleED2K(const ED2KURL& url);

public slots:

    void openURL(const QString& url);
    void openURL(const KUrl& url, const KParts::OpenUrlArguments& urlargs = KParts::OpenUrlArguments(), const KParts::BrowserArguments browserargs = KParts::BrowserArguments());

protected slots:

    void slotUrlSelected(const KUrl&, const KParts::OpenUrlArguments&, const KParts::BrowserArguments);
    void setStatusBarText(const QString& text);
    void loadingProgress(int percent);

    void backState();
    void forwardState();
    void goHome();

private:
    void restoreState(QByteArray& state);
    QByteArray saveState();
    void pushState();

    KHTMLPart* browser;
    KSqueezedTextLabel* statusbar;
    QProgressBar* progressbar;
    KPushButton *backButton, *forwardButton, *homeButton;

    QList<QByteArray> history;
    int hpos;
    KUrl initialURL;
    bool initialState;
};


#endif // __kmldonkey_webbrowser_h__
