/* -*- c++ -*-
 *
 * gifthost.h
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *                    Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_gifthost_h__
#define __libkmldonkey_gifthost_h__

#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>
#include <qmap.h>
#include <qobject.h>
#include <kaction.h>
#include <kurl.h>

#include "hostiface.h"

//! Representation of an Gift host.
class GiftHost : public HostInterface
{
public:
    GiftHost(const QString& h_name,
             const QString& h_address,
             int h_port,
             const QString& h_username);
    ~GiftHost();

    QString username();

private:
    QString m_username;
};

#endif
