/* -*- c++ -*-
 *
 * statspageclients.h
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_statspageclients_h__
#define __kmldonkey_statspageclients_h__

#include <qframe.h>
#include <qscrollview.h>

class QVBox;

#include "statspage.h"
#include "donkeyprotocol.h"

class ClientsPieWidgetObject
{
public:
    QString label;
    double value;
    QColor color;
};

class ClientsPieWidget : public QFrame
{
public:
    ClientsPieWidget(QWidget *parent);
    void addValue(const QString& label, const double value, QColor color);

protected:
    virtual void paintEvent(QPaintEvent*);

private:
    QValueList<ClientsPieWidgetObject*> values;
};

class StatsPageClientsCallback : public ConsoleCallbackInterface
{
public:
    StatsPageClientsCallback();
    virtual ~StatsPageClientsCallback();
    void callback(const QString& cmd, const QString& res);
    StatsPageClients *page;
private:
    QValueList<QColor> colorsList;
    QValueList<QColor>::iterator colorsListIterator;
    QMap<QString, QColor> colorsMap;
};

class StatsPageClients : public QScrollView
{
    Q_OBJECT
public:
    StatsPageClients(QWidget* parent);
    QVBox *box;
public slots:
    void slotUpdate();
protected:
    void showEvent(QShowEvent* event);
    void hideEvent(QHideEvent *);
    void keyPressEvent(QKeyEvent *);
private:
    StatsPageClientsCallback *callback;
};

#endif
