package kissme.vm.loaders;

import java.util.HashMap;
import java.util.zip.ZipFile;
import java.util.zip.ZipEntry;

import java.io.InputStream;
import java.io.File;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipException;

public class ZipClassLoader {

  private static HashMap zipfilesMap = new HashMap();
  private static Object emptyZipFile = new Object();

  public static byte[] getClassData(String className, String loaderPath)
  {
    Object hashResult = null;
    ZipFile jf = null;

    /* We keep a map of Zipfiles */
    if((hashResult = zipfilesMap.get(loaderPath)) == null)
      {
	/* we haven't created this jar file yet */
	try {
	  jf = new ZipFile(new File(loaderPath));
	} catch(FileNotFoundException fnf)
	  {
	    zipfilesMap.put(loaderPath, emptyZipFile); /* we use this Object to cache the fact that it doesn't exist */
	    return null;
	  }
	 catch(IOException ioe)
	   {
	    zipfilesMap.put(loaderPath, emptyZipFile); /* we use this Object to cache the fact that it doesn't exist */
	    return null;
	   }
	zipfilesMap.put(loaderPath, jf);
      }
    else
      {
	if(hashResult == emptyZipFile)
	  return null;
	
	jf = (ZipFile) hashResult;
      }

    ZipEntry je = (ZipEntry) jf.getEntry(className + ".class");
    if(je != null)
      {
	int length = (int) je.getSize();
	byte[] buffer = new byte[length];
	try {
	  InputStream is = jf.getInputStream(je);
	  int haveread = 0;
	  while(haveread < length)
	    {
	      int res = is.read(buffer, haveread, (length - haveread));
	      if(res == -1)
		return null;
	      haveread += res;
	    }
	} catch(ZipException ze)
	  {
	    return null;
	  }
	 catch(IOException ioe)
	  {
	    return null;
	  }
	return buffer;
      }
    else
      {
	return null;
      }
  }
}
