/**
 * machine.java
 *
 * interface to the kernel.
 */

package jos.system;

public class machine {

	public native static byte  in8( short port );
	public native static char in16( short port );
	public native static int  in32( short port );

	public native static void  out8( short port, byte val );
	public native static void out16( short port, char val );
	public native static void out32( short port, int  val );

    public native static short read8(int address);
    public native static short write8(int address, short value); // Returns 8 bits written.

    public native static int read16(int address);
    public native static int write16(int address, int value); // Returns 16 bits written.

    public native static int read32(int address);
    public native static int write32(int address, int value); // Returns 32 bits written.

  //    public native static void testSVGA();

  //Prints a string to the kernel console buffer thing
  public native static void printk(String s);
    public native static void freeSystemHeap();
  public static void printk(int n)
    {
	printk( new Integer(n).toString());
    }

} /* end jos.system.machine */





