/*-
 * Copyright(c) 2002-2011 Exar Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification are permitted provided the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of the Exar Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*$FreeBSD$*/

#ifndef	VXGE_HAL_REGDEFS_H
#define	VXGE_HAL_REGDEFS_H

__EXTERN_BEGIN_DECLS

#define	VXGE_HAL_TITAN_ASIC_ID_GET_INITIAL_DEVICE_ID(bits)	bVAL16(bits, 0)
#define	VXGE_HAL_TITAN_ASIC_ID_GET_INITIAL_MAJOR_REVISION(bits)	bVAL8(bits, 48)
#define	VXGE_HAL_TITAN_ASIC_ID_GET_INITIAL_MINOR_REVISION(bits)	bVAL8(bits, 56)

#define	VXGE_HAL_VPD_LEN						80
#define	VXGE_HAL_CARD_TITAN_VPD_ADDR					0x80
#define	VPD_READ_COMPLETE						0x80

#define	VXGE_HAL_VPATH_TO_FUNC_MAP_CFG1_GET_CFG1(bits)		bVAL5(bits, 3)

#define	VXGE_HAL_DEBUG_ASSIGNMENTS_GET_VHLABEL(bits)		bVAL5(bits, 3)
#define	VXGE_HAL_DEBUG_ASSIGNMENTS_GET_VPLANE(bits)		bVAL5(bits, 11)
#define	VXGE_HAL_DEBUG_ASSIGNMENTS_GET_FUNC(bits)		bVAL5(bits, 19)

#define	VXGE_HAL_HOST_TYPE_ASSIGNMENTS_GET_HOST_TYPE_ASSIGNMENTS(bits)\
							    bVAL3(bits, 5)
#define	VXGE_HAL_VPLANE_ASSIGNMENTS_GET_VPLANE_ASSIGNMENTS(bits)    \
							    bVAL5(bits, 3)

#define	VXGE_HAL_PF_SW_RESET_COMMAND					0xA5

#define	VXGE_HAL_TITAN_PCICFGMGMT_REG_SPACES				17
#define	VXGE_HAL_TITAN_SRPCIM_REG_SPACES				17
#define	VXGE_HAL_TITAN_VPMGMT_REG_SPACES				17
#define	VXGE_HAL_TITAN_VPATH_REG_SPACES					17

#define	VXGE_HAL_PRIV_VPATH_ACTION					5
#define	VXGE_HAL_BW_CONTROL						12
#define	VXGE_HAL_RTS_ACCESS_FW_MEMO_ACTION_NON_PRIV_BANDWIDTH_CTRL	32
#define	VXGE_HAL_RTS_ACCESS_FW_MEMO_ACTION_PRIV_NWIF			17
#define	VXGE_HAL_API_FUNC_MODE_COMMIT					21

#define	VXGE_HAL_ASIC_MODE_RESERVED					0
#define	VXGE_HAL_ASIC_MODE_NO_IOV					1
#define	VXGE_HAL_ASIC_MODE_SR_IOV					2
#define	VXGE_HAL_ASIC_MODE_MR_IOV					3

#define	VXGE_HAL_TXMAC_GEN_CFG1_TMAC_PERMA_STOP_EN		mBIT(3)
#define	VXGE_HAL_TXMAC_GEN_CFG1_BLOCK_BCAST_TO_WIRE		mBIT(19)
#define	VXGE_HAL_TXMAC_GEN_CFG1_BLOCK_BCAST_TO_SWITCH		mBIT(23)
#define	VXGE_HAL_TXMAC_GEN_CFG1_HOST_APPEND_FCS			mBIT(31)

#define	VXGE_HAL_VPATH_IS_FIRST_GET_VPATH_IS_FIRST(bits)	bVAL1(bits, 3)

#define	VXGE_HAL_TIM_VPATH_ASSIGNMENT_GET_BMAP_ROOT(bits)	bVAL32(bits, 0)

#define	VXGE_HAL_RXMAC_CFG0_PORT_VPMGMT_CLONE_GET_MAX_PYLD_LEN(bits)\
							bVAL14(bits, 50)

#define	VXGE_HAL_XMAC_VSPORT_CHOICES_VP_GET_VSPORT_VECTOR(bits)	bVAL17(bits, 0)

#define	VXGE_HAL_XMAC_VPATH_TO_VSPORT_VPMGMT_CLONE_GET_VSPORT_NUMBER(bits)\
							bVAL5(bits, 3)

#define	VXGE_HAL_KDFC_DRBL_TRIPLET_TOTAL_GET_KDFC_MAX_SIZE(bits)\
							bVAL15(bits, 17)

#define	VXGE_HAL_KDFC_TRPL_FIFO_0_CTRL_MODE_LEGACY_MODE			0
#define	VXGE_HAL_KDFC_TRPL_FIFO_0_CTRL_MODE_NON_OFFLOAD_ONLY		1
#define	VXGE_HAL_KDFC_TRPL_FIFO_0_CTRL_MODE_MULTI_OP_MODE		2

#define	VXGE_HAL_KDFC_TRPL_FIFO_1_CTRL_MODE_MESSAGES_ONLY		0
#define	VXGE_HAL_KDFC_TRPL_FIFO_1_CTRL_MODE_MULTI_OP_MODE		1

#define	VXGE_HAL_TOC_GET_KDFC_INITIAL_OFFSET(val)\
					(val&~VXGE_HAL_TOC_KDFC_INITIAL_BIR(7))
#define	VXGE_HAL_TOC_GET_KDFC_INITIAL_BIR(val)		    bVAL3(val, 61)
#define	VXGE_HAL_TOC_GET_USDC_INITIAL_OFFSET(val)\
					(val&~VXGE_HAL_TOC_USDC_INITIAL_BIR(7))
#define	VXGE_HAL_TOC_GET_USDC_INITIAL_BIR(val)		    bVAL3(val, 61)

#define	VXGE_HAL_LAG_CFG_GET_MODE(bits)			    bVAL2(bits, 6)
#define	VXGE_HAL_LAG_TX_CFG_GET_DISTRIB_ALG_SEL(bits)	    bVAL2(bits, 6)

#define	VXGE_HAL_TOC_KDFC_VPATH_STRIDE_GET_TOC_KDFC_VPATH_STRIDE(bits)	bits
#define	VXGE_HAL_TOC_KDFC_FIFO_STRIDE_GET_TOC_KDFC_FIFO_STRIDE(bits)	bits

#define	VXGE_HAL_KDFC_TRPL_FIFO_OFFSET_GET_KDFC_RCTR0(bits) bVAL15(bits, 1)
#define	VXGE_HAL_KDFC_TRPL_FIFO_OFFSET_GET_KDFC_RCTR1(bits) bVAL15(bits, 17)
#define	VXGE_HAL_KDFC_TRPL_FIFO_OFFSET_GET_KDFC_RCTR2(bits) bVAL15(bits, 33)

#define	VXGE_HAL_KDFC_TRPL_FIFO_OFFSET_KDFC_VAPTH_NUM(val)  vBIT(val, 42, 5)
#define	VXGE_HAL_KDFC_TRPL_FIFO_OFFSET_KDFC_FIFO_NUM(val)   vBIT(val, 47, 2)
#define	VXGE_HAL_KDFC_TRPL_FIFO_OFFSET_KDFC_FIFO_OFFSET(val) vBIT(val, 49, 15)

#define	VXGE_HAL_PRC_CFG4_RING_MODE_ONE_BUFFER				0
#define	VXGE_HAL_PRC_CFG4_RING_MODE_THREE_BUFFER			1
#define	VXGE_HAL_PRC_CFG4_RING_MODE_FIVE_BUFFER				2

#define	VXGE_HAL_PRC_CFG7_SCATTER_MODE_A				0
#define	VXGE_HAL_PRC_CFG7_SCATTER_MODE_B				2
#define	VXGE_HAL_PRC_CFG7_SCATTER_MODE_C				1

#define	VXGE_HAL_RTDMA_BW_CTRL_GET_DESIRED_BW(bits)	    bVAL18(bits, 46)

#define	VXGE_HAL_RTS_MGR_STEER_CTRL_WE_READ				0
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_WE_WRITE				1

#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_DA			0
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_VID			1
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_ETYPE		2
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_PN			3
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_RANGE_PN		4
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_RTH_GEN_CFG		5
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_RTH_SOLO_IT		6
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_RTH_JHASH_CFG	7
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_RTH_MASK		8
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_RTH_KEY		9
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_QOS			10
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_DS			11
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_RTH_MULTI_IT	12
#define	VXGE_HAL_RTS_MGR_STEER_CTRL_DATA_STRUCT_SEL_FW_MEMO		13

#define	VXGE_HAL_RTS_MGR_STEER_DATA0_GET_DA_MAC_ADDR(bits)  bVAL48(bits, 0)
#define	VXGE_HAL_RTS_MGR_STEER_DATA0_DA_MAC_ADDR(val)	    vBIT(val, 0, 48)

#define	VXGE_HAL_RTS_MGR_STEER_DATA1_GET_DA_MAC_ADDR_MASK(bits) bVAL48(bits, 0)
#define	VXGE_HAL_RTS_MGR_STEER_DATA1_DA_MAC_ADDR_MASK(val)  vBIT(val, 0, 48)
#define	VXGE_HAL_RTS_MGR_STEER_DATA1_DA_MAC_ADDR_ADD_PRIVILEGED_MODE mBIT(54)
#define	VXGE_HAL_RTS_MGR_STEER_DATA1_GET_DA_MAC_ADDR_ADD_VPATH(bits)\
							    bVAL5(bits, 55)
#define	VXGE_HAL_RTS_MGR_STEER_DATA1_DA_MAC_ADDR_ADD_VPATH(val)	vBIT(val, 55, 5)
#define	VXGE_HAL_RTS_MGR_STEER_DATA1_GET_DA_MAC_ADDR_ADD_MODE(bits)\
							    bVAL2(bits, 62)
#define	VXGE_HAL_RTS_MGR_STEER_DATA1_DA_MAC_ADDR_MODE(val)  vBIT(val, 62, 2)

#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_ADD_ENTRY			0
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_DELETE_ENTRY		1
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_LIST_FIRST_ENTRY		2
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_LIST_NEXT_ENTRY		3
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_READ_ENTRY		0
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_WRITE_ENTRY		1
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_CLEAR_TABLE		2
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_FW_MEMO_VERSION		0
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_FW_MEMO_CARD_INFO		3
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_LED_CONTROL		4
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_VPATH_MAP			5
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_PCI_CONFIG		6
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_UDP_RTH			10
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_FUNC_MODE			11
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_SEND_MSG			15
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_FW_UPGRADE		16
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_PORT_CTRL			17
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_PORT_INFO			18
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_COMMIT			21
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_GET_FUNC_COUNT		24
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_GET_FUNC_MODE		29
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_ACTION_ALL_CLEAR			172

#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_DA		0
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_VID		1
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_ETYPE		2
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_PN		3
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_RTH_GEN_CFG	5
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_RTH_SOLO_IT	6
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_RTH_JHASH_CFG	7
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_RTH_MASK		8
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_RTH_KEY		9
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_QOS		10
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_DS		11
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_RTH_MULTI_IT	12
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_DATA_STRUCT_SEL_FW_MEMO		13
#define	VXGE_HAL_MSG_SEND_TO_VPATH_MASK				0xFFFFFFFFUL
#define	VXGE_HAL_MSG_SEND_RETRY						100

#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_OFFSET_FW_UPGRADE_MODE		2
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_OFFSET_FW_UPGRADE_DATA		3
#define	VXGE_HAL_RTS_ACCESS_STEER_CTRL_OFFSET_FW_UPGRADE_COMMIT		4

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_STREAM_SKIP	    mBIT(63)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_GET_RET_CODE(bits) \
							    bVAL8(bits, 56)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_GET_RET_CODE_OK	0
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_GET_RET_CODE_DONE	1
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_GET_RET_CODE_ERROR	2
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_GET_RET_CODE_SKIP	3
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_GET_SUB_CODE(bits) \
							    bVAL8(bits, 48)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_GET_SUB_SUB_CODE(bits) \
							    bVAL8(bits, 40)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_UPGRADE_GET_SKIP_BYTES(bits) \
							    bVAL32(bits, 24)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_FW_UPGRADE_GET_TOTAL_STEPS(bits) \
							    bVAL32(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_FW_UPGRADE_GET_COMPL_STEPS(bits) \
							    bVAL32(bits, 32)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_DA_MAC_ADDR(bits) bVAL48(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_DA_MAC_ADDR(val)    vBIT(val, 0, 48)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_VLAN_ID(bits)   bVAL11(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_VLAN_ID(val)	    vBIT(val, 0, 12)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_ETYPE(bits)	    bVAL11(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_ETYPE(val)	    vBIT(val, 0, 16)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_SEND_MSG_TYPE(val)	vBIT(val, 0, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_SEND_MSG_DEST(val)	vBIT(val, 8, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_SEND_MSG_SRC(val)    vBIT(val, 16, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_SEND_MSG_DATA(val)    vBIT(val, 32, 32)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_PN_SRC_DEST_SEL(bits) bVAL1(bits, 3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_PN_SRC_DEST_SEL	    mBIT(3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_PN_TCP_UDP_SEL(bits) bVAL1(bits, 7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_PN_TCP_UDP_SEL	    mBIT(7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_PN_PORT_NUM(bits) bVAL16(bits, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_PN_PORT_NUM(val)    vBIT(val, 8, 16)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_RTH_EN(bits) bVAL1(bits, 3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_RTH_EN	    mBIT(3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_BUCKET_SIZE(bits)\
							    bVAL4(bits, 4)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_BUCKET_SIZE(val) vBIT(val, 4, 4)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_ALG_SEL(bits)\
							    bVAL2(bits, 10)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_ALG_SEL(val) vBIT(val, 10, 2)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_ALG_SEL_JENKINS	0
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_ALG_SEL_MS_RSS	1
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_ALG_SEL_CRC32C	2
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_RTH_TCP_IPV4_EN(bits)\
							    bVAL1(bits, 15)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_RTH_TCP_IPV4_EN	mBIT(15)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_RTH_IPV4_EN(bits)\
							    bVAL1(bits, 19)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_RTH_IPV4_EN mBIT(19)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_RTH_TCP_IPV6_EN(bits)\
							    bVAL1(bits, 23)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_RTH_TCP_IPV6_EN	mBIT(23)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_RTH_IPV6_EN(bits)\
							    bVAL1(bits, 27)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_RTH_IPV6_EN mBIT(27)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_RTH_TCP_IPV6_EX_EN(bits)\
							    bVAL1(bits, 31)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_RTH_TCP_IPV6_EX_EN mBIT(31)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_RTH_IPV6_EX_EN(bits)\
							    bVAL1(bits, 35)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_RTH_IPV6_EX_EN	mBIT(35)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_ACTIVE_TABLE(bits)\
							    bVAL1(bits, 39)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_ACTIVE_TABLE mBIT(39)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_GEN_REPL_ENTRY_EN(bits)\
							    bVAL1(bits, 43)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_GEN_REPL_ENTRY_EN mBIT(43)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_SOLO_IT_ENTRY_EN(bits)\
							    bVAL1(bits, 3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_SOLO_IT_ENTRY_EN mBIT(3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_SOLO_IT_BUCKET_DATA(bits)\
							    bVAL7(bits, 9)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_SOLO_IT_BUCKET_DATA(val)\
							    vBIT(val, 9, 7)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_ITEM0_BUCKET_NUM(bits)\
							    bVAL8(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_ITEM0_BUCKET_NUM(val)\
							    vBIT(val, 0, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_ITEM0_ENTRY_EN(bits)\
							    bVAL1(bits, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_ITEM0_ENTRY_EN  mBIT(8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_ITEM0_BUCKET_DATA(bits)\
							    bVAL7(bits, 9)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_ITEM0_BUCKET_DATA(val)\
							    vBIT(val, 9, 7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_ITEM1_BUCKET_NUM(bits)\
							    bVAL8(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_ITEM1_BUCKET_NUM(val)\
							    vBIT(val, 16, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_ITEM1_ENTRY_EN(bits)\
							    bVAL1(bits, 24)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_ITEM1_ENTRY_EN  mBIT(24)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_ITEM1_BUCKET_DATA(bits)\
							    bVAL7(bits, 25)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_ITEM1_BUCKET_DATA(val)\
							    vBIT(val, 25, 7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM0_BUCKET_NUM(bits)\
							    bVAL8(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM0_BUCKET_NUM(val)\
							    vBIT(val, 0, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM0_ENTRY_EN(bits)\
							    bVAL1(bits, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM0_ENTRY_EN  mBIT(8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM0_BUCKET_DATA(bits)\
							    bVAL7(bits, 9)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM0_BUCKET_DATA(val)\
							    vBIT(val, 9, 7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM1_BUCKET_NUM(bits)\
							    bVAL8(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM1_BUCKET_NUM(val)\
							    vBIT(val, 16, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM1_ENTRY_EN(bits)\
							    bVAL1(bits, 24)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM1_ENTRY_EN  mBIT(24)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM1_BUCKET_DATA(bits)\
							    bVAL7(bits, 25)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM1_BUCKET_DATA(val)\
							    vBIT(val, 25, 7)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_JHASH_CFG_GOLDEN_RATIO(bits)\
							    bVAL32(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_JHASH_CFG_GOLDEN_RATIO(val)\
							    vBIT(val, 0, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_JHASH_CFG_INIT_VALUE(bits)\
							    bVAL32(bits, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_JHASH_CFG_INIT_VALUE(val)\
							    vBIT(val, 32, 32)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_MASK_IPV6_SA_MASK(bits)\
							    bVAL16(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_MASK_IPV6_SA_MASK(val)\
							    vBIT(val, 0, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_MASK_IPV6_DA_MASK(bits)\
							    bVAL16(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_MASK_IPV6_DA_MASK(val)\
							    vBIT(val, 16, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_MASK_IPV4_SA_MASK(bits)\
							    bVAL4(bits, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_MASK_IPV4_SA_MASK(val)\
							    vBIT(val, 32, 4)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_MASK_IPV4_DA_MASK(bits)\
							    bVAL4(bits, 36)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_MASK_IPV4_DA_MASK(val)\
							    vBIT(val, 36, 4)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_MASK_L4SP_MASK(bits)\
							    bVAL2(bits, 40)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_MASK_L4SP_MASK(val)	vBIT(val, 40, 2)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_MASK_L4DP_MASK(bits)\
							    bVAL2(bits, 42)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_MASK_L4DP_MASK(val)	vBIT(val, 42, 2)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_RTH_KEY_KEY(bits)	bVAL64(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_RTH_KEY_KEY		vBIT(val, 0, 64)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_QOS_ENTRY_EN(bits)	bVAL1(bits, 3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_QOS_ENTRY_EN		mBIT(3)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_DS_ENTRY_EN(bits)	bVAL1(bits, 3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_DS_ENTRY_EN		mBIT(3)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_DA_MAC_ADDR_MASK(bits)\
								bVAL48(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_DA_MAC_ADDR_MASK(val)	vBIT(val, 0, 48)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_DA_MAC_ADDR_ADD_PRIVILEGED_MODE	mBIT(54)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_DA_MAC_ADDR_ADD_VPATH(bits)\
							    bVAL5(bits, 55)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_DA_MAC_ADDR_ADD_VPATH(val)\
							    vBIT(val, 55, 5)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_DA_MAC_ADDR_ADD_MODE(bits)\
							    bVAL2(bits, 62)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_DA_MAC_ADDR_MODE(val)	vBIT(val, 62, 2)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM4_BUCKET_NUM(bits)\
							    bVAL8(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM4_BUCKET_NUM(val)\
							    vBIT(val, 0, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM4_ENTRY_EN(bits)\
							    bVAL1(bits, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM4_ENTRY_EN  mBIT(8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM4_BUCKET_DATA(bits)\
							    bVAL7(bits, 9)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM4_BUCKET_DATA(val)\
							    vBIT(val, 9, 7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM5_BUCKET_NUM(bits)\
							    bVAL8(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM5_BUCKET_NUM(val)\
							    vBIT(val, 16, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM5_ENTRY_EN(bits)\
							    bVAL1(bits, 24)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM5_ENTRY_EN  mBIT(24)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM5_BUCKET_DATA(bits)\
							    bVAL7(bits, 25)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM5_BUCKET_DATA(val)\
							    vBIT(val, 25, 7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM6_BUCKET_NUM(bits)\
							    bVAL8(bits, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM6_BUCKET_NUM(val)\
							    vBIT(val, 32, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM6_ENTRY_EN(bits)\
							    bVAL1(bits, 40)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM6_ENTRY_EN  mBIT(40)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM6_BUCKET_DATA(bits)\
							    bVAL7(bits, 41)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM6_BUCKET_DATA(val)\
							    vBIT(val, 41, 7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM7_BUCKET_NUM(bits)\
							    bVAL8(bits, 48)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM7_BUCKET_NUM(val)\
							    vBIT(val, 48, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM7_ENTRY_EN(bits)\
							    bVAL1(bits, 56)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM7_ENTRY_EN  mBIT(56)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RTH_ITEM7_BUCKET_DATA(bits)\
							    bVAL7(bits, 57)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_RTH_ITEM7_BUCKET_DATA(val)\
							    vBIT(val, 57, 7)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_FW_VERSION		0
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PART_NUMBER		0
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_SERIAL_NUMBER		1
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_FLASH_VERSION		2
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PCI_MODE		3
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_DESC_0		4
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_DESC_1		5
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_DESC_2		6
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_DESC_3		7
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORTS			8

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORT0_PMD_TYPE	10
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORT0_PMD_VENDOR	11
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORT0_PMD_PARTNO	13
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORT0_PMD_SERNO	14

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORT1_PMD_TYPE	20
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORT1_PMD_VENDOR	21
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORT1_PMD_PARTNO	23
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_PORT1_PMD_SERNO	24

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_LAG_MODE		1
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_ACTIVE_PORT		2

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_MEMO_ITEM_STATUS(bits)	\
							    bVAL8(bits, 56)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_STATUS(val)		\
							    vBIT(val, 56, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_STATUS_SUCCESS	1
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MEMO_ITEM_STATUS_FAIL		0

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_MEMO_ITEM_GET_LAG_MODE(bits)	\
							    bVAL3(bits, 61)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_MEMO_ITEM_LAG_MODE(val)		\
							    vBIT(val, 61, 3)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_MEMO_ITEM_PREFFERRED_PORT   mBIT(62)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_MEMO_ITEM_ACTIVE_PORT	    mBIT(63)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_LED_CONTROL_ON			1
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_LED_CONTROL_OFF			0

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_PCI_ADDR(bits)  bVAL16(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_PCI_ADDR(val)	    vBIT(val, 16, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_PCI_CONFIG_READ			0
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_PCI_CONFIG_WRITE	    mBIT(39)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_BYTE_COUNT(bits) bVAL8(bits, 40)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_BYTE_COUNT(val)	    vBIT(val, 40, 8)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_VH(bits)	    bVAL8(bits, 48)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_VH(val)		    vBIT(val, 48, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FUNCTION(bits)  bVAL8(bits, 56)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNCTION(val)	    vBIT(val, 56, 8)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_PCI_DATA(bits)  bVAL32(bits, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_PCI_DATA(val)	    vBIT(val, 32, 32)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_PCI_DATA(bits)  bVAL32(bits, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_PCI_DATA(val)	    vBIT(val, 32, 32)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_IS_VPATH_ASSIGNED(vpid) mBIT((63-vpid))

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_IGNORE_IN_SVC_CHECK mBIT(0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_MSG_TYPE(bits)  bVAL7(bits, 1)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE(val)	    vBIT(val, 1, 7)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE_UNKNOWN		0
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE_DEVICE_RESET_BEGIN	1
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE_DEVICE_RESET_END	2
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE_VPATH_RESET_BEGIN	3
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE_VPATH_RESET_END	4
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE_PRIV_DRIVER_UP		5
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE_PRIV_DRIVER_DOWN	6
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_TYPE_ACK			127
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_MSG_DEST(bits)  bVAL8(bits, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_DEST(val)	    vBIT(val, 8, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_MSG_DEST_MRPCIM	    0xfe
#define	VXGE_HAL_RTS_ACCESS_STEER_MSG_DEST_BROADCAST	    0xff
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_MSG_SRC(bits)   bVAL8(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_SRC(val)	    vBIT(val, 16, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_SEQ_NUM(bits)   bVAL32(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_SEQ_NUM(val)	    vBIT(val, 32, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_MSG_DATA(bits)  bVAL16(bits, 48)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_DATA(val)	    vBIT(val, 48, 16)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_ERROR_PENDING	0
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_MSG_ERROR_NOT_IN_SVC	1

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_UDP_RTH_ENABLE		mBIT(63)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_VHN(val)		vBIT(val, 48, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_VFID(val)		vBIT(val, 56, 8)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RX_PRIORITY(bits)	bVAL3(bits, 45)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RX_MIN_BW(bits)	bVAL8(bits, 48)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_RX_MAX_BW(bits)	bVAL8(bits, 56)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_SET_RX_PRIORITY(val)	vBIT(val, 45, 3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_SET_RX_MIN_BW(val)	vBIT(val, 48, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_SET_RX_MAX_BW(val)	vBIT(val, 56, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_SET_VPATH_OR_FUNC(val)	vBIT(val, 0, 8)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_TX_PRIORITY(bits)	bVAL3(bits, 21)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_TX_MIN_BW(bits)	bVAL8(bits, 24)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_GET_TX_MAX_BW(bits)	bVAL8(bits, 32)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_SET_TX_PRIORITY(val)	vBIT(val, 21, 3)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_SET_TX_MIN_BW(val)	vBIT(val, 24, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA1_SET_TX_MAX_BW(val)	vBIT(val, 32, 8)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_NUM_FUNC(bits)	bVAL8(bits, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FUNC_MODE(bits)	bVAL8(bits, 56)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE(val)		vBIT(val, 56, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_SF1_VP17	0
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_MF8_VP2	1
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_SR17_VP1	2
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_MR17_VP1	3
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_MR8_VP2	4
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_MF17_VP1	5
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_SR8_VP2	6
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_SR4_VP4	7
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_MF2_VP8	8
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_MF4_VP4	9
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_MR4_VP4	10
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FUNC_MODE_MF8P_VP2	11

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FW_VER_DAY(bits)\
							    bVAL8(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_VER_DAY(val)	vBIT(val, 0, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FW_VER_MONTH(bits)\
							    bVAL8(bits, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_VER_MONTH(val)   vBIT(val, 8, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FW_VER_YEAR(bits) bVAL16(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_VER_YEAR(val)    vBIT(val, 16, 16)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FW_VER_MAJOR(bits)\
							    bVAL8(bits, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_VER_MAJOR	vBIT(val, 32, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FW_VER_MINOR(bits)\
							    bVAL8(bits, 40)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_VER_MINOR	vBIT(val, 40, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FW_VER_BUILD(bits)\
							    bVAL16(bits, 48)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FW_VER_BUILD	vBIT(val, 48, 16)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FLASH_VER_DAY(bits)\
							    bVAL8(bits, 0)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FLASH_VER_DAY(val)  vBIT(val, 0, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FLASH_VER_MONTH(bits)\
							    bVAL8(bits, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FLASH_VER_MONTH(val) vBIT(val, 8, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FLASH_VER_YEAR(bits)\
							    bVAL16(bits, 16)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FLASH_VER_YEAR(val) vBIT(val, 16, 16)

#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FLASH_VER_MAJOR(bits)\
							    bVAL8(bits, 32)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FLASH_VER_MAJOR	    vBIT(val, 32, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FLASH_VER_MINOR(bits)\
							    bVAL8(bits, 40)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FLASH_VER_MINOR	    vBIT(val, 40, 8)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_FLASH_VER_BUILD(bits)\
							    bVAL16(bits, 48)
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_FLASH_VER_BUILD	    vBIT(val, 48, 16)

/* Netork port control API related */
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_SET_NWIF_CMD(val)	vBIT(val, 0, 8)

/* Bandwidth & priority related MACROS */
#define	VXGE_HAL_RTS_ACCESS_STEER_DATA0_GET_API_VER(bits) \
							vxge_bVALn(bits, 0, 8)

#define	VXGE_HAL_ASIC_NTWK_VP_CTRL_GET_XMACJ_SHOW_PORT_INFO(bits)\
							    bVAL1(bits, 55)
#define	VXGE_HAL_ASIC_NTWK_VP_CTRL_GET_XMACJ_PORT_NUM(bits) bVAL1(bits, 63)

#define	VXGE_HAL_SRPCIM_TO_VPATH_ALARM_REG_GET_ALARM(bits)  bVAL17(bits, 0)

#define	VXGE_HAL_RX_MULTI_CAST_STATS_GET_FRAME_DISCARD(bits) bVAL16(bits, 48)
#define	VXGE_HAL_RX_FRM_TRANSFERRED_GET_RX_FRM_TRANSFERRED(bits)\
							    bVAL32(bits, 32)
#define	VXGE_HAL_RXD_RETURNED_GET_RXD_RETURNED(bits)	    bVAL16(bits, 48)
#define	VXGE_HAL_PRC_RXD_DOORBELL_GET_NEW_QW_CNT(bits)	    bVAL16(bits, 48)
#define	VXGE_HAL_PRC_CFG6_GET_RXD_SPAT(bits)		    bVAL9(bits, 36)
#define	VXGE_HAL_VPATH_DEBUG_STATS0_GET_INI_NUM_MWR_SENT(bits) bVAL32(bits, 0)
#define	VXGE_HAL_VPATH_DEBUG_STATS1_GET_INI_NUM_MRD_SENT(bits) bVAL32(bits, 0)
#define	VXGE_HAL_VPATH_DEBUG_STATS2_GET_INI_NUM_CPL_RCVD(bits) bVAL32(bits, 0)
#define	VXGE_HAL_VPATH_DEBUG_STATS3_GET_INI_NUM_MWR_BYTE_SENT(bits) (bits)
#define	VXGE_HAL_VPATH_DEBUG_STATS4_GET_INI_NUM_CPL_BYTE_RCVD(bits) (bits)
#define	VXGE_HAL_VPATH_DEBUG_STATS5_GET_WRCRDTARB_XOFF(bits) bVAL32(bits, 32)
#define	VXGE_HAL_VPATH_DEBUG_STATS6_GET_RDCRDTARB_XOFF(bits) bVAL32(bits, 32)
#define	VXGE_HAL_VPATH_GENSTATS_COUNT01_GET_PPIF_VPATH_GENSTATS_COUNT1(bits)\
							    bVAL32(bits, 0)
#define	VXGE_HAL_VPATH_GENSTATS_COUNT01_GET_PPIF_VPATH_GENSTATS_COUNT0(bits)\
							    bVAL32(bits, 32)
#define	VXGE_HAL_VPATH_GENSTATS_COUNT23_GET_PPIF_VPATH_GENSTATS_COUNT3(bits)\
							    bVAL32(bits, 0)
#define	VXGE_HAL_VPATH_GENSTATS_COUNT23_GET_PPIF_VPATH_GENSTATS_COUNT2(bits)\
							    bVAL32(bits, 32)
#define	VXGE_HAL_VPATH_GENSTATS_COUNT4_GET_PPIF_VPATH_GENSTATS_COUNT4(bits)\
							    bVAL32(bits, 0)
#define	VXGE_HAL_VPATH_GENSTATS_COUNT5_GET_PPIF_VPATH_GENSTATS_COUNT5(bits)\
							    bVAL32(bits, 32)
#define	\
    VXGE_HAL_TX_VP_RESET_DISCARDED_FRMS_GET_TX_VP_RESET_DISCARDED_FRMS(bits)\
							    bVAL16(bits, 48)
#define	VXGE_HAL_DBG_STATS_GET_RX_MPA_CRC_FAIL_FRMS(bits)   bVAL16(bits, 0)
#define	VXGE_HAL_DBG_STATS_GET_RX_MPA_MRK_FAIL_FRMS(bits)   bVAL16(bits, 16)
#define	VXGE_HAL_DBG_STATS_GET_RX_MPA_LEN_FAIL_FRMS(bits)   bVAL16(bits, 32)
#define	VXGE_HAL_DBG_STATS_GET_RX_FAU_RX_WOL_FRMS(bits)	    bVAL16(bits, 0)
#define	VXGE_HAL_DBG_STATS_GET_RX_FAU_RX_VP_RESET_DISCARDED_FRMS(bits)\
							    bVAL16(bits, 16)
#define	VXGE_HAL_DBG_STATS_GET_RX_FAU_RX_PERMITTED_FRMS(bits) bVAL16(bits, 32)

#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_OP_TYPE_ADDR			0x0
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_OP_TYPE_WRITE			0x1
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_OP_TYPE_READ_INCR			0x2
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_OP_TYPE_READ			0x3
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_OP_TYPE_RESERVED			0x4
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_OP_TYPE_ADDR_WRITE		0x5
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_OP_TYPE_ADDR_READ_INCR		0x6
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_OP_TYPE_ADDR_READ			0x7

#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_PMA_CONTROL_1		0x0000
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_PMA_CONTROL_1_LOOPBACK	0x01

#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL		0x8000
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_1_BYTE	0x02
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_256_BYTES	0x03
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_COMPLETE	0x04
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_PROGRESS	0x08
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_FAILED	0x0C
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_STAT_MASK	0x0C
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_READ	0x00
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_WRITE	0x20
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_CONTROL_ADDR(val)	(val<<8)

#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_DATA_XFP_TEMP_1	0x8067
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_DATA_XFP_TEMP_2	0x8068
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_EEPROM_NVR_DATA_DATA(val)\
							    (val&0xff)

#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_ALARM_FLAG		0xA070
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_ALARM_FLAG_PWR_LOW	0x01
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_ALARM_FLAG_PWR_HIGH	0x02
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_ALARM_FLAG_CUR_LOW	0x04
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_ALARM_FLAG_CUR_HIGH	0x08
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_ALARM_FLAG_TEMP_LOW	0x40
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_ALARM_FLAG_TEMP_HIGH	0x80

#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_WARN_FLAG		0xA074
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_WARN_FLAG_PWR_LOW	0x01
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_WARN_FLAG_PWR_HIGH	0x02
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_WARN_FLAG_CUR_LOW	0x04
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_WARN_FLAG_CUR_HIGH	0x08
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_WARN_FLAG_TEMP_LOW	0x40
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_TX_WARN_FLAG_TEMP_HIGH	0x80

#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT			0xA100
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_SINGLE_UPDATE	0x0000
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_SLOW_PER_UPDATE	0x0001
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_INT_PER_UPDATE	0x0002
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_FAST_PER_UPDATE	0x0003
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_READ_IDLE	0x0000
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_READ_COMPLETE	0x0004
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_READ_PROGRESS	0x0008
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_READ_FAILED	0x000C
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_UPLOAD_EN	0x0010
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_256_BYTES	0x0000
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_1_BYTES		0x0100
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_WRITE_IDLE	0x0000
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_WRITE_COMPLETE	0x1000
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_WRITE_PROGRESS	0x2000
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_DOM_CMD_STAT_WRITE_FAILED	0x3000


#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_TX_LED			0xD006
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_RX_LED			0xD007
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_ADDR_LINK_LED			0xD008

#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_DEVAD_PMA_PMD			1
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_DEVAD_PCS				3
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_DEVAD_PHY_XS			4
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_DEVAD_DTE_XS			5
#define	VXGE_HAL_MDIO_MGR_ACCESS_PORT_DEVAD_AN				7

#define	VXGE_HAL_MDIO_GEN_CFG_PORT_GET_MDIO_PHY_PRTAD(bits) bVAL5(bits, 19)
#define	VXGE_HAL_MDIO_GEN_CFG_PORT_MDIO_PHY_PRTAD(val)	    vBIT(val, 19, 5)

#define	VXGE_HAL_XGXS_STATIC_CFG_PORT_GET_MDIO_DTE_PRTAD(bits) bVAL5(bits, 7)
#define	VXGE_HAL_XGXS_STATIC_CFG_PORT_MDIO_DTE_PRTAD(val)   vBIT(val, 7, 5)

#define	VXGE_HAL_MDIO_MGR_ACCESS_GET_PORT_DATA(bits)	    bVAL16(bits, 32)

#define	VXGE_HAL_MRPCIM_DEBUG_STATS0_GET_INI_WR_DROP(bits)  bVAL32(bits, 0)
#define	VXGE_HAL_MRPCIM_DEBUG_STATS0_GET_INI_RD_DROP(bits)  bVAL32(bits, 32)
#define	\
    VXGE_HAL_MRPCIM_DEBUG_STATS1_GET_VPLANE_WRCRDTARB_PH_CRDT_DEPLETED(bits)\
							    bVAL32(bits, 32)
#define	\
    VXGE_HAL_MRPCIM_DEBUG_STATS2_GET_VPLANE_WRCRDTARB_PD_CRDT_DEPLETED(bits)\
							    bVAL32(bits, 32)
#define	\
    VXGE_HAL_MRPCIM_DEBUG_STATS3_GET_VPLANE_RDCRDTARB_NPH_CRDT_DEPLETED(bits)\
							    bVAL32(bits, 32)
#define	VXGE_HAL_MRPCIM_DEBUG_STATS4_GET_INI_WR_VPIN_DROP(bits) bVAL32(bits, 0)
#define	VXGE_HAL_MRPCIM_DEBUG_STATS4_GET_INI_RD_VPIN_DROP(bits) bVAL32(bits, 32)
#define	VXGE_HAL_GENSTATS_COUNT01_GET_GENSTATS_COUNT1(bits) bVAL32(bits, 0)
#define	VXGE_HAL_GENSTATS_COUNT01_GET_GENSTATS_COUNT0(bits) bVAL32(bits, 32)
#define	VXGE_HAL_GENSTATS_COUNT23_GET_GENSTATS_COUNT3(bits) bVAL32(bits, 0)
#define	VXGE_HAL_GENSTATS_COUNT23_GET_GENSTATS_COUNT2(bits) bVAL32(bits, 32)
#define	VXGE_HAL_GENSTATS_COUNT4_GET_GENSTATS_COUNT4(bits)  bVAL32(bits, 32)
#define	VXGE_HAL_GENSTATS_COUNT5_GET_GENSTATS_COUNT5(bits)  bVAL32(bits, 32)

#define	VXGE_HAL_DEBUG_STATS0_GET_RSTDROP_MSG(bits)	    bVAL32(bits, 0)
#define	VXGE_HAL_DEBUG_STATS0_GET_RSTDROP_CPL(bits)	    bVAL32(bits, 32)
#define	VXGE_HAL_DEBUG_STATS1_GET_RSTDROP_CLIENT0(bits)	    bVAL32(bits, 0)
#define	VXGE_HAL_DEBUG_STATS1_GET_RSTDROP_CLIENT1(bits)	    bVAL32(bits, 32)
#define	VXGE_HAL_DEBUG_STATS2_GET_RSTDROP_CLIENT2(bits)	    bVAL32(bits, 0)
#define	VXGE_HAL_DEBUG_STATS3_GET_VPLANE_DEPL_PH(bits)	    bVAL16(bits, 0)
#define	VXGE_HAL_DEBUG_STATS3_GET_VPLANE_DEPL_NPH(bits)	    bVAL16(bits, 16)
#define	VXGE_HAL_DEBUG_STATS3_GET_VPLANE_DEPL_CPLH(bits)    bVAL16(bits, 32)
#define	VXGE_HAL_DEBUG_STATS4_GET_VPLANE_DEPL_PD(bits)	    bVAL16(bits, 0)
#define	VXGE_HAL_DEBUG_STATS4_GET_VPLANE_DEPL_NPD(bits)	    bVAL16(bits, 16)
#define	VXGE_HAL_DEBUG_STATS4_GET_VPLANE_DEPL_CPLD(bits)    bVAL16(bits, 32)

#define	VXGE_HAL_ORP_LRO_EVENTS_GET_ORP_LRO_EVENTS(bits)    (bits)
#define	VXGE_HAL_ORP_BS_EVENTS_GET_ORP_BS_EVENTS(bits)	    (bits)
#define	VXGE_HAL_ORP_IWARP_EVENTS_GET_ORP_IWARP_EVENTS(bits) (bits)
#define	VXGE_HAL_DBG_STATS_TPA_TX_PATH_GET_TX_PERMITTED_FRMS(bits)\
							    bVAL32(bits, 32)

#define	VXGE_HAL_DBG_STAT_TX_ANY_FRMS_GET_PORT0_TX_ANY_FRMS(bits)\
							    bVAL8(bits, 0)
#define	VXGE_HAL_DBG_STAT_TX_ANY_FRMS_GET_PORT1_TX_ANY_FRMS(bits)\
							    bVAL8(bits, 8)
#define	VXGE_HAL_DBG_STAT_TX_ANY_FRMS_GET_PORT2_TX_ANY_FRMS(bits)\
							    bVAL8(bits, 16)

#define	VXGE_HAL_DBG_STAT_RX_ANY_FRMS_GET_PORT0_RX_ANY_FRMS(bits)\
							    bVAL8(bits, 0)
#define	VXGE_HAL_DBG_STAT_RX_ANY_FRMS_GET_PORT1_RX_ANY_FRMS(bits)\
							    bVAL8(bits, 8)
#define	VXGE_HAL_DBG_STAT_RX_ANY_FRMS_GET_PORT2_RX_ANY_FRMS(bits)\
							    bVAL8(bits, 16)

__EXTERN_END_DECLS

#endif	/* VXGE_HAL_REGDEFS_H */
