/**************************************************************************
 *  Kchmviewer - a CHM file viewer with broad language support            *
 *  Copyright (C) 2004-2010 George Yunaev, kchmviewer@ulduzsoft.com       *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *																	      *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/


#if 0

#include "kde-qt.h"
#include "viewwindow.h"


class ViewWindow_QtWebKit : public QWebView, public ViewWindow
{
	Q_OBJECT
	public:
		ViewWindow_QtWebKit( ViewWindowTabs * parent );
		~ViewWindow_QtWebKit();

		//! Open a page from current chm archive
		virtual bool	openPage (const QString& url);
		
		//! Invalidate current view, doing all the cleanups etc.
		virtual void	invalidate();
	
		//! Return current ZoomFactor.
		virtual int		getZoomFactor() const { return m_zoomfactor; }
		
		//! Sets ZoomFactor. The value returned by getZoomFactor(), given to this function, should give the same result.
		virtual void	setZoomFactor (int zoom);
		
		//! Relatively changes ZoomFactor. Most common values are -1 and 1.
		virtual void	addZoomFactor (int value);
	
		//! Popups the print dialog, and prints the current page on the printer.
		virtual bool	printCurrentPage();
	
		//! Select the content of the whole page
		virtual void	clipSelectAll();
	
		//! Copies the selected content to the clipboard
		virtual void	clipCopy();
	
		//! Implements "find in page" functionality
		virtual void	find( const QString& text, int flags );
		virtual void	onFindNext();
		virtual void	onFindPrevious();
	
		/*!
		* Return current scrollbar position in view window. Saved on program exit. 
		* There is no restriction on returned value, except that giving this value to 
		* setScrollbarPosition() should move the scrollbar in the same position.
		*/
		virtual int		getScrollbarPosition();
		
		//! Sets the scrollbar position.
		virtual void	setScrollbarPosition(int pos);
	
		virtual QObject *	getQObject() { return this; }
		virtual QWidget *	getQWidget() { return this; }
	
		static	QString decodeUrl( const QString &url );
			

	

		
	private:
		// Overloaded to provide custom context menu
		void 			contextMenuEvent( QContextMenuEvent *e );
		
		void			mouseReleaseEvent ( QMouseEvent * event );

		void			find( bool forward, bool backward );
		
		QMenu * 		createPopupMenu ( const QPoint & pos );
		
		// Overriden to change the source
		void			setSource ( const QUrl & name );
		
		QString			anchorAt( const QPoint & pos );
		
		int				m_zoomfactor;
		bool			m_allowSourceChange;
	
		// Search data
		QString			m_searchText;
		int 			m_flags;
};


#endif /* KCHMVIEWWINDOW_QTWEBKIT_H */
