# Sanitizer support

## General considerations

Using Clang's sanitizers obviously require you to use Clang (`USECLANG=1`), but there's another
catch: most sanitizers require a run-time library, provided by the host compiler, while the instrumented
code generated by Julia's JIT relies on functionality from that library. This implies that the
LLVM version of your host compiler matches that of the LLVM library used within Julia.

An easy solution is to have an dedicated build folder for providing a matching toolchain, by building
with `BUILD_LLVM_CLANG=1`. You can then refer to this toolchain from another build
folder by specifying `USECLANG=1` while overriding the `CC` and `CXX` variables.

## Address Sanitizer (ASAN)

For detecting or debugging memory bugs, you can use Clang's [address sanitizer (ASAN)](http://clang.llvm.org/docs/AddressSanitizer.html).
By compiling with `SANITIZE=1` you enable ASAN for the Julia compiler and its generated code.
In addition, you can specify `LLVM_SANITIZE=1` to sanitize the LLVM library as well. Note that
these options incur a high performance and memory cost. For example, using ASAN for Julia and
LLVM makes `testall1` takes 8-10 times as long while using 20 times as much memory (this can be
reduced to respectively a factor of 3 and 4 by using the options described below).

By default, Julia sets the `allow_user_segv_handler=1` ASAN flag, which is required for signal
delivery to work properly. You can define other options using the `ASAN_OPTIONS` environment flag,
in which case you'll need to repeat the default option mentioned before. For example, memory usage
can be reduced by specifying `fast_unwind_on_malloc=0` and `malloc_context_size=2`, at the cost
of backtrace accuracy. For now, Julia also sets `detect_leaks=0`, but this should be removed in
the future.

## Memory Sanitizer (MSAN)

For detecting use of uninitialized memory, you can use Clang's [memory sanitizer (MSAN)](http://clang.llvm.org/docs/MemorySanitizer.html)
by compiling with `SANITIZE_MEMORY=1`.
