#!/bin/sh
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')
VERSION=$2
UNDERSCOREVERSION=$( echo $VERSION | sed 's/\./_/g')
TAR=../${SOURCE}_${VERSION}.orig.tar.xz
DIR=$SOURCE-$VERSION

TAG=$( svn list https://svn.java.net/svn/jtharness~svn/tags | grep $UNDERSCOREVERSION )
echo "Tag: $TAG"

svn export https://svn.java.net/svn/jtharness~svn/tags/$TAG/code/ $DIR
XZ_OPT=--best tar -Jcf $TAR $DIR
rm -rf $DIR $3

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

exit 0
