[![Build Status](https://travis-ci.org/jmock-developers/jmock-library.svg?branch=jmock2)](https://travis-ci.org/jmock-developers/jmock-library)

Upgrading to 2.8.X
==================
Are you seeing NPEs?
  
  We have had to make a breaking change to with(). Tests using with(any(matcher)) for method signatures that require native types will throw NullPointerException.
  
     oneOf(mock).methodWithIntParams(with(any(Integer.class)));
  
  should be changed to:

    oneOf(mock).methodWithIntParams(with.intIs(anything());
    
  This is due to a compiler change in Java 1.7.
  The 2.6.0 release was compiled with Java 1.6 so it did not suffer this problem.

Advantages of jMock 2 over jMock 1
==================================
* Uses real method calls, not strings: can refactor more easily and
  autocomplete in the IDE.
* Customisation by delegation, not by inheritance
* Many more plugin-points for customisation
* Independent of any testing framework: compatability with the testing
  framework is a plugin-point.
* Can mock concrete classes *without* calling their constructors (if
  you really want to).
* Uses Hamcrest matchers, so can use a large and ever-growing library
  of matchers in expectations.
* Expectations match in FIFO order, so tests are easier to understand


How to get up and running
=========================

You will need to add the jmock-2.0.0.jar and to your classpath.  Also
add the appropriate integration JAR to your classpath to integrate
jMock 2 with the test framework you use.  For example, if you use
JUnit 4, add jmock-junit4-2.0.0.jar to your classpath.

You will also need to add hamcrest-api-1.0.0.jar and hamcrest-lib-1.0.0.jar
to your classpath.



Package Structure
=================

jMock 2 is organised into published and internal packages.  We
guarantee to maintain backward compatability of types in published
packages within the same major version of jMock.  There are no
guarantees about backward compatability for types in internal
packages.

Types defined in published packages may themselves define public
methods that accept or return types from internal packages or inherit
methods from types in internal packages.  Such methods have no
compatability guarantees and should not be considered as part of the
published interface.


Published packages
------------------

org.jmock
	DSL-style API

org.jmock.api

org.jmock.lib
	Convenient classes that implement the APIs in the core, are used 
	by the DSL-style API, and can be used in user-defined APIs 

org.jmock.integration
	Classes integrating jMock with different testing APIs, such 
	as JUnit 3.x, JUnit 4.x and TestNG. 


Packages of example code
------------------------

org.jmock.lib.nonstd	
	Lib classes that rely on clever hacks or otherwise cannot be 
	guaranteed to always work in all JVMs.  There are no compatability
	guarantees with these classes.  Use at your own risk.


Internal packages
-----------------

org.jmock.internal
	Internal implementation details 

org.jmock.test
	Tests for jMock itself



Plug-in Points
==============

Matcher:
	Controls the matching of invocations to expectations
Action:
	Performs an action in response to an invocation
Imposteriser:
	Wraps mock objects in an adapter of the correct type
Expectation:
	Matches an invocation and fakes its behaviour
ExpectationErrorTranslator: 
	Translates expectation errors into error type used by a specific 
	testing framework.
MockObjectNamingScheme:
    Creates names for mock objects based on the mocked type.
