% Extended support for a user-specific directory with private extensions
%  * If a subdirectory .jed/ exists in Jed_Home_Directory, 
%    let Jed_Home_Directory point there,
%  * Prepend site-specific and user-specific libraries to the library path,
%  * evaluate (if existent) the file ini.sl in site and home libraries
%    to enable initialization (autoloads etc).
%  * set Color_Scheme_, dfa-cache- and documentation- path
%  
% Together with make-ini.sl, this provides a convenient way of extending
% jed with contributed or home-made scripts.
% 
% Version 0.9    first public version
%         0.9.1  Jed_Highlight_Cache_Path += Jed_Home_Library;
%         0.9.2  cleanup of code and documentation,
%                custom_variable for Jed_Site_Library and Jed_Home_Library
% 
% USAGE
% 
% Either rename to (or insert into) defaults.sl, 
% so it is read automatically at startup, 
% or write in your .jedrc
%   require("home-lib", "/FULL_PATH_TO/home-lib.sl")
% or put home-lib.sl in JED_ROOT/lib and write in .jedrc 
%   require("home-lib")
% Debian sysadmins can also put it in /etc/jed-init.d for automatic evaluation
% 
% CUSTOMIZATION
% 
% For other than the default paths use the environment variables 
% JED_HOME and JED_SITE_LIB or define Jed_Site_Library, and 
% Jed_Home_Library before evaluating home-lib.sl.
%          
% TODO: * adapt and test for windows systems
% 	* find nice names for the private documentation files
% 	* make this a part of site.sl :-)


% --- adjust jed home directory ------------------------------------------

% Jed_Home_Directory is defined in site.sl, defaulting to $HOME
% If Jed_Home_Directory/.jed/ exists, point Jed_Home_Directory there,
$1 = path_concat(Jed_Home_Directory, ".jed");
if(2 == file_status($1))
  Jed_Home_Directory = $1;
if(2 == file_status(Jed_Home_Directory)) % directory does exist
{
   % documentation on library functions is under doc/txt/libfuns.txt
   $1 = path_concat(path_concat(path_concat(
      Jed_Home_Directory, "doc"), "txt"), "libfuns.txt");
   if(1 == file_status($1))
     Jed_Doc_Files = Jed_Doc_Files + "," + $1;
}


% --- Site Library --------------------------------------------------------

%!%+
%\variable{Jed_Site_Library}
%\synopsis{Directory for site-wide non-standard slang scripts}
%\description
%  The value of this variable specifies the directory for site-wide
%  jed-slang scripts. It is a custom variable that defaults to 
%  JED_ROOT/site-lib (on Unix also etc/jed/lib and etc/jed are tried) 
%  or the value of the \var{JED_SITE_LIB} environment variable.
%  set to "" if the given/default directory is not present.
%\seealso{Jed_Home_Library, get_jed_library_path, set_jed_library_path}
%!%
custom_variable("Jed_Site_Library", getenv("JED_SITE_LIB"));
if (Jed_Site_Library == NULL)
   Jed_Site_Library = path_concat(JED_ROOT, "site-lib");
if (file_status(Jed_Site_Library) != 2) % no directory
  Jed_Site_Library = "";

% --- Home Library --------------------------------------------------------

% declare the home library and documentation assuming 
% Jed_Home_Directory has a structure similar to JED_ROOT:

%!%+
%\variable{Jed_Home_Library}
%\synopsis{Directory for private non-standard slang scripts}
%\description
%  The directory for private jed-slang scripts. Defaults to 
%  Jed_Home_Directory/lib.
%  Jed_Home_Library is set to "" if the given/default directory is 
%  not present.
%\seealso{Jed_Site_Library, Jed_Home_Directory, set_jed_library_path}
%!%
custom_variable("Jed_Home_Library", path_concat(Jed_Home_Directory, "lib"));
if (file_status(Jed_Home_Library) != 2) % no directory
  Jed_Home_Library = "";


% --- "register" the libraries -------------------------------------------

foreach ([Jed_Site_Library, Jed_Home_Library])
{
   $0 = ();
   if (2 == file_status($0)) % directory does exist
     {
	set_jed_library_path($0 + "," 
	   + get_jed_library_path());
	$1 = path_concat($0, "colors");
	if (2 == file_status($1))
	  Color_Scheme_Path = Color_Scheme_Path + "," + $1;
	% documentation
	$1 = path_concat($0, "libfuns.txt");
	if (1 == file_status($1))
	  Jed_Doc_Files = $1 + "," + Jed_Doc_Files;
#ifdef HAS_DFA_SYNTAX
	$1 = path_concat($0, "dfa");
	if (2 == file_status($1))
	  {
	     Jed_Highlight_Cache_Dir = $1;
	     Jed_Highlight_Cache_Path += "," + $1;
	  }
	else
	  {
	     Jed_Highlight_Cache_Dir = $0;
	     Jed_Highlight_Cache_Path += "," + $0;
	  }
#endif
	% Declare the public functions to jed.
	% Check for a file ini.sl containing the initialization code
	% (e.g. autoload declarations).
	$1 = path_concat($0, "ini.sl");
	if (1 == file_status($1))
	  () = evalfile($1);
     }
}
