/***********************************************************
/        Title: usbserial.c
/       Author: David Corcoran
/      Purpose: Abstracts usb API to serial like calls
/      License: See file COPYING
/           $Id: usbserial_linux.c,v 1.9 2001/11/24 16:29:53 rousseau Exp $
************************************************************/

#include <stdio.h>

#include "pcscdefines.h"
#include "stdlib.h"
#include "GemCore.h"
#include "usbserial.h"
#include "usblinux.h"
#include "Config.h"
#include "GCdebug.h"

#define USBWRITE_PIPE   0x06
#define USBREAD_PIPE    0x85
#define USB_TIMEOUT 10000

#define USBMAX_READERS  (PCSCLITE_MAX_CHANNELS)

/*
 * Change the following to uniquely match your reader. 
 */
enum
{
	kMyVendorID = 0x08E6,		/* change to match your reader */
	kMyProductID = 0x0430,		/* change to match your reader */
};

static int iInitialized = FALSE;
static int usbDevice[USBMAX_READERS];

status_t OpenUSB(DWORD lun, DWORD Channel)
{
	if (iInitialized == FALSE)
	{
		int i;

		for (i=0; i<USBMAX_READERS; i++)
			usbDevice[i] = -1;

		iInitialized = TRUE;
	}

	DEBUG_COMM3("OpenUSB: Lun: %d, Channel: %d", lun, Channel);

	/* is the device already used? */
	if (usbDevice[lun] > 0)
		return STATUS_UNSUCCESSFUL;

	usbDevice[lun] = open_linux_usb_dev(kMyVendorID, kMyProductID, lun);

	if (usbDevice[lun] <= 0)
		return STATUS_UNSUCCESSFUL;

	return STATUS_SUCCESS;
} /* OpenUSB */

status_t WriteUSB(DWORD lun, DWORD length, unsigned char *buffer)
{
	int rv,
	 len;

	DEBUG_XXD("-> ", buffer, length);

	len = length;

	rv = bulk_linux_usb_dev(usbDevice[lun], USBWRITE_PIPE, buffer, &len,
		USB_TIMEOUT);

	if (rv < 0)
		return STATUS_UNSUCCESSFUL;

	return STATUS_SUCCESS;
} /* WriteUSB */

status_t ReadUSB(DWORD lun, DWORD * length, unsigned char *buffer)
{
	int rv, len;

	len = 256;

	rv = bulk_linux_usb_dev(usbDevice[lun], USBREAD_PIPE, buffer, &len,
		USB_TIMEOUT);
	*length = len;

	if (rv < 0)
		return STATUS_UNSUCCESSFUL;

	DEBUG_XXD("<- ", buffer, len);

	return STATUS_SUCCESS;
} /* ReadUSB */

status_t CloseUSB(DWORD lun)
{
	close_linux_usb_dev(usbDevice[lun]);

	/* mark the resource unused */
	usbDevice[lun] = -1;

	return STATUS_SUCCESS;
} /* CloseUSB */

