
;; Don't need this, no one else will be loading this file.
;(define-module (g-wrapped gw-test-spec)
;  :use-module (g-wrap))

(let ((m (gw:new-module "gw-test-parent")))

  (gw:module-set-guile-module! m '(test gw-test-parent))

  (gw:module-depends-on m "gw-runtime")

  (gw:module-set-declarations-ccodegen!
   m
   (lambda (client-only?)
     (list
      "#include \"gw-test-parent-code.h\"\n")))

  (let ((nnt (gw:wrap-non-native-type
              m
              '<gw:TestParentObj*>
              "gwTestParentObj*" "const gwTestParentObj*")))
    #t)

  (gw:wrap-function
   m
   'gw-test-parent-make-obj
   '<gw:TestParentObj*>
   "gw_test_parent_make_obj"
   '(((<gw:m-chars-caller-owned> gw:const) data))
   "Make a gwTestParentObj*.")

  (gw:wrap-function
   m
   'gw-test-parent-same-obj
   '<gw:TestParentObj*>
   "gw_test_parent_same_obj"
   '((<gw:TestParentObj*> data))
   "Make a gwTestParentObj*.")

  (gw:wrap-function
   m
   'gw-test-parent-display-obj
   '<gw:void>
   "gw_test_parent_display_obj"
   '(((<gw:TestParentObj*> gw:const) f)))

  
  #t)
