//
// C++ Implementation: networkdialog
//
// Description:
//
//
// Author: Lorn Potter <lorn.potter@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "ui_NetworkDialogBase.h"
#include "networkdialog.h"

#include <QUrl>
#include <QFile>
#include <QtGui>
#include <QHttp>
#include <QTimer>


NetworkDialog::NetworkDialog(QWidget *parent)
        : QDialog(parent)
{
    setupUi(this);
    setWindowTitle(tr("Network Download"));
    // setModal(false);
    setWindowModality( Qt::ApplicationModal);
    QTimer::singleShot(150, this, SLOT(downloadFile())); 
 }

NetworkDialog::~NetworkDialog()
{
    http->abort();
}

void NetworkDialog::downloadFile()
{
// http://www.gutenberg.org/feeds/catalog.rdf.zip
// http://www.gutenberg.org/feeds/today.rss
// http://www.gutenberg.org/dirs/GUTINDEX.ALL
//
    if(serverPath.isEmpty() || filenamePath.isEmpty()) {
        qWarning() << "empty!";
        return ;
    }
    
    QUrl url(serverPath);
    label->setText("<p>Downloading "+serverPath+"<br>Please wait...</p>");
    qWarning() << __PRETTY_FUNCTION__ << serverPath << filenamePath;
    file = new QFile(filenamePath);
    
    if (!file->open(QIODevice::WriteOnly/* | QIODevice::Truncate*/)) {
        QMessageBox::information(this, tr("HTTP"),
                                 tr("Unable to save the file %1: %2.")
                                 .arg(filenamePath).arg(file->errorString()));
        //        http->abort();
        //   reject();
        return ;
    }


    http = new QHttp(this);
    qWarning() << url.host() << url.path();
    http->setHost(url.host(), QHttp::ConnectionModeHttp/*, url.port() != -1 ? url.port() : 80*/);

    //  if (!url.userName().isEmpty())
    //     http->setUser(url.userName(), url.password());

    connect(http, SIGNAL(dataReadProgress(int,int)),
            this, SLOT(setProgress(int,int)));

    connect(http, SIGNAL(requestFinished(int, bool)),
            this, SLOT(httpRequestFinished(int, bool)));

    connect(http, SIGNAL(responseHeaderReceived(const QHttpResponseHeader &)),
            this, SLOT(readResponseHeader(const QHttpResponseHeader &)));

    connect(http,SIGNAL(done(bool)),this,SLOT(isDone(bool)));

    httpRequestAborted = false;
    httpGetId = http->get(url.path(), file);
}

void NetworkDialog::setProgress(int done, int total)
{
    if (httpRequestAborted)
        return;
  //   qWarning("fileSize is %d, total is %d", fileSize, total);
      /*   if(fileSize == total)  {
           httpRequestAborted = true;
           http->abort();
           reject();
           }
      */
    progressBar->setMaximum(total);
    progressBar->setValue(done);
    QString gak = QString("%1 bytes out of %2 bytes completed").arg(done).arg(total);
    label->setText(gak);
}

void NetworkDialog::httpRequestFinished(int requestId, bool error)
{
    qWarning() << __PRETTY_FUNCTION__ << error;
    
    if (httpRequestAborted) {
          /*      if (file) {
                  file->close();
                  file->remove();
                  delete file;
                  file = 0;
                  }
          */
        progressBar->hide();
        return;
    }

    if (requestId != httpGetId)
        return;

    progressBar->hide();
    file->close();

    if (error) {
        file->remove();
        qWarning() <<" Download failed:" << http->errorString();
        QString gak = QString("Download failed: %1").arg(http->errorString());        QMessageBox::information(this,tr("Warning"), gak,0);
        httpRequestAborted = true;
        progressBar->hide();
        http->abort();
    } else {
        QString fileName = "";
    }

    delete file;
    file = 0;
}

void NetworkDialog::readResponseHeader(const QHttpResponseHeader &responseHeader)
{
    qWarning() << __PRETTY_FUNCTION__<< responseHeader.reasonPhrase();
    
    if (responseHeader.statusCode() != 200) {
        QString gak = QString("Download failed: %1").arg(responseHeader.reasonPhrase());
        label->setText(gak);
        QMessageBox::information(this,tr("Warning"), gak,0);
        if(responseHeader.statusCode() == 404)
            emit fileNotFound();
        qWarning() <<" Download failed:" << responseHeader.reasonPhrase();
        httpRequestAborted = true;
        progressBar->hide();
        http->abort();
        return;
    }
}

void NetworkDialog::isDone(bool error)
{
    qWarning() << __PRETTY_FUNCTION__ << error;
    if(!error) {
        accept();
        emit downloadFinished(); 
    } else {
        if(file->exists()) {
            file->close();
            file->remove();
        }
        //        label->setText(tr("Sorry your download failed."));        
        reject();        
        emit downloadFailed();
    }
}


/*!
    \fn NetworkDialog::setUrl(const QString &urlStr)
 */
void NetworkDialog::setUrl(const QString &urlStr)
{
    qWarning() << __PRETTY_FUNCTION__ << urlStr;
    serverPath = urlStr;
}


/*!
    \fn NetworkDialog::setFile(const QString &file)
 */
void NetworkDialog::setFile(const QString &file)
{
    qWarning() << __PRETTY_FUNCTION__ << file;
    filenamePath = file;
}
