<?xml version="1.0"?> <!-- -*- xml -*- -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="form/widgets/text_field/pos">
    <xsl:text> AT (</xsl:text>
    
    <!-- Position -->
    <xsl:value-of select="@x"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@y"/>
    
    <!-- Size -->
    <xsl:choose>
      <xsl:when test="@width='auto'">
	<xsl:text> 30</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> </xsl:text>
	<xsl:value-of select="@width"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@height"/>   
    <xsl:text>)</xsl:text>
    
  </xsl:template>
  <xsl:template match="form/widgets/text_field">

    <xsl:text>  FIELD</xsl:text>

    <xsl:text> ID </xsl:text>
    <xsl:value-of select="@id"/>

    <xsl:apply-templates select="pos"/>

    <xsl:text> FONT </xsl:text>
    <xsl:value-of select="text/@font"/>

    <xsl:choose>
      <xsl:when test="usable">
	<xsl:text> USABLE</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> NONUSABLE</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="editable">
	<xsl:text> EDITABLE</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> NONEDITABLE</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="multi_line">
	<xsl:text> MULTIPLELINES</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> SINGLELINE</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="justify_right">
	<xsl:text> RIGHTALIGN</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text> LEFTALIGN</xsl:text>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="underline">
      <xsl:text> UNDERLINED</xsl:text>
    </xsl:if>

    <xsl:if test="dynamic_size">
      <xsl:text> DYNAMICSIZE</xsl:text>
    </xsl:if>

    <xsl:if test="auto_shift">
      <xsl:text> AUTOSHIFT</xsl:text>
    </xsl:if>


    <xsl:if test="numeric">
      <xsl:text> NUMERIC</xsl:text>
    </xsl:if>

    <xsl:if test="has_scrollbar">
      <xsl:text> HASSCROLLBAR</xsl:text>
    </xsl:if>

    <xsl:text> MAXCHARS </xsl:text>
    <xsl:choose>
      <xsl:when test="text/@max_length=0">
	<xsl:text>32767</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="text/@max_length"/>
      </xsl:otherwise>
    </xsl:choose>
    
    <xsl:text>
</xsl:text>
  </xsl:template>

</xsl:stylesheet>
