//$Id: label.h,v 1.14 2001/11/06 12:54:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_FORM_EDITOR_LABEL_H
#define GUIKACHU_FORM_EDITOR_LABEL_H

namespace Guikachu
{
    namespace Widgets
    {
	class Label;
    }
}

#include "widget.h"
#include "resource.h"
#include "textual.h"

#include "label-prop.h"

namespace Guikachu
{
    namespace Widgets
    {
	class Label: public Widget,
		     public Textual
	{
	    GUI::FormEditor::LabelProperties *editor;
	    
	public:
	    Label (Resources::Form   *owner,
		   const std::string &id);
	    virtual ~Label ();
	    
	    virtual Type get_type () const { return WIDGET_LABEL; };
	    
	    virtual GUI::FormEditor::CanvasItem *create_canvas_item (GUI::FormEditor::Form *form);
	    virtual Gtk::Widget                 *create_editor ();
	    
	    Property<bool> usable;
	    
	private:
	    // Persistance
	    virtual bool load (StorageNode &node);
	    virtual void save (StorageNode &node) const;
	    virtual void save_rcp (std::ostream &ostr) const;
	};
    }
}

#endif /* !GUIKACHU_FORM_EDITOR_LABEL_H */
