//$Id: label.cc,v 1.24 2001/11/06 12:54:54 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "label.h"
#include "label-canvas.h"

using Guikachu::Widgets::Label;
using namespace Guikachu::GUI::FormEditor;

Label::Label (Resources::Form   *owner,
	      const std::string &id):
    Widget (owner, id),
    Textual (changed, id),
    editor (0),
    usable (changed, true)
{
}

Label::~Label ()
{
    if (editor)
	delete editor;
}

Gtk::Widget *Label::create_editor ()
{
    if (!editor)
	editor = new LabelProperties (this);
    
    return editor->get_editor ();
}

CanvasItem* Label::create_canvas_item (GUI::FormEditor::Form *form)
{
    return new LabelCanvasItem (this, form);
}

bool Label::load (StorageNode &node)
{
    /* Non-NULL default values */
    usable = false;
    
    for (StorageNode curr_node  = node.children ();
	 curr_node; curr_node++)
    {
	if (curr_node.name () == "pos")
	{
	    x = curr_node.get_prop<int> ("x");
	    y = curr_node.get_prop<int> ("y");
	}
	else if (curr_node.name () == "text")
	{
	    text = curr_node.get_content ();
	    font = curr_node.get_prop<int> ("font");
	}
	else if (curr_node.name () == "usable")
	    usable = true;
	else
	    g_warning ("Error parsing `label' widget: "
		       "unexpected element `%s'",
		       curr_node.name ().c_str ());
    }

    changed ();

    return true;
}

void Label::save (StorageNode &node) const
{
    StorageNode my_node;

    /* Position */
    my_node = StorageNode (node).add_node ("pos");
    my_node.set_prop ("x", x);
    my_node.set_prop ("y", y);

    /* Usable */
    if (usable)
	node.add_node ("usable");
    
    /* Text and font */
    my_node = node.add_node ("text", text);
    my_node.set_prop ("font", font);
}

void Label::save_rcp (std::ostream &ostr) const
{
    ostr << "  LABEL \"" << text << "\"" << " ID " << id;
    ostr << " AT (" << x << " " << y << ")";
    ostr << " FONT " << font;
    if (usable)
	ostr << " USABLE";
    else
	ostr << " NONUSABLE";
    ostr << std::endl;
}
