#include <config.h>

#include <gst/editor/editor.h>
#include <gst/element-browser/browser.h>
#include <gst/debug-ui/debug-ui.h>

int
main (int argc, char *argv[])
{
  GstElementFactory *chosen = NULL;

  const struct poptOption *gst_table;

  gst_table = gst_init_get_popt_table ();

  if (!gnome_program_init ("GStreamer Plugin Inspector", VERSION,
	  LIBGNOMEUI_MODULE, argc, argv, GNOME_PARAM_POPT_TABLE, gst_table,
	  NULL))
    g_error ("cannot gnome_progam_init(), aborting...");
  gste_init ();

  chosen = (GstElementFactory *) gst_element_browser_pick_modal ();
  if (chosen)
    g_print ("selected '%s'\n", GST_OBJECT_NAME (chosen));
  else
    g_print ("didn't choose any\n");
  return 0;
}
