/*************************************************************************
*                                                                        *
*   lockfile.c - a lockfile manager                                      *
*   Author: Kord Campbell <kord@grub.org>                                *
*   Copyright (C) 2001 Grub, Inc.                                        *
*                                                                        *
*   This program is free software; you can redistribute it and/or modify *
*   it under the terms of the GNU General Public License as published by *
*   the Free Software Foundation; either version 2, or (at your option)  *
*   any later version.                                                   *
*                                                                        *
*   This program is distributed in the hope that it will be useful,      *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
*   GNU General Public License for more details.                         *
*                                                                        *
*   You should have received a copy of the GNU General Public License    *
*   along with this program; if not, write to the Free Software          *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*                                                                        *
**************************************************************************/

#include "lockfile.h"

#define BUFLEN 128

using namespace std;

int check_lock_file(char *filename)
{
	FILE *fp;

	fp = fopen(filename, "r");

	if (!fp) // no lockfile found 
	{
		return(make_lock_file(filename));
	}
	else // lockfile found 
	{
		int pig_check;
		int pig;

		// read in process id
		if (fscanf(fp, "%d", &pig) == 0)
		{
			// failure of read
			if (fp) { fclose(fp); fp = 0; }
			return(-1);
		}
	
		pig_check = kill(pig, 0);

		if (pig_check == -1 && errno == ESRCH) // old process is not running
		{
			unlink(filename); // delete old lockfile
			if (fp) { fclose(fp); fp = 0; }

			int ret = make_lock_file(filename);
			if (ret == 0)
			{
				if (fp) { fclose(fp); fp = 0; }
				return(1);	
			}
			else
			{
				if (fp) { fclose(fp); fp = 0; }
				return(-1);
			}
		}
		else if (pig_check == -1 && errno == EPERM) // perm error is occuring
		{
			cout << "(lockfile) there is a permissions error on the lockfile..." << endl;
			if (fp) { fclose(fp); fp = 0; }
			return(-1);
		}
		else if (pig_check == -1 && errno == EINVAL) // some other error
		{
			cout << "(lockfile) some other wierd error is occuring..." << endl;
			if (fp) { fclose(fp); fp = 0; }
			return(-1);
		}
		else if (pig_check == 0) // other grub client is running
		{
			if (fp) { fclose(fp); fp = 0; }
			return(2);
		}
	}

	if (fp) { fclose(fp); fp = 0; }
	return(0);
}

int make_lock_file(char *filename)
{
	// get our process id
	pid_t pig;
	pig = getpid();
	FILE *fp;

	// open the file
	fp = fopen(filename, "w");

	// check to see if open was good
	if (!fp)
	{
		return (-1);	
	}
	else
	{
		// print to the file
		fprintf(fp, "%d", pig);

		// close the file
		if (!fclose(fp))
		{
			return(0);
		}
		else
		{
			return(-1);
		}
	}
}

/*
void main()
{
	char *filename = "grub.lock";
	int ret;
	
	ret = check_lock_file(filename);
		
	printf("return value is: %d\n", ret);
	
	sleep(20);
}		
*/


