/* $Id: dbl_list.h,v 1.2 2001/05/15 19:14:33 ozra Exp $ */

/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2000 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *   Author:  Igor Stojanovski - ozra   (email: ozra@grub.org)            *
 *                                                                        *
 **************************************************************************/

#ifndef _DBL_LIST_H
#define _DBL_LIST_H

/* This is a header file for a simple doubly linked list of pointers. */

#include <stdlib.h>


typedef struct dbl_list_node_t {
	void *data;
	struct dbl_list_node_t *prev;
	struct dbl_list_node_t *next;
} dbl_list_node_t;


typedef struct dbl_list_t {
	dbl_list_node_t *front;
	dbl_list_node_t *back;
	int count;
} dbl_list_t;



/* dbl_list_create()
   Creates a new linked list
   Parameters:
     None.
   Returns:
     An instance of an empty list; null if memory allocation failed.
 */
dbl_list_t      *dbl_list_create();


/* dbl_list_destroy()
   Removes all items from the list and then destroys it.
   Parameters:
     lst - the list to destroy
   Returns:
     Nothing.
 */
void             dbl_list_destroy( dbl_list_t *lst );


/* dbl_list_append()
   Adds a new item to the list at the end.
   Parameters:
     lst - the list to append to
     data - the pointer to append
   Returns:
     A pointer to the node that conteins the appended data;
     null if memory allocation failed.
 */
dbl_list_node_t *dbl_list_append( dbl_list_t *lst, void *data );


/* dbl_list_delete(
   Deletes a node from the linked list.  The pointers of the other nodes
   are adjusted accordingly.
   Parameters:
     lst - the list to delete a node from
     node - the node to remove from the list.  The memory node points to is
     freed and thus unusable.
   Returns:
     Nothing.
 */
void             dbl_list_delete( dbl_list_t *lst, dbl_list_node_t *node );


/* dbl_list_front()
   Returns a pointer to the first node of the list.
   Parameters:
     lst - the list
   Return:
     Pointer to the first node of the list, or 0 if list is empty.
 */
dbl_list_node_t *dbl_list_front( dbl_list_t *lst );


/* dbl_list_next()
   Gets the next node in the list.
   Parameters:
     node - the node to obtain follower from
   Returns:
     Pointer to the node that follows the var node, or 0 if end of list.
 */
dbl_list_node_t *dbl_list_next( dbl_list_node_t *node );


/* dbl_list_data()
   Returns the data field of a node
   Parameter:
     node - the node to get the data from
   Returns:
     The same pointer that was passed when this node was created.
 */
void            *dbl_list_data( dbl_list_node_t *node );


/* dbl_list_count()
   Returns the number of items (nodes) in the linked list
   Parameter:
     lst - the list to obtain count from
   Returns:
     The count.
 */
int              dbl_list_count( dbl_list_t *lst );


#endif
