/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 **************************************************************************/
/* 
 * Project: 	GRUB-CLIENT <http://www.grub.org>
 * Module:	clog
 * Author:	Ledio Ago
 * Date:	March 7, 2002
 * Files: 	CLog.cpp CLog.h
 * Description: This module will initilize the GrubCLog module used to
 *		to track down the client. 
 */

#ifndef _clog_H_
#define _clog_H_

#ifdef __cplusplus
#include <GrubCLog.h>

#define clog grub_clog->Logprintf

extern GrubCLog *grub_clog;
#else  /* __cplusplus */
/* also defined in gc_log.h */
#define GCLOG_TRACE 1
#define GCLOG_DEBUG 2
#define GCLOG_INFO  4
#define GCLOG_ERR   8
#define GCLOG_ALERT 16 
#define GCLOG_CRIT  32
#define GCLOG_EMERG 64
#endif  /* ! __cplusplus */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Function:	clog_init
 * Description: It will initilize GrubCLog object used to log errors
 *		or just logs to trace down programs.
 */
void clog_init( char *file_name );

/*
 * Function:	clog_uninit
 * Description:	It will delete the GrubCLog object.
 */
void clog_uninit();

void clog_c(unsigned int level, const char *info );
 
#ifdef __cplusplus
}
#endif

#endif
