#include "StatusInterface.h"

using namespace std;

// create the two structs that contain all our settings and statistics -
// these are GLOBAL structs, with Config_Info contained in the ConfigFileInfo.h
// and Status_Info contained in StatusInterface.h, both get initilized in the
// Status_Info constructor, which is a *little* confusing.
Config_Info Config_File_Info;
Status_Info Crawler_Status_Info;

Status::Status() : BaseFace()
{
}

Status::~Status()
{
}

void Status::pauseCrawler(bool state)
{
	Crawler_Status_Info.crawler_pause = state;
}

void Status::softShutdown()
{
	// add logging to these routines if you end up using them
	Crawler_Status_Info.gui_quit = true;
	Crawler_Status_Info.coordinator_quit = true;
}

void Status::hardShutdown()
{ 
	// add logging to these routines if you end up using them
	Crawler_Status_Info.gui_quit = true;
	Crawler_Status_Info.coordinator_quit = true;
	Crawler_Status_Info.crawler_quit = true;
	Crawler_Status_Info.protocol_quit = true;
}

// returns true if bandwidth was set successfully or false, if not
bool Status::setBandwidthLimit(int new_band_limit)
{
	if (new_band_limit > 0)
	{ 
		Config_File_Info.MaxAmountOfBandwidth = new_band_limit;
		return true;
	}
	else
	{
		return false;
	}
}

// return current bandwidth usage in kilobits/sec
int Status::getBandwidth()
{
	return Crawler_Status_Info.usage;
}

// return current bandwidth limit in kilobits/sec
int Status::getBandwidthLimit()
{
	return Config_File_Info.MaxAmountOfBandwidth;
}

// return the number of crawler to spawn for crawling
int Status::getNumberCrawlers()
{
	return Config_File_Info.NumOfCrawlersToRun;
}

// returns true if the new number of crawlers was set, false if not
bool Status::setNumberCrawlers(int new_number_crawlers)
{
	// need to add sanity checking for more than 100 crawlers
	if(new_number_crawlers > 0)
	{
		Config_File_Info.NumOfCrawlersToRun = new_number_crawlers;
		return true;
	}
	return false;
}

void Status::EventSetBandwidth(int Bandwidth)
{
}

void Status::EventSetCrawlerCount(int Count)
{
}

void Status::EventGetBandwidth()
{
}

void Status::EventGetBandwidthLimit()
{
}

void Status::EventGetCrawlerCount()
{
}

void Status::EventGetStatus()
{
}


