/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *   File: ServerSettings.h                                               *
 *   Authors: Kord Campbell                                               *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/

#ifndef _SERVERSETTINGS_H_
#define _SERVERSETTINGS_H_

#include "StatusInterface.h"
#include "string" 	
#include "unistd.h" 
#include "stdio.h" 
#include "sys/time.h"  
#include "sys/resource.h" 
#include "sys/types.h"	
#include "sys/stat.h"
#include "fcntl.h"
#include "ctype.h"
#include "iostream.h"
#include "signal.h"
#include "errno.h"
#include "limits.h"
#include <stdlib.h>
#include <iterator>
#include <functional>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
#include <sys/wait.h>
#include <sys/types.h>
#include "clog.h"

extern "C" {
 #include <verbose.h>
}

#define CURL_TIMEOUT 30
#define BUFLEN 100
#define NUMSET 10
#define SERVERURL "http://brainbug.grub.org/settings/%s-%s.php?clientid=%d&password=%s"

#include "ConfigFileInfo.h"

size_t SettingsWriteMemoryCallback(void *ptr, size_t size, size_t nmemb, void *data);
int parsethecontents(int set_num, char *contents, char *setting);
int readServerSettings();

#endif
